/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.alm.mylyn.ui.bridge.monitor;

import java.util.List;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.CentralTestDataEditor;
import org.eclipse.jubula.client.ui.rcp.editors.IJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.rcp.editors.PersistableEditorInput;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.monitor.ui.AbstractEditorTracker;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.IEditorPart;

public class EditorInteractionMonitor
extends AbstractEditorTracker {
    private static final String CTDE_ORIGIN_ID = "ctde";
    private static final String CDTE_HANDLE = "00000000000000000000000000000005";

    protected void editorBroughtToTop(IEditorPart part) {
    }

    protected void editorClosed(IEditorPart part) {
        block5: {
            List interesting;
            IInteractionContext activeContext;
            block6: {
                block4: {
                    if (Plugin.getDefault().getClientStatus() == Plugin.ClientStatus.STOPPING || TasksUi.getTaskActivityManager().getActiveTask() == null) {
                        return;
                    }
                    activeContext = ContextCore.getContextManager().getActiveContext();
                    interesting = activeContext.getInteresting();
                    if (!(part instanceof CentralTestDataEditor)) break block4;
                    for (IInteractionElement element : interesting) {
                        if (!element.getContentType().equals("org.eclipse.jubula.client.alm.mylyn.ui.bridge.content.type.editor.ctd")) continue;
                        activeContext.delete(element);
                    }
                    break block5;
                }
                if (!(part instanceof ObjectMappingMultiPageEditor)) break block6;
                PersistableEditorInput input = (PersistableEditorInput)((ObjectMappingMultiPageEditor)part).getEditorInput();
                IPersistentObject po = input.getNode();
                String id = ((IAUTMainPO)po).getGuid();
                for (IInteractionElement element : interesting) {
                    if (!element.getHandleIdentifier().equals(id)) continue;
                    activeContext.delete(element);
                }
                break block5;
            }
            if (!(part instanceof AbstractJBEditor)) break block5;
            AbstractContextStructureBridge editorBridge = ContextCore.getStructureBridge((Object)part);
            for (IInteractionElement element : interesting) {
                if (!element.getHandleIdentifier().equals(editorBridge.getHandleIdentifier((Object)part))) continue;
                activeContext.delete(element);
            }
        }
    }

    protected void editorOpened(IEditorPart part) {
        if (TasksUi.getTaskActivityManager().getActiveTask() == null) {
            return;
        }
        InteractionEvent iEvent = null;
        if (part instanceof ObjectMappingMultiPageEditor) {
            iEvent = this.getInteractionEvent((ObjectMappingMultiPageEditor)part);
        } else if (part instanceof CentralTestDataEditor) {
            iEvent = this.getInteractionEvent((CentralTestDataEditor)part);
        } else if (part instanceof IJBEditor) {
            iEvent = this.getInteractionEvent((IJBEditor)part);
        }
        if (iEvent != null) {
            ContextCore.getContextManager().processInteractionEvent(iEvent);
        }
    }

    private InteractionEvent getInteractionEvent(IJBEditor jbEditor) {
        String guid = null;
        AbstractContextStructureBridge bridge = ContextCore.getStructureBridge((Object)jbEditor);
        IPersistentObject workingVersion = jbEditor.getEditorHelper().getEditSupport().getWorkVersion();
        if (workingVersion instanceof INodePO && (guid = ((INodePO)workingVersion).getGuid()) != null) {
            return new InteractionEvent(InteractionEvent.Kind.SELECTION, bridge.getContentType(), bridge.getHandleIdentifier((Object)jbEditor), guid);
        }
        return null;
    }

    private InteractionEvent getInteractionEvent(CentralTestDataEditor ctde) {
        return new InteractionEvent(InteractionEvent.Kind.SELECTION, "org.eclipse.jubula.client.alm.mylyn.ui.bridge.content.type.editor.ctd", CDTE_HANDLE, CTDE_ORIGIN_ID);
    }

    private InteractionEvent getInteractionEvent(ObjectMappingMultiPageEditor ome) {
        PersistableEditorInput input = (PersistableEditorInput)ome.getEditorInput();
        IPersistentObject element = input.getNode();
        String id = ((IAUTMainPO)element).getGuid();
        return new InteractionEvent(InteractionEvent.Kind.SELECTION, "org.eclipse.jubula.client.alm.mylyn.ui.bridge.content.type.editor.ome", id, id);
    }
}

