/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.teststyle.checks.contexts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jubula.client.core.businessprocess.db.TestJobBP;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.ISpecPersistable;
import org.eclipse.jubula.client.teststyle.checks.contexts.BaseContext;
import org.eclipse.jubula.client.teststyle.i18n.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecTestCaseContext
extends BaseContext {
    public ExecTestCaseContext() {
        super(IExecTestCasePO.class);
    }

    public List<Object> getAll() {
        ArrayList<Object> tmp = new ArrayList<Object>();
        IProjectPO project = GeneralStorage.getInstance().getProject();
        for (ISpecPersistable p : project.getSpecObjCont().getSpecObjList()) {
            tmp.addAll(this.getExecTestCases(p));
        }
        for (ISpecPersistable p : TestSuiteBP.getListOfTestSuites((IProjectPO)project)) {
            tmp.addAll(this.getExecTestCases(p));
        }
        for (ISpecPersistable p : TestJobBP.getListOfTestJobs((IProjectPO)project)) {
            tmp.addAll(this.getExecTestCases(p));
        }
        return tmp;
    }

    private List<Object> getExecTestCases(Object root) {
        ArrayList<Object> tmp = new ArrayList<Object>();
        if (root instanceof IExecTestCasePO) {
            tmp.add(root);
        } else if (root instanceof INodePO) {
            INodePO node = (INodePO)root;
            for (Object o : node.getUnmodifiableNodeList()) {
                tmp.addAll(this.getExecTestCases(o));
            }
        }
        return tmp;
    }

    @Override
    public String getName() {
        return Messages.ContextExecTestCaseName;
    }

    @Override
    public String getDescription() {
        return Messages.ContextExecTestCaseDescription;
    }
}

