/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.gerrit.dashboard;

import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.gerrit.dashboard.Messages;
import org.eclipse.mylyn.gerrit.dashboard.trace.Tracer;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class GerritPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.mylyn.gerrit.dashboard.core";
    private static final String DASHBOARD_VERSION_QUALIFIER = "qualifier";
    private static GerritPlugin Fplugin;
    public static Tracer Ftracer;

    static {
        Ftracer = new Tracer();
    }

    public void start(BundleContext aContext) throws Exception {
        super.start(aContext);
        Fplugin = this;
        Ftracer = new Tracer();
        Ftracer.init(PLUGIN_ID);
        Ftracer.traceDebug(Messages.GerritPlugin_started);
        this.verifyVersion(PLUGIN_ID);
    }

    private void verifyVersion(String aBundleStr) {
        IBundleGroupProvider[] grpprovider;
        Version ver;
        Bundle bdleCurrent = Platform.getBundle((String)aBundleStr);
        if (bdleCurrent != null && (ver = bdleCurrent.getVersion()).getQualifier().equals(DASHBOARD_VERSION_QUALIFIER)) {
            Ftracer.traceDebug(NLS.bind((String)Messages.GerritPlugin_Version, (Object)aBundleStr, (Object)ver.toString()));
            return;
        }
        IBundleGroupProvider[] iBundleGroupProviderArray = grpprovider = Platform.getBundleGroupProviders();
        int n = grpprovider.length;
        int n2 = 0;
        while (n2 < n) {
            IBundleGroupProvider element = iBundleGroupProviderArray[n2];
            IBundleGroup[] bdlgrp = element.getBundleGroups();
            Ftracer.traceDebug("bundle group count: " + bdlgrp.length);
            int j = 0;
            while (j < bdlgrp.length) {
                if (bdlgrp[j].getIdentifier().contains(aBundleStr)) {
                    Ftracer.traceDebug("\t bdlgrp[" + j + "] : " + bdlgrp[j].getName() + "\t : " + bdlgrp[j].getProviderName() + "\t version: " + bdlgrp[j].getVersion() + "\t : " + bdlgrp[j].getIdentifier());
                    break;
                }
                ++j;
            }
            ++n2;
        }
    }

    public void stop(BundleContext aContext) throws Exception {
        Fplugin = null;
        super.stop(aContext);
        Ftracer.traceDebug(Messages.GerritPlugin_stopped);
    }

    public static GerritPlugin getDefault() {
        return Fplugin;
    }

    public void logError(String aMsg, Exception ae) {
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, aMsg, (Throwable)ae));
    }

    public void logWarning(String aMsg, Exception ae) {
        this.getLog().log((IStatus)new Status(2, PLUGIN_ID, 0, aMsg, (Throwable)ae));
    }

    public void logInfo(String aMsg, Exception ae) {
        this.getLog().log((IStatus)new Status(1, PLUGIN_ID, 0, aMsg, (Throwable)ae));
    }
}

