/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.handlers;

import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeEntry;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultView;
import org.eclipse.viatra.query.tooling.ui.queryresult.util.QueryResultViewUtil;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * @author Abel Hegedus
 */
@SuppressWarnings("all")
public class LoadQueriesHandler extends AbstractHandler {
  public final static String COMMAND_ID = "org.eclipse.viatra.query.tooling.ui.result.loadqueries";
  
  @Override
  public Object execute(final ExecutionEvent event) throws ExecutionException {
    final ISelection selection = HandlerUtil.getCurrentSelection(event);
    IWorkbenchSite _activeSite = HandlerUtil.getActiveSite(event);
    IWorkbenchPage _page = _activeSite.getPage();
    final IViewPart resultView = _page.findView(QueryResultView.ID);
    if ((resultView instanceof QueryResultView)) {
      final QueryResultView queryResultView = ((QueryResultView) resultView);
      final boolean active = queryResultView.hasActiveEngine();
      boolean _and = false;
      if (!active) {
        _and = false;
      } else {
        _and = (selection instanceof IStructuredSelection);
      }
      if (_and) {
        final Set<QueryRegistryTreeEntry> selectedQueries = QueryResultViewUtil.getRegistryEntriesFromSelection(((IStructuredSelection) selection));
        final Procedure1<QueryRegistryTreeEntry> _function = new Procedure1<QueryRegistryTreeEntry>() {
          @Override
          public void apply(final QueryRegistryTreeEntry it) {
            it.load();
          }
        };
        IterableExtensions.<QueryRegistryTreeEntry>forEach(selectedQueries, _function);
        final Function1<QueryRegistryTreeEntry, IQuerySpecificationRegistryEntry> _function_1 = new Function1<QueryRegistryTreeEntry, IQuerySpecificationRegistryEntry>() {
          @Override
          public IQuerySpecificationRegistryEntry apply(final QueryRegistryTreeEntry it) {
            return it.getEntry();
          }
        };
        Iterable<IQuerySpecificationRegistryEntry> _map = IterableExtensions.<QueryRegistryTreeEntry, IQuerySpecificationRegistryEntry>map(selectedQueries, _function_1);
        queryResultView.loadQueriesIntoActiveEngine(_map);
      } else {
        IWorkbenchPartSite _site = queryResultView.getSite();
        Shell _shell = _site.getShell();
        LoadQueriesHandler.queryLoadingFailed(_shell);
      }
    }
    return null;
  }
  
  public static void queryLoadingFailed(final Shell parent) {
    MessageDialog.openError(parent, "Query loading failed", 
      "Please load a model into the Query Results view before loading queries!");
  }
}
