/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotatableType;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFix;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class TypeAnnotationRewriteOperations {
    public static void addTypeAnnotation(ASTRewrite astRewrite, ASTNode target, Annotation newAnnotation, TextEditGroup group) {
        if (target instanceof AnnotatableType) {
            AnnotatableType annotatableType = (AnnotatableType)target;
            if (annotatableType.isSimpleType()) {
                annotatableType = (AnnotatableType)astRewrite.get(annotatableType.getParent(), annotatableType.getLocationInParent());
            }
            if (annotatableType.isSimpleType()) {
                SimpleType simpleType = (SimpleType)annotatableType;
                Name name2 = simpleType.getName();
                assert (name2.isQualifiedName());
                QualifiedName qualifiedName = (QualifiedName)name2;
                qualifiedName.getName();
                Name qualifier = (Name)astRewrite.createMoveTarget((ASTNode)qualifiedName.getQualifier());
                SimpleName name = (SimpleName)astRewrite.createMoveTarget((ASTNode)qualifiedName.getName());
                NameQualifiedType nameQualifiedType = astRewrite.getAST().newNameQualifiedType(qualifier, name);
                nameQualifiedType.annotations().add(newAnnotation);
                astRewrite.replace((ASTNode)annotatableType, (ASTNode)nameQualifiedType, group);
            } else if (annotatableType.isNameQualifiedType()) {
                ListRewrite listRewrite = astRewrite.getListRewrite((ASTNode)annotatableType, NameQualifiedType.ANNOTATIONS_PROPERTY);
                listRewrite.insertLast((ASTNode)newAnnotation, group);
            } else if (annotatableType.isQualifiedType()) {
                ListRewrite listRewrite = astRewrite.getListRewrite((ASTNode)annotatableType, QualifiedType.ANNOTATIONS_PROPERTY);
                listRewrite.insertLast((ASTNode)newAnnotation, group);
            }
        } else if (target instanceof Dimension) {
            Dimension dimension = (Dimension)target;
            ListRewrite listRewrite = astRewrite.getListRewrite((ASTNode)dimension, Dimension.ANNOTATIONS_PROPERTY);
            listRewrite.insertLast((ASTNode)newAnnotation, group);
        }
    }

    static class MoveTypeAnnotationRewriteOperation
    extends CompilationUnitRewriteOperationsFix.CompilationUnitRewriteOperation {
        private IProblemLocation fProblem;
        private CompilationUnit fCompilationUnit;
        private ASTNode fNewAnnotationTarget;
        private Annotation fAnnotation;

        public MoveTypeAnnotationRewriteOperation(CompilationUnit compilationUnit, IProblemLocation problem) {
            this.fCompilationUnit = compilationUnit;
            this.fProblem = problem;
            CompilationUnit astRoot = this.fCompilationUnit;
            ASTNode selectedNode = this.fProblem.getCoveringNode(astRoot);
            if (selectedNode instanceof Annotation) {
                this.fAnnotation = (Annotation)selectedNode;
                this.fNewAnnotationTarget = MoveTypeAnnotationRewriteOperation.determineNewAnnotationTarget(this.fAnnotation);
            } else {
                this.fAnnotation = null;
                this.fNewAnnotationTarget = null;
            }
        }

        public boolean isMove() {
            return this.fNewAnnotationTarget != null;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModel linkedModel) throws CoreException {
            TextEditGroup group = this.createTextEditGroup(this.isMove() ? FixMessages.TypeAnnotationFix_move : FixMessages.TypeAnnotationFix_remove, cuRewrite);
            ASTRewrite astRewrite = cuRewrite.getASTRewrite();
            if (this.fAnnotation != null) {
                if (this.fNewAnnotationTarget != null) {
                    Annotation newAnnotation = (Annotation)astRewrite.createMoveTarget((ASTNode)this.fAnnotation);
                    TypeAnnotationRewriteOperations.addTypeAnnotation(astRewrite, this.fNewAnnotationTarget, newAnnotation, group);
                }
                astRewrite.remove((ASTNode)this.fAnnotation, group);
            }
        }

        public static ASTNode determineNewAnnotationTarget(Annotation annotation) {
            List dimensions;
            Object type;
            ASTNode parent = annotation.getParent();
            if (parent instanceof MethodDeclaration) {
                MethodDeclaration methodDeclaration = (MethodDeclaration)parent;
                List extraDimensions = methodDeclaration.extraDimensions();
                if (!extraDimensions.isEmpty()) {
                    return (ASTNode)extraDimensions.get(0);
                }
                type = methodDeclaration.getReturnType2();
            } else {
                type = parent instanceof FieldDeclaration ? ((FieldDeclaration)parent).getType() : (parent instanceof SingleVariableDeclaration ? ((SingleVariableDeclaration)parent).getType() : (parent instanceof VariableDeclarationStatement ? ((VariableDeclarationStatement)parent).getType() : (parent instanceof SimpleType && parent.getParent() instanceof QualifiedType ? (Type)parent.getParent() : null)));
            }
            if (type == null) {
                return null;
            }
            if (type.isPrimitiveType()) {
                return null;
            }
            if (type.isParameterizedType()) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                type = parameterizedType.getType();
            }
            if (type.isAnnotatable()) {
                return type;
            }
            if (type.isArrayType() && !(dimensions = ((ArrayType)type).dimensions()).isEmpty()) {
                return (ASTNode)dimensions.get(0);
            }
            return null;
        }
    }
}

