/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.lang.reflect.Method;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.net4j.util.StringUtil;

public class ThreadPool
extends ThreadPoolExecutor
implements RejectedExecutionHandler {
    public static final String DEFAULT_THREAD_GROUP_NAME = "net4j";
    public static final int DEFAULT_CORE_POOL_SIZE = 10;
    public static final int DEFAULT_MAXIMUM_POOL_SIZE = Integer.MAX_VALUE;
    public static final long DEFAULT_KEEP_ALIVE_SECONDS = 60L;
    private static final Class<?> LINKED_BLOCKING_DEQUE_CLASS;
    private static final Method ADD_FIRST_METHOD;

    static {
        Class<?> c = null;
        Method m = null;
        try {
            c = Class.forName("java.util.concurrent.LinkedBlockingDeque");
            m = c.getMethod("addFirst", Object.class);
        }
        catch (Throwable ex) {
            c = null;
            m = null;
        }
        LINKED_BLOCKING_DEQUE_CLASS = c;
        ADD_FIRST_METHOD = m;
    }

    public ThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, TimeUnit.SECONDS, (BlockingQueue<Runnable>)ThreadPool.createWorkQueue(), threadFactory);
        ((WorkQueue)this.getQueue()).setThreadPool(this);
        this.setRejectedExecutionHandler(this);
    }

    public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
        ((WorkQueue)this.getQueue()).addFirst(runnable);
    }

    public static ThreadPool create() {
        return ThreadPool.create(null, 10, Integer.MAX_VALUE, 60L);
    }

    public static ThreadPool create(String description) {
        String[] tokens;
        String threadGroupName = null;
        int corePoolSize = 10;
        int maximumPoolSize = Integer.MAX_VALUE;
        long keepAliveSeconds = 60L;
        if (!StringUtil.isEmpty(description) && (tokens = description.split(":")).length > 0) {
            threadGroupName = tokens[0];
            if (tokens.length > 1) {
                try {
                    corePoolSize = Integer.parseInt(tokens[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (tokens.length > 2) {
                    try {
                        maximumPoolSize = Integer.parseInt(tokens[2]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (tokens.length > 3) {
                        try {
                            keepAliveSeconds = Long.parseLong(tokens[3]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return ThreadPool.create(threadGroupName, corePoolSize, maximumPoolSize, keepAliveSeconds);
    }

    public static ThreadPool create(String threadGroupName, int corePoolSize, int maximumPoolSize, long keepAliveSeconds) {
        ThreadFactory threadFactory = ThreadPool.createThreadFactory(threadGroupName);
        return new ThreadPool(corePoolSize, maximumPoolSize, keepAliveSeconds, threadFactory);
    }

    private static ThreadFactory createThreadFactory(String threadGroupName) {
        if (threadGroupName == null) {
            threadGroupName = DEFAULT_THREAD_GROUP_NAME;
        }
        final ThreadGroup threadGroup = new ThreadGroup(threadGroupName);
        ThreadFactory threadFactory = new ThreadFactory(){
            private final AtomicInteger num = new AtomicInteger();

            public Thread newThread(Runnable r) {
                Thread thread = new Thread(threadGroup, r, String.valueOf(threadGroup.getName()) + "-thread-" + this.num.incrementAndGet());
                thread.setDaemon(true);
                return thread;
            }
        };
        return threadFactory;
    }

    private static WorkQueue createWorkQueue() {
        if (LINKED_BLOCKING_DEQUE_CLASS != null) {
            try {
                return new WorkQueueJRE16();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new WorkQueueJRE15();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface WorkQueue
    extends BlockingQueue<Runnable> {
        public void setThreadPool(ThreadPool var1);

        public void addFirst(Runnable var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WorkQueueJRE15
    extends LinkedBlockingQueue<Runnable>
    implements WorkQueue {
        private static final long serialVersionUID = 1L;
        private ThreadPool threadPool;

        @Override
        public void setThreadPool(ThreadPool threadPool) {
            this.threadPool = threadPool;
        }

        @Override
        public void addFirst(Runnable runnable) {
            super.offer(runnable);
        }

        @Override
        public boolean offer(Runnable runnable) {
            int poolSize = this.threadPool.getPoolSize();
            if (poolSize < this.threadPool.getMaximumPoolSize() && poolSize == this.threadPool.getActiveCount()) {
                return false;
            }
            return super.offer(runnable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class WorkQueueJRE16
    extends AbstractQueue<Runnable>
    implements WorkQueue {
        private final BlockingQueue<Runnable> delegate = WorkQueueJRE16.createDelegate();
        private ThreadPool threadPool;

        @Override
        public void setThreadPool(ThreadPool threadPool) {
            this.threadPool = threadPool;
        }

        @Override
        public void addFirst(Runnable runnable) {
            try {
                ADD_FIRST_METHOD.invoke(this.delegate, runnable);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.delegate.offer(runnable);
        }

        @Override
        public boolean offer(Runnable r) {
            int poolSize = this.threadPool.getPoolSize();
            if (poolSize < this.threadPool.getMaximumPoolSize() && poolSize == this.threadPool.getActiveCount()) {
                return false;
            }
            return this.delegate.offer(r);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public Runnable poll() {
            return (Runnable)this.delegate.poll();
        }

        @Override
        public Iterator<Runnable> iterator() {
            return this.delegate.iterator();
        }

        @Override
        public Runnable peek() {
            return (Runnable)this.delegate.peek();
        }

        @Override
        public void put(Runnable e) throws InterruptedException {
            this.delegate.put(e);
        }

        @Override
        public boolean offer(Runnable e, long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.offer(e, timeout, unit);
        }

        @Override
        public Runnable take() throws InterruptedException {
            return this.delegate.take();
        }

        @Override
        public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
            return this.delegate.poll(timeout, unit);
        }

        @Override
        public int remainingCapacity() {
            return this.delegate.remainingCapacity();
        }

        @Override
        public int drainTo(Collection<? super Runnable> c) {
            return this.delegate.drainTo(c);
        }

        @Override
        public int drainTo(Collection<? super Runnable> c, int maxElements) {
            return this.delegate.drainTo(c, maxElements);
        }

        private static BlockingQueue<Runnable> createDelegate() {
            try {
                return (BlockingQueue)LINKED_BLOCKING_DEQUE_CLASS.newInstance();
            }
            catch (Throwable throwable) {
                return new LinkedBlockingQueue<Runnable>();
            }
        }
    }
}

