/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.LinkedList;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.WrappedException;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLOutput {
    private static final AttributesImpl NO_ATTRIBUTES = new AttributesImpl();
    private TransformerHandler xmlHandler;
    private char[] newLine;
    private char[] indentation;
    private LinkedList<Element> stack = new LinkedList();
    private Element element;

    public XMLOutput(OutputStream out) throws TransformerConfigurationException, SAXException {
        this.setNewLine("\n");
        this.setIndentation("  ");
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        this.xmlHandler = factory.newTransformerHandler();
        Transformer transformer = this.xmlHandler.getTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("version", "1.0");
        transformer.setOutputProperty("encoding", "UTF-8");
        this.xmlHandler.setResult(new StreamResult(out));
        this.xmlHandler.startDocument();
    }

    public void setNewLine(String newLine) {
        this.newLine = newLine.toCharArray();
    }

    public void setIndentation(String indentation) {
        this.indentation = indentation.toCharArray();
    }

    public XMLOutput element(String name) throws SAXException {
        this.flush();
        this.element = new Element(name);
        return this;
    }

    public XMLOutput attribute(String name, Object value) throws SAXException {
        if (value != null) {
            return this.attributeOrNull(name, value);
        }
        return this;
    }

    public XMLOutput attributeOrNull(String name, Object value) throws SAXException {
        this.checkElement();
        this.element.addAttribute(name, value);
        return this;
    }

    public Writer characters() throws SAXException {
        this.checkElement();
        this.newLine();
        this.element.start();
        this.xmlHandler.startCDATA();
        return new Writer(){

            public void write(char[] cbuf, int off, int len) throws IOException {
                try {
                    XMLOutput.this.xmlHandler.characters(cbuf, off, len);
                }
                catch (SAXException ex) {
                    throw WrappedException.wrap(ex);
                }
            }

            public void flush() throws IOException {
            }

            public void close() throws IOException {
                try {
                    try {
                        XMLOutput.this.xmlHandler.endCDATA();
                        XMLOutput.this.element.end();
                    }
                    catch (SAXException ex) {
                        throw WrappedException.wrap(ex);
                    }
                }
                finally {
                    XMLOutput.this.element = null;
                }
            }
        };
    }

    public OutputStream bytes() throws SAXException {
        this.checkElement();
        this.newLine();
        this.element.start();
        this.xmlHandler.startCDATA();
        return new OutputStream(){

            public void write(byte[] b, int off, int len) throws IOException {
                try {
                    char[] cbuf = HexUtil.bytesToHex(b, off, len).toCharArray();
                    XMLOutput.this.xmlHandler.characters(cbuf, 0, cbuf.length);
                }
                catch (SAXException ex) {
                    throw WrappedException.wrap(ex);
                }
            }

            public void write(int i) throws IOException {
                byte b = (byte)((i & 0xFF) + -128);
                byte[] bs = new byte[]{b};
                this.write(bs, 0, 1);
            }

            public void close() throws IOException {
                try {
                    try {
                        XMLOutput.this.xmlHandler.endCDATA();
                        XMLOutput.this.element.end();
                    }
                    catch (SAXException ex) {
                        throw WrappedException.wrap(ex);
                    }
                }
                finally {
                    XMLOutput.this.element = null;
                }
            }
        };
    }

    public XMLOutput push() throws SAXException {
        this.newLine();
        this.element.start();
        this.stack.add(this.element);
        this.element = null;
        return this;
    }

    public XMLOutput pop() throws SAXException {
        this.flush();
        Element element = this.stack.removeLast();
        if (element.hasChildren()) {
            this.newLine();
        }
        element.end();
        return this;
    }

    public void done() throws SAXException {
        while (!this.stack.isEmpty()) {
            this.pop();
        }
        this.xmlHandler.endDocument();
    }

    private void flush() throws SAXException {
        if (this.element != null) {
            this.newLine();
            this.element.start();
            this.element.end();
            this.element = null;
        }
    }

    private void newLine() throws SAXException {
        this.xmlHandler.ignorableWhitespace(this.newLine, 0, this.newLine.length);
        int i = 0;
        while (i < this.stack.size()) {
            this.xmlHandler.ignorableWhitespace(this.indentation, 0, this.indentation.length);
            ++i;
        }
    }

    private void checkElement() {
        if (this.element == null) {
            throw new IllegalStateException("No element");
        }
    }

    private final class Element {
        private String name;
        private AttributesImpl attributes;
        private boolean children;

        public Element(String name) {
            this.name = name;
        }

        public boolean hasChildren() {
            return this.children;
        }

        public void addChild() {
            this.children = true;
        }

        public void addAttribute(String name, Object value) {
            if (this.attributes == null) {
                this.attributes = new AttributesImpl();
            }
            if (value == null) {
                value = "";
            }
            this.attributes.addAttribute("", "", name, "", value.toString());
        }

        public void start() throws SAXException {
            if (!XMLOutput.this.stack.isEmpty()) {
                ((Element)XMLOutput.this.stack.getLast()).addChild();
            }
            XMLOutput.this.xmlHandler.startElement("", "", this.name, this.attributes == null ? NO_ATTRIBUTES : this.attributes);
        }

        public void end() throws SAXException {
            XMLOutput.this.xmlHandler.endElement("", "", this.name);
        }
    }
}

