/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.statevalue;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.DoubleStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.LongStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

final class IntegerStateValue
extends TmfStateValue {
    private final int value;

    public IntegerStateValue(int valueAsInt) {
        this.value = valueAsInt;
    }

    @Override
    public ITmfStateValue.Type getType() {
        return ITmfStateValue.Type.INTEGER;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof IntegerStateValue)) {
            return false;
        }
        IntegerStateValue other = (IntegerStateValue)object;
        return this.value == other.value;
    }

    public int hashCode() {
        return this.value;
    }

    public @Nullable String toString() {
        return String.format("%3d", this.value);
    }

    @Override
    public int unboxInt() {
        return this.value;
    }

    @Override
    public long unboxLong() {
        return this.value;
    }

    @Override
    public int compareTo(@Nullable ITmfStateValue other) {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        switch (other.getType()) {
            case INTEGER: {
                IntegerStateValue otherIntValue = (IntegerStateValue)other;
                return Integer.compare(this.value, otherIntValue.value);
            }
            case DOUBLE: {
                double otherDoubleValue = ((DoubleStateValue)other).unboxDouble();
                return Double.compare(this.value, otherDoubleValue);
            }
            case LONG: {
                long otherLongValue = ((LongStateValue)other).unboxLong();
                return Long.compare(this.value, otherLongValue);
            }
            case NULL: {
                return Integer.compare(this.value, other.unboxInt());
            }
            case STRING: {
                throw new StateValueTypeException("An Integer state value cannot be compared to a String state value.");
            }
        }
        throw new StateValueTypeException("An Integer state value cannot be compared to the type " + (Object)((Object)other.getType()));
    }

    @Override
    public @Nullable Object unboxValue() {
        return this.value;
    }
}

