/*******************************************************************************
* Copyright (c) 2004 Actuate Corporation.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*  Actuate Corporation  - initial API and implementation
*******************************************************************************/ 

package org.eclipse.birt.report.model.elements;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.RectangleHandle;
import org.eclipse.birt.report.model.api.elements.ReportDesignConstants;
import org.eclipse.birt.report.model.core.Module;

/**
 * The Rectangle element describes a simple rectangle. The user can set the line
 * size, line color, line pattern and fill color using style properties. The
 * rectangle element adds no properties beyond those inherited from the base
 * graphic item.
 * 
 */

public class RectangleItem extends ReportItem
{

	/**
	 * Default constructor.
	 */

	public RectangleItem( )
	{
		super( );
	}

	/**
	 * Constructs the rectangle item with an optional name.
	 * 
	 * @param theName
	 *            the optional name
	 */

	public RectangleItem( String theName )
	{
		super( theName );
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.birt.report.model.core.DesignElement#getElementName()
	 */

	public String getElementName( )
	{
		return ReportDesignConstants.RECTANGLE_ITEM;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.birt.report.model.core.DesignElement#getHandle(org.eclipse.birt.report.model.elements.ReportDesign)
	 */

	public DesignElementHandle getHandle( Module module )
	{
		return handle( module );
	}

	/**
	 * Returns an API handle for this element.
	 * 
	 * @param module
	 *            the report design
	 * @return an API handle for this element
	 */

	public RectangleHandle handle( Module module )
	{
		if ( handle == null )
		{
			handle = new RectangleHandle( module, this );
		}
		return (RectangleHandle) handle;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.birt.report.model.core.DesignElement#apply(org.eclipse.birt.report.model.elements.ElementVisitor)
	 */
	
	public void apply( ElementVisitor visitor )
	{
		visitor.visitRectangle( this );
	}
}
