/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.launching;

import java.text.ParseException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifierImpl;
import org.eclipse.datatools.sqltools.core.profile.ConnectProfile;
import org.eclipse.datatools.sqltools.core.profile.ISQLToolsProfileListener;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorActivator;
import org.eclipse.datatools.sqltools.routineeditor.launching.LaunchHelper;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class SQLToolsLaunchProfileListener
implements ISQLToolsProfileListener {
    public void profileChanged(IConnectionProfile profile, String oldName, String oldDesc, Boolean oldAutoConnect, boolean onlyNameChanged, ConnectProfile oldProfile) {
        ILaunchConfigurationType type = LaunchHelper.getLaunchConfigType();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
            int i = 0;
            while (i < configs.length) {
                try {
                    DatabaseIdentifier databaseIdentifier = LaunchHelper.readDatabaseIdentifier(configs[i]);
                    String pName = databaseIdentifier.getProfileName();
                    if (pName.equals(oldName)) {
                        ILaunchConfigurationWorkingCopy copy = configs[i].getWorkingCopy();
                        String encodedProc = configs[i].getAttribute("org.eclipse.datatools.sqltools.debug.launching.procid", "");
                        ProcIdentifier procId = ProcIdentifierImpl.decodeWithNewProfile((String)encodedProc, (String)profile.getName());
                        copy.setAttribute("org.eclipse.datatools.sqltools.debug.launching.procid", procId.encode());
                        copy.setAttribute("org.eclipse.datatools.sqltools.debug.launching.profileName", profile.getName());
                        copy.doSave();
                    }
                }
                catch (ParseException pe) {
                    RoutineEditorActivator.getDefault().log(pe);
                }
                catch (CoreException coreException) {}
                ++i;
            }
        }
        catch (CoreException ce) {
            RoutineEditorActivator.getDefault().log(ce);
        }
    }

    public void profileAdded(IConnectionProfile profile) {
    }

    public void profileDeleted(IConnectionProfile profile) {
        ILaunchConfigurationType type = LaunchHelper.getLaunchConfigType();
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
            int i = 0;
            while (i < configs.length) {
                try {
                    DatabaseIdentifier databaseIdentifier = LaunchHelper.readDatabaseIdentifier(configs[i]);
                    String pName = databaseIdentifier.getProfileName();
                    if (pName.equals(profile.getName())) {
                        configs[i].delete();
                    }
                }
                catch (CoreException coreException) {}
                ++i;
            }
        }
        catch (CoreException ce) {
            RoutineEditorActivator.getDefault().log(ce);
        }
    }
}

