/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.ui.internal.menu;

import java.io.IOException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.gitflow.Activator;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.ui.internal.UIText;
import org.eclipse.egit.gitflow.ui.internal.actions.ReleaseStartFromCommitHandler;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class DynamicHistoryMenu
extends ContributionItem {
    public void fill(Menu menu, int index) {
        GitFlowRepository gfRepo = this.getRepository();
        if (gfRepo == null) {
            return;
        }
        RevCommit selectedCommit = this.getSelectedCommit();
        if (selectedCommit == null) {
            return;
        }
        String startCommitSha1 = selectedCommit.getName();
        Shell activeShell = this.getActiveShell();
        ReleaseStartFromCommitHandler listener = new ReleaseStartFromCommitHandler(gfRepo, startCommitSha1, activeShell);
        MenuItem menuItem = new MenuItem(menu, 8, index);
        menuItem.setText(NLS.bind((String)UIText.DynamicHistoryMenu_startGitflowReleaseFrom, (Object)this.abbreviate(selectedCommit)));
        menuItem.addSelectionListener((SelectionListener)listener);
        boolean isEnabled = false;
        try {
            isEnabled = gfRepo.isOnDevelop(selectedCommit);
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log(org.eclipse.egit.gitflow.ui.Activator.error(e.getMessage(), e));
        }
        menuItem.setEnabled(isEnabled);
    }

    private String abbreviate(RevCommit selectedCommit) {
        return selectedCommit.getId().abbreviate(7).name();
    }

    private RevCommit getSelectedCommit() {
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getSelectionProvider().getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structSelection = (IStructuredSelection)selection;
        Object firstElement = structSelection.getFirstElement();
        if (!(firstElement instanceof RevCommit)) {
            return null;
        }
        return (RevCommit)firstElement;
    }

    private Shell getActiveShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    private GitFlowRepository getRepository() {
        IWorkbenchPart activePart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        Repository repository = (Repository)Utils.getAdapter((IAdaptable)activePart, Repository.class);
        if (repository == null) {
            return null;
        }
        return new GitFlowRepository(repository);
    }
}

