/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.profiling.launch;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;

public class LocalFileProxy
implements IRemoteFileProxy {
    URI workingDirURI;

    public LocalFileProxy(URI uri) {
        this.workingDirURI = uri;
    }

    @Override
    public URI toURI(IPath path) {
        return path.toFile().toURI();
    }

    @Override
    public URI toURI(String path) {
        try {
            return new URI(path);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public String toPath(URI uri) {
        return uri.getPath();
    }

    @Override
    public String getDirectorySeparator() {
        return System.getProperty("file.separator");
    }

    @Override
    public IFileStore getResource(String path) {
        return EFS.getLocalFileSystem().getStore((IPath)new Path(path));
    }

    @Override
    public URI getWorkingDir() {
        return this.workingDirURI;
    }
}

