/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.GeneratedCodeMap;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.dynamicimpl.TypeHandler;

public interface JavaCodeGenerator {
    public GlobalScope newGlobalScope(Collection<TypeHandler<?>> var1, Collection<GeneratedCodeMap> var2);

    public static interface ClassScope
    extends FileScope {
        public ClassScope getRootClassScope();

        @Override
        public ClassScope newClassScope();

        public <T extends ElementData> T addMember(Object var1, ElementFactory<T> var2);

        public MethodScope newMethodScope();

        public void writeClassMembers();
    }

    public static interface ElementData {
        public void generateCode(ClassScope var1);
    }

    public static interface ElementFactory<T extends ElementData> {
        public T create(int var1);
    }

    public static interface FileScope
    extends GlobalScope {
        public StringBuilder getStringBuilder();

        public void startLine(String var1);

        public void append(String var1);

        public void indentRight();

        public void indentLeft();

        public ClassScope newClassScope();
    }

    public static interface GlobalScope {
        public String getTypeImplReference(TypeHandler<?> var1);

        public String getTypeImplShortName(TypeHandler<?> var1);

        public FileScope newFileScope(StringBuilder var1);
    }

    public static class Impl
    implements JavaCodeGenerator {
        @Override
        public GlobalScope newGlobalScope(Collection<TypeHandler<?>> typeHandlers, Collection<GeneratedCodeMap> basePackages) {
            return new GlobalScopeImpl(typeHandlers, basePackages);
        }

        private static class ClassScopeImpl
        extends FileScopeImpl
        implements ClassScope {
            private final State state;
            private final ClassScope parentClass;

            ClassScopeImpl(FileScopeImpl fileScopeImpl, ClassScope parentClass) {
                super(fileScopeImpl);
                this.state = new State();
                this.parentClass = parentClass;
            }

            ClassScopeImpl(ClassScopeImpl classScopeImpl) {
                super(classScopeImpl);
                this.state = classScopeImpl.state;
                this.parentClass = classScopeImpl.parentClass;
            }

            @Override
            public ClassScope getRootClassScope() {
                if (this.parentClass == null) {
                    return this;
                }
                return this.parentClass.getRootClassScope();
            }

            @Override
            public <T extends ElementData> T addMember(Object key, ElementFactory<T> factory) {
                return this.state.addMember(key, factory);
            }

            @Override
            public void writeClassMembers() {
                this.state.writeClassElements(this);
            }

            @Override
            public MethodScope newMethodScope() {
                return new MethodScopeImpl(this);
            }

            @Override
            protected ClassScopeImpl asClassScopeImpl() {
                return this;
            }

            private static class State {
                private final Map<Object, ElementData> key2ElementData = new HashMap<Object, ElementData>(2);
                private int nextCode = 0;

                private State() {
                }

                <T extends ElementData> T addMember(Object key, ElementFactory<T> factory) {
                    List<Object> extendedKey = Arrays.asList(key, factory);
                    ElementData rawData = this.key2ElementData.get(extendedKey);
                    ElementData data = rawData;
                    if (data == null) {
                        data = factory.create(this.nextCode++);
                        this.key2ElementData.put(extendedKey, data);
                    }
                    return (T)data;
                }

                void writeClassElements(ClassScope classScope) {
                    for (ElementData data : this.key2ElementData.values()) {
                        data.generateCode(classScope);
                    }
                    this.key2ElementData.clear();
                }
            }
        }

        private static class FileScopeImpl
        extends GlobalScopeImpl
        implements FileScope {
            private final State state;

            FileScopeImpl(GlobalScopeImpl globalScopeImpl, StringBuilder stringBuilder) {
                super(globalScopeImpl);
                this.state = new State(stringBuilder);
            }

            FileScopeImpl(FileScopeImpl fileScopeImpl) {
                super(fileScopeImpl);
                this.state = fileScopeImpl.state;
            }

            @Override
            public StringBuilder getStringBuilder() {
                return this.state.getStringBuilder();
            }

            @Override
            public void startLine(String line) {
                this.state.startLine(line);
            }

            @Override
            public void append(String line) {
                this.state.append(line);
            }

            @Override
            public void indentRight() {
                this.state.indentRight();
            }

            @Override
            public void indentLeft() {
                this.state.indentLeft();
            }

            @Override
            public ClassScope newClassScope() {
                return new ClassScopeImpl(this, this.asClassScopeImpl());
            }

            protected ClassScopeImpl asClassScopeImpl() {
                return null;
            }

            private static class State {
                private final StringBuilder stringBuilder;
                private int indent = 0;

                State(StringBuilder stringBuilder) {
                    this.stringBuilder = stringBuilder;
                }

                StringBuilder getStringBuilder() {
                    return this.stringBuilder;
                }

                void startLine(String line) {
                    int i = 0;
                    while (i < this.indent) {
                        this.stringBuilder.append(' ');
                        ++i;
                    }
                    this.stringBuilder.append(line);
                }

                void append(String line) {
                    this.stringBuilder.append(line);
                }

                void indentRight() {
                    this.indent += 2;
                }

                void indentLeft() {
                    this.indent -= 2;
                }
            }
        }

        private static class GlobalScopeImpl
        implements GlobalScope {
            private final State state;

            GlobalScopeImpl(Collection<TypeHandler<?>> typeHandlers, Collection<GeneratedCodeMap> basePackages) {
                this.state = new State(typeHandlers, basePackages);
            }

            GlobalScopeImpl(GlobalScopeImpl globalScopeImpl) {
                this.state = globalScopeImpl.state;
            }

            @Override
            public String getTypeImplReference(TypeHandler<?> typeHandler) {
                return this.state.getTypeImplReference(typeHandler);
            }

            @Override
            public String getTypeImplShortName(TypeHandler<?> typeHandler) {
                return this.state.getTypeImplShortName(typeHandler);
            }

            @Override
            public FileScope newFileScope(StringBuilder output) {
                return new FileScopeImpl(this, output);
            }

            private static class State {
                private final Map<TypeHandler<?>, String> type2Name;
                private final Collection<GeneratedCodeMap> basePackages;

                State(Collection<TypeHandler<?>> typeHandlers, Collection<GeneratedCodeMap> basePackages) {
                    this.basePackages = basePackages;
                    this.type2Name = State.buildLocalTypeNameMap(typeHandlers);
                }

                String getTypeImplReference(TypeHandler<?> typeHandler) {
                    String localName = this.type2Name.get(typeHandler);
                    if (localName == null) {
                        for (GeneratedCodeMap base : this.basePackages) {
                            String result = base.getTypeImplementationReference(typeHandler.getTypeClass());
                            if (result == null) continue;
                            return result;
                        }
                    } else {
                        return localName;
                    }
                    throw new RuntimeException();
                }

                String getTypeImplShortName(TypeHandler<?> typeHandler) {
                    String result = this.type2Name.get(typeHandler);
                    if (result == null) {
                        throw new RuntimeException();
                    }
                    return result;
                }

                private static Map<TypeHandler<?>, String> buildLocalTypeNameMap(Collection<TypeHandler<?>> typeHandlers) {
                    ArrayList list = new ArrayList(typeHandlers);
                    Collections.sort(list, new Comparator<TypeHandler<?>>(){

                        @Override
                        public int compare(TypeHandler<?> o1, TypeHandler<?> o2) {
                            return this.getName(o1).compareTo(this.getName(o2));
                        }

                        private String getName(TypeHandler<?> handler) {
                            return handler.getTypeClass().getName();
                        }
                    });
                    int uniqueCode = 0;
                    HashMap result = new HashMap();
                    for (TypeHandler typeHandler : list) {
                        String name;
                        String conflict = result.put(typeHandler, name = "Value_" + uniqueCode++);
                        if (conflict == null) continue;
                        throw new RuntimeException();
                    }
                    return result;
                }
            }
        }

        private static class MethodScopeImpl
        extends ClassScopeImpl
        implements MethodScope {
            private final State state = new State();

            public MethodScopeImpl(ClassScopeImpl classScopeImpl) {
                super(classScopeImpl);
            }

            @Override
            public String newMethodScopedName(String prefix) {
                return this.state.newMethodScopedName(prefix);
            }

            private static class State {
                private int nextId = 0;

                private State() {
                }

                String newMethodScopedName(String prefix) {
                    return String.valueOf(prefix) + this.nextId++;
                }
            }
        }
    }

    public static interface MethodScope
    extends ClassScope {
        public String newMethodScopedName(String var1);
    }

    public static class Util {
        public static final String BASE_PACKAGE = "org.eclipse.wst.jsdt.chromium.internal.protocolparser";
        public static final String THROWS_CLAUSE = " throws org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException";

        public static void writeJavaTypeName(Type arg, StringBuilder output) {
            if (arg instanceof Class) {
                Class clazz = (Class)arg;
                output.append(clazz.getCanonicalName());
            } else if (arg instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)arg;
                Util.writeJavaTypeName(parameterizedType.getRawType(), output);
                output.append("<");
                Type[] params = parameterizedType.getActualTypeArguments();
                int i = 0;
                while (i < params.length) {
                    if (i != 0) {
                        output.append(", ");
                    }
                    Util.writeJavaTypeName(params[i], output);
                    ++i;
                }
                output.append(">");
            } else if (arg instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)arg;
                Type[] upperBounds = wildcardType.getUpperBounds();
                if (upperBounds == null) {
                    throw new RuntimeException();
                }
                if (upperBounds.length != 1) {
                    throw new RuntimeException();
                }
                output.append("? extends ");
                Util.writeJavaTypeName(upperBounds[0], output);
            } else {
                output.append(arg);
            }
        }

        public static void writeReadValueAndHasValue(MethodScope scope, String fieldName, String jsonObjectRef, String valueRef, String hasValueRef) {
            scope.startLine("Object " + valueRef + " = " + jsonObjectRef + ".get(\"" + fieldName + "\");\n");
            scope.startLine("boolean " + hasValueRef + ";\n");
            scope.startLine("if (" + valueRef + " == null) {\n");
            scope.startLine("  " + hasValueRef + " = " + jsonObjectRef + ".containsKey(\"" + fieldName + "\");\n");
            scope.startLine("} else {\n");
            scope.startLine("  " + hasValueRef + " = true;\n");
            scope.startLine("}\n");
        }
    }
}

