/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native.value;

import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.internal.v8native.InternalContext;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.ValueHandle;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.EvaluateMessage;
import org.eclipse.wst.jsdt.chromium.util.GenericCallback;
import org.eclipse.wst.jsdt.chromium.util.RelaySyncCallback;

public interface LoadableString {
    public String getCurrentString();

    public boolean needsReload();

    public RelayOk reloadBigger(GenericCallback<Void> var1, SyncCallback var2);

    public EvaluateMessage.Value getProtocolDescription(InternalContext var1);

    public static interface Factory {
        public static final Factory IMMUTABLE = new Factory(){

            @Override
            public LoadableString create(ValueHandle handle) {
                return new Immutable(handle.text());
            }
        };

        public LoadableString create(ValueHandle var1);
    }

    public static class Immutable
    implements LoadableString {
        private final String value;

        public Immutable(String value) {
            this.value = value;
        }

        @Override
        public String getCurrentString() {
            return this.value;
        }

        @Override
        public boolean needsReload() {
            return false;
        }

        @Override
        public RelayOk reloadBigger(GenericCallback<Void> callback, SyncCallback syncCallback) {
            if (callback != null) {
                callback.success(null);
            }
            return RelaySyncCallback.finish(syncCallback);
        }

        @Override
        public EvaluateMessage.Value getProtocolDescription(InternalContext hostInternalContext) {
            return EvaluateMessage.Value.createForValue(this.value);
        }
    }
}

