/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.agilegrid;

import java.beans.PropertyChangeListener;
import org.agilemore.agilegrid.CellEditor;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class AgileCellEditorActionHandler {
    private final ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
    private CutActionHandler cellCutAction = new CutActionHandler();
    private CopyActionHandler cellCopyAction = new CopyActionHandler();
    private PasteActionHandler cellPasteAction = new PasteActionHandler();
    private DeleteActionHandler cellDeleteAction = new DeleteActionHandler();
    private SelectAllActionHandler cellSelectAllAction = new SelectAllActionHandler();
    private FindActionHandler cellFindAction = new FindActionHandler();
    private UndoActionHandler cellUndoAction = new UndoActionHandler();
    private RedoActionHandler cellRedoAction = new RedoActionHandler();
    private IAction cutAction;
    private IAction copyAction;
    private IAction pasteAction;
    private IAction deleteAction;
    private IAction selectAllAction;
    private IAction findAction;
    private IAction undoAction;
    private IAction redoAction;
    private IPropertyChangeListener cutActionListener = new ActionEnabledChangeListener((IAction)this.cellCutAction);
    private IPropertyChangeListener copyActionListener = new ActionEnabledChangeListener((IAction)this.cellCopyAction);
    private IPropertyChangeListener pasteActionListener = new ActionEnabledChangeListener((IAction)this.cellPasteAction);
    private IPropertyChangeListener deleteActionListener = new ActionEnabledChangeListener((IAction)this.cellDeleteAction);
    private IPropertyChangeListener selectAllActionListener = new ActionEnabledChangeListener((IAction)this.cellSelectAllAction);
    private IPropertyChangeListener findActionListener = new ActionEnabledChangeListener((IAction)this.cellFindAction);
    private IPropertyChangeListener undoActionListener = new ActionEnabledChangeListener((IAction)this.cellUndoAction);
    private IPropertyChangeListener redoActionListener = new ActionEnabledChangeListener((IAction)this.cellRedoAction);
    private CellEditor activeEditor;
    private PropertyChangeListener cellListener = new CellChangeListener();
    private Listener controlListener = new ControlListener();

    public AgileCellEditorActionHandler(IActionBars actionBar) {
        actionBar.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cellCutAction);
        actionBar.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.cellCopyAction);
        actionBar.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.cellPasteAction);
        actionBar.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.cellDeleteAction);
        actionBar.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.cellSelectAllAction);
        actionBar.setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)this.cellFindAction);
        actionBar.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.cellUndoAction);
        actionBar.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.cellRedoAction);
    }

    public void dispose() {
        this.setCutAction(null);
        this.setCopyAction(null);
        this.setPasteAction(null);
        this.setDeleteAction(null);
        this.setSelectAllAction(null);
        this.setFindAction(null);
        this.setUndoAction(null);
        this.setRedoAction(null);
        if (this.activeEditor != null) {
            Control control = this.activeEditor.getControl();
            if (!control.isDisposed()) {
                control.removeListener(26, this.controlListener);
                control.removeListener(27, this.controlListener);
            }
            this.activeEditor.removePropertyChangeListener(this.cellListener);
        }
        this.activeEditor = null;
    }

    public void setCopyAction(IAction action) {
        if (this.copyAction == action) {
            return;
        }
        if (this.copyAction != null) {
            this.copyAction.removePropertyChangeListener(this.copyActionListener);
        }
        this.copyAction = action;
        if (this.copyAction != null) {
            this.copyAction.addPropertyChangeListener(this.copyActionListener);
        }
        this.cellCopyAction.updateEnabledState();
    }

    public void setCutAction(IAction action) {
        if (this.cutAction == action) {
            return;
        }
        if (this.cutAction != null) {
            this.cutAction.removePropertyChangeListener(this.cutActionListener);
        }
        this.cutAction = action;
        if (this.cutAction != null) {
            this.cutAction.addPropertyChangeListener(this.cutActionListener);
        }
        this.cellCutAction.updateEnabledState();
    }

    public void setDeleteAction(IAction action) {
        if (this.deleteAction == action) {
            return;
        }
        if (this.deleteAction != null) {
            this.deleteAction.removePropertyChangeListener(this.deleteActionListener);
        }
        this.deleteAction = action;
        if (this.deleteAction != null) {
            this.deleteAction.addPropertyChangeListener(this.deleteActionListener);
        }
        this.cellDeleteAction.updateEnabledState();
    }

    public void setFindAction(IAction action) {
        if (this.findAction == action) {
            return;
        }
        if (this.findAction != null) {
            this.findAction.removePropertyChangeListener(this.findActionListener);
        }
        this.findAction = action;
        if (this.findAction != null) {
            this.findAction.addPropertyChangeListener(this.findActionListener);
        }
        this.cellFindAction.updateEnabledState();
    }

    public void setPasteAction(IAction action) {
        if (this.pasteAction == action) {
            return;
        }
        if (this.pasteAction != null) {
            this.pasteAction.removePropertyChangeListener(this.pasteActionListener);
        }
        this.pasteAction = action;
        if (this.pasteAction != null) {
            this.pasteAction.addPropertyChangeListener(this.pasteActionListener);
        }
        this.cellPasteAction.updateEnabledState();
    }

    public void setRedoAction(IAction action) {
        if (this.redoAction == action) {
            return;
        }
        if (this.redoAction != null) {
            this.redoAction.removePropertyChangeListener(this.redoActionListener);
        }
        this.redoAction = action;
        if (this.redoAction != null) {
            this.redoAction.addPropertyChangeListener(this.redoActionListener);
        }
        this.cellRedoAction.updateEnabledState();
    }

    public void setSelectAllAction(IAction action) {
        if (this.selectAllAction == action) {
            return;
        }
        if (this.selectAllAction != null) {
            this.selectAllAction.removePropertyChangeListener(this.selectAllActionListener);
        }
        this.selectAllAction = action;
        if (this.selectAllAction != null) {
            this.selectAllAction.addPropertyChangeListener(this.selectAllActionListener);
        }
        this.cellSelectAllAction.updateEnabledState();
    }

    public void setUndoAction(IAction action) {
        if (this.undoAction == action) {
            return;
        }
        if (this.undoAction != null) {
            this.undoAction.removePropertyChangeListener(this.undoActionListener);
        }
        this.undoAction = action;
        if (this.undoAction != null) {
            this.undoAction.addPropertyChangeListener(this.undoActionListener);
        }
        this.cellUndoAction.updateEnabledState();
    }

    private void updateActionsEnableState() {
        this.cellCutAction.updateEnabledState();
        this.cellCopyAction.updateEnabledState();
        this.cellPasteAction.updateEnabledState();
        this.cellDeleteAction.updateEnabledState();
        this.cellSelectAllAction.updateEnabledState();
        this.cellFindAction.updateEnabledState();
        this.cellUndoAction.updateEnabledState();
        this.cellRedoAction.updateEnabledState();
    }

    public void setActiveCellEditor(CellEditor editor) {
        if (this.activeEditor != null) {
            this.activeEditor.removePropertyChangeListener(this.cellListener);
        }
        if (editor != null) {
            Control control = editor.getControl();
            if (control != null && !control.isDisposed()) {
                control.addListener(26, this.controlListener);
                control.addListener(27, this.controlListener);
            }
            editor.addPropertyChangeListener(this.cellListener);
            this.updateActionsEnableState();
        }
        this.activeEditor = editor;
    }

    private class ActionEnabledChangeListener
    implements IPropertyChangeListener {
        private IAction actionHandler;

        protected ActionEnabledChangeListener(IAction actionHandler) {
            this.actionHandler = actionHandler;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (AgileCellEditorActionHandler.this.activeEditor != null) {
                return;
            }
            if (event.getProperty().equals("enabled")) {
                Boolean bool = (Boolean)event.getNewValue();
                this.actionHandler.setEnabled(bool.booleanValue());
                return;
            }
            if (event.getProperty().equals("text")) {
                String text = (String)event.getNewValue();
                this.actionHandler.setText(text);
                return;
            }
            if (event.getProperty().equals("toolTipText")) {
                String text = (String)event.getNewValue();
                this.actionHandler.setToolTipText(text);
                return;
            }
        }
    }

    private class CellChangeListener
    implements PropertyChangeListener {
        private CellChangeListener() {
        }

        public void propertyChange(java.beans.PropertyChangeEvent event) {
            if (AgileCellEditorActionHandler.this.activeEditor == null) {
                return;
            }
            if (event.getPropertyName().equals("cut")) {
                AgileCellEditorActionHandler.this.cellCutAction.setEnabled(AgileCellEditorActionHandler.this.activeEditor.isCutEnabled());
                return;
            }
            if (event.getPropertyName().equals("copy")) {
                AgileCellEditorActionHandler.this.cellCopyAction.setEnabled(AgileCellEditorActionHandler.this.activeEditor.isCopyEnabled());
                return;
            }
            if (event.getPropertyName().equals("paste")) {
                AgileCellEditorActionHandler.this.cellPasteAction.setEnabled(AgileCellEditorActionHandler.this.activeEditor.isPasteEnabled());
                return;
            }
            if (event.getPropertyName().equals("delete")) {
                AgileCellEditorActionHandler.this.cellDeleteAction.setEnabled(AgileCellEditorActionHandler.this.activeEditor.isDeleteEnabled());
                return;
            }
            if (event.getPropertyName().equals("selectall")) {
                AgileCellEditorActionHandler.this.cellSelectAllAction.setEnabled(AgileCellEditorActionHandler.this.activeEditor.isSelectAllEnabled());
                return;
            }
            if (event.getPropertyName().equals("find")) {
                AgileCellEditorActionHandler.this.cellFindAction.setEnabled(AgileCellEditorActionHandler.this.activeEditor.isFindEnabled());
                return;
            }
            if (event.getPropertyName().equals("undo")) {
                AgileCellEditorActionHandler.this.cellUndoAction.setEnabled(AgileCellEditorActionHandler.this.activeEditor.isUndoEnabled());
                return;
            }
            if (event.getPropertyName().equals("redo")) {
                AgileCellEditorActionHandler.this.cellRedoAction.setEnabled(AgileCellEditorActionHandler.this.activeEditor.isRedoEnabled());
                return;
            }
        }
    }

    private class ControlListener
    implements Listener {
        private ControlListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 26: {
                    if (AgileCellEditorActionHandler.this.activeEditor != null) {
                        AgileCellEditorActionHandler.this.activeEditor.addPropertyChangeListener(AgileCellEditorActionHandler.this.cellListener);
                    }
                    AgileCellEditorActionHandler.this.updateActionsEnableState();
                    break;
                }
                case 27: {
                    if (AgileCellEditorActionHandler.this.activeEditor != null) {
                        AgileCellEditorActionHandler.this.activeEditor.removePropertyChangeListener(AgileCellEditorActionHandler.this.cellListener);
                    }
                    AgileCellEditorActionHandler.this.activeEditor = null;
                    AgileCellEditorActionHandler.this.updateActionsEnableState();
                    break;
                }
            }
        }
    }

    private class CopyActionHandler
    extends Action {
        protected CopyActionHandler() {
            super(EMFEditUIPlugin.INSTANCE.getString("_UI_Copy_menu_item"));
            this.setId("CellEditorCopyActionHandler");
            this.setEnabled(false);
            this.setImageDescriptor(AgileCellEditorActionHandler.this.sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        }

        public void runWithEvent(Event event) {
            if (AgileCellEditorActionHandler.this.activeEditor != null) {
                AgileCellEditorActionHandler.this.activeEditor.performCopy();
                return;
            }
            if (AgileCellEditorActionHandler.this.copyAction != null) {
                AgileCellEditorActionHandler.this.copyAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (AgileCellEditorActionHandler.this.activeEditor != null) {
                this.setEnabled(AgileCellEditorActionHandler.this.activeEditor.isCopyEnabled());
                return;
            }
            if (AgileCellEditorActionHandler.this.copyAction != null) {
                this.setEnabled(AgileCellEditorActionHandler.this.copyAction.isEnabled());
                return;
            }
            this.setEnabled(false);
        }
    }

    private class CutActionHandler
    extends Action {
        protected CutActionHandler() {
            super(EMFEditUIPlugin.INSTANCE.getString("_UI_Cut_menu_item"));
            this.setId("CellEditorCutActionHandler");
            this.setEnabled(false);
            this.setImageDescriptor(AgileCellEditorActionHandler.this.sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        }

        public void runWithEvent(Event event) {
            if (AgileCellEditorActionHandler.this.activeEditor != null) {
                AgileCellEditorActionHandler.this.activeEditor.performCut();
                return;
            }
            if (AgileCellEditorActionHandler.this.cutAction != null) {
                AgileCellEditorActionHandler.this.cutAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (AgileCellEditorActionHandler.this.activeEditor != null) {
                this.setEnabled(AgileCellEditorActionHandler.this.activeEditor.isCutEnabled());
                return;
            }
            if (AgileCellEditorActionHandler.this.cutAction != null) {
                this.setEnabled(AgileCellEditorActionHandler.this.cutAction.isEnabled());
                return;
            }
            this.setEnabled(false);
        }
    }

    private class DeleteActionHandler
    extends Action {
        protected DeleteActionHandler() {
            super(EMFEditUIPlugin.INSTANCE.getString("_UI_Delete_menu_item"));
            this.setId("CellEditorDeleteActionHandler");
            this.setEnabled(false);
            this.setImageDescriptor(AgileCellEditorActionHandler.this.sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        }

        public void runWithEvent(Event event) {
            if (AgileCellEditorActionHandler.this.activeEditor != null) {
                AgileCellEditorActionHandler.this.activeEditor.performDelete();
                return;
            }
            if (AgileCellEditorActionHandler.this.deleteAction != null) {
                AgileCellEditorActionHandler.this.deleteAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (AgileCellEditorActionHandler.this.activeEditor != null) {
                this.setEnabled(AgileCellEditorActionHandler.this.activeEditor.isDeleteEnabled());
                return;
            }
            if (AgileCellEditorActionHandler.this.deleteAction != null) {
                this.setEnabled(AgileCellEditorActionHandler.this.deleteAction.isEnabled());
                return;
            }
            this.setEnabled(false);
        }
    }

    private class FindActionHandler
    extends Action {
        protected FindActionHandler() {
            this.setId("CellEditorFindActionHandler");
            this.setEnabled(false);
        }

        public void runWithEvent(Event event) {
            if (AgileCellEditorActionHandler.this.activeEditor != null) {
                AgileCellEditorActionHandler.this.activeEditor.performFind();
                return;
            }
            if (AgileCellEditorActionHandler.this.findAction != null) {
                AgileCellEditorActionHandler.this.findAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (AgileCellEditorActionHandler.this.activeEditor != null) {
                this.setEnabled(AgileCellEditorActionHandler.this.activeEditor.isFindEnabled());
                return;
            }
            if (AgileCellEditorActionHandler.this.findAction != null) {
                this.setEnabled(AgileCellEditorActionHandler.this.findAction.isEnabled());
                return;
            }
            this.setEnabled(false);
        }
    }

    private class PasteActionHandler
    extends Action {
        protected PasteActionHandler() {
            super(EMFEditUIPlugin.INSTANCE.getString("_UI_Paste_menu_item"));
            this.setId("CellEditorPasteActionHandler");
            this.setEnabled(false);
            this.setImageDescriptor(AgileCellEditorActionHandler.this.sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        }

        public void runWithEvent(Event event) {
            if (AgileCellEditorActionHandler.this.activeEditor != null) {
                AgileCellEditorActionHandler.this.activeEditor.performPaste();
                return;
            }
            if (AgileCellEditorActionHandler.this.pasteAction != null) {
                AgileCellEditorActionHandler.this.pasteAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (AgileCellEditorActionHandler.this.activeEditor != null) {
                this.setEnabled(AgileCellEditorActionHandler.this.activeEditor.isPasteEnabled());
                return;
            }
            if (AgileCellEditorActionHandler.this.pasteAction != null) {
                this.setEnabled(AgileCellEditorActionHandler.this.pasteAction.isEnabled());
                return;
            }
            this.setEnabled(false);
        }
    }

    private class RedoActionHandler
    extends Action {
        protected RedoActionHandler() {
            super(EMFEditUIPlugin.INSTANCE.getString("_UI_Redo_menu_item"));
            this.setId("CellEditorRedoActionHandler");
            this.setEnabled(false);
            this.setImageDescriptor(AgileCellEditorActionHandler.this.sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        }

        public void runWithEvent(Event event) {
            if (AgileCellEditorActionHandler.this.activeEditor != null) {
                AgileCellEditorActionHandler.this.activeEditor.performRedo();
                return;
            }
            if (AgileCellEditorActionHandler.this.redoAction != null) {
                AgileCellEditorActionHandler.this.redoAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (AgileCellEditorActionHandler.this.activeEditor != null) {
                this.setEnabled(AgileCellEditorActionHandler.this.activeEditor.isRedoEnabled());
                return;
            }
            if (AgileCellEditorActionHandler.this.redoAction != null) {
                this.setEnabled(AgileCellEditorActionHandler.this.redoAction.isEnabled());
                this.setText(AgileCellEditorActionHandler.this.redoAction.getText());
                this.setToolTipText(AgileCellEditorActionHandler.this.redoAction.getToolTipText());
                return;
            }
            this.setEnabled(false);
        }
    }

    private class SelectAllActionHandler
    extends Action {
        protected SelectAllActionHandler() {
            super("Select All");
            this.setId("CellEditorSelectAllActionHandler");
            this.setEnabled(false);
        }

        public void runWithEvent(Event event) {
            if (AgileCellEditorActionHandler.this.activeEditor != null) {
                AgileCellEditorActionHandler.this.activeEditor.performSelectAll();
                return;
            }
            if (AgileCellEditorActionHandler.this.selectAllAction != null) {
                AgileCellEditorActionHandler.this.selectAllAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (AgileCellEditorActionHandler.this.activeEditor != null) {
                this.setEnabled(AgileCellEditorActionHandler.this.activeEditor.isSelectAllEnabled());
                return;
            }
            if (AgileCellEditorActionHandler.this.selectAllAction != null) {
                this.setEnabled(AgileCellEditorActionHandler.this.selectAllAction.isEnabled());
                return;
            }
            this.setEnabled(false);
        }
    }

    private class UndoActionHandler
    extends Action {
        protected UndoActionHandler() {
            super(EMFEditUIPlugin.INSTANCE.getString("_UI_Undo_menu_item"));
            this.setId("CellEditorUndoActionHandler");
            this.setEnabled(false);
            this.setImageDescriptor(AgileCellEditorActionHandler.this.sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        }

        public void runWithEvent(Event event) {
            if (AgileCellEditorActionHandler.this.activeEditor != null) {
                AgileCellEditorActionHandler.this.activeEditor.performUndo();
                return;
            }
            if (AgileCellEditorActionHandler.this.undoAction != null) {
                AgileCellEditorActionHandler.this.undoAction.runWithEvent(event);
                return;
            }
        }

        public void updateEnabledState() {
            if (AgileCellEditorActionHandler.this.activeEditor != null) {
                this.setEnabled(AgileCellEditorActionHandler.this.activeEditor.isUndoEnabled());
                return;
            }
            if (AgileCellEditorActionHandler.this.undoAction != null) {
                this.setEnabled(AgileCellEditorActionHandler.this.undoAction.isEnabled());
                this.setText(AgileCellEditorActionHandler.this.undoAction.getText());
                this.setToolTipText(AgileCellEditorActionHandler.this.undoAction.getToolTipText());
                return;
            }
            this.setEnabled(false);
        }
    }
}

