/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.agilegrid;

import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.Cell;
import org.agilemore.agilegrid.CellNavigationStrategy;
import org.agilemore.agilegrid.EditorActivationEvent;
import org.agilemore.agilegrid.ICellNavigationStrategy;
import org.agilemore.agilegrid.ILayoutAdvisor;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class ProrAgileGrid
extends AgileGrid {
    public static final int DND_DROP_AS_SIBLING = 0;
    public static final int DND_DROP_AS_CHILD = 1;
    public Cell dndHoverCell;
    public int dndHoverDropMode;
    protected ICellNavigationStrategy cyclingCellNavigationStrategy = new CellNavigationStrategy(){

        public Cell findSelectedCell(AgileGrid agileGrid, Cell currentCell, Event event) {
            if (event.type != 1 || event.keyCode != 9) {
                return super.findSelectedCell(agileGrid, currentCell, event);
            }
            Cell findSelectedCell = super.findSelectedCell(agileGrid, currentCell, event);
            System.out.println(findSelectedCell);
            if (findSelectedCell == null || findSelectedCell == currentCell) {
                int direction = (event.stateMask & 0x20000) != 0 ? 4 : 8;
                findSelectedCell = ProrAgileGrid.this.getCyclingNeighbor(currentCell, direction, true);
            }
            return findSelectedCell;
        }

        public boolean isNavigationEvent(AgileGrid agileGrid, Event event) {
            if (event.type == 15) {
                event.doit = false;
                return false;
            }
            return super.isNavigationEvent(agileGrid, event);
        }
    };

    public ProrAgileGrid(Composite parent, int style) {
        super(parent, style);
        this.setCellNavigationStrategy(this.cyclingCellNavigationStrategy);
        this.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                Point pos = ProrAgileGrid.this.toControl(e.x, e.y);
                Cell clickedCell = ProrAgileGrid.this.getCell(pos.x, pos.y);
                if (!ProrAgileGrid.this.isCellSelected(clickedCell.row, clickedCell.column)) {
                    ProrAgileGrid.this.clearSelection();
                    ProrAgileGrid.this.focusCell(clickedCell, true);
                } else {
                    ProrAgileGrid.this.focusCell(clickedCell, false);
                }
            }
        });
    }

    public int getYForRow(int row) {
        if (row < 0 || row > this.topRow + this.getRowsVisible() - 1) {
            return Integer.MIN_VALUE;
        }
        ILayoutAdvisor layoutAdvisor = this.getLayoutAdvisor();
        int fixedRowCount = layoutAdvisor.getFixedRowCount();
        if (row < fixedRowCount) {
            return Integer.MIN_VALUE;
        }
        int y = this.getLinePixels();
        if (layoutAdvisor.isTopHeaderVisible()) {
            y += layoutAdvisor.getTopHeaderHeight();
            y += this.getLinePixels();
        }
        int i = 0;
        while (i < fixedRowCount) {
            if (row == i) {
                return y;
            }
            y += layoutAdvisor.getRowHeight(i);
            y += this.getLinePixels();
            ++i;
        }
        i = this.topRow;
        while (i <= this.topRow + this.getRowsVisible() - 1) {
            if (row == i) {
                return y;
            }
            y += layoutAdvisor.getRowHeight(i);
            y += this.getLinePixels();
            ++i;
        }
        return Integer.MIN_VALUE;
    }

    public void triggerEditorActivationEvent(EditorActivationEvent editorActivationEvent, Object hint) {
        if (editorActivationEvent.eventType == 1 && editorActivationEvent.keyCode == 127) {
            return;
        }
        super.triggerEditorActivationEvent(editorActivationEvent, hint);
    }

    public Cell getCyclingNeighbor(Cell cell, int directionMask, boolean sameLevel) {
        Cell neighborCell = null;
        if ((directionMask & 8) == 8 && cell.column == this.getLayoutAdvisor().getColumnCount() - 1) {
            neighborCell = this.getLayoutAdvisor().mergeInto(cell.row + 1, 0);
        }
        if ((directionMask & 4) == 4 && cell.column == 0 && cell.row > 0) {
            neighborCell = this.getLayoutAdvisor().mergeInto(cell.row - 1, this.getLayoutAdvisor().getColumnCount() - 1);
        }
        return neighborCell != null ? neighborCell : cell;
    }
}

