/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.search.filter;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.eclipse.rmf.reqif10.AttributeDefinition;
import org.eclipse.rmf.reqif10.AttributeDefinitionDate;
import org.eclipse.rmf.reqif10.AttributeValue;
import org.eclipse.rmf.reqif10.AttributeValueDate;
import org.eclipse.rmf.reqif10.SpecElementWithAttributes;
import org.eclipse.rmf.reqif10.common.util.ReqIF10Util;
import org.eclipse.rmf.reqif10.search.filter.AbstractAttributeFilter;
import org.eclipse.rmf.reqif10.search.filter.IFilter;

public class DateFilter
extends AbstractAttributeFilter {
    public static final ImmutableSet<IFilter.Operator> SUPPORTED_OPERATORS = Sets.immutableEnumSet((Enum)IFilter.Operator.IS, (Enum[])new IFilter.Operator[]{IFilter.Operator.IS_NOT, IFilter.Operator.BETWEEN, IFilter.Operator.BEFORE, IFilter.Operator.AFTER, IFilter.Operator.IS_SET, IFilter.Operator.IS_NOT_SET});
    private IFilter.Operator operator;
    private GregorianCalendar filterValue1;
    private GregorianCalendar filterValue2;
    private AttributeDefinitionDate attributeDefinition;
    private InternalAttribute internalAttribute;
    private boolean isInternal;

    public DateFilter(IFilter.Operator operator, GregorianCalendar value1, GregorianCalendar value2, AttributeDefinitionDate attributeDefinition) {
        this(operator, value1, value2, null, attributeDefinition);
        this.isInternal = false;
        if (attributeDefinition == null) {
            throw new IllegalArgumentException("AttributeDefinition can not be null");
        }
        System.out.println("Instatiated new Filter: " + this.toString());
    }

    public DateFilter(IFilter.Operator operator, GregorianCalendar value1, GregorianCalendar value2, InternalAttribute internalFeature) {
        this(operator, value1, value2, internalFeature, null);
        this.isInternal = true;
        if (internalFeature == null) {
            throw new IllegalArgumentException("AttributeDefinition can not be null");
        }
        System.out.println("Instatiated new Filter: " + this.toString());
    }

    private DateFilter(IFilter.Operator operator, GregorianCalendar value1, GregorianCalendar value2, InternalAttribute internalFeature, AttributeDefinitionDate attributeDefinition) {
        if (!SUPPORTED_OPERATORS.contains((Object)operator)) {
            throw new IllegalArgumentException("This filter does not support the " + operator.toString() + " operation");
        }
        if (value1 == null && operator != IFilter.Operator.IS_SET && operator != IFilter.Operator.IS_NOT_SET) {
            throw new IllegalArgumentException("Value can not be null");
        }
        if (operator.equals((Object)IFilter.Operator.BETWEEN) && value2 == null) {
            throw new IllegalArgumentException("Value2 can not be null when using the operator " + operator.toString());
        }
        if (value2 != null) {
            this.filterValue2 = this.copyCalendar(value2, true);
            this.filterValue2.set(11, 23);
            this.filterValue2.set(12, 59);
            this.filterValue2.set(13, 59);
            this.filterValue2.set(14, 999);
            this.filterValue2.getTimeInMillis();
        }
        if (value1 != null) {
            if (operator == IFilter.Operator.IS || operator == IFilter.Operator.IS_NOT) {
                this.filterValue1 = this.copyCalendar(value1, false);
                this.filterValue2 = this.copyCalendar(value1, false);
                this.filterValue2.add(10, 24);
                this.filterValue2.getTimeInMillis();
            } else {
                this.filterValue1 = this.copyCalendar(value1, true);
            }
            this.filterValue1.getTimeInMillis();
        }
        this.operator = operator;
        if (operator.equals((Object)IFilter.Operator.BETWEEN) && this.filterValue1.after(this.filterValue2)) {
            GregorianCalendar fv1 = this.filterValue1;
            this.filterValue1 = this.filterValue2;
            this.filterValue2 = fv1;
        }
        this.internalAttribute = internalFeature;
        this.attributeDefinition = attributeDefinition;
    }

    private GregorianCalendar copyCalendar(GregorianCalendar source, boolean copyTimeOfDay) {
        source.getTimeInMillis();
        GregorianCalendar calendar = new GregorianCalendar(source.getTimeZone());
        calendar.set(1, source.get(1));
        calendar.set(2, source.get(2));
        calendar.set(5, source.get(5));
        if (copyTimeOfDay) {
            calendar.set(11, source.get(11));
            calendar.set(12, source.get(12));
            calendar.set(13, source.get(13));
            calendar.set(14, source.get(14));
        } else {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        }
        return calendar;
    }

    @Override
    public boolean match(SpecElementWithAttributes element) {
        AttributeValue attributeValue;
        Object theValue = this.isInternal ? this.getInternalAttributeValue(element) : ((attributeValue = ReqIF10Util.getAttributeValue((SpecElementWithAttributes)element, (AttributeDefinition)this.attributeDefinition)) == null || !((AttributeValueDate)attributeValue).isSetTheValue() ? null : ((AttributeValueDate)attributeValue).getTheValue());
        if (theValue == null) {
            theValue = this.getDefaultValue(element);
        }
        if (theValue == null) {
            switch (this.operator) {
                case IS_NOT: {
                    return true;
                }
                case IS: 
                case BETWEEN: 
                case BEFORE: 
                case AFTER: {
                    return false;
                }
            }
            return super.match(element);
        }
        ((Calendar)theValue).getTimeInMillis();
        switch (this.operator) {
            case IS: {
                return ((Calendar)theValue).compareTo(this.filterValue1) >= 0 && ((Calendar)theValue).before(this.filterValue2);
            }
            case IS_NOT: {
                return ((Calendar)theValue).compareTo(this.filterValue1) < 0 || !((Calendar)theValue).before(this.filterValue2);
            }
            case BEFORE: {
                return ((Calendar)theValue).compareTo(this.filterValue1) < 0;
            }
            case AFTER: {
                return ((Calendar)theValue).compareTo(this.filterValue1) > 0;
            }
            case BETWEEN: {
                return ((Calendar)theValue).compareTo(this.filterValue1) >= 0 && ((Calendar)theValue).compareTo(this.filterValue2) <= 0;
            }
        }
        return super.match(element);
    }

    private GregorianCalendar getDefaultValue(SpecElementWithAttributes element) {
        if (!AbstractAttributeFilter.isSetAttribute(element, (AttributeDefinition)this.attributeDefinition)) {
            return null;
        }
        if (!this.isInternal && this.attributeDefinition instanceof AttributeDefinitionDate) {
            AttributeDefinitionDate ad = this.attributeDefinition;
            return ad.isSetDefaultValue() ? ad.getDefaultValue().getTheValue() : null;
        }
        if (this.isInternal) {
            return null;
        }
        throw new IllegalStateException("Expected an AttributeDefinitionString as attribute but found " + this.attributeDefinition.getClass());
    }

    @Override
    public Object getAttribute() {
        return this.isInternal ? this.internalAttribute : this.attributeDefinition;
    }

    @Override
    public IFilter.Operator getOperator() {
        return this.operator;
    }

    @Override
    public GregorianCalendar getFilterValue1() {
        return this.filterValue1;
    }

    @Override
    public GregorianCalendar getFilterValue2() {
        return this.filterValue2;
    }

    @Override
    public ImmutableSet<IFilter.Operator> getSupportedOperators() {
        return SUPPORTED_OPERATORS;
    }

    @Override
    protected GregorianCalendar getInternalAttributeValue(SpecElementWithAttributes element) {
        if (this.internalAttribute.equals((Object)InternalAttribute.LAST_CHANGE)) {
            if (!element.isSetLastChange()) {
                return null;
            }
            return element.getLastChange();
        }
        throw new IllegalArgumentException((Object)((Object)this.internalAttribute) + " is not supported by this feature");
    }

    @Override
    public String getFilterValue1AsString() {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MMM-dd");
        return fmt.format(this.getFilterValue1().getTime());
    }

    @Override
    public String getFilterValue2AsString() {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MMM-dd");
        return fmt.format(this.getFilterValue2().getTime());
    }

    public static enum InternalAttribute {
        LAST_CHANGE;

    }
}

