/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.jobs.JobsExecutor;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.remoteservice.Activator;
import org.eclipse.ecf.remoteservice.CallbackRemoteCallListener;
import org.eclipse.ecf.remoteservice.IAsyncCallback;
import org.eclipse.ecf.remoteservice.IAsyncRemoteServiceProxy;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteCallListener;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceProxy;
import org.eclipse.ecf.remoteservice.IRemoteServiceProxyCreator;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.RemoteCall;
import org.eclipse.ecf.remoteservice.asyncproxy.AbstractAsyncProxyRemoteCall;
import org.eclipse.ecf.remoteservice.asyncproxy.AbstractAsyncProxyRemoteService;
import org.eclipse.ecf.remoteservice.asyncproxy.IAsyncProxyCompletable;
import org.eclipse.ecf.remoteservice.events.IRemoteCallCompleteEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteCallEvent;
import org.eclipse.ecf.remoteservice.util.AsyncUtil;
import org.eclipse.equinox.concurrent.future.IExecutor;
import org.eclipse.equinox.concurrent.future.IFuture;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceException;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRemoteService
extends AbstractAsyncProxyRemoteService
implements IRemoteService,
InvocationHandler {
    protected static final Object[] EMPTY_ARGS = new Object[0];
    protected int futureExecutorServiceMaxThreads = Integer.parseInt(System.getProperty("ecf.remoteservice.futureExecutorServiceMaxThreads", "10"));
    protected ExecutorService futureExecutorService;
    protected IExecutor iFutureExecutor;
    private Long defaultTimeout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExecutorService getFutureExecutorService(IRemoteCall call) {
        AbstractRemoteService abstractRemoteService = this;
        synchronized (abstractRemoteService) {
            if (this.futureExecutorService == null) {
                this.futureExecutorService = Executors.newFixedThreadPool(this.futureExecutorServiceMaxThreads);
            }
        }
        return this.futureExecutorService;
    }

    protected void setFutureExecutorService(ExecutorService executorService) {
        this.futureExecutorService = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IExecutor getIFutureExecutor(IRemoteCall call) {
        AbstractRemoteService abstractRemoteService = this;
        synchronized (abstractRemoteService) {
            if (this.iFutureExecutor == null) {
                this.iFutureExecutor = new JobsExecutor("RSJobs[rsID=" + this.getRemoteServiceID() + "]");
            }
        }
        return this.iFutureExecutor;
    }

    protected void setIFutureExecutor(IExecutor executor) {
        this.iFutureExecutor = executor;
    }

    protected abstract String[] getInterfaceClassNames();

    protected abstract IRemoteServiceID getRemoteServiceID();

    protected abstract IRemoteServiceReference getRemoteServiceReference();

    protected Class loadInterfaceClass(String className) throws ClassNotFoundException {
        return this.loadInterfaceClass(this.getClass().getClassLoader(), className);
    }

    protected Class loadInterfaceClass(ClassLoader cl, String className) throws ClassNotFoundException {
        return Class.forName(className, true, cl);
    }

    protected IRemoteService getRemoteService() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getDefaultTimeout() {
        AbstractRemoteService abstractRemoteService = this;
        synchronized (abstractRemoteService) {
            if (this.defaultTimeout == null) {
                Object o = this.getRemoteServiceReference().getProperty("osgi.basic.timeout");
                if (o != null) {
                    if (o instanceof Number) {
                        this.defaultTimeout = ((Number)o).longValue();
                    } else if (o instanceof String) {
                        this.defaultTimeout = Long.valueOf((String)o);
                    }
                } else {
                    this.defaultTimeout = IRemoteCall.DEFAULT_TIMEOUT;
                }
            }
        }
        return this.defaultTimeout;
    }

    protected IFuture callAsync(AbstractAsyncProxyRemoteCall call) {
        return this.callAsync((IRemoteCall)call);
    }

    @Override
    public IFuture callAsync(final IRemoteCall call) {
        IExecutor executor = this.getIFutureExecutor(call);
        if (executor == null) {
            throw new ServiceException("iFuture executor is null.  Cannot callAsync remote method=" + call.getMethod());
        }
        return executor.execute(new IProgressRunnable(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return AbstractRemoteService.this.callSync(call);
            }
        }, null);
    }

    @Override
    public Object getProxy() throws ECFException {
        ArrayList<Class> classes = new ArrayList<Class>();
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            String[] clazzes = this.getInterfaceClassNames();
            int i = 0;
            while (i < clazzes.length) {
                classes.add(this.loadInterfaceClass(cl, clazzes[i]));
                ++i;
            }
        }
        catch (Exception e) {
            ECFException except = new ECFException("Failed to create proxy", (Throwable)e);
            this.logWarning("Exception in remote service getProxy", except);
            throw except;
        }
        catch (NoClassDefFoundError e) {
            ECFException except = new ECFException("Failed to load proxy interface class", (Throwable)e);
            this.logWarning("Could not load class for getProxy", except);
            throw except;
        }
        return this.getProxy(cl, classes.toArray(new Class[classes.size()]));
    }

    protected void addRemoteServiceProxyToProxy(List classes) {
        IRemoteServiceReference rsReference = this.getRemoteServiceReference();
        if (rsReference != null && rsReference.getProperty("ecf.rsvc.norsproxy") == null) {
            classes.add(IRemoteServiceProxy.class);
        }
    }

    private boolean nameAlreadyPresent(String className, List classes) {
        for (Class c : classes) {
            if (!className.equals(c.getName())) continue;
            return true;
        }
        return false;
    }

    protected List addAsyncProxyClasses(ClassLoader cl, Class[] interfaces) {
        List<Class> intfs = Arrays.asList(interfaces);
        ArrayList<Class> results = new ArrayList<Class>();
        if (this.getRemoteServiceReference().getProperty("ecf.rsvc.async.noproxy") == null) {
            for (Class intf : intfs) {
                Class asyncClass;
                String intfName = this.convertInterfaceNameToAsyncInterfaceName(intf.getName());
                if (intfName == null || this.nameAlreadyPresent(intfName, intfs) || (asyncClass = this.findAsyncRemoteServiceProxyClass(cl, intf)) == null || intfs.contains(asyncClass)) continue;
                results.add(asyncClass);
            }
        }
        results.addAll(intfs);
        return results;
    }

    @Override
    public Object getProxy(ClassLoader cl, Class[] interfaces) throws ECFException {
        List classes = this.addAsyncProxyClasses(cl, interfaces);
        this.addRemoteServiceProxyToProxy(classes);
        try {
            return this.createProxy(cl, classes.toArray(new Class[classes.size()]));
        }
        catch (Exception e) {
            ECFException except = new ECFException("Failed to create proxy", (Throwable)e);
            this.logWarning("Exception in remote service getProxy", except);
            throw except;
        }
        catch (NoClassDefFoundError e) {
            ECFException except = new ECFException("Failed to load proxy interface class", (Throwable)e);
            this.logWarning("Could not load class for getProxy", except);
            throw except;
        }
    }

    protected IRemoteServiceProxyCreator getRemoteServiceProxyCreator() {
        ServiceTracker st = new ServiceTracker(Activator.getDefault().getContext(), IRemoteServiceProxyCreator.class, null);
        st.open();
        IRemoteServiceProxyCreator result = (IRemoteServiceProxyCreator)st.getService();
        st.close();
        return result;
    }

    protected Object createProxy(ClassLoader cl, Class[] classes) {
        IRemoteServiceProxyCreator proxyCreator = this.getRemoteServiceProxyCreator();
        if (proxyCreator != null) {
            return proxyCreator.createProxy(new ProxyClassLoader(cl), classes, this);
        }
        return Proxy.newProxyInstance(new ProxyClassLoader(cl), classes, (InvocationHandler)this);
    }

    protected Object createProxy(Class[] classes) {
        return this.createProxy(this.getClass().getClassLoader(), classes);
    }

    protected Class findAsyncRemoteServiceProxyClass(Class c) {
        String proxyClassName = this.convertInterfaceNameToAsyncInterfaceName(c.getName());
        try {
            return Class.forName(proxyClassName);
        }
        catch (ClassNotFoundException e) {
            this.logInfo("No async remote service interface found with name=" + proxyClassName + " for proxy service class=" + c.getName(), e);
            return null;
        }
        catch (NoClassDefFoundError e) {
            this.logWarning("Async remote service interface with name=" + proxyClassName + " could not be loaded for proxy service class=" + c.getName(), e);
            return null;
        }
    }

    protected Class findAsyncRemoteServiceProxyClass(ClassLoader cl, Class c) {
        String proxyClassName = this.convertInterfaceNameToAsyncInterfaceName(c.getName());
        if (proxyClassName == null) {
            return null;
        }
        try {
            return Class.forName(proxyClassName, true, cl);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            this.logWarning("Async remote service interface with name=" + proxyClassName + " could not be loaded for proxy service class=" + c.getName(), e);
            return null;
        }
    }

    protected String convertInterfaceNameToAsyncInterfaceName(String interfaceName) {
        if (interfaceName == null) {
            return null;
        }
        String asyncProxyName = (String)this.getRemoteServiceReference().getProperty("ecf.rsvc.async.proxy_" + interfaceName);
        if (asyncProxyName != null) {
            return asyncProxyName;
        }
        if (interfaceName.endsWith("Async")) {
            return interfaceName;
        }
        return String.valueOf(interfaceName) + "Async";
    }

    protected Object[] getCallParametersForProxyInvoke(String callMethod, Method proxyMethod, Object[] args) {
        return args == null ? EMPTY_ARGS : args;
    }

    protected long getCallTimeoutForProxyInvoke(String callMethod, Method proxyMethod, Object[] args) {
        return this.getDefaultTimeout();
    }

    protected String getCallMethodNameForProxyInvoke(Method method, Object[] args) {
        return method.getName();
    }

    protected Object invokeObject(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("toString")) {
            String[] clazzes = this.getInterfaceClassNames();
            String proxyClass = clazzes.length == 1 ? clazzes[0] : Arrays.asList(clazzes).toString();
            return String.valueOf(proxyClass) + ".proxy@" + this.getRemoteServiceID();
        }
        if (methodName.equals("hashCode")) {
            return this.hashCode();
        }
        if (methodName.equals("equals")) {
            if (args == null || args.length == 0) {
                return Boolean.FALSE;
            }
            try {
                return new Boolean(Proxy.getInvocationHandler(args[0]).equals(this));
            }
            catch (IllegalArgumentException e) {
                return Boolean.FALSE;
            }
        }
        if (methodName.equals("getRemoteService")) {
            return this.getRemoteService();
        }
        if (methodName.equals("getRemoteServiceReference")) {
            return this.getRemoteServiceReference();
        }
        return null;
    }

    protected Object invokeSync(IRemoteCall call) throws ECFException {
        return this.callSync(call);
    }

    protected boolean isAsync(Object proxy, Method method, Object[] args) {
        return Arrays.asList(method.getDeclaringClass().getInterfaces()).contains(IAsyncRemoteServiceProxy.class) || method.getName().endsWith("Async");
    }

    protected IRemoteCall createRemoteCall(final String callMethod, final Object[] callParameters, final long callTimeout) {
        return new IRemoteCall(){

            public String getMethod() {
                return callMethod;
            }

            public Object[] getParameters() {
                return callParameters;
            }

            public long getTimeout() {
                return callTimeout;
            }
        };
    }

    protected void handleProxyException(String message, Throwable t) throws ServiceException {
        if (t instanceof ServiceException) {
            throw (ServiceException)t;
        }
        throw new ServiceException(message, 5, t);
    }

    protected void handleInvokeSyncException(String methodName, ECFException e) throws Throwable {
        Throwable cause = e.getCause();
        if (cause instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)cause).getTargetException();
        }
        if (cause instanceof ServiceException) {
            throw (ServiceException)cause;
        }
        if (cause instanceof RuntimeException) {
            throw new ServiceException("RuntimeException for method=" + methodName + " on remote service proxy=" + this.getRemoteServiceID(), 5, cause);
        }
        if (cause instanceof NoClassDefFoundError) {
            throw new ServiceException("Remote NoClassDefFoundError for method=" + methodName + " on remote service proxy=" + this.getRemoteServiceID(), 5, cause);
        }
        if (cause != null) {
            throw cause;
        }
        throw new ServiceException("Unexpected exception for method=" + methodName + " on remote service proxy=" + this.getRemoteServiceID(), 5, (Throwable)e);
    }

    protected Object invokeReturnAsync(Object proxy, Method method, Object[] args) throws Throwable {
        return this.callFuture(this.getAsyncRemoteCall(method.getName(), args), method.getReturnType());
    }

    protected boolean isOSGIAsync() {
        return AsyncUtil.isOSGIAsync(this.getRemoteServiceReference());
    }

    protected boolean isInterfaceAsync(Class interfaceClass) {
        return interfaceClass.getName().endsWith("Async");
    }

    protected boolean isMethodAsync(String methodName) {
        return methodName.endsWith("Async");
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object resultObject = null;
        try {
            resultObject = this.invokeObject(proxy, method, args);
        }
        catch (Throwable t) {
            this.handleProxyException("Exception invoking local Object method on remote service proxy=" + this.getRemoteServiceID(), t);
        }
        if (resultObject != null) {
            return resultObject;
        }
        try {
            if (this.isReturnAsync(proxy, method, args)) {
                if (this.isInterfaceAsync(method.getDeclaringClass()) && this.isMethodAsync(method.getName())) {
                    return this.invokeAsync(method, args);
                }
                if (this.isOSGIAsync()) {
                    return this.invokeReturnAsync(proxy, method, args);
                }
            }
        }
        catch (Throwable t) {
            this.handleProxyException("Exception invoking async method on remote service proxy=" + this.getRemoteServiceID(), t);
        }
        String callMethod = this.getCallMethodNameForProxyInvoke(method, args);
        Object[] callParameters = this.getCallParametersForProxyInvoke(callMethod, method, args);
        long callTimeout = this.getCallTimeoutForProxyInvoke(callMethod, method, args);
        IRemoteCall remoteCall = this.createRemoteCall(callMethod, callParameters, callTimeout);
        try {
            return this.invokeSync(remoteCall);
        }
        catch (ECFException e) {
            this.handleInvokeSyncException(method.getName(), e);
            return null;
        }
    }

    protected RemoteCall getAsyncRemoteCall(String invokeMethodName, Object[] asyncArgs) {
        return new RemoteCall(invokeMethodName, asyncArgs, this.getDefaultTimeout());
    }

    protected Object invokeAsync(Method method, Object[] args) throws Throwable {
        String invokeMethodName = this.getAsyncInvokeMethodName(method);
        AsyncArgs asyncArgs = this.getAsyncArgs(method, args);
        RemoteCall remoteCall = this.getAsyncRemoteCall(invokeMethodName, asyncArgs.getArgs());
        IRemoteCallListener listener = asyncArgs.getListener();
        return listener != null ? this.callAsyncWithResult(remoteCall, listener) : this.callFuture(remoteCall, asyncArgs.getReturnType());
    }

    protected Object callAsyncWithResult(IRemoteCall call, IRemoteCallListener listener) {
        this.callAsync(call, listener);
        return null;
    }

    protected void callCompletableAsync(AbstractAsyncProxyRemoteCall call, final IAsyncProxyCompletable completable) {
        this.callAsync((IRemoteCall)call, new IRemoteCallListener(){

            public void handleEvent(IRemoteCallEvent event) {
                if (event instanceof IRemoteCallCompleteEvent) {
                    IRemoteCallCompleteEvent cce = (IRemoteCallCompleteEvent)event;
                    completable.handleComplete(cce.getResponse(), cce.hadException(), cce.getException());
                }
            }
        });
    }

    protected Future callFutureAsync(AbstractAsyncProxyRemoteCall call) {
        return this.callFutureAsync((IRemoteCall)call);
    }

    protected Future callFutureAsync(final IRemoteCall call) {
        ExecutorService executorService = this.getFutureExecutorService(call);
        if (executorService == null) {
            throw new ServiceException("future executor service is null.  .  Cannot callAsync remote method=" + call.getMethod());
        }
        return executorService.submit(new Callable(){

            public Object call() throws Exception {
                return AbstractRemoteService.this.callSync(call);
            }
        });
    }

    protected AsyncArgs getAsyncArgs(Method method, Object[] args) {
        IRemoteCallListener listener = null;
        Class<?> returnType = method.getReturnType();
        if (Future.class.isAssignableFrom(returnType) || IFuture.class.isAssignableFrom(returnType)) {
            return new AsyncArgs(args, returnType);
        }
        if (args == null || args.length == 0) {
            throw new IllegalArgumentException("Async calls must include a IRemoteCallListener instance as the last argument");
        }
        Object lastArg = args[args.length - 1];
        if (lastArg instanceof IRemoteCallListener) {
            listener = (IRemoteCallListener)lastArg;
        }
        if (lastArg instanceof IAsyncCallback) {
            listener = new CallbackRemoteCallListener((IAsyncCallback)lastArg);
        }
        if (listener == null) {
            throw new IllegalArgumentException("Last argument must be an instance of IRemoteCallListener");
        }
        return new AsyncArgs(listener, args);
    }

    protected String getAsyncInvokeMethodName(Method method) {
        String methodName = method.getName();
        return methodName.endsWith("Async") ? methodName.substring(0, methodName.length() - "Async".length()) : methodName;
    }

    private void logInfo(String message, Throwable e) {
        Activator a = Activator.getDefault();
        if (a != null) {
            a.log((IStatus)new Status(1, "org.eclipse.ecf.remoteservice", message, e));
        }
    }

    protected void logWarning(String string, Throwable e) {
        Activator a = Activator.getDefault();
        if (a != null) {
            a.log((IStatus)new Status(2, "org.eclipse.ecf.remoteservice", string, e));
        }
    }

    public Future<Object> callAsync(IRemoteCall call, Callable<Object> callable) {
        return this.getFutureExecutorService(call).submit(callable);
    }

    public Object callSync(IRemoteCall call, Callable<Object> callable) throws InterruptedException, ExecutionException, TimeoutException {
        return this.callAsync(call, callable).get(call.getTimeout(), TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        AbstractRemoteService abstractRemoteService = this;
        synchronized (abstractRemoteService) {
            if (this.futureExecutorService != null) {
                this.futureExecutorService.shutdownNow();
                this.futureExecutorService = null;
            }
            this.iFutureExecutor = null;
        }
    }

    protected Future<Object> callAsyncWithTimeout(final IRemoteCall call, final Callable<Object> callable) {
        return this.getFutureExecutorService(call).submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    return AbstractRemoteService.this.getFutureExecutorService(call).submit(callable).get(call.getTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    throw new InterruptedException("Interrupted calling remote service method=" + call.getMethod());
                }
                catch (ExecutionException e) {
                    throw new InvocationTargetException(e.getCause(), "Exception calling remote service method=" + call.getMethod());
                }
                catch (TimeoutException e) {
                    throw new TimeoutException("Timeout calling remote service method=" + call.getMethod() + " timeout=" + call.getTimeout());
                }
            }
        });
    }

    protected IRemoteCallCompleteEvent createRCCESuccess(Object result) {
        return this.createRCCE(result, null);
    }

    protected IRemoteCallCompleteEvent createRCCEFailure(Throwable e) {
        return this.createRCCE(null, e);
    }

    protected IRemoteCallCompleteEvent createRCCE(final Object result, final Throwable e) {
        return new IRemoteCallCompleteEvent(){

            public long getRequestId() {
                return 0L;
            }

            public Object getResponse() {
                return result;
            }

            public boolean hadException() {
                return e != null;
            }

            public Throwable getException() {
                return e;
            }
        };
    }

    protected void callAsyncWithTimeout(final IRemoteCall call, final Callable<IRemoteCallCompleteEvent> callable, final IRemoteCallListener callback) {
        this.getFutureExecutorService(call).submit(new Runnable(){

            public void run() {
                try {
                    callback.handleEvent((IRemoteCallEvent)AbstractRemoteService.this.getFutureExecutorService(call).submit(callable).get(call.getTimeout(), TimeUnit.MILLISECONDS));
                }
                catch (InterruptedException e) {
                    callback.handleEvent(AbstractRemoteService.this.createRCCE(null, new InterruptedException("Interrupted calling remote service method=" + call.getMethod())));
                }
                catch (ExecutionException e) {
                    callback.handleEvent(AbstractRemoteService.this.createRCCE(null, new InvocationTargetException(e.getCause(), "Exception calling remote service method=" + call.getMethod())));
                }
                catch (TimeoutException e) {
                    callback.handleEvent(AbstractRemoteService.this.createRCCE(null, new TimeoutException("Timeout calling remote service method=" + call.getMethod() + " timeout=" + call.getTimeout())));
                }
            }
        });
    }

    public class AsyncArgs {
        private IRemoteCallListener listener;
        private Object[] args;
        private Class returnType;

        public AsyncArgs(Object[] originalArgs, Class returnType) {
            this.listener = null;
            this.args = originalArgs;
            this.returnType = returnType;
        }

        public AsyncArgs(IRemoteCallListener listener, Object[] originalArgs) {
            this.listener = listener;
            if (this.listener != null) {
                int asynchArgsLength = originalArgs.length - 1;
                this.args = new Object[asynchArgsLength];
                System.arraycopy(originalArgs, 0, this.args, 0, asynchArgsLength);
            } else {
                this.args = originalArgs;
            }
        }

        public IRemoteCallListener getListener() {
            return this.listener;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public Class getReturnType() {
            return this.returnType;
        }
    }

    public class ProxyClassLoader
    extends ClassLoader {
        private ClassLoader cl;

        public ProxyClassLoader(ClassLoader cl) {
            this.cl = cl;
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            try {
                return this.cl.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                Activator a = Activator.getDefault();
                if (a == null) {
                    throw e;
                }
                BundleContext context = a.getContext();
                if (context == null) {
                    throw e;
                }
                return context.getBundle().loadClass(name);
            }
        }
    }
}

