/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.packet.PacketExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XHTMLExtension
implements PacketExtension {
    private List<String> bodies = new ArrayList<String>();

    @Override
    public String getElementName() {
        return "html";
    }

    @Override
    public String getNamespace() {
        return "http://jabber.org/protocol/xhtml-im";
    }

    @Override
    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<").append(this.getElementName()).append(" xmlns=\"").append(this.getNamespace()).append("\">");
        Iterator<String> i = this.getBodies();
        while (i.hasNext()) {
            buf.append(i.next());
        }
        buf.append("</").append(this.getElementName()).append(">");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<String> getBodies() {
        List<String> list = this.bodies;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<String>(this.bodies)).iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBody(String body) {
        List<String> list = this.bodies;
        synchronized (list) {
            this.bodies.add(body);
        }
    }

    public int getBodiesCount() {
        return this.bodies.size();
    }
}

