/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab.ui;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.ecf.example.collab.share.EclipseCollabSharedObject;
import org.eclipse.ecf.internal.example.collab.Messages;
import org.eclipse.ecf.internal.example.collab.ui.LineChatClientView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.ViewPart;

public class LineChatView
extends ViewPart {
    public static final String VIEW_ID = "org.eclipse.ecf.internal.example.collab.ui.LineChatView";
    private static final String COLLABORATION_PROJECTS_ARE_NOT_AVAILABLE_ = Messages.LineChatView_NO_CONNECT_MESSAGE;
    protected static LineChatView singleton = null;
    protected static Hashtable clientViews = new Hashtable();
    TabFolder tabFolder = null;
    Composite parentComposite = null;
    Label inactiveLabel = null;
    static IToolBarManager toolbarManager = null;
    static IActionBars actionBars = null;

    public static boolean isDisposed() {
        return singleton == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object addClientView(LineChatClientView cv, TabItem ti) {
        Hashtable hashtable = clientViews;
        synchronized (hashtable) {
            return clientViews.put(cv, ti);
        }
    }

    protected void removeClientView(LineChatClientView cv) {
        final TabItem ti = (TabItem)clientViews.remove(cv);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (ti != null) {
                    ti.dispose();
                }
                if (clientViews.isEmpty() && singleton != null) {
                    if (LineChatView.singleton.tabFolder != null) {
                        LineChatView.singleton.tabFolder.dispose();
                        LineChatView.singleton.tabFolder = null;
                    }
                    LineChatView.this.createInactiveComposite(LineChatView.singleton.parentComposite);
                    actionBars.getToolBarManager().removeAll();
                    actionBars.getMenuManager().removeAll();
                    actionBars.updateActionBars();
                    if (!LineChatView.singleton.parentComposite.isDisposed()) {
                        LineChatView.singleton.parentComposite.layout();
                    }
                }
            }
        });
    }

    protected void hideView() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage wp = LineChatView.this.getSite().getPage();
                    wp.hideView((IViewPart)LineChatView.this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void setViewName(String name) {
        if (singleton != null) {
            singleton.setPartName(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LineChatClientView createClientView(EclipseCollabSharedObject lch, String name, String initText, String downloaddir) throws Exception {
        LineChatClientView newView = null;
        Hashtable hashtable = clientViews;
        synchronized (hashtable) {
            if (singleton == null) {
                throw new InstantiationException(Messages.LineChatView_EXCEPTION_VIEW_NOT_INITIALIZED);
            }
            if (LineChatView.singleton.inactiveLabel != null) {
                LineChatView.singleton.inactiveLabel.dispose();
            }
            if (LineChatView.singleton.tabFolder == null) {
                LineChatView.singleton.tabFolder = new TabFolder(LineChatView.singleton.parentComposite, 0);
            }
            newView = new LineChatClientView(lch, singleton, name, initText, downloaddir);
            TabItem ti = new TabItem(LineChatView.singleton.tabFolder, 0);
            ti.setControl((Control)newView.getTeamChat());
            ti.setText(newView.name);
            singleton.addClientView(newView, ti);
            actionBars.updateActionBars();
            LineChatView.singleton.parentComposite.layout();
        }
        return newView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFocus() {
        Hashtable hashtable = clientViews;
        synchronized (hashtable) {
            LineChatView.singleton.parentComposite.setFocus();
        }
    }

    protected static void addActionToToolbar(Action action) {
        toolbarManager.add((IAction)action);
        actionBars.updateActionBars();
    }

    protected static void removeActionFromToolbar(Action action) {
        if (action == null) {
            return;
        }
        toolbarManager.remove(action.getId());
        actionBars.updateActionBars();
    }

    public void createPartControl(Composite parent) {
        singleton = this;
        IViewSite viewSite = this.getViewSite();
        actionBars = viewSite.getActionBars();
        toolbarManager = actionBars.getToolBarManager();
        this.parentComposite = parent;
        this.createInactiveComposite(parent);
    }

    private void createInactiveComposite(Composite parent) {
        if (!parent.isDisposed()) {
            this.inactiveLabel = new Label(parent, 0);
            this.inactiveLabel.setText(COLLABORATION_PROJECTS_ARE_NOT_AVAILABLE_);
        }
    }

    protected void disposeClient(LineChatClientView lccv) {
        if (singleton != null) {
            singleton.removeClientView(lccv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Hashtable hashtable = clientViews;
        synchronized (hashtable) {
            this.closeAllClients();
        }
        singleton = null;
        super.dispose();
    }

    public void saveState(IMemento state) {
    }

    protected void closeAllClients() {
        Enumeration e = clientViews.keys();
        while (e.hasMoreElements()) {
            LineChatClientView vc = (LineChatClientView)e.nextElement();
            vc.closeClient();
        }
        clientViews.clear();
    }

    protected void setActiveTab(String name) {
        if (name == null) {
            return;
        }
        if (this.tabFolder != null) {
            TabItem[] items = this.tabFolder.getItems();
            if (items == null) {
                return;
            }
            int i = 0;
            while (i < items.length) {
                String itemName = items[i].getText();
                if (name.equals(itemName)) {
                    this.tabFolder.setSelection(i);
                }
                ++i;
            }
        }
    }
}

