/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.irc.ui.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.user.IUser;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.presence.chatroom.IChatRoomContainer;
import org.eclipse.ecf.presence.ui.chatroom.ChatRoomManagerView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class AbstractActionDelegate
implements IViewActionDelegate {
    private IStructuredSelection selection;
    private IChatRoomContainer chatRoomContainer;

    protected abstract String getMessage(String var1);

    protected String getUsername(IUser user) {
        String username = user.getName();
        if (username.startsWith("@")) {
            username = username.substring(1);
        }
        return username;
    }

    public void run(IAction action) {
        if (this.chatRoomContainer == null || this.selection == null) {
            return;
        }
        try {
            for (IUser user : this.selection) {
                String message = this.getMessage(this.getUsername(user));
                this.chatRoomContainer.getChatRoomMessageSender().sendMessage(message);
            }
        }
        catch (ECFException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.ecf.irc.ui", e.getMessage(), (Throwable)e));
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        this.selection = (IStructuredSelection)selection;
    }

    public void init(IViewPart view) {
        this.chatRoomContainer = ((ChatRoomManagerView)view).getActiveChatRoomContainer();
    }
}

