/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.IContainerListener;
import org.eclipse.ecf.core.events.IContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.IContainerEjectedEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.presence.ui.Activator;
import org.eclipse.ecf.internal.presence.ui.dialogs.ReceiveAuthorizeRequestDialog;
import org.eclipse.ecf.presence.IPresence;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.Presence;
import org.eclipse.ecf.presence.roster.IRoster;
import org.eclipse.ecf.presence.roster.IRosterEntry;
import org.eclipse.ecf.presence.roster.IRosterItem;
import org.eclipse.ecf.presence.roster.IRosterListener;
import org.eclipse.ecf.presence.roster.IRosterManager;
import org.eclipse.ecf.presence.roster.IRosterSubscriptionListener;
import org.eclipse.ecf.presence.ui.MultiRosterView;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MultiRosterAccount {
    protected final MultiRosterView multiRosterView;
    protected IContainer container;
    protected IPresenceContainerAdapter adapter;
    IRosterListener updateListener = new IRosterListener(){

        public void handleRosterUpdate(IRoster roster, IRosterItem changedValue) {
            Display.getDefault().asyncExec(new Runnable(this, changedValue){
                final /* synthetic */ 1 this$1;
                private final /* synthetic */ IRosterItem val$changedValue;
                {
                    this.this$1 = var1_1;
                    this.val$changedValue = iRosterItem;
                }

                public void run() {
                    1.access$0(this.this$1).multiRosterView.refreshTreeViewer(this.val$changedValue, true);
                }
            });
        }

        public void handleRosterEntryAdd(IRosterEntry entry) {
            Display.getDefault().asyncExec(new Runnable(this, entry){
                final /* synthetic */ 1 this$1;
                private final /* synthetic */ IRosterEntry val$entry;
                {
                    this.this$1 = var1_1;
                    this.val$entry = iRosterEntry;
                }

                public void run() {
                    1.access$0(this.this$1).multiRosterView.addEntryToTreeViewer(this.val$entry);
                }
            });
        }

        public void handleRosterEntryRemove(IRosterEntry entry) {
            Display.getDefault().asyncExec(new Runnable(this, entry){
                final /* synthetic */ 1 this$1;
                private final /* synthetic */ IRosterEntry val$entry;
                {
                    this.this$1 = var1_1;
                    this.val$entry = iRosterEntry;
                }

                public void run() {
                    1.access$0(this.this$1).multiRosterView.removeEntryFromTreeViewer(this.val$entry);
                }
            });
        }

        static /* synthetic */ MultiRosterAccount access$0(1 var0) {
            return var0.MultiRosterAccount.this;
        }
    };
    IContainerListener containerListener = new IContainerListener(){

        public void handleEvent(IContainerEvent event) {
            if (event instanceof IContainerDisconnectedEvent || event instanceof IContainerEjectedEvent) {
                Display.getDefault().asyncExec(new Runnable(this){
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        5.access$0(this.this$1).multiRosterView.rosterAccountDisconnected(5.access$0(this.this$1));
                    }
                });
            }
        }

        static /* synthetic */ MultiRosterAccount access$0(5 var0) {
            return var0.MultiRosterAccount.this;
        }
    };
    IRosterSubscriptionListener subscriptionListener = new IRosterSubscriptionListener(){

        public void handleSubscribeRequest(ID fromID) {
            Display.getDefault().asyncExec(new Runnable(this, fromID){
                final /* synthetic */ 7 this$1;
                private final /* synthetic */ ID val$fromID;
                {
                    this.this$1 = var1_1;
                    this.val$fromID = iD;
                }

                public void run() {
                    try {
                        Shell shell = 7.access$0(this.this$1).multiRosterView.getViewSite().getShell();
                        ReceiveAuthorizeRequestDialog authRequest = new ReceiveAuthorizeRequestDialog(shell, this.val$fromID.getName(), 7.access$0(this.this$1).getRoster().getUser().getID().getName());
                        authRequest.setBlockOnOpen(true);
                        authRequest.open();
                        int res = authRequest.getButtonPressed();
                        if (res == 1025) {
                            7.access$0(this.this$1).getRosterManager().getPresenceSender().sendPresenceUpdate(this.val$fromID, (IPresence)new Presence(IPresence.Type.SUBSCRIBED));
                        }
                    }
                    catch (ECFException e) {
                        Activator.getDefault().getLog().log(e.getStatus());
                    }
                }
            });
        }

        public void handleSubscribed(ID fromID) {
        }

        public void handleUnsubscribed(ID fromID) {
            Display.getDefault().asyncExec(new Runnable(this, fromID){
                final /* synthetic */ 7 this$1;
                private final /* synthetic */ ID val$fromID;
                {
                    this.this$1 = var1_1;
                    this.val$fromID = iD;
                }

                public void run() {
                    7.access$0(this.this$1).multiRosterView.removeEntryFromTreeViewer(this.val$fromID);
                }
            });
        }

        static /* synthetic */ MultiRosterAccount access$0(7 var0) {
            return var0.MultiRosterAccount.this;
        }
    };

    public MultiRosterAccount(MultiRosterView multiRosterView, IContainer container, IPresenceContainerAdapter adapter) {
        this.multiRosterView = multiRosterView;
        Assert.isNotNull((Object)container);
        Assert.isNotNull((Object)adapter);
        this.container = container;
        this.adapter = adapter;
        this.container.addListener(this.containerListener);
        this.getRosterManager().addRosterListener(this.updateListener);
        this.getRosterManager().addRosterSubscriptionListener(this.subscriptionListener);
    }

    public IContainer getContainer() {
        return this.container;
    }

    public IPresenceContainerAdapter getPresenceContainerAdapter() {
        return this.adapter;
    }

    public IRosterManager getRosterManager() {
        return this.getPresenceContainerAdapter().getRosterManager();
    }

    public IRoster getRoster() {
        return this.getRosterManager().getRoster();
    }

    public void dispose() {
        this.getRosterManager().removeRosterSubscriptionListener(this.subscriptionListener);
        this.getRosterManager().removeRosterListener(this.updateListener);
        this.container.removeListener(this.containerListener);
    }
}

