/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.Map;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.AbstractTopologyManager;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.EndpointDescription;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.RemoteServiceAdmin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.service.remoteserviceadmin.EndpointEvent;
import org.osgi.service.remoteserviceadmin.EndpointEventListener;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminEvent;

public class BasicTopologyManagerImpl
extends AbstractTopologyManager
implements EndpointEventListener {
    private static final boolean allowLoopbackReference = new Boolean(System.getProperty("org.eclipse.ecf.osgi.services.discovery.allowLoopbackReference", "false"));
    private static final String defaultScope = System.getProperty("org.eclipse.ecf.osgi.services.discovery.endpointListenerScope");
    private String ecfEndpointListenerScope;
    private static final String ONLY_ECF_SCOPE = "(ecf.endpoint.id.ns=*)";
    private static final String NO_ECF_SCOPE = "(!(ecf.endpoint.id.ns=*))";

    BasicTopologyManagerImpl(BundleContext context) {
        super(context);
        if (defaultScope != null) {
            this.ecfEndpointListenerScope = defaultScope;
        }
        if (allowLoopbackReference) {
            this.ecfEndpointListenerScope = ONLY_ECF_SCOPE;
        } else {
            StringBuffer elScope = new StringBuffer("");
            elScope.append("(&(!(").append("endpoint.framework.uuid").append("=").append(this.getFrameworkUUID()).append("))");
            elScope.append(ONLY_ECF_SCOPE);
            elScope.append(")");
            this.ecfEndpointListenerScope = elScope.toString();
        }
    }

    String[] getScope() {
        return new String[]{this.ecfEndpointListenerScope, NO_ECF_SCOPE};
    }

    protected String getFrameworkUUID() {
        return super.getFrameworkUUID();
    }

    void exportRegisteredServices(String exportRegisteredSvcsClassname, String exportRegisteredSvcsFilter) {
        try {
            final ServiceReference[] existingServiceRefs = this.getContext().getAllServiceReferences(exportRegisteredSvcsClassname, exportRegisteredSvcsFilter);
            if (existingServiceRefs != null && existingServiceRefs.length > 0) {
                new Thread(new Runnable(){

                    public void run() {
                        int i = 0;
                        while (i < existingServiceRefs.length) {
                            BasicTopologyManagerImpl.this.handleServiceRegistering(existingServiceRefs[i]);
                            ++i;
                        }
                    }
                }, "BasicTopologyManagerPreRegSrvExporter").start();
            }
        }
        catch (InvalidSyntaxException e) {
            this.logError("exportRegisteredServices", "Could not retrieve existing service references for exportRegisteredSvcsClassname=" + exportRegisteredSvcsClassname + " and exportRegisteredSvcsFilter=" + exportRegisteredSvcsFilter, e);
        }
    }

    protected void handleEndpointAdded(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint, String matchedFilter) {
        if (matchedFilter.equals(this.ecfEndpointListenerScope) && endpoint instanceof EndpointDescription) {
            this.handleECFEndpointAdded((EndpointDescription)endpoint);
        }
    }

    protected void handleEndpointRemoved(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint, String matchedFilter) {
        if (matchedFilter.equals(this.ecfEndpointListenerScope) && endpoint instanceof EndpointDescription) {
            this.handleECFEndpointRemoved((org.osgi.service.remoteserviceadmin.EndpointDescription)((EndpointDescription)endpoint));
        }
    }

    void event(ServiceEvent event, Map listeners) {
        this.handleEvent(event, listeners);
    }

    void handleRemoteAdminEvent(RemoteServiceAdminEvent event) {
        if (!(event instanceof RemoteServiceAdmin.RemoteServiceAdminEvent)) {
            return;
        }
        RemoteServiceAdmin.RemoteServiceAdminEvent rsaEvent = (RemoteServiceAdmin.RemoteServiceAdminEvent)event;
        int eventType = event.getType();
        EndpointDescription endpointDescription = rsaEvent.getEndpointDescription();
        switch (eventType) {
            case 2: {
                this.advertiseEndpointDescription((org.osgi.service.remoteserviceadmin.EndpointDescription)endpointDescription);
                break;
            }
            case 3: {
                this.unadvertiseEndpointDescription((org.osgi.service.remoteserviceadmin.EndpointDescription)endpointDescription);
                break;
            }
            case 6: {
                this.logError("handleRemoteAdminEvent.EXPORT_ERROR", "Export error with event=" + rsaEvent);
                break;
            }
            case 7: {
                this.logWarning("handleRemoteAdminEvent.EXPORT_WARNING", "Export warning with event=" + rsaEvent);
                break;
            }
            case 10: {
                this.advertiseModifyEndpointDescription((org.osgi.service.remoteserviceadmin.EndpointDescription)endpointDescription);
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                this.logError("handleRemoteAdminEvent.IMPORT_ERROR", "Import error with event=" + rsaEvent);
                break;
            }
            case 8: {
                this.logWarning("handleRemoteAdminEvent.IMPORT_WARNING", "Import warning with event=" + rsaEvent);
                break;
            }
            default: {
                this.logWarning("handleRemoteAdminEvent", "RemoteServiceAdminEvent=" + rsaEvent + " received with unrecognized type");
            }
        }
    }

    public void endpointChanged(EndpointEvent event, String matchedFilter) {
        int eventType = event.getType();
        org.osgi.service.remoteserviceadmin.EndpointDescription ed = event.getEndpoint();
        switch (eventType) {
            case 1: {
                this.handleEndpointAdded(ed, matchedFilter);
                break;
            }
            case 2: {
                this.handleEndpointRemoved(ed, matchedFilter);
                break;
            }
            case 4: {
                this.handleEndpointModified(ed, matchedFilter);
                break;
            }
            case 8: {
                this.handleEndpointModifiedEndmatch(ed, matchedFilter);
            }
        }
    }

    protected void handleEndpointModifiedEndmatch(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint, String matchedFilter) {
    }

    protected void handleEndpointModified(org.osgi.service.remoteserviceadmin.EndpointDescription endpoint, String matchedFilter) {
        if (matchedFilter.equals(this.ecfEndpointListenerScope) && endpoint instanceof EndpointDescription) {
            this.handleECFEndpointModified((EndpointDescription)endpoint);
        }
    }
}

