/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.httpclient45;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.core.util.ProxyAddress;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient45.Activator;
import org.eclipse.ecf.internal.provider.filetransfer.httpclient45.DefaultNTLMProxyHandler;
import org.eclipse.ecf.provider.filetransfer.httpclient45.HttpClientRetrieveFileTransfer;
import org.osgi.framework.FrameworkUtil;

public class HttpClientProxyCredentialProvider
extends BasicCredentialsProvider {
    private static final String COMPUTERNAME_ENV = "COMPUTERNAME";
    private static final String HOSTNAME_ENV = "HOSTNAME";
    private static final String LOGONSERVER_ENV = "LOGONSERVER";
    private static final String USER_DOMAIN_ENV = "USERDOMAIN";
    private static final String USER_DNS_DOMAIN_ENV = "USERDNSDOMAIN";
    private static final char BACKSLASH = '\\';
    private static final char SLASH = '/';
    private static final String OSGI_OS = "osgi.os";
    private static final String OSGI_OS_WIN32 = "win32";
    private static final String NTLM_DOMAIN_PROPERTY = "http.auth.ntlm.domain";

    protected Proxy getECFProxy() {
        return null;
    }

    protected boolean allowNTLMAuthentication() {
        DefaultNTLMProxyHandler.setSeenNTLM();
        return Activator.getDefault().getNTLMProxyHandler().allowNTLMAuthentication(null);
    }

    protected Credentials getNTLMCredentials(Credentials credentials) {
        DefaultNTLMProxyHandler.setSeenNTLM();
        Credentials fixed = HttpClientProxyCredentialProvider.fixNTCredentials(credentials);
        if (fixed == credentials || this.allowNTLMAuthentication()) {
            return fixed;
        }
        return null;
    }

    protected NTCredentials getNTLMCredentials(Proxy proxy) {
        if (this.allowNTLMAuthentication()) {
            return HttpClientProxyCredentialProvider.createNTLMCredentials(proxy);
        }
        return null;
    }

    public Credentials getCredentials(AuthScope authscope) {
        Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient45", (String)"org.eclipse.ecf.provider.filetransfer/debug/methods/entering", HttpClientProxyCredentialProvider.class, (String)("getCredentials " + String.valueOf(authscope)));
        Credentials result = super.getCredentials(authscope);
        if (result != null) {
            Credentials fixed;
            if ("ntlm".equalsIgnoreCase(authscope.getScheme()) && (fixed = HttpClientProxyCredentialProvider.fixNTCredentials(result)) != result) {
                result = fixed;
                this.setCredentials(authscope, fixed);
            }
            return result;
        }
        Proxy proxy = this.getECFProxy();
        if (proxy == null) {
            return null;
        }
        if (!HttpClientProxyCredentialProvider.matchAuthScopeAndProxy(authscope, proxy)) {
            return null;
        }
        NTCredentials credentials = null;
        if ("ntlm".equalsIgnoreCase(authscope.getScheme())) {
            credentials = this.getNTLMCredentials(proxy);
        } else if ("basic".equalsIgnoreCase(authscope.getScheme()) || "digest".equalsIgnoreCase(authscope.getScheme())) {
            String proxyUsername = proxy.getUsername();
            String proxyPassword = proxy.getPassword();
            if (proxyUsername != null) {
                credentials = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
            }
        } else if ("negotiate".equalsIgnoreCase(authscope.getScheme())) {
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient45", (String)"SPNEGO is not supported, if you can contribute support, please do so.");
        } else {
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient45", (String)"Unrecognized authentication scheme.");
        }
        if (credentials != null) {
            this.setCredentials(authscope, (Credentials)credentials);
        }
        return credentials;
    }

    private static boolean matchAuthScopeAndProxy(AuthScope authscope, Proxy proxy) {
        ProxyAddress proxyAddress = proxy.getAddress();
        return authscope.getHost().equals(proxyAddress.getHostName()) && authscope.getPort() == proxyAddress.getPort();
    }

    public static NTCredentials createNTLMCredentials(Proxy p) {
        if (p == null) {
            return null;
        }
        return HttpClientProxyCredentialProvider.createNTLMCredentials(p.getUsername(), p.getPassword());
    }

    protected static NTCredentials createNTLMCredentials(String username, String password) {
        String un = HttpClientProxyCredentialProvider.getNTLMUserName(username);
        String domain = HttpClientProxyCredentialProvider.getNTLMDomainName(username);
        if (un == null || domain == null || un.isEmpty() || domain.isEmpty()) {
            return null;
        }
        String workstation = HttpClientProxyCredentialProvider.getNTLMWorkstation();
        return new NTCredentials(un, password, workstation, domain);
    }

    public static Credentials fixNTCredentials(Credentials credentials) {
        if (credentials == null) {
            return null;
        }
        if (credentials instanceof NTCredentials) {
            NTCredentials ntCreds = (NTCredentials)credentials;
            String userName = ntCreds.getUserName();
            String domainUser = HttpClientProxyCredentialProvider.getNTLMUserName(userName);
            if (ntCreds.getDomain() == null || domainUser != userName) {
                String domain = HttpClientProxyCredentialProvider.getNTLMDomainName(userName);
                String workstation = HttpClientProxyCredentialProvider.getNTLMWorkstation();
                return new NTCredentials(domainUser, ntCreds.getPassword(), workstation, domain);
            }
        } else if (credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials basicCredentials = (UsernamePasswordCredentials)credentials;
            return HttpClientProxyCredentialProvider.createNTLMCredentials(basicCredentials.getUserName(), basicCredentials.getPassword());
        }
        return credentials;
    }

    public static String getNTLMWorkstation() {
        String dnsName = HttpClientProxyCredentialProvider.getDnsHostName();
        if (dnsName != null) {
            return dnsName;
        }
        String hostName = HttpClientProxyCredentialProvider.getEnvHostName();
        if (hostName != null) {
            return hostName;
        }
        return null;
    }

    private static boolean isWindows() {
        String os = FrameworkUtil.getBundle(HttpClientProxyCredentialProvider.class).getBundleContext().getProperty(OSGI_OS);
        return OSGI_OS_WIN32.equalsIgnoreCase(os);
    }

    private static String getEnvHostName() {
        boolean isWindows = HttpClientProxyCredentialProvider.isWindows();
        String envKey = isWindows ? COMPUTERNAME_ENV : HOSTNAME_ENV;
        String hostName = System.getenv(envKey);
        if (hostName == null && isWindows) {
            hostName = System.getenv(HOSTNAME_ENV);
        }
        return hostName;
    }

    private static String getDnsHostName() {
        try {
            String hostName;
            InetAddress localHost = InetAddress.getLocalHost();
            if (!(localHost.isLoopbackAddress() || (hostName = localHost.getHostName()) == null || "".equals(hostName) || "localhost".equals(hostName) || hostName.equals(localHost.getHostAddress()))) {
                return hostName;
            }
        }
        catch (UnknownHostException e) {
            Trace.catching((String)"org.eclipse.ecf.provider.filetransfer.httpclient45", (String)"org.eclipse.ecf.provider.filetransfer/debug/exceptions/catching", HttpClientRetrieveFileTransfer.class, (String)"getDnsHostName", (Throwable)e);
        }
        return null;
    }

    public static String getNTLMDomainName(String userName) {
        String domain = HttpClientProxyCredentialProvider.getDomainFromUserName(userName);
        if (domain != null) {
            return domain;
        }
        domain = HttpClientProxyCredentialProvider.getDomainFromSystemProperties();
        if (domain != null) {
            return domain;
        }
        return HttpClientProxyCredentialProvider.getDomainFromEnv();
    }

    private static String getDomainFromEnv() {
        String domain = System.getenv(USER_DOMAIN_ENV);
        if (domain != null) {
            if (HttpClientProxyCredentialProvider.isRealDomain(domain)) {
                return domain;
            }
            return null;
        }
        domain = System.getenv(USER_DNS_DOMAIN_ENV);
        if (domain != null) {
            return domain;
        }
        return null;
    }

    private static String getDomainFromSystemProperties() {
        String domain = System.getProperty(NTLM_DOMAIN_PROPERTY);
        return domain;
    }

    private static boolean isRealDomain(String domain) {
        String logonHost;
        String hostName = HttpClientProxyCredentialProvider.getEnvHostName();
        if (!domain.equalsIgnoreCase(hostName)) {
            return true;
        }
        return HttpClientProxyCredentialProvider.isWindows() && (logonHost = System.getenv(LOGONSERVER_ENV)) != null && !logonHost.equalsIgnoreCase(Character.toString('\\') + "\\" + domain);
    }

    private static String getDomainFromUserName(String userName) {
        if (userName == null) {
            return null;
        }
        int pos = HttpClientProxyCredentialProvider.getNTLMDomainUserSeparatorPos(userName);
        if (pos != -1) {
            return userName.substring(0, pos);
        }
        return null;
    }

    private static int getNTLMDomainUserSeparatorPos(String userName) {
        int pos = userName.indexOf(92);
        if (pos == -1) {
            pos = userName.indexOf(47);
        }
        return pos;
    }

    public static String getNTLMUserName(String userName) {
        if (userName == null) {
            return null;
        }
        int pos = HttpClientProxyCredentialProvider.getNTLMDomainUserSeparatorPos(userName);
        if (pos == -1) {
            return userName;
        }
        if (userName.length() > pos + 1 && (userName.charAt(pos + 1) == '/' || userName.charAt(pos + 1) == '\\')) {
            ++pos;
        }
        if (userName.length() >= pos + 1) {
            return userName.substring(pos + 1);
        }
        return userName;
    }
}

