/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.utility.filter;

import java.io.Serializable;
import org.eclipse.persistence.jpa.jpql.utility.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompoundFilter<T>
implements Filter<T>,
Cloneable,
Serializable {
    protected final Filter<T> filter1;
    protected final Filter<T> filter2;
    private static final long serialVersionUID = 1L;

    protected CompoundFilter(Filter<T> filter1, Filter<T> filter2) {
        this.checkFilter1(filter1);
        this.checkFilter2(filter2);
        this.filter1 = filter1;
        this.filter2 = filter2;
    }

    private void checkFilter1(Filter<T> filter) {
        if (filter == null) {
            throw new IllegalArgumentException("The first Filter cannot be null");
        }
    }

    private void checkFilter2(Filter<T> filter) {
        if (filter == null) {
            throw new IllegalArgumentException("The second Filter cannot be null");
        }
    }

    public CompoundFilter<T> clone() {
        try {
            return (CompoundFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("The cloning of this " + this.getClass().getSimpleName() + " was not successful.", e);
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof CompoundFilter)) {
            return false;
        }
        CompoundFilter other = (CompoundFilter)object;
        return this.filter1.equals(other.filter1) && this.filter2.equals(other.filter2) || this.filter1.equals(other.filter2) && this.filter2.equals(other.filter1);
    }

    public Filter<T> getFilter1() {
        return this.filter1;
    }

    public Filter<T> getFilter2() {
        return this.filter2;
    }

    public int hashCode() {
        return this.filter1.hashCode() ^ this.filter2.hashCode();
    }

    protected abstract String operatorString();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" (filter1=");
        sb.append(this.filter1);
        sb.append(", filter2=");
        sb.append(this.filter2);
        sb.append(")");
        return sb.toString();
    }
}

