/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import org.eclipse.persistence.annotations.Direction;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.queries.OracleArrayTypeMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.OracleObjectTypeMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.queries.StoredFunctionCall;
import org.eclipse.persistence.queries.StoredProcedureCall;

public class StoredProcedureParameterMetadata
extends ORMetadata {
    private Boolean m_optional;
    private Integer m_jdbcType;
    private MetadataClass m_type;
    private String m_direction;
    private String m_mode;
    private String m_jdbcTypeName;
    private String m_name;
    private String m_queryParameter;
    private String m_typeName;

    public StoredProcedureParameterMetadata() {
        super("<stored-procedure-parameter>");
    }

    public StoredProcedureParameterMetadata(MetadataAnnotation storedProcedureParameter, MetadataAccessor accessor) {
        super(storedProcedureParameter, accessor);
        this.m_direction = storedProcedureParameter.getAttributeString("direction");
        this.m_mode = storedProcedureParameter.getAttributeString("mode");
        this.m_name = storedProcedureParameter.getAttributeString("name");
        this.m_queryParameter = storedProcedureParameter.getAttributeString("queryParameter");
        this.m_type = this.getMetadataClass(storedProcedureParameter.getAttributeClass("type", Void.class));
        this.m_jdbcType = storedProcedureParameter.getAttributeInteger("jdbcType");
        this.m_jdbcTypeName = storedProcedureParameter.getAttributeString("jdbcTypeName");
        this.m_optional = storedProcedureParameter.getAttributeBooleanDefaultFalse("optional");
    }

    protected ObjectRelationalDatabaseField buildNestedField(OracleArrayTypeMetadata aType) {
        ObjectRelationalDatabaseField dbFld = new ObjectRelationalDatabaseField("");
        String nestedType = aType.getNestedType();
        dbFld.setSqlTypeName(nestedType);
        for (OracleObjectTypeMetadata oType : this.getEntityMappings().getOracleObjectTypes()) {
            if (!oType.getName().equals(nestedType)) continue;
            dbFld.setSqlType(2002);
            dbFld.setTypeName(oType.getJavaType());
        }
        return dbFld;
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof StoredProcedureParameterMetadata) {
            StoredProcedureParameterMetadata parameter = (StoredProcedureParameterMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_type, parameter.getType())) {
                return false;
            }
            if (!this.valuesMatch(this.m_direction, parameter.getDirection())) {
                return false;
            }
            if (!this.valuesMatch(this.m_mode, parameter.getMode())) {
                return false;
            }
            if (!this.valuesMatch(this.m_jdbcType, parameter.getJdbcType())) {
                return false;
            }
            if (!this.valuesMatch(this.m_jdbcTypeName, parameter.getJdbcTypeName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_name, parameter.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_optional, parameter.getOptional())) {
                return false;
            }
            return this.valuesMatch(this.m_queryParameter, parameter.getQueryParameter());
        }
        return false;
    }

    protected OracleArrayTypeMetadata getArrayTypeMetadata(String javaClassName) {
        for (OracleArrayTypeMetadata aType : this.getEntityMappings().getOracleArrayTypes()) {
            if (!aType.getJavaType().equals(javaClassName)) continue;
            return aType;
        }
        return null;
    }

    public String getDirection() {
        return this.m_direction;
    }

    public Integer getJdbcType() {
        return this.m_jdbcType;
    }

    public String getJdbcTypeName() {
        return this.m_jdbcTypeName;
    }

    public String getMode() {
        return this.m_mode;
    }

    public String getName() {
        return this.m_name;
    }

    public Boolean getOptional() {
        return this.m_optional;
    }

    public String getQueryParameter() {
        return this.m_queryParameter;
    }

    public MetadataClass getType() {
        return this.m_type;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    protected boolean hasJdbcType() {
        return this.m_jdbcType != null && !this.m_jdbcType.equals(-1);
    }

    protected boolean hasJdbcTypeName() {
        return this.m_jdbcTypeName != null && !this.m_jdbcTypeName.equals("");
    }

    protected boolean hasType() {
        return !this.m_type.isVoid();
    }

    protected boolean hasTypeName() {
        return this.m_typeName != null && !this.m_typeName.equals("");
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.m_type = this.initXMLClassName(this.m_typeName);
    }

    public boolean isOutParameter() {
        String parameterMode;
        String string = parameterMode = this.m_direction == null ? this.m_mode : this.m_direction;
        return parameterMode != null && (parameterMode.equals("OUT") || parameterMode.equals("INOUT") || parameterMode.equals("REF_CURSOR") || parameterMode.equals(Direction.OUT_CURSOR.name()));
    }

    private boolean process(StoredProcedureCall call, int index) {
        boolean shouldCallByIndex = false;
        if (this.m_name == null || this.m_name.equals("")) {
            if (this.m_queryParameter == null || this.m_queryParameter.equals("")) {
                shouldCallByIndex = true;
                this.m_queryParameter = String.valueOf(index);
            } else {
                this.m_name = this.m_queryParameter;
            }
        }
        if (this.m_queryParameter == null || this.m_queryParameter.equals("")) {
            this.m_queryParameter = this.m_name;
        }
        if (this.m_optional != null && this.m_optional.booleanValue()) {
            call.addOptionalArgument(this.m_queryParameter);
        }
        if (this.m_mode == null) {
            this.m_mode = this.m_direction == null ? "IN" : this.m_direction;
        }
        return shouldCallByIndex;
    }

    public void processArgument(StoredProcedureCall call, boolean callByIndex, int index) {
        boolean shouldCallByIndex = this.process(call, index);
        if (!callByIndex) {
            callByIndex = shouldCallByIndex;
        }
        if (this.m_mode.equals("IN")) {
            if (this.hasType()) {
                if (callByIndex) {
                    call.addUnamedArgument(this.m_queryParameter, this.getJavaClass(this.m_type));
                } else if (this.hasJdbcType() && this.hasJdbcTypeName()) {
                    OracleArrayTypeMetadata aType = null;
                    if (this.hasTypeName() && (aType = this.getArrayTypeMetadata(this.m_typeName)) != null) {
                        call.addNamedArgument(this.m_name, this.m_queryParameter, this.m_jdbcType.intValue(), this.m_jdbcTypeName, this.getJavaClass(this.m_type), (DatabaseField)this.buildNestedField(aType));
                    } else {
                        call.addNamedArgument(this.m_name, this.m_queryParameter, this.m_jdbcType.intValue(), this.m_jdbcTypeName, this.getJavaClass(this.m_type));
                    }
                } else {
                    call.addNamedArgument(this.m_name, this.m_queryParameter, this.getJavaClass(this.m_type));
                }
            } else if (this.hasJdbcType() && this.hasJdbcTypeName()) {
                if (callByIndex) {
                    call.addUnamedArgument(this.m_queryParameter, this.m_jdbcType.intValue(), this.m_jdbcTypeName);
                } else {
                    call.addNamedArgument(this.m_name, this.m_queryParameter, this.m_jdbcType.intValue(), this.m_jdbcTypeName);
                }
            } else if (this.hasJdbcType()) {
                if (callByIndex) {
                    call.addUnamedArgument(this.m_queryParameter, this.m_jdbcType.intValue());
                } else {
                    call.addNamedArgument(this.m_name, this.m_queryParameter, this.m_jdbcType.intValue());
                }
            } else if (callByIndex) {
                call.addUnamedArgument(this.m_queryParameter);
            } else {
                call.addNamedArgument(this.m_name, this.m_queryParameter);
            }
        } else if (this.m_mode.equals("OUT")) {
            if (this.hasType()) {
                if (callByIndex) {
                    call.addUnamedOutputArgument(this.m_queryParameter, this.getJavaClass(this.m_type));
                } else if (this.hasJdbcType() && this.hasJdbcTypeName()) {
                    OracleArrayTypeMetadata aType = null;
                    if (this.hasTypeName() && (aType = this.getArrayTypeMetadata(this.m_typeName)) != null) {
                        call.addNamedOutputArgument(this.m_name, this.m_queryParameter, this.m_jdbcType.intValue(), this.m_jdbcTypeName, this.getJavaClass(this.m_type), (DatabaseField)this.buildNestedField(aType));
                    } else {
                        call.addNamedOutputArgument(this.m_name, this.m_queryParameter, this.m_jdbcType.intValue(), this.m_jdbcTypeName, this.getJavaClass(this.m_type));
                    }
                } else {
                    call.addNamedOutputArgument(this.m_name, this.m_queryParameter, this.getJavaClass(this.m_type));
                }
            } else if (this.hasJdbcType() && this.hasJdbcTypeName()) {
                if (callByIndex) {
                    call.addUnamedOutputArgument(this.m_queryParameter, this.m_jdbcType.intValue(), this.m_jdbcTypeName);
                } else {
                    call.addNamedOutputArgument(this.m_name, this.m_queryParameter, this.m_jdbcType.intValue(), this.m_jdbcTypeName);
                }
            } else if (this.hasJdbcType()) {
                if (callByIndex) {
                    call.addUnamedOutputArgument(this.m_queryParameter, this.m_jdbcType.intValue());
                } else {
                    call.addNamedOutputArgument(this.m_name, this.m_queryParameter, this.m_jdbcType.intValue());
                }
            } else if (callByIndex) {
                call.addUnamedOutputArgument(this.m_queryParameter);
            } else {
                call.addNamedOutputArgument(this.m_name, this.m_queryParameter);
            }
            this.setDatabaseFieldSettings((DatabaseField)call.getParameters().get(call.getParameters().size() - 1));
        } else if (this.m_mode.equals(Direction.IN_OUT.name()) || this.m_mode.equals("INOUT")) {
            if (this.hasType()) {
                if (callByIndex) {
                    call.addUnamedInOutputArgument(this.m_queryParameter, this.m_queryParameter, this.getJavaClass(this.m_type));
                } else if (this.hasJdbcType() && this.hasJdbcTypeName()) {
                    call.addNamedInOutputArgument(this.m_name, this.m_queryParameter, this.m_queryParameter, this.m_jdbcType.intValue(), this.m_jdbcTypeName, this.getJavaClass(this.m_type));
                } else {
                    call.addNamedInOutputArgument(this.m_name, this.m_queryParameter, this.m_queryParameter, this.getJavaClass(this.m_type));
                }
            } else if (this.hasJdbcType() && this.hasJdbcTypeName()) {
                if (callByIndex) {
                    call.addUnamedInOutputArgument(this.m_queryParameter, this.m_queryParameter, this.m_jdbcType.intValue(), this.m_jdbcTypeName);
                } else {
                    call.addNamedInOutputArgument(this.m_name, this.m_queryParameter, this.m_queryParameter, this.m_jdbcType.intValue(), this.m_jdbcTypeName);
                }
            } else if (this.hasJdbcType()) {
                if (callByIndex) {
                    call.addUnamedInOutputArgument(this.m_queryParameter, this.m_queryParameter, this.m_jdbcType.intValue());
                } else {
                    call.addNamedInOutputArgument(this.m_name, this.m_queryParameter, this.m_queryParameter, this.m_jdbcType.intValue());
                }
            } else if (callByIndex) {
                call.addUnamedInOutputArgument(this.m_queryParameter);
            } else {
                call.addNamedInOutputArgument(this.m_name, this.m_queryParameter);
            }
            Object[] array = (Object[])call.getParameters().get(call.getParameters().size() - 1);
            if (array[0] == array[1]) {
                array[1] = ((DatabaseField)array[1]).clone();
            }
            this.setDatabaseFieldSettings((DatabaseField)array[1]);
        } else if (this.m_mode.equals(Direction.OUT_CURSOR.name()) || this.m_mode.equals("REF_CURSOR")) {
            if (callByIndex) {
                call.useUnnamedCursorOutputAsResultSet(index);
            } else {
                call.useNamedCursorOutputAsResultSet(this.m_queryParameter);
            }
        }
    }

    public void processResult(StoredFunctionCall call, int index) {
        this.process((StoredProcedureCall)call, index);
        if (this.hasType()) {
            if (this.hasJdbcType() && this.hasJdbcTypeName()) {
                OracleArrayTypeMetadata aType = null;
                if (this.hasTypeName() && (aType = this.getArrayTypeMetadata(this.m_typeName)) != null) {
                    call.setResult(this.m_jdbcType.intValue(), this.m_jdbcTypeName, this.getJavaClass(this.m_type), (DatabaseField)this.buildNestedField(aType));
                } else {
                    call.setResult(this.m_jdbcType.intValue(), this.m_jdbcTypeName, this.getJavaClass(this.m_type));
                }
            } else {
                call.setResult(this.m_name, this.getJavaClass(this.m_type));
            }
        } else if (this.hasJdbcType() && this.hasJdbcTypeName()) {
            call.setResult(this.m_name, this.m_jdbcType.intValue(), this.m_jdbcTypeName);
        } else if (this.hasJdbcType()) {
            call.setResult(this.m_name, this.m_jdbcType.intValue());
        } else {
            call.setResult(this.m_name);
        }
    }

    protected void setDatabaseFieldSettings(DatabaseField field) {
        if (this.getProject().useDelimitedIdentifier()) {
            field.setUseDelimiters(true);
        } else if (this.getProject().getShouldForceFieldNamesToUpperCase() && !field.shouldUseDelimiters()) {
            field.useUpperCaseForComparisons(true);
        }
    }

    public void setDirection(String direction) {
        this.m_direction = direction;
    }

    public void setJdbcType(Integer jdbcType) {
        this.m_jdbcType = jdbcType;
    }

    public void setJdbcTypeName(String jdbcTypeName) {
        this.m_jdbcTypeName = jdbcTypeName;
    }

    public void setMode(String mode) {
        this.m_mode = mode;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setOptional(Boolean optional) {
        this.m_optional = optional;
    }

    public void setQueryParameter(String queryParameter) {
        this.m_queryParameter = queryParameter;
    }

    public void setType(MetadataClass type) {
        this.m_type = type;
    }

    public void setTypeName(String typeName) {
        this.m_typeName = typeName;
    }
}

