/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.avro;

import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeSet;
import oracle.kv.Consistency;
import oracle.kv.Value;
import oracle.kv.avro.UndefinedSchemaException;
import oracle.kv.impl.api.avro.AvroCatalogImpl;
import oracle.kv.impl.api.avro.CBindingBridge;
import oracle.kv.impl.api.avro.RawBinding;
import oracle.kv.impl.api.avro.SchemaAccessor;
import oracle.kv.impl.api.avro.SchemaChecker;
import oracle.kv.impl.api.avro.SchemaData;
import oracle.kv.impl.api.avro.SchemaInfo;
import oracle.kv.impl.test.TestHook;
import org.apache.avro.Schema;

class SchemaCache {
    private final SchemaAccessor accessor;
    private final CBindingBridge cBindingBridge;
    private volatile Contents contents;
    private TestHook<Void> cacheMissHook;

    SchemaCache(SchemaAccessor accessor) {
        this.accessor = accessor;
        this.cBindingBridge = new CBindingBridgeImpl();
        this.contents = new Contents().updateStoredSchemas(accessor, accessor.getLowestConsistency());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStoredSchemas(Consistency consistency) {
        SchemaCache schemaCache = this;
        synchronized (schemaCache) {
            this.contents = this.contents.updateStoredSchemas(this.accessor, consistency);
        }
    }

    Map<String, Schema> getCurrentSchemas() {
        return this.contents.currentSchemas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SchemaInfo getSchemaInfoById(int schemaId) {
        SchemaInfo info = this.contents.byId.get(schemaId);
        if (info != null) {
            return info;
        }
        if (this.cacheMissHook != null) {
            this.cacheMissHook.doHook(null);
        }
        SchemaCache schemaCache = this;
        synchronized (schemaCache) {
            info = this.contents.byId.get(schemaId);
            if (info != null) {
                return info;
            }
            for (Consistency consistency : this.accessor.getConsistencyRamp()) {
                this.contents = this.contents.updateStoredSchemas(this.accessor, consistency);
                info = this.contents.byId.get(schemaId);
                if (info == null) continue;
                return info;
            }
            this.contents = this.contents.refreshStoredSchemas(this.accessor, this.accessor.getHighestConsistency());
            info = this.contents.byId.get(schemaId);
            if (info != null) {
                return info;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SchemaInfo getSchemaInfoByValue(Schema schemaValue) {
        SchemaInfo info = this.contents.byValue.get(schemaValue);
        if (info != null) {
            return info;
        }
        if (this.cacheMissHook != null) {
            this.cacheMissHook.doHook(null);
        }
        SchemaCache schemaCache = this;
        synchronized (schemaCache) {
            info = this.contents.byValue.get(schemaValue);
            if (info != null) {
                return info;
            }
            this.contents = this.contents.updateUserSchemas(schemaValue);
            info = this.contents.byValue.get(schemaValue);
            if (info != null) {
                return info;
            }
            for (Consistency consistency : this.accessor.getConsistencyRamp()) {
                this.contents = this.contents.updateStoredSchemas(this.accessor, consistency);
                this.contents = this.contents.updateUserSchemas(schemaValue);
                info = this.contents.byValue.get(schemaValue);
                if (info == null) continue;
                return info;
            }
            this.contents = this.contents.refreshStoredSchemas(this.accessor, this.accessor.getHighestConsistency());
            this.contents = this.contents.updateUserSchemas(schemaValue);
            info = this.contents.byValue.get(schemaValue);
            if (info != null) {
                return info;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaInfo getByValueAndUpdateCSchema(Schema schemaValue, long cSchema, boolean alwaysCacheCSchema) {
        SchemaCache schemaCache = this;
        synchronized (schemaCache) {
            SchemaInfo info = this.contents.findByValue(schemaValue, true);
            if (info == null) {
                for (Consistency consistency : this.accessor.getConsistencyRamp()) {
                    this.contents = this.contents.updateStoredSchemas(this.accessor, consistency);
                    info = this.contents.findByValue(schemaValue, true);
                    if (info == null) continue;
                    break;
                }
                if (info == null) {
                    this.contents = this.contents.refreshStoredSchemas(this.accessor, this.accessor.getHighestConsistency());
                    info = this.contents.findByValue(schemaValue, true);
                    if (info == null) {
                        return null;
                    }
                }
            }
            this.contents = this.contents.updateCSchema(cSchema, info, alwaysCacheCSchema);
            return info;
        }
    }

    public CBindingBridge getCBindingBridge() {
        return this.cBindingBridge;
    }

    int getByIdSize() {
        return this.contents.byId.size();
    }

    int getByNameSize() {
        return this.contents.byName.size();
    }

    int getByValueSize() {
        return this.contents.byValue.size();
    }

    int getByCSchemaSize() {
        return this.contents.byCSchema.size();
    }

    void setCacheMissHook(TestHook<Void> hook) {
        this.cacheMissHook = hook;
    }

    private static class Contents {
        final Map<String, SchemaInfo> byName;
        final Map<Integer, SchemaInfo> byId;
        final Map<Schema, SchemaInfo> byValue;
        final Map<Long, SchemaInfo> byCSchema;
        final Map<String, Schema> currentSchemas;
        final int nextSchemaId;

        Contents() {
            this.byName = Collections.emptyMap();
            this.byId = Collections.emptyMap();
            this.byValue = Collections.emptyMap();
            this.byCSchema = Collections.emptyMap();
            this.currentSchemas = Collections.emptyMap();
            this.nextSchemaId = 1;
        }

        private Contents(Contents prevContents, Map<String, SchemaInfo> byName, Map<Integer, SchemaInfo> byId, Map<Schema, SchemaInfo> byValue, Map<Long, SchemaInfo> byCSchema, boolean deriveCurrentSchemas, int nextSchemaId) {
            this.byName = byName != null ? byName : prevContents.byName;
            this.byId = byId != null ? byId : prevContents.byId;
            this.byValue = byValue != null ? byValue : prevContents.byValue;
            this.byCSchema = byCSchema != null ? byCSchema : prevContents.byCSchema;
            int n = this.nextSchemaId = nextSchemaId != 0 ? nextSchemaId : prevContents.nextSchemaId;
            if (deriveCurrentSchemas) {
                HashMap<String, Schema> newCurrentSchemas = new HashMap<String, Schema>(byName.size());
                for (Map.Entry<String, SchemaInfo> entry : byName.entrySet()) {
                    newCurrentSchemas.put(entry.getKey(), entry.getValue().getSchema());
                }
                this.currentSchemas = Collections.unmodifiableMap(newCurrentSchemas);
            } else {
                this.currentSchemas = prevContents.currentSchemas;
            }
        }

        Contents updateStoredSchemas(SchemaAccessor accessor, Consistency consistency) {
            SortedMap<Integer, SchemaData> newSchemas = accessor.readActiveSchemas(this.nextSchemaId, true, consistency);
            if (newSchemas.isEmpty()) {
                return this;
            }
            return this.addSchemas(newSchemas);
        }

        Contents refreshStoredSchemas(SchemaAccessor accessor, Consistency consistency) {
            SortedMap<Integer, SchemaData> allSchemas = accessor.readActiveSchemas(1, true, consistency);
            if (allSchemas.keySet().equals(this.byId.keySet())) {
                return this;
            }
            TreeSet<Integer> newIds = new TreeSet<Integer>(allSchemas.keySet());
            newIds.removeAll(this.byId.keySet());
            if (newIds.isEmpty() || (Integer)newIds.first() < this.nextSchemaId) {
                return new Contents().addSchemas(allSchemas);
            }
            return this.addSchemas(allSchemas.tailMap(this.nextSchemaId));
        }

        private Contents addSchemas(SortedMap<Integer, SchemaData> newSchemas) {
            HashMap<String, SchemaInfo> newByName = new HashMap<String, SchemaInfo>(this.byName);
            HashMap<Integer, SchemaInfo> newById = new HashMap<Integer, SchemaInfo>(this.byId);
            for (Map.Entry<Integer, SchemaData> entry : newSchemas.entrySet()) {
                Integer id = entry.getKey();
                Schema schema = entry.getValue().getSchema();
                String name = schema.getFullName();
                SchemaInfo prevVersion = (SchemaInfo)newByName.get(name);
                SchemaInfo info = new SchemaInfo(schema, id, prevVersion);
                newByName.put(name, info);
                newById.put(id, info);
            }
            return new Contents(this, Collections.unmodifiableMap(newByName), Collections.unmodifiableMap(newById), null, null, true, newSchemas.lastKey() + 1);
        }

        Contents updateUserSchemas(Schema schemaValue) {
            SchemaInfo info = this.findByValue(schemaValue, false);
            if (info == null) {
                return this;
            }
            IdentityHashMap<Schema, SchemaInfo> newByValue = new IdentityHashMap<Schema, SchemaInfo>(this.byValue);
            newByValue.put(schemaValue, info);
            return new Contents(this, null, null, Collections.unmodifiableMap(newByValue), null, false, 0);
        }

        Contents updateCSchema(long cSchema, SchemaInfo info, boolean alwaysCacheCSchema) {
            if (info.getCSchema() == 0L) {
                info.setCSchema(cSchema);
            } else if (!alwaysCacheCSchema) {
                return this;
            }
            if (this.byCSchema != null && this.byCSchema.containsKey(cSchema)) {
                return this;
            }
            HashMap<Long, SchemaInfo> newByCSchema = new HashMap<Long, SchemaInfo>(this.byCSchema);
            newByCSchema.put(cSchema, info);
            return new Contents(this, null, null, null, Collections.unmodifiableMap(newByCSchema), false, 0);
        }

        SchemaInfo findByValue(Schema schemaValue, boolean allowNullDefault) {
            for (SchemaInfo info = this.byName.get(schemaValue.getFullName()); info != null; info = info.getPreviousVersion()) {
                if (!SchemaChecker.equalSerializationWithDefault(schemaValue, info.getSchema(), allowNullDefault)) continue;
                return info;
            }
            return null;
        }
    }

    private class CBindingBridgeImpl
    implements CBindingBridge {
        private CBindingBridgeImpl() {
        }

        @Override
        public Schema getJavaSchema(long cSchema) {
            SchemaInfo info = ((SchemaCache)SchemaCache.this).contents.byCSchema.get(cSchema);
            if (info == null) {
                return null;
            }
            return info.getSchema();
        }

        @Override
        public Schema putSchema(String schemaText, long cSchema) throws UndefinedSchemaException, IllegalArgumentException {
            Schema javaSchema;
            try {
                javaSchema = new Schema.Parser().parse(schemaText);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Error parsing schema", e);
            }
            SchemaInfo info = SchemaCache.this.getByValueAndUpdateCSchema(javaSchema, cSchema, true);
            if (info == null) {
                throw AvroCatalogImpl.newUndefinedSchemaException(javaSchema);
            }
            return info.getSchema();
        }

        @Override
        public long getCSchema(Schema javaSchema) throws UndefinedSchemaException {
            SchemaInfo info = SchemaCache.this.getSchemaInfoByValue(javaSchema);
            if (info == null) {
                throw AvroCatalogImpl.newUndefinedSchemaException(javaSchema);
            }
            return info.getCSchema();
        }

        @Override
        public long putSchema(Schema javaSchema, long cSchema) throws UndefinedSchemaException {
            SchemaInfo info = SchemaCache.this.getByValueAndUpdateCSchema(javaSchema, cSchema, false);
            if (info == null) {
                throw AvroCatalogImpl.newUndefinedSchemaException(javaSchema);
            }
            return info.getCSchema();
        }

        @Override
        public long[] getCachedCSchemas() {
            Map<Long, SchemaInfo> map = ((SchemaCache)SchemaCache.this).contents.byCSchema;
            long[] array = new long[map.size()];
            int i = 0;
            for (long x : map.keySet()) {
                array[i++] = x;
            }
            return array;
        }

        @Override
        public int getValueRawDataOffset(Value value) {
            return RawBinding.getValueRawDataOffset(value);
        }

        @Override
        public Schema getValueSchema(Value value) throws IllegalArgumentException {
            return RawBinding.getValueSchema(value, SchemaCache.this);
        }

        @Override
        public Value allocateValue(Schema schema, int rawDataSize) throws UndefinedSchemaException {
            return RawBinding.allocateValue(schema, rawDataSize, SchemaCache.this);
        }
    }
}

