/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.SingleKeyOperation;
import oracle.kv.impl.util.SerializationUtil;

public class GetIdentityAttrsAndValues
extends SingleKeyOperation {
    private final long curVersion;
    private final int clientIdentityCacheSize;
    private final boolean needAttributes;
    private final boolean needNextSequence;
    private final String sgName;

    public GetIdentityAttrsAndValues(byte[] keyBytes, long curVersion, int clientIdentityCacheSize, boolean needAttributes, boolean needNextSequence, String sgName) {
        super(InternalOperation.OpCode.GET_IDENTITY, keyBytes);
        this.curVersion = curVersion;
        this.clientIdentityCacheSize = clientIdentityCacheSize;
        this.needAttributes = needAttributes;
        this.needNextSequence = needNextSequence;
        this.sgName = sgName;
    }

    GetIdentityAttrsAndValues(DataInput in, short serialVersion) throws IOException {
        super(InternalOperation.OpCode.GET_IDENTITY, in, serialVersion);
        this.curVersion = in.readLong();
        this.clientIdentityCacheSize = in.readInt();
        this.needAttributes = in.readBoolean();
        this.needNextSequence = in.readBoolean();
        this.sgName = SerializationUtil.readString(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        out.writeLong(this.curVersion);
        out.writeInt(this.clientIdentityCacheSize);
        out.writeBoolean(this.needAttributes);
        out.writeBoolean(this.needNextSequence);
        SerializationUtil.writeString(out, serialVersion, this.sgName);
    }

    public long getCurVersion() {
        return this.curVersion;
    }

    public int getClientCacheSize() {
        return this.clientIdentityCacheSize;
    }

    public boolean getNeedAttributes() {
        return this.needAttributes;
    }

    public boolean getNeedNextSequence() {
        return this.needNextSequence;
    }

    public String getSgName() {
        return this.sgName;
    }
}

