/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.sessionconsole;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.sql.DataSource;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.table.DefaultTableModel;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQueryResult;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.JNDIConnector;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionProfiler;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;
import org.eclipse.persistence.tools.beans.ExpressionPanel;
import org.eclipse.persistence.tools.beans.MessageDialog;
import org.eclipse.persistence.tools.beans.TextAreaOutputStream;
import org.eclipse.persistence.tools.profiler.PerformanceProfiler;
import org.eclipse.persistence.tools.sessionconsole.ClassInfo;
import org.eclipse.persistence.tools.sessionconsole.ClassInfoCompare;
import org.eclipse.persistence.tools.sessionconsole.LoginEditorPanel;
import org.eclipse.persistence.tools.sessionconsole.ProfileBrowser;

public class SessionConsolePanel
extends JPanel
implements ActionListener,
ItemListener,
MouseListener,
PropertyChangeListener,
ListSelectionListener {
    protected int compileCount = 0;
    protected Vector results;
    protected Vector cacheResults;
    private Session fieldSession = null;
    private JButton mBrowseProfileButton = null;
    private JMenuItem mBrowseProfileMenuItem = null;
    private JPanel sqlPage = null;
    private JPopupMenu sqlPagePopupMenu = null;
    private JTable sqlPageTable = null;
    private JMenuItem mClearSQLMenuItem = null;
    private JMenuItem mCopySQLMenuItem = null;
    private JMenuItem mCutSQLMenuItem = null;
    private JMenuItem mDeleteSQLMenuItem = null;
    private JMenuItem mInsertSQLMenuItem = null;
    private JMenuItem mSelectSQLMenuItem = null;
    private JButton mSQLExecuteButton = null;
    private JPopupMenu mSQLMenu = null;
    private JScrollPane mSQLScrollPane = null;
    private JTextPane mSQLText = null;
    private JButton jpqlExecuteButton = null;
    private JTextPane jpqlText = null;
    private JPanel cachePage = null;
    private JButton mInspectCacheButton = null;
    private JMenuItem mInspectCacheMenuItem = null;
    private JButton mClearCacheButton = null;
    private JMenuItem mClearCacheMenuItem = null;
    private JMenuItem mSQLSelectMenuItem = null;
    private JMenu mSQLTemplateMenu = null;
    private JMenuItem mSQLUpdateMenuItem = null;
    private JScrollPane cacheScrollPane = null;
    private JList mClassList = null;
    private JScrollPane mClassScrollPane = null;
    private JButton mClearButton = null;
    private JMenuItem mClearDescriptorsMenuItem = null;
    private JButton mClearLogButton = null;
    private JMenuItem cutMenuItem = null;
    private JMenuItem copyMenuItem = null;
    private JMenuItem pasteMenuItem = null;
    private JMenuItem mClearLogMenuItem = null;
    private JMenuItem mClearResultsMenuItem = null;
    private JPopupMenu mDescriptorMenu = null;
    private JMenuItem mExecuteQueryMenuItem = null;
    private ExpressionPanel mExpressionPanel = null;
    private JCheckBoxMenuItem mFullNamesMenuItem = null;
    private JMenuItem mInspectDescriptorMenuItem = null;
    private JMenuItem mInspectResultMenuItem = null;
    private JMenuItem mInspectSessionMenuItem1 = null;
    private JPopupMenu mJPopupMenu1 = null;
    private JSeparator mJSeparator4 = null;
    private JSeparator mJSeparator5 = null;
    private JSeparator mJSeparator6 = null;
    private JSeparator mJSeparator7 = null;
    private JButton mLoadProjectButton = null;
    private JTabbedPane mLogBook = null;
    private JComboBox logLevelChoice = null;
    private JButton mLoginButton = null;
    private LoginEditorPanel mLoginEditorPanel = null;
    private JPopupMenu mLoginMenu = null;
    private JMenuItem mLoginMenuItem = null;
    private JPanel mLoginPage = null;
    private JPopupMenu mLogMenu = null;
    private JButton mLogoutButton = null;
    private JMenuItem mLogoutMenuItem = null;
    private JPanel mLogPage = null;
    private JCheckBox mLogProfileCheckbox = null;
    private JCheckBoxMenuItem mLogProfileMenuItem = null;
    private JCheckBoxMenuItem mLogProfileMenuItem1 = null;
    private JScrollPane mLogScrollPane = null;
    private JSplitPane mLogSplitter = null;
    private JTextArea mLogText = null;
    private JMenuItem mPasteSQLMenuItem = null;
    private JCheckBox mProfileCheckbox = null;
    private JButton mQueryButton = null;
    private JPopupMenu mQueryMenu = null;
    private JPanel mQueryPage = null;
    private JMenuItem mResetDescriptorsMenuItem = null;
    private JPanel mResultPage = null;
    private JScrollPane mResultsScrollPane = null;
    private JTable mResultsTable = null;
    private JButton mSelectButton = null;
    private JPanel javaPage = null;
    private JScrollPane javaScrollPane = null;
    private JTextPane javaText = null;
    private JButton javaExecuteButton = null;
    private JButton javaClearButton = null;
    private JPanel mTopPanel = null;
    private JSplitPane mTopSplitPane = null;
    private JMenuItem mUpdateSQLMenuItem = null;
    private JTabbedPane mWorkspaceBook = null;
    private boolean shouldUseJndiConnector = false;

    public SessionConsolePanel() {
        this.initialize();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.getCutMenuItem()) {
                this.cutLog();
            }
            if (e.getSource() == this.getCopyMenuItem()) {
                this.cutLog();
            }
            if (e.getSource() == this.getPasteMenuItem()) {
                this.cutLog();
            }
            if (e.getSource() == this.getLoginButton()) {
                this.login();
            }
            if (e.getSource() == this.getLogoutButton()) {
                this.logout();
            }
            if (e.getSource() == this.getLoadProjectButton()) {
                this.loadProject();
            }
            if (e.getSource() == this.getClearLogButton()) {
                this.clearLog();
            }
            if (e.getSource() == this.getBrowseProfileButton()) {
                this.browseProfile();
            }
            if (e.getSource() == this.getSelectButton()) {
                this.selectSQL();
            }
            if (e.getSource() == this.getSQLExecuteButton()) {
                this.executeSQL();
            }
            if (e.getSource() == this.getJPQLExecuteButton()) {
                this.executeJPQL();
            }
            if (e.getSource() == this.getJavaExecuteButton()) {
                this.executeJava();
            }
            if (e.getSource() == this.getClearButton()) {
                this.clearSQL();
            }
            if (e.getSource() == this.getJavaClearButton()) {
                this.clearJava();
            }
            if (e.getSource() == this.getClearCacheButton()) {
                this.clearCache();
            }
            if (e.getSource() == this.getInspectCacheButton()) {
                this.inspectFromCache();
            }
            if (e.getSource() == this.getQueryButton()) {
                this.executeQuery();
            }
            if (e.getSource() == this.getClearCacheMenuItem()) {
                this.clearCache();
            }
            if (e.getSource() == this.getInspectCacheMenuItem()) {
                this.inspectFromCache();
            }
            if (e.getSource() == this.getClearResultsMenuItem()) {
                this.clearResults();
            }
            if (e.getSource() == this.getInspectResultMenuItem()) {
                this.inspectResult();
            }
            if (e.getSource() == this.getInspectDescriptorMenuItem()) {
                this.inspectDescriptor();
            }
            if (e.getSource() == this.getClearDescriptorsMenuItem()) {
                this.clearDescriptors();
            }
            if (e.getSource() == this.getResetDescriptorsMenuItem()) {
                this.resetDescriptors();
            }
            if (e.getSource() == this.getInsertSQLMenuItem()) {
                this.templateSQLInsert();
            }
            if (e.getSource() == this.getUpdateSQLMenuItem()) {
                this.templateSQLUpdate();
            }
            if (e.getSource() == this.getDeleteSQLMenuItem()) {
                this.templateSQLDelete();
            }
            if (e.getSource() == this.getSelectSQLMenuItem()) {
                this.templateSQLSelect();
            }
            if (e.getSource() == this.getSQLUpdateMenuItem()) {
                this.executeSQL();
            }
            if (e.getSource() == this.getSQLSelectMenuItem()) {
                this.selectSQL();
            }
            if (e.getSource() == this.getClearSQLMenuItem()) {
                this.clearSQL();
            }
            if (e.getSource() == this.getCutSQLMenuItem()) {
                this.cutSQL();
            }
            if (e.getSource() == this.getCopySQLMenuItem()) {
                this.copySQL();
            }
            if (e.getSource() == this.getPasteSQLMenuItem()) {
                this.pasteSQL();
            }
            if (e.getSource() == this.getLoginMenuItem()) {
                this.login();
            }
            if (e.getSource() == this.getLogoutMenuItem()) {
                this.logout();
            }
            if (e.getSource() == this.getInspectSessionMenuItem1()) {
                this.inspectSession();
            }
            if (e.getSource() == this.getExecuteQueryMenuItem()) {
                this.executeQuery();
            }
            if (e.getSource() == this.getClearLogMenuItem()) {
                this.clearLog();
            }
            if (e.getSource() == this.getBrowseProfileMenuItem()) {
                this.browseProfile();
            }
            if (e.getSource() == this.getFullNamesMenuItem()) {
                this.resetDescriptors();
            }
        }
        catch (Throwable error) {
            this.handleException(error);
        }
    }

    public void browseProfile() {
        if (this.getSession().isInProfile()) {
            ProfileBrowser.browseProfiles(((PerformanceProfiler)this.getSession().getProfiler()).getProfiles());
        }
    }

    public static void centerComponent(Component component, Component parent) {
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        Dimension parentSize = parent.getSize();
        Dimension size = component.getSize();
        int xOffset = parent.getLocation().x;
        int yOffset = parent.getLocation().y;
        parentSize.height /= 2;
        parentSize.width /= 2;
        size.height /= 2;
        size.width /= 2;
        component.setLocation(parentSize.width - size.width + xOffset, parentSize.height - size.height + yOffset);
    }

    public void clearCache() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.resetCache();
    }

    public void clearDescriptors() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        ((AbstractSession)this.getSession()).setProject(new Project());
        this.resetDescriptors();
    }

    public void clearLog() {
        this.getLogText().setText("");
    }

    public void copyLog() {
        this.getLogText().copy();
    }

    public void cutLog() {
        this.getLogText().cut();
    }

    public void pasteLog() {
        this.getLogText().paste();
    }

    public void clearResults() {
        this.setResults(new Vector());
        DefaultTableModel model = new DefaultTableModel();
        this.getResultsTable().setModel(model);
        this.getResultsTable().repaint();
    }

    public void clearSQL() {
        this.getSQLText().setText("");
    }

    public void clearJava() {
        this.getJavaText().setText("");
    }

    private void connEtoC14(ItemEvent arg1) {
        try {
            this.logProfileChanged();
        }
        catch (Throwable exception) {
            this.handleException(exception);
        }
    }

    private void connEtoC15(ItemEvent arg1) {
        try {
            this.profileChanged();
        }
        catch (Throwable exception) {
            this.handleException(exception);
        }
    }

    private void connEtoC16(ItemEvent arg1) {
        try {
            this.loggingChanged();
        }
        catch (Throwable exception) {
            this.handleException(exception);
        }
    }

    private void connEtoC18(MouseEvent arg1) {
        try {
            this.genericPopupDisplay(arg1, this.getSQLMenu());
        }
        catch (Throwable exception) {
            this.handleException(exception);
        }
    }

    private void connEtoC19(MouseEvent arg1) {
        try {
            this.genericPopupDisplay(arg1, this.getCachePopupMenu());
        }
        catch (Throwable exception) {
            this.handleException(exception);
        }
    }

    private void connEtoC20(MouseEvent arg1) {
        try {
            this.genericPopupDisplay(arg1, this.getJPopupMenu1());
        }
        catch (Throwable exception) {
            this.handleException(exception);
        }
    }

    private void connEtoC21(MouseEvent arg1) {
        try {
            this.genericPopupDisplay(arg1, this.getDescriptorMenu());
        }
        catch (Throwable exception) {
            this.handleException(exception);
        }
    }

    private void connEtoC3(ListSelectionEvent arg1) {
        try {
            this.descriptorChanged();
        }
        catch (Throwable exception) {
            this.handleException(exception);
        }
    }

    private void connEtoC40(MouseEvent arg1) {
        try {
            this.genericPopupDisplay(arg1, this.getQueryMenu());
        }
        catch (Throwable exception) {
            this.handleException(exception);
        }
    }

    private void connEtoC41(MouseEvent arg1) {
        try {
            this.genericPopupDisplay(arg1, this.getLogMenu());
        }
        catch (Throwable exception) {
            this.handleException(exception);
        }
    }

    private void connEtoC42(MouseEvent arg1) {
        try {
            this.genericPopupDisplay(arg1, this.getLoginMenu());
        }
        catch (Throwable exception) {
            this.handleException(exception);
        }
    }

    private void connPtoP1SetTarget() {
        try {
            this.getBrowseProfileButton().setEnabled(this.getBrowseProfileMenuItem().isEnabled());
        }
        catch (Throwable exception) {
            this.handleException(exception);
        }
    }

    private void connPtoP2SetTarget() {
        try {
            this.getLogProfileCheckbox().setSelected(this.getLogProfileMenuItem().isSelected());
        }
        catch (Throwable exception) {
            this.handleException(exception);
        }
    }

    private void connPtoP3SetTarget() {
        try {
            this.getLogProfileMenuItem1().setSelected(this.getProfileCheckbox().isSelected());
        }
        catch (Throwable exception) {
            this.handleException(exception);
        }
    }

    private void connPtoP4SetTarget() {
        try {
            this.getLogLevelChoice().setSelectedIndex(this.getSession().getSessionLog().getLevel());
        }
        catch (Throwable exception) {
            this.handleException(exception);
        }
    }

    public void copySQL() {
        this.getSQLText().copy();
    }

    public void createTables() {
    }

    public void cutSQL() {
        this.getSQLText().cut();
    }

    public void descriptorChanged() {
        this.resetCache();
        ClassInfo info = (ClassInfo)this.getClassList().getSelectedValue();
        if (info != null) {
            this.getExpressionPanel().setDescriptor(info.descriptor);
        }
    }

    public void executeQuery() {
        this.showBusyCursor();
        try {
            ClassInfo info = (ClassInfo)this.getClassList().getSelectedValue();
            if (info == null) {
                return;
            }
            ReadAllQuery query = new ReadAllQuery(this.getExpressionPanel().getDescriptor().getJavaClass());
            query.setSelectionCriteria(this.getExpressionPanel().getExpression());
            this.setResultObjects((Vector)this.getSession().executeQuery((DatabaseQuery)query), this.getExpressionPanel().getDescriptor());
            this.getLogBook().setSelectedComponent(this.getResultPage());
        }
        finally {
            this.showNormalCursor();
        }
    }

    public void executeSQL() {
        this.showBusyCursor();
        try {
            String sql = this.getSQLText().getSelectedText();
            if (sql == null || sql.length() == 0) {
                return;
            }
            this.getSession().executeNonSelectingCall((Call)new SQLCall(sql));
        }
        finally {
            this.showNormalCursor();
        }
    }

    public void executeJPQL() {
        this.showBusyCursor();
        try {
            this.getSession().getProject().getJPQLParseCache().getCache().clear();
            String jpql = this.getJPQLText().getSelectedText();
            if (jpql == null || jpql.length() == 0) {
                return;
            }
            DatabaseQuery query = ((AbstractSession)this.getSession()).getQueryBuilder().buildQuery((CharSequence)jpql, (AbstractSession)this.getSession());
            if (query.isReadQuery()) {
                this.setResultReports((Vector)this.getSession().executeQuery(query));
                this.getLogBook().setSelectedComponent(this.getResultPage());
            } else {
                this.getSession().executeQuery(query);
            }
        }
        finally {
            this.showNormalCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeJava() {
        this.showBusyCursor();
        try {
            String java = this.getJavaText().getSelectedText();
            if (java == null || java.length() == 0) {
                return;
            }
            try {
                Object value;
                ++this.compileCount;
                String className = "JavaCode" + this.compileCount;
                String[] source = new String[]{className + ".java"};
                File file = new File(className + ".java");
                file.createNewFile();
                FileWriter writer = new FileWriter(file);
                writer.write("import java.util.*;\n");
                writer.write("import org.eclipse.persistence.sessions.*;\n");
                writer.write("import org.eclipse.persistence.expressions.*;\n");
                writer.write("import org.eclipse.persistence.queries.*;\n");
                writer.write("public class " + className + " {\n");
                writer.write("public Session session;\n");
                writer.write("public Object exec() {\n");
                writer.write(java);
                if (java.indexOf("return") < 0) {
                    writer.write("return \"success\";\n");
                }
                writer.write("}\n");
                writer.write("}\n");
                writer.flush();
                writer.close();
                Object[] params = new Object[]{source};
                Class<?> mainClass = Class.forName("com.sun.tools.javac.Main");
                Class[] parameterTypes = new Class[]{String[].class};
                Method method = mainClass.getMethod("compile", parameterTypes);
                int result = (Integer)method.invoke(null, params);
                if (result != 0) {
                    throw new RuntimeException("Java code compile failed. This could either be a legitimate compile failure, or could result if you do not have the tools.jar from your JDK on the classpath.");
                }
                Class<?> newClass = Class.forName(className);
                Object newInstance = newClass.newInstance();
                newClass.getField("session").set(newInstance, this.getSession());
                try {
                    value = newClass.getMethod("exec", null).invoke(newInstance, (Object[])null);
                }
                catch (InvocationTargetException exception) {
                    throw exception.getCause();
                }
                this.inspect(value);
            }
            catch (Throwable exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new RuntimeException(exception.toString());
            }
        }
        finally {
            this.showNormalCursor();
        }
    }

    public void genericPopupDisplay(MouseEvent mouseEvent, JPopupMenu menu) {
        if (mouseEvent.isPopupTrigger()) {
            menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private JButton getBrowseProfileButton() {
        if (this.mBrowseProfileButton == null) {
            try {
                this.mBrowseProfileButton = new JButton();
                this.mBrowseProfileButton.setName("BrowseProfileButton");
                this.mBrowseProfileButton.setText("Browse Profile");
                this.mBrowseProfileButton.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mBrowseProfileButton;
    }

    private JMenuItem getBrowseProfileMenuItem() {
        if (this.mBrowseProfileMenuItem == null) {
            try {
                this.mBrowseProfileMenuItem = new JMenuItem();
                this.mBrowseProfileMenuItem.setName("BrowseProfileMenuItem");
                this.mBrowseProfileMenuItem.setText("Browse Profile");
                this.mBrowseProfileMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mBrowseProfileMenuItem;
    }

    private JPanel getSQLPage() {
        if (this.sqlPage == null) {
            try {
                this.sqlPage = new JPanel();
                this.sqlPage.setName("SQL");
                this.sqlPage.setLayout(new GridBagLayout());
                this.sqlPage.setBackground(SystemColor.control);
                GridBagConstraints constraintsSQLExecuteButton = new GridBagConstraints();
                constraintsSQLExecuteButton.gridx = 1;
                constraintsSQLExecuteButton.gridy = 1;
                constraintsSQLExecuteButton.insets = new Insets(2, 2, 2, 2);
                this.getSQLPage().add((Component)this.getSQLExecuteButton(), constraintsSQLExecuteButton);
                GridBagConstraints constraintsClearButton = new GridBagConstraints();
                constraintsClearButton.gridx = 2;
                constraintsClearButton.gridy = 1;
                constraintsClearButton.insets = new Insets(2, 2, 2, 2);
                this.getSQLPage().add((Component)this.getClearButton(), constraintsClearButton);
                GridBagConstraints constraintsSelectButton = new GridBagConstraints();
                constraintsSelectButton.gridx = 0;
                constraintsSelectButton.gridy = 1;
                constraintsSelectButton.insets = new Insets(2, 2, 2, 2);
                this.getSQLPage().add((Component)this.getSelectButton(), constraintsSelectButton);
                GridBagConstraints constraintsSQLScrollPane = new GridBagConstraints();
                constraintsSQLScrollPane.gridx = 0;
                constraintsSQLScrollPane.gridy = 0;
                constraintsSQLScrollPane.gridwidth = 5;
                constraintsSQLScrollPane.fill = 1;
                constraintsSQLScrollPane.weightx = 1.0;
                constraintsSQLScrollPane.weighty = 1.0;
                constraintsSQLScrollPane.insets = new Insets(0, 0, 2, 0);
                this.getSQLPage().add((Component)this.getSQLScrollPane(), constraintsSQLScrollPane);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.sqlPage;
    }

    private JPanel getJPQLPage() {
        JPanel page = new JPanel();
        page.setName("JPQL");
        page.setLayout(new GridBagLayout());
        page.setBackground(SystemColor.control);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.insets = new Insets(2, 2, 2, 2);
        page.add((Component)this.getJPQLExecuteButton(), constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 5;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 0, 2, 0);
        page.add((Component)this.getJPQLScrollPane(), constraints);
        return page;
    }

    private JPanel getJavaPage() {
        if (this.javaPage == null) {
            try {
                this.javaPage = new JPanel();
                this.javaPage.setName("Java");
                this.javaPage.setLayout(new GridBagLayout());
                this.javaPage.setBackground(SystemColor.control);
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.gridx = 1;
                constraints.gridy = 1;
                constraints.insets = new Insets(2, 2, 2, 2);
                this.getJavaPage().add((Component)this.getJavaExecuteButton(), constraints);
                constraints = new GridBagConstraints();
                constraints.gridx = 2;
                constraints.gridy = 1;
                constraints.insets = new Insets(2, 2, 2, 2);
                this.getJavaPage().add((Component)this.getJavaClearButton(), constraints);
                constraints = new GridBagConstraints();
                constraints.gridx = 0;
                constraints.gridy = 0;
                constraints.gridwidth = 5;
                constraints.fill = 1;
                constraints.weightx = 1.0;
                constraints.weighty = 1.0;
                constraints.insets = new Insets(0, 0, 2, 0);
                this.getJavaPage().add((Component)this.getJavaScrollPane(), constraints);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.javaPage;
    }

    private JPanel getCachePage() {
        if (this.cachePage == null) {
            try {
                this.cachePage = new JPanel();
                this.cachePage.setName("CachePage");
                this.cachePage.setLayout(new GridBagLayout());
                this.cachePage.setBackground(SystemColor.control);
                GridBagConstraints constraintsClearCacheButton = new GridBagConstraints();
                constraintsClearCacheButton.gridx = 0;
                constraintsClearCacheButton.gridy = 1;
                constraintsClearCacheButton.insets = new Insets(2, 2, 2, 2);
                this.getCachePage().add((Component)this.getClearCacheButton(), constraintsClearCacheButton);
                GridBagConstraints constraintsCacheScrollPane = new GridBagConstraints();
                constraintsCacheScrollPane.gridx = 0;
                constraintsCacheScrollPane.gridy = 0;
                constraintsCacheScrollPane.gridwidth = 6;
                constraintsCacheScrollPane.fill = 1;
                constraintsCacheScrollPane.weightx = 1.0;
                constraintsCacheScrollPane.weighty = 1.0;
                constraintsCacheScrollPane.insets = new Insets(0, 0, 2, 0);
                this.getCachePage().add((Component)this.getCacheScrollPane(), constraintsCacheScrollPane);
                GridBagConstraints constraintsInspectCacheButton = new GridBagConstraints();
                constraintsInspectCacheButton.gridx = 1;
                constraintsInspectCacheButton.gridy = 1;
                constraintsInspectCacheButton.insets = new Insets(2, 2, 2, 2);
                this.getCachePage().add((Component)this.getInspectCacheButton(), constraintsInspectCacheButton);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.cachePage;
    }

    private JPopupMenu getCachePopupMenu() {
        if (this.sqlPagePopupMenu == null) {
            try {
                this.sqlPagePopupMenu = new JPopupMenu();
                this.sqlPagePopupMenu.setName("CachePopupMenu");
                this.sqlPagePopupMenu.add(this.getClearCacheMenuItem());
                this.sqlPagePopupMenu.add(this.getInspectCacheMenuItem());
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.sqlPagePopupMenu;
    }

    public Vector getCacheResults() {
        return this.cacheResults;
    }

    private JScrollPane getCacheScrollPane() {
        if (this.cacheScrollPane == null) {
            try {
                this.cacheScrollPane = new JScrollPane();
                this.cacheScrollPane.setName("CacheScrollPane");
                this.getCacheScrollPane().setViewportView(this.getCacheTable());
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.cacheScrollPane;
    }

    private JTable getCacheTable() {
        if (this.sqlPageTable == null) {
            try {
                this.sqlPageTable = new JTable();
                this.sqlPageTable.setName("CacheTable");
                this.getCacheScrollPane().setColumnHeaderView(this.sqlPageTable.getTableHeader());
                this.sqlPageTable.setAutoResizeMode(3);
                this.sqlPageTable.setPreferredSize(new Dimension(600, 300));
                this.sqlPageTable.setBounds(0, 0, 583, 370);
                this.sqlPageTable.setPreferredScrollableViewportSize(new Dimension(600, 300));
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.sqlPageTable;
    }

    private JList getClassList() {
        if (this.mClassList == null) {
            try {
                this.mClassList = new JList();
                this.mClassList.setName("ClassList");
                this.mClassList.setBorder(new BasicBorders.MarginBorder());
                this.mClassList.setBounds(0, 0, 160, 428);
                this.mClassList.setMinimumSize(new Dimension(1, 1));
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mClassList;
    }

    private JScrollPane getClassScrollPane() {
        if (this.mClassScrollPane == null) {
            try {
                this.mClassScrollPane = new JScrollPane();
                this.mClassScrollPane.setName("ClassScrollPane");
                this.mClassScrollPane.setMaximumSize(new Dimension(0, 0));
                this.mClassScrollPane.setPreferredSize(new Dimension(120, 0));
                this.mClassScrollPane.setMinimumSize(new Dimension(100, 0));
                this.getClassScrollPane().setViewportView(this.getClassList());
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mClassScrollPane;
    }

    private JButton getClearButton() {
        if (this.mClearButton == null) {
            try {
                this.mClearButton = new JButton();
                this.mClearButton.setName("ClearButton");
                this.mClearButton.setText("Clear");
                this.mClearButton.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mClearButton;
    }

    private JButton getJavaClearButton() {
        if (this.javaClearButton == null) {
            try {
                this.javaClearButton = new JButton();
                this.javaClearButton.setName("JavaClearButton");
                this.javaClearButton.setText("Clear");
                this.javaClearButton.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.javaClearButton;
    }

    private JButton getClearCacheButton() {
        if (this.mClearCacheButton == null) {
            try {
                this.mClearCacheButton = new JButton();
                this.mClearCacheButton.setName("ClearCacheButton");
                this.mClearCacheButton.setText("Clear Cache");
                this.mClearCacheButton.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mClearCacheButton;
    }

    private JMenuItem getClearCacheMenuItem() {
        if (this.mClearCacheMenuItem == null) {
            try {
                this.mClearCacheMenuItem = new JMenuItem();
                this.mClearCacheMenuItem.setName("ClearCacheMenuItem");
                this.mClearCacheMenuItem.setText("Clear Cache");
                this.mClearCacheMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mClearCacheMenuItem;
    }

    private JMenuItem getClearDescriptorsMenuItem() {
        if (this.mClearDescriptorsMenuItem == null) {
            try {
                this.mClearDescriptorsMenuItem = new JMenuItem();
                this.mClearDescriptorsMenuItem.setName("ClearDescriptorsMenuItem");
                this.mClearDescriptorsMenuItem.setText("Clear Descriptors");
                this.mClearDescriptorsMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mClearDescriptorsMenuItem;
    }

    private JButton getClearLogButton() {
        if (this.mClearLogButton == null) {
            try {
                this.mClearLogButton = new JButton();
                this.mClearLogButton.setName("ClearLogButton");
                this.mClearLogButton.setText("Clear");
                this.mClearLogButton.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mClearLogButton;
    }

    private JMenuItem getClearLogMenuItem() {
        if (this.mClearLogMenuItem == null) {
            try {
                this.mClearLogMenuItem = new JMenuItem();
                this.mClearLogMenuItem.setName("ClearLogMenuItem");
                this.mClearLogMenuItem.setText("Clear Log");
                this.mClearLogMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mClearLogMenuItem;
    }

    private JMenuItem getCutMenuItem() {
        if (this.cutMenuItem == null) {
            try {
                this.cutMenuItem = new JMenuItem();
                this.cutMenuItem.setName("CutMenuItem");
                this.cutMenuItem.setText("Cut");
                this.cutMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.cutMenuItem;
    }

    private JMenuItem getCopyMenuItem() {
        if (this.copyMenuItem == null) {
            try {
                this.copyMenuItem = new JMenuItem();
                this.copyMenuItem.setName("CopyMenuItem");
                this.copyMenuItem.setText("Copy");
                this.copyMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.copyMenuItem;
    }

    private JMenuItem getPasteMenuItem() {
        if (this.pasteMenuItem == null) {
            try {
                this.pasteMenuItem = new JMenuItem();
                this.pasteMenuItem.setName("PasteMenuItem");
                this.pasteMenuItem.setText("Paste");
                this.pasteMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.pasteMenuItem;
    }

    private JMenuItem getClearResultsMenuItem() {
        if (this.mClearResultsMenuItem == null) {
            try {
                this.mClearResultsMenuItem = new JMenuItem();
                this.mClearResultsMenuItem.setName("ClearResultsMenuItem");
                this.mClearResultsMenuItem.setText("Clear Results");
                this.mClearResultsMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mClearResultsMenuItem;
    }

    private JMenuItem getClearSQLMenuItem() {
        if (this.mClearSQLMenuItem == null) {
            try {
                this.mClearSQLMenuItem = new JMenuItem();
                this.mClearSQLMenuItem.setName("ClearSQLMenuItem");
                this.mClearSQLMenuItem.setText("Clear SQL");
                this.mClearSQLMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mClearSQLMenuItem;
    }

    private JMenuItem getCopySQLMenuItem() {
        if (this.mCopySQLMenuItem == null) {
            try {
                this.mCopySQLMenuItem = new JMenuItem();
                this.mCopySQLMenuItem.setName("CopySQLMenuItem");
                this.mCopySQLMenuItem.setText("Copy");
                this.mCopySQLMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mCopySQLMenuItem;
    }

    private JMenuItem getCutSQLMenuItem() {
        if (this.mCutSQLMenuItem == null) {
            try {
                this.mCutSQLMenuItem = new JMenuItem();
                this.mCutSQLMenuItem.setName("CutSQLMenuItem");
                this.mCutSQLMenuItem.setText("Cut");
                this.mCutSQLMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mCutSQLMenuItem;
    }

    private JMenuItem getDeleteSQLMenuItem() {
        if (this.mDeleteSQLMenuItem == null) {
            try {
                this.mDeleteSQLMenuItem = new JMenuItem();
                this.mDeleteSQLMenuItem.setName("DeleteSQLMenuItem");
                this.mDeleteSQLMenuItem.setText("Delete SQL");
                this.mDeleteSQLMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mDeleteSQLMenuItem;
    }

    private JPopupMenu getDescriptorMenu() {
        if (this.mDescriptorMenu == null) {
            try {
                this.mDescriptorMenu = new JPopupMenu();
                this.mDescriptorMenu.setName("DescriptorMenu");
                this.mDescriptorMenu.add(this.getResetDescriptorsMenuItem());
                this.mDescriptorMenu.add(this.getClearDescriptorsMenuItem());
                this.mDescriptorMenu.add(this.getFullNamesMenuItem());
                this.mDescriptorMenu.add(this.getInspectDescriptorMenuItem());
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mDescriptorMenu;
    }

    private JMenuItem getExecuteQueryMenuItem() {
        if (this.mExecuteQueryMenuItem == null) {
            try {
                this.mExecuteQueryMenuItem = new JMenuItem();
                this.mExecuteQueryMenuItem.setName("ExecuteQueryMenuItem");
                this.mExecuteQueryMenuItem.setText("Execute Query");
                this.mExecuteQueryMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mExecuteQueryMenuItem;
    }

    private ExpressionPanel getExpressionPanel() {
        if (this.mExpressionPanel == null) {
            try {
                this.mExpressionPanel = new ExpressionPanel();
                this.mExpressionPanel.setName("ExpressionPanel");
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mExpressionPanel;
    }

    private JCheckBoxMenuItem getFullNamesMenuItem() {
        if (this.mFullNamesMenuItem == null) {
            try {
                this.mFullNamesMenuItem = new JCheckBoxMenuItem();
                this.mFullNamesMenuItem.setName("FullNamesMenuItem");
                this.mFullNamesMenuItem.setText("Display Package Names");
                this.mFullNamesMenuItem.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mFullNamesMenuItem;
    }

    private JMenuItem getInsertSQLMenuItem() {
        if (this.mInsertSQLMenuItem == null) {
            try {
                this.mInsertSQLMenuItem = new JMenuItem();
                this.mInsertSQLMenuItem.setName("InsertSQLMenuItem");
                this.mInsertSQLMenuItem.setText("Insert SQL");
                this.mInsertSQLMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mInsertSQLMenuItem;
    }

    private JButton getInspectCacheButton() {
        if (this.mInspectCacheButton == null) {
            try {
                this.mInspectCacheButton = new JButton();
                this.mInspectCacheButton.setName("InspectCacheButton");
                this.mInspectCacheButton.setText("Inspect");
                this.mInspectCacheButton.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mInspectCacheButton;
    }

    private JMenuItem getInspectCacheMenuItem() {
        if (this.mInspectCacheMenuItem == null) {
            try {
                this.mInspectCacheMenuItem = new JMenuItem();
                this.mInspectCacheMenuItem.setName("InspectCacheMenuItem");
                this.mInspectCacheMenuItem.setText("Inspect Cache");
                this.mInspectCacheMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mInspectCacheMenuItem;
    }

    private JMenuItem getInspectDescriptorMenuItem() {
        if (this.mInspectDescriptorMenuItem == null) {
            try {
                this.mInspectDescriptorMenuItem = new JMenuItem();
                this.mInspectDescriptorMenuItem.setName("InspectDescriptorMenuItem");
                this.mInspectDescriptorMenuItem.setText("Inspect Descriptor");
                this.mInspectDescriptorMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mInspectDescriptorMenuItem;
    }

    private JMenuItem getInspectResultMenuItem() {
        if (this.mInspectResultMenuItem == null) {
            try {
                this.mInspectResultMenuItem = new JMenuItem();
                this.mInspectResultMenuItem.setName("InspectResultMenuItem");
                this.mInspectResultMenuItem.setText("Inspect Result");
                this.mInspectResultMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mInspectResultMenuItem;
    }

    private JMenuItem getInspectSessionMenuItem1() {
        if (this.mInspectSessionMenuItem1 == null) {
            try {
                this.mInspectSessionMenuItem1 = new JMenuItem();
                this.mInspectSessionMenuItem1.setName("InspectSessionMenuItem1");
                this.mInspectSessionMenuItem1.setText("Inspect Session");
                this.mInspectSessionMenuItem1.setBackground(SystemColor.menu);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mInspectSessionMenuItem1;
    }

    private JPopupMenu getJPopupMenu1() {
        if (this.mJPopupMenu1 == null) {
            try {
                this.mJPopupMenu1 = new JPopupMenu();
                this.mJPopupMenu1.setName("JPopupMenu1");
                this.mJPopupMenu1.add(this.getClearResultsMenuItem());
                this.mJPopupMenu1.add(this.getInspectResultMenuItem());
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mJPopupMenu1;
    }

    private JSeparator getJSeparator4() {
        if (this.mJSeparator4 == null) {
            try {
                this.mJSeparator4 = new JSeparator();
                this.mJSeparator4.setName("JSeparator4");
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mJSeparator4;
    }

    private JSeparator getJSeparator5() {
        if (this.mJSeparator5 == null) {
            try {
                this.mJSeparator5 = new JSeparator();
                this.mJSeparator5.setName("JSeparator5");
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mJSeparator5;
    }

    private JSeparator getJSeparator6() {
        if (this.mJSeparator6 == null) {
            try {
                this.mJSeparator6 = new JSeparator();
                this.mJSeparator6.setName("JSeparator6");
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mJSeparator6;
    }

    private JSeparator getJSeparator7() {
        if (this.mJSeparator7 == null) {
            try {
                this.mJSeparator7 = new JSeparator();
                this.mJSeparator7.setName("JSeparator7");
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mJSeparator7;
    }

    private JButton getLoadProjectButton() {
        if (this.mLoadProjectButton == null) {
            try {
                this.mLoadProjectButton = new JButton();
                this.mLoadProjectButton.setName("LoadProjectButton");
                this.mLoadProjectButton.setText("Load Project...");
                this.mLoadProjectButton.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mLoadProjectButton;
    }

    private JTabbedPane getLogBook() {
        if (this.mLogBook == null) {
            try {
                this.mLogBook = new JTabbedPane();
                this.mLogBook.setName("LogBook");
                this.mLogBook.insertTab("Log", null, this.getLogPage(), null, 0);
                this.mLogBook.setBackgroundAt(0, SystemColor.control);
                this.mLogBook.insertTab("ResultPage", null, this.getResultPage(), null, 1);
                this.mLogBook.setBackgroundAt(1, SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mLogBook;
    }

    private JComboBox getLogLevelChoice() {
        if (this.logLevelChoice == null) {
            try {
                this.logLevelChoice = new JComboBox();
                this.logLevelChoice.setName("LogLevelChoice");
                this.logLevelChoice.addItem("All");
                this.logLevelChoice.addItem("Finest");
                this.logLevelChoice.addItem("Finer");
                this.logLevelChoice.addItem("Fine");
                this.logLevelChoice.addItem("Config");
                this.logLevelChoice.addItem("Info");
                this.logLevelChoice.addItem("Warning");
                this.logLevelChoice.addItem("Sever");
                this.logLevelChoice.addItem("None");
                this.logLevelChoice.setSelectedItem("None");
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.logLevelChoice;
    }

    private JButton getLoginButton() {
        if (this.mLoginButton == null) {
            try {
                this.mLoginButton = new JButton();
                this.mLoginButton.setName("LoginButton");
                this.mLoginButton.setText("Login");
                this.mLoginButton.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mLoginButton;
    }

    public LoginEditorPanel getLoginEditor() {
        return this.getLoginEditorPanel();
    }

    private LoginEditorPanel getLoginEditorPanel() {
        if (this.mLoginEditorPanel == null) {
            try {
                this.mLoginEditorPanel = new LoginEditorPanel();
                this.mLoginEditorPanel.setName("LoginEditorPanel");
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mLoginEditorPanel;
    }

    private JPopupMenu getLoginMenu() {
        if (this.mLoginMenu == null) {
            try {
                this.mLoginMenu = new JPopupMenu();
                this.mLoginMenu.setName("LoginMenu");
                this.mLoginMenu.add(this.getLoginMenuItem());
                this.mLoginMenu.add(this.getLogoutMenuItem());
                this.mLoginMenu.add(this.getInspectSessionMenuItem1());
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mLoginMenu;
    }

    private JMenuItem getLoginMenuItem() {
        if (this.mLoginMenuItem == null) {
            try {
                this.mLoginMenuItem = new JMenuItem();
                this.mLoginMenuItem.setName("LoginMenuItem");
                this.mLoginMenuItem.setText("Login");
                this.mLoginMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mLoginMenuItem;
    }

    private JPanel getLoginPage() {
        if (this.mLoginPage == null) {
            try {
                this.mLoginPage = new JPanel();
                this.mLoginPage.setName("LoginPage");
                this.mLoginPage.setLayout(new GridBagLayout());
                this.mLoginPage.setBackground(SystemColor.control);
                GridBagConstraints constraintsLoginEditorPanel = new GridBagConstraints();
                constraintsLoginEditorPanel.gridx = 0;
                constraintsLoginEditorPanel.gridy = 0;
                constraintsLoginEditorPanel.gridwidth = 6;
                constraintsLoginEditorPanel.fill = 1;
                constraintsLoginEditorPanel.weightx = 1.0;
                constraintsLoginEditorPanel.weighty = 1.0;
                constraintsLoginEditorPanel.insets = new Insets(2, 2, 2, 2);
                this.getLoginPage().add((Component)this.getLoginEditorPanel(), constraintsLoginEditorPanel);
                GridBagConstraints constraintsLoginButton = new GridBagConstraints();
                constraintsLoginButton.gridx = 0;
                constraintsLoginButton.gridy = 1;
                constraintsLoginButton.insets = new Insets(2, 2, 2, 2);
                this.getLoginPage().add((Component)this.getLoginButton(), constraintsLoginButton);
                GridBagConstraints constraintsLogoutButton = new GridBagConstraints();
                constraintsLogoutButton.gridx = 1;
                constraintsLogoutButton.gridy = 1;
                constraintsLogoutButton.insets = new Insets(2, 2, 2, 2);
                this.getLoginPage().add((Component)this.getLogoutButton(), constraintsLogoutButton);
                GridBagConstraints constraintsLoadProjectButton = new GridBagConstraints();
                constraintsLoadProjectButton.gridx = 2;
                constraintsLoadProjectButton.gridy = 1;
                constraintsLoadProjectButton.insets = new Insets(2, 2, 2, 2);
                this.getLoginPage().add((Component)this.getLoadProjectButton(), constraintsLoadProjectButton);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mLoginPage;
    }

    private JPopupMenu getLogMenu() {
        if (this.mLogMenu == null) {
            try {
                this.mLogMenu = new JPopupMenu();
                this.mLogMenu.setName("LogMenu");
                this.mLogMenu.add(this.getCutMenuItem());
                this.mLogMenu.add(this.getCopyMenuItem());
                this.mLogMenu.add(this.getPasteMenuItem());
                this.mLogMenu.add(this.getJSeparator7());
                this.mLogMenu.add(this.getClearLogMenuItem());
                this.mLogMenu.add(this.getJSeparator7());
                this.mLogMenu.add(this.getLogProfileMenuItem1());
                this.mLogMenu.add(this.getLogProfileMenuItem());
                this.mLogMenu.add(this.getBrowseProfileMenuItem());
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mLogMenu;
    }

    private JButton getLogoutButton() {
        if (this.mLogoutButton == null) {
            try {
                this.mLogoutButton = new JButton();
                this.mLogoutButton.setName("LogoutButton");
                this.mLogoutButton.setText("Logout");
                this.mLogoutButton.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mLogoutButton;
    }

    private JMenuItem getLogoutMenuItem() {
        if (this.mLogoutMenuItem == null) {
            try {
                this.mLogoutMenuItem = new JMenuItem();
                this.mLogoutMenuItem.setName("LogoutMenuItem");
                this.mLogoutMenuItem.setText("Logout");
                this.mLogoutMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mLogoutMenuItem;
    }

    private JPanel getLogPage() {
        if (this.mLogPage == null) {
            try {
                this.mLogPage = new JPanel();
                this.mLogPage.setName("LogPage");
                this.mLogPage.setLayout(new GridBagLayout());
                this.mLogPage.setBackground(SystemColor.control);
                GridBagConstraints constraintsLogScrollPane = new GridBagConstraints();
                constraintsLogScrollPane.gridx = 0;
                constraintsLogScrollPane.gridy = 0;
                constraintsLogScrollPane.gridwidth = 13;
                constraintsLogScrollPane.fill = 1;
                constraintsLogScrollPane.weightx = 1.0;
                constraintsLogScrollPane.weighty = 1.0;
                constraintsLogScrollPane.insets = new Insets(2, 2, 2, 2);
                this.getLogPage().add((Component)this.getLogScrollPane(), constraintsLogScrollPane);
                GridBagConstraints constraintsClearLogButton = new GridBagConstraints();
                constraintsClearLogButton.gridx = 12;
                constraintsClearLogButton.gridy = 1;
                constraintsClearLogButton.anchor = 13;
                constraintsClearLogButton.insets = new Insets(2, 2, 2, 2);
                this.getLogPage().add((Component)this.getClearLogButton(), constraintsClearLogButton);
                GridBagConstraints constraintsLogLabel = new GridBagConstraints();
                constraintsLogLabel.gridx = 0;
                constraintsLogLabel.gridy = 1;
                constraintsLogLabel.anchor = 17;
                constraintsLogLabel.insets = new Insets(2, 2, 2, 2);
                this.getLogPage().add((Component)new JLabel("Log Level:"), constraintsLogLabel);
                GridBagConstraints constraintsLogCheckbox = new GridBagConstraints();
                constraintsLogCheckbox.gridx = 1;
                constraintsLogCheckbox.gridy = 1;
                constraintsLogCheckbox.fill = 2;
                constraintsLogCheckbox.anchor = 17;
                constraintsLogCheckbox.insets = new Insets(2, 2, 2, 2);
                this.getLogPage().add((Component)this.getLogLevelChoice(), constraintsLogCheckbox);
                GridBagConstraints constraintsProfileCheckbox = new GridBagConstraints();
                constraintsProfileCheckbox.gridx = 0;
                constraintsProfileCheckbox.gridy = 2;
                constraintsProfileCheckbox.anchor = 17;
                constraintsProfileCheckbox.insets = new Insets(2, 2, 2, 2);
                this.getLogPage().add((Component)this.getProfileCheckbox(), constraintsProfileCheckbox);
                GridBagConstraints constraintsLogProfileCheckbox = new GridBagConstraints();
                constraintsLogProfileCheckbox.gridx = 1;
                constraintsLogProfileCheckbox.gridy = 2;
                constraintsLogProfileCheckbox.anchor = 17;
                constraintsLogProfileCheckbox.insets = new Insets(2, 2, 2, 2);
                this.getLogPage().add((Component)this.getLogProfileCheckbox(), constraintsLogProfileCheckbox);
                GridBagConstraints constraintsBrowseProfileButton = new GridBagConstraints();
                constraintsBrowseProfileButton.gridx = 12;
                constraintsBrowseProfileButton.gridy = 2;
                constraintsBrowseProfileButton.anchor = 13;
                constraintsBrowseProfileButton.insets = new Insets(2, 2, 2, 2);
                this.getLogPage().add((Component)this.getBrowseProfileButton(), constraintsBrowseProfileButton);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mLogPage;
    }

    private JCheckBox getLogProfileCheckbox() {
        if (this.mLogProfileCheckbox == null) {
            try {
                this.mLogProfileCheckbox = new JCheckBox();
                this.mLogProfileCheckbox.setName("LogProfileCheckbox");
                this.mLogProfileCheckbox.setText("Log Profile");
                this.mLogProfileCheckbox.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mLogProfileCheckbox;
    }

    private JCheckBoxMenuItem getLogProfileMenuItem() {
        if (this.mLogProfileMenuItem == null) {
            try {
                this.mLogProfileMenuItem = new JCheckBoxMenuItem();
                this.mLogProfileMenuItem.setName("LogProfileMenuItem");
                this.mLogProfileMenuItem.setText("Log Profile");
                this.mLogProfileMenuItem.setBackground(SystemColor.menu);
                this.mLogProfileMenuItem.setActionCommand("LogSQLMenuItem");
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mLogProfileMenuItem;
    }

    private JCheckBoxMenuItem getLogProfileMenuItem1() {
        if (this.mLogProfileMenuItem1 == null) {
            try {
                this.mLogProfileMenuItem1 = new JCheckBoxMenuItem();
                this.mLogProfileMenuItem1.setName("LogProfileMenuItem1");
                this.mLogProfileMenuItem1.setText("Profile");
                this.mLogProfileMenuItem1.setBackground(SystemColor.menu);
                this.mLogProfileMenuItem1.setActionCommand("ProfileMenuItem");
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mLogProfileMenuItem1;
    }

    private JScrollPane getLogScrollPane() {
        if (this.mLogScrollPane == null) {
            try {
                this.mLogScrollPane = new JScrollPane();
                this.mLogScrollPane.setName("LogScrollPane");
                this.mLogScrollPane.setAutoscrolls(true);
                this.getLogScrollPane().setViewportView(this.getLogText());
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mLogScrollPane;
    }

    private JSplitPane getLogSplitter() {
        if (this.mLogSplitter == null) {
            try {
                this.mLogSplitter = new JSplitPane(0);
                this.mLogSplitter.setName("LogSplitter");
                this.mLogSplitter.setAutoscrolls(true);
                this.mLogSplitter.setDividerSize(8);
                this.mLogSplitter.setMaximumSize(new Dimension(0, 0));
                this.mLogSplitter.setDividerLocation(300);
                this.mLogSplitter.setOneTouchExpandable(true);
                this.mLogSplitter.setMinimumSize(new Dimension(0, 0));
                this.getLogSplitter().add((Component)this.getLogBook(), "bottom");
                this.getLogSplitter().add((Component)this.getTopPanel(), "top");
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mLogSplitter;
    }

    private JTextArea getLogText() {
        if (this.mLogText == null) {
            try {
                this.mLogText = new JTextArea();
                this.mLogText.setName("LogText");
                this.mLogText.setAutoscrolls(true);
                this.mLogText.setBounds(0, 0, 10, 10);
                this.mLogText.setEditable(true);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mLogText;
    }

    private JMenuItem getPasteSQLMenuItem() {
        if (this.mPasteSQLMenuItem == null) {
            try {
                this.mPasteSQLMenuItem = new JMenuItem();
                this.mPasteSQLMenuItem.setName("PasteSQLMenuItem");
                this.mPasteSQLMenuItem.setText("Paste");
                this.mPasteSQLMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mPasteSQLMenuItem;
    }

    private JCheckBox getProfileCheckbox() {
        if (this.mProfileCheckbox == null) {
            try {
                this.mProfileCheckbox = new JCheckBox();
                this.mProfileCheckbox.setName("ProfileCheckbox");
                this.mProfileCheckbox.setText("Profile");
                this.mProfileCheckbox.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mProfileCheckbox;
    }

    private JButton getQueryButton() {
        if (this.mQueryButton == null) {
            try {
                this.mQueryButton = new JButton();
                this.mQueryButton.setName("QueryButton");
                this.mQueryButton.setText("Execute Query");
                this.mQueryButton.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mQueryButton;
    }

    private JPopupMenu getQueryMenu() {
        if (this.mQueryMenu == null) {
            try {
                this.mQueryMenu = new JPopupMenu();
                this.mQueryMenu.setName("QueryMenu");
                this.mQueryMenu.add(this.getExecuteQueryMenuItem());
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mQueryMenu;
    }

    private JPanel getQueryPage() {
        if (this.mQueryPage == null) {
            try {
                this.mQueryPage = new JPanel();
                this.mQueryPage.setName("QueryPage");
                this.mQueryPage.setLayout(new GridBagLayout());
                this.mQueryPage.setBackground(SystemColor.control);
                GridBagConstraints constraintsQueryButton = new GridBagConstraints();
                constraintsQueryButton.gridx = 0;
                constraintsQueryButton.gridy = 1;
                constraintsQueryButton.anchor = 17;
                constraintsQueryButton.insets = new Insets(2, 2, 2, 2);
                this.getQueryPage().add((Component)this.getQueryButton(), constraintsQueryButton);
                GridBagConstraints constraintsExpressionPanel = new GridBagConstraints();
                constraintsExpressionPanel.gridx = 0;
                constraintsExpressionPanel.gridy = 0;
                constraintsExpressionPanel.fill = 1;
                constraintsExpressionPanel.weightx = 1.0;
                constraintsExpressionPanel.weighty = 1.0;
                this.getQueryPage().add((Component)this.getExpressionPanel(), constraintsExpressionPanel);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mQueryPage;
    }

    private JMenuItem getResetDescriptorsMenuItem() {
        if (this.mResetDescriptorsMenuItem == null) {
            try {
                this.mResetDescriptorsMenuItem = new JMenuItem();
                this.mResetDescriptorsMenuItem.setName("ResetDescriptorsMenuItem");
                this.mResetDescriptorsMenuItem.setText("Reset Descriptors");
                this.mResetDescriptorsMenuItem.setBackground(SystemColor.menu);
                this.mResetDescriptorsMenuItem.setForeground(Color.black);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mResetDescriptorsMenuItem;
    }

    private JPanel getResultPage() {
        if (this.mResultPage == null) {
            try {
                this.mResultPage = new JPanel();
                this.mResultPage.setName("Query Results");
                this.mResultPage.setLayout(new GridBagLayout());
                this.mResultPage.setBackground(SystemColor.control);
                GridBagConstraints constraintsResultsScrollPane = new GridBagConstraints();
                constraintsResultsScrollPane.gridx = 0;
                constraintsResultsScrollPane.gridy = 0;
                constraintsResultsScrollPane.fill = 1;
                constraintsResultsScrollPane.weightx = 1.0;
                constraintsResultsScrollPane.weighty = 1.0;
                constraintsResultsScrollPane.insets = new Insets(2, 2, 2, 2);
                this.getResultPage().add((Component)this.getResultsScrollPane(), constraintsResultsScrollPane);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mResultPage;
    }

    public Vector getResults() {
        return this.results;
    }

    private JScrollPane getResultsScrollPane() {
        if (this.mResultsScrollPane == null) {
            try {
                this.mResultsScrollPane = new JScrollPane();
                this.mResultsScrollPane.setName("ResultsScrollPane");
                this.mResultsScrollPane.setVerticalScrollBarPolicy(22);
                this.mResultsScrollPane.setHorizontalScrollBarPolicy(32);
                this.getResultsScrollPane().setViewportView(this.getResultsTable());
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mResultsScrollPane;
    }

    private JTable getResultsTable() {
        if (this.mResultsTable == null) {
            try {
                this.mResultsTable = new JTable();
                this.mResultsTable.setName("ResultsTable");
                this.getResultsScrollPane().setColumnHeaderView(this.mResultsTable.getTableHeader());
                this.mResultsTable.setAutoResizeMode(0);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mResultsTable;
    }

    private JButton getSelectButton() {
        if (this.mSelectButton == null) {
            try {
                this.mSelectButton = new JButton();
                this.mSelectButton.setName("SelectButton");
                this.mSelectButton.setText("Select");
                this.mSelectButton.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mSelectButton;
    }

    private JMenuItem getSelectSQLMenuItem() {
        if (this.mSelectSQLMenuItem == null) {
            try {
                this.mSelectSQLMenuItem = new JMenuItem();
                this.mSelectSQLMenuItem.setName("SelectSQLMenuItem");
                this.mSelectSQLMenuItem.setText("Select SQL");
                this.mSelectSQLMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mSelectSQLMenuItem;
    }

    public Session getSession() {
        return this.fieldSession;
    }

    private JButton getSQLExecuteButton() {
        if (this.mSQLExecuteButton == null) {
            try {
                this.mSQLExecuteButton = new JButton();
                this.mSQLExecuteButton.setName("SQLExecuteButton");
                this.mSQLExecuteButton.setText("Update");
                this.mSQLExecuteButton.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mSQLExecuteButton;
    }

    private JButton getJPQLExecuteButton() {
        if (this.jpqlExecuteButton == null) {
            try {
                this.jpqlExecuteButton = new JButton();
                this.jpqlExecuteButton.setName("JPQLExecuteButton");
                this.jpqlExecuteButton.setText("Execute");
                this.jpqlExecuteButton.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.jpqlExecuteButton;
    }

    private JButton getJavaExecuteButton() {
        if (this.javaExecuteButton == null) {
            try {
                this.javaExecuteButton = new JButton();
                this.javaExecuteButton.setName("JavaExecuteButton");
                this.javaExecuteButton.setText("Execute");
                this.javaExecuteButton.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.javaExecuteButton;
    }

    private JPopupMenu getSQLMenu() {
        if (this.mSQLMenu == null) {
            try {
                this.mSQLMenu = new JPopupMenu();
                this.mSQLMenu.setName("SQLMenu");
                this.mSQLMenu.add(this.getSQLUpdateMenuItem());
                this.mSQLMenu.add(this.getSQLSelectMenuItem());
                this.mSQLMenu.add(this.getJSeparator4());
                this.mSQLMenu.add(this.getClearSQLMenuItem());
                this.mSQLMenu.add(this.getJSeparator6());
                this.mSQLMenu.add(this.getCutSQLMenuItem());
                this.mSQLMenu.add(this.getCopySQLMenuItem());
                this.mSQLMenu.add(this.getPasteSQLMenuItem());
                this.mSQLMenu.add(this.getJSeparator5());
                this.mSQLMenu.add(this.getSQLTemplateMenu());
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mSQLMenu;
    }

    private JScrollPane getSQLScrollPane() {
        if (this.mSQLScrollPane == null) {
            try {
                this.mSQLScrollPane = new JScrollPane();
                this.mSQLScrollPane.setName("SQLScrollPane");
                this.getSQLScrollPane().setViewportView(this.getSQLText());
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mSQLScrollPane;
    }

    private JScrollPane getJPQLScrollPane() {
        JScrollPane pane = new JScrollPane();
        pane.setName("JPQLScrollPane");
        pane.setViewportView(this.getJPQLText());
        return pane;
    }

    private JScrollPane getJavaScrollPane() {
        if (this.javaScrollPane == null) {
            try {
                this.javaScrollPane = new JScrollPane();
                this.javaScrollPane.setName("JavaScrollPane");
                this.getJavaScrollPane().setViewportView(this.getJavaText());
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.javaScrollPane;
    }

    private JMenuItem getSQLSelectMenuItem() {
        if (this.mSQLSelectMenuItem == null) {
            try {
                this.mSQLSelectMenuItem = new JMenuItem();
                this.mSQLSelectMenuItem.setName("SQLSelectMenuItem");
                this.mSQLSelectMenuItem.setText("Execute SQL Select");
                this.mSQLSelectMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mSQLSelectMenuItem;
    }

    private JMenu getSQLTemplateMenu() {
        if (this.mSQLTemplateMenu == null) {
            try {
                this.mSQLTemplateMenu = new JMenu();
                this.mSQLTemplateMenu.setName("SQLTemplateMenu");
                this.mSQLTemplateMenu.setText("SQL");
                this.mSQLTemplateMenu.setBackground(SystemColor.menu);
                this.mSQLTemplateMenu.add(this.getInsertSQLMenuItem());
                this.mSQLTemplateMenu.add(this.getUpdateSQLMenuItem());
                this.mSQLTemplateMenu.add(this.getDeleteSQLMenuItem());
                this.mSQLTemplateMenu.add(this.getSelectSQLMenuItem());
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mSQLTemplateMenu;
    }

    private JTextPane getSQLText() {
        if (this.mSQLText == null) {
            try {
                this.mSQLText = new JTextPane();
                this.mSQLText.setName("SQLText");
                this.mSQLText.setBorder(new BasicBorders.MarginBorder());
                this.mSQLText.setBounds(0, 0, 467, 156);
                this.mSQLText.setMaximumSize(new Dimension(0, 0));
                this.mSQLText.setMinimumSize(new Dimension(1, 1));
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mSQLText;
    }

    private JTextPane getJPQLText() {
        if (this.jpqlText == null) {
            this.jpqlText = new JTextPane();
            this.jpqlText.setName("JPQLText");
            this.jpqlText.setBorder(new BasicBorders.MarginBorder());
            this.jpqlText.setBounds(0, 0, 467, 156);
            this.jpqlText.setMaximumSize(new Dimension(0, 0));
            this.jpqlText.setMinimumSize(new Dimension(1, 1));
        }
        return this.jpqlText;
    }

    private JTextPane getJavaText() {
        if (this.javaText == null) {
            try {
                this.javaText = new JTextPane();
                this.javaText.setName("JavaText");
                this.javaText.setBorder(new BasicBorders.MarginBorder());
                this.javaText.setBounds(0, 0, 467, 156);
                this.javaText.setMaximumSize(new Dimension(0, 0));
                this.javaText.setMinimumSize(new Dimension(1, 1));
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.javaText;
    }

    private JMenuItem getSQLUpdateMenuItem() {
        if (this.mSQLUpdateMenuItem == null) {
            try {
                this.mSQLUpdateMenuItem = new JMenuItem();
                this.mSQLUpdateMenuItem.setName("SQLUpdateMenuItem");
                this.mSQLUpdateMenuItem.setText("Execute SQL Update");
                this.mSQLUpdateMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mSQLUpdateMenuItem;
    }

    private JPanel getTopPanel() {
        if (this.mTopPanel == null) {
            try {
                this.mTopPanel = new JPanel();
                this.mTopPanel.setName("TopPanel");
                this.mTopPanel.setLayout(new GridBagLayout());
                this.mTopPanel.setBackground(SystemColor.control);
                GridBagConstraints constraintsTopSplitPane = new GridBagConstraints();
                constraintsTopSplitPane.gridx = 0;
                constraintsTopSplitPane.gridy = 0;
                constraintsTopSplitPane.fill = 1;
                constraintsTopSplitPane.weightx = 1.0;
                constraintsTopSplitPane.weighty = 1.0;
                constraintsTopSplitPane.ipady = 300;
                this.getTopPanel().add((Component)this.getTopSplitPane(), constraintsTopSplitPane);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mTopPanel;
    }

    private JSplitPane getTopSplitPane() {
        if (this.mTopSplitPane == null) {
            try {
                this.mTopSplitPane = new JSplitPane(1);
                this.mTopSplitPane.setName("TopSplitPane");
                this.mTopSplitPane.setDividerSize(8);
                this.mTopSplitPane.setOneTouchExpandable(true);
                this.mTopSplitPane.setDividerLocation(150);
                this.getTopSplitPane().add((Component)this.getClassScrollPane(), "left");
                this.getTopSplitPane().add((Component)this.getWorkspaceBook(), "right");
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mTopSplitPane;
    }

    private JMenuItem getUpdateSQLMenuItem() {
        if (this.mUpdateSQLMenuItem == null) {
            try {
                this.mUpdateSQLMenuItem = new JMenuItem();
                this.mUpdateSQLMenuItem.setName("UpdateSQLMenuItem");
                this.mUpdateSQLMenuItem.setText("Update SQL");
                this.mUpdateSQLMenuItem.setBackground(SystemColor.menu);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mUpdateSQLMenuItem;
    }

    public JTabbedPane getWorkspaceBook() {
        if (this.mWorkspaceBook == null) {
            try {
                this.mWorkspaceBook = new JTabbedPane();
                this.mWorkspaceBook.setName("WorkspaceBook");
                this.mWorkspaceBook.setAutoscrolls(false);
                this.mWorkspaceBook.setBackground(SystemColor.control);
                this.mWorkspaceBook.setMaximumSize(new Dimension(0, 0));
                this.mWorkspaceBook.setMinimumSize(new Dimension(1, 1));
                this.mWorkspaceBook.insertTab("Login", null, this.getLoginPage(), null, 0);
                this.mWorkspaceBook.insertTab("Cache", null, this.getCachePage(), null, 1);
                this.mWorkspaceBook.insertTab("Query", null, this.getQueryPage(), null, 2);
                this.mWorkspaceBook.insertTab("JPQL", null, this.getJPQLPage(), null, 3);
                this.mWorkspaceBook.insertTab("SQL", null, this.getSQLPage(), null, 4);
                this.mWorkspaceBook.insertTab("Java", null, this.getJavaPage(), null, 5);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.mWorkspaceBook;
    }

    private void handleException(Throwable exception) {
        System.out.println("--------- UNCAUGHT EXCEPTION ---------");
        exception.printStackTrace(System.out);
        MessageDialog.displayException(exception, this);
    }

    private void initConnections() throws Exception {
        this.getClassList().addListSelectionListener(this);
        this.getLoginButton().addActionListener(this);
        this.getLogoutButton().addActionListener(this);
        this.getLoadProjectButton().addActionListener(this);
        this.getClearLogButton().addActionListener(this);
        this.getBrowseProfileButton().addActionListener(this);
        this.getLogProfileCheckbox().addItemListener(this);
        this.getProfileCheckbox().addItemListener(this);
        this.getLogLevelChoice().addItemListener(this);
        this.getSelectButton().addActionListener(this);
        this.getSQLExecuteButton().addActionListener(this);
        this.getJPQLExecuteButton().addActionListener(this);
        this.getJavaExecuteButton().addActionListener(this);
        this.getClearButton().addActionListener(this);
        this.getJavaClearButton().addActionListener(this);
        this.getClearCacheButton().addActionListener(this);
        this.getInspectCacheButton().addActionListener(this);
        this.getQueryButton().addActionListener(this);
        this.getClearCacheMenuItem().addActionListener(this);
        this.getInspectCacheMenuItem().addActionListener(this);
        this.getSQLText().addMouseListener(this);
        this.getCacheTable().addMouseListener(this);
        this.getClassList().addMouseListener(this);
        this.getResultsTable().addMouseListener(this);
        this.getClearResultsMenuItem().addActionListener(this);
        this.getInspectResultMenuItem().addActionListener(this);
        this.getInspectDescriptorMenuItem().addActionListener(this);
        this.getClearDescriptorsMenuItem().addActionListener(this);
        this.getResetDescriptorsMenuItem().addActionListener(this);
        this.getInsertSQLMenuItem().addActionListener(this);
        this.getUpdateSQLMenuItem().addActionListener(this);
        this.getDeleteSQLMenuItem().addActionListener(this);
        this.getSelectSQLMenuItem().addActionListener(this);
        this.getSQLUpdateMenuItem().addActionListener(this);
        this.getSQLSelectMenuItem().addActionListener(this);
        this.getClearSQLMenuItem().addActionListener(this);
        this.getCutSQLMenuItem().addActionListener(this);
        this.getCopySQLMenuItem().addActionListener(this);
        this.getPasteSQLMenuItem().addActionListener(this);
        this.getLoginMenuItem().addActionListener(this);
        this.getLogoutMenuItem().addActionListener(this);
        this.getInspectSessionMenuItem1().addActionListener(this);
        this.getQueryPage().addMouseListener(this);
        this.getLogText().addMouseListener(this);
        this.getLoginPage().addMouseListener(this);
        this.getExecuteQueryMenuItem().addActionListener(this);
        this.getClearLogMenuItem().addActionListener(this);
        this.getBrowseProfileMenuItem().addActionListener(this);
        this.getBrowseProfileMenuItem().addPropertyChangeListener(this);
        this.getFullNamesMenuItem().addActionListener(this);
        this.connPtoP1SetTarget();
        this.connPtoP2SetTarget();
        this.connPtoP3SetTarget();
        this.connPtoP4SetTarget();
    }

    private void initialize() {
        try {
            this.setSession((Session)new Project(new DatabaseLogin()).createDatabaseSession());
            this.setName("SessionInspectorPanel");
            this.setLayout(new GridBagLayout());
            this.setBackground(SystemColor.control);
            this.setSize(849, 588);
            GridBagConstraints constraintsLogSplitter = new GridBagConstraints();
            constraintsLogSplitter.gridx = 0;
            constraintsLogSplitter.gridy = 0;
            constraintsLogSplitter.fill = 1;
            constraintsLogSplitter.weightx = 1.0;
            constraintsLogSplitter.weighty = 1.0;
            this.add((Component)this.getLogSplitter(), constraintsLogSplitter);
            this.initConnections();
        }
        catch (Throwable exception) {
            this.handleException(exception);
        }
        this.setup();
    }

    public void inspect(Object object) {
        this.getLogText().append(String.valueOf(object));
        this.getLogText().append(Helper.cr());
        this.getLogBook().setSelectedComponent(this.getLogPage());
    }

    public void inspectDescriptor() {
        ClassInfo classInfo = (ClassInfo)this.getClassList().getSelectedValue();
        if (classInfo == null) {
            return;
        }
        this.inspect(classInfo.descriptor);
    }

    public void inspectFromCache() {
        int index = this.getCacheTable().getSelectedRow();
        if (index < 0) {
            return;
        }
        Object result = this.getCacheResults().elementAt(index);
        if (result == null) {
            return;
        }
        this.inspect(result);
    }

    public void inspectResult() {
        int index = this.getResultsTable().getSelectedRow();
        if (index < 0) {
            return;
        }
        Object result = this.getResults().elementAt(index);
        if (result == null) {
            return;
        }
        this.inspect(result);
    }

    public void inspectSession() {
        this.inspect(this.getSession());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.getLogProfileCheckbox()) {
            this.connEtoC14(e);
        }
        if (e.getSource() == this.getProfileCheckbox()) {
            this.connEtoC15(e);
        }
        if (e.getSource() == this.getLogLevelChoice()) {
            this.connEtoC16(e);
        }
    }

    public void loadLoginFromFile() {
        DatabaseLogin login = null;
        try {
            FileInputStream file = new FileInputStream("console.login");
            ObjectInputStream stream = new ObjectInputStream(file);
            DatabaseLogin fileLogin = (DatabaseLogin)stream.readObject();
            login = new DatabaseLogin();
            login.setDriverURLHeader(fileLogin.getDriverURLHeader());
            login.setDatabaseURL(fileLogin.getDatabaseURL());
            login.setDriverClassName(fileLogin.getDriverClassName());
            login.setPlatformClassName(fileLogin.getPlatformClassName());
            login.setUserName(fileLogin.getUserName());
            login.setEncryptedPassword(fileLogin.getPassword());
            stream.close();
            file.close();
        }
        catch (Throwable file) {
            // empty catch block
        }
        if (login == null) {
            return;
        }
        try {
            this.getLoginEditorPanel().setLogin(login);
        }
        catch (Exception exception) {
            this.getLoginEditorPanel().setLogin(new DatabaseLogin());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProject() {
        JFileChooser dialog = new JFileChooser();
        dialog.setDialogTitle("Select Mapping Workbench project deployment XML file");
        FileFilter filer = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().indexOf(".xml") != -1 || file.isDirectory();
            }

            @Override
            public String getDescription() {
                return "XML Files (*.xml)";
            }
        };
        dialog.setFileFilter(filer);
        dialog.setCurrentDirectory(new File("."));
        int status = dialog.showOpenDialog(this);
        if (status == 1) {
            return;
        }
        if (dialog.getSelectedFile() == null) {
            MessageDialog.displayMessage("Invalid project file selected.", this);
            return;
        }
        this.showBusyCursor();
        try {
            String path = dialog.getSelectedFile().getPath();
            Project project = XMLProjectReader.read((String)path);
            if (this.getSession().isConnected()) {
                ((DatabaseSession)this.getSession()).addDescriptors(project);
            } else {
                ((AbstractSession)this.getSession()).setProject(project);
                this.getLoginEditorPanel().setLogin((DatabaseLogin)project.getDatasourceLogin());
            }
            this.resetDescriptors();
        }
        finally {
            this.showNormalCursor();
        }
    }

    public void loadSQLFromFile() {
        String sql = "";
        try {
            FileInputStream file = new FileInputStream("console.sql");
            byte[] data = new byte[file.available()];
            file.read(data);
            sql = new String(data);
            file.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getSQLText().setText(sql);
    }

    public void loggingChanged() {
        int logLevel = this.getLogLevelChoice().getSelectedIndex();
        if (logLevel != this.getSession().getLogLevel()) {
            this.getSession().setLogLevel(logLevel);
            this.getSession().getSessionLog().setShouldDisplayData(Boolean.valueOf(true));
            if (logLevel > 1) {
                this.getSession().getSessionLog().setShouldPrintConnection(false);
                this.getSession().getSessionLog().setShouldPrintDate(false);
                this.getSession().getSessionLog().setShouldPrintSession(false);
                this.getSession().getSessionLog().setShouldPrintThread(false);
            } else {
                this.getSession().getSessionLog().setShouldPrintConnection(true);
                this.getSession().getSessionLog().setShouldPrintDate(true);
                this.getSession().getSessionLog().setShouldPrintSession(true);
                this.getSession().getSessionLog().setShouldPrintThread(true);
            }
            Iterator iterator = SessionManager.getManager().getSessions().values().iterator();
            while (iterator.hasNext()) {
                ((Session)iterator.next()).setSessionLog(this.getSession().getSessionLog());
            }
        }
    }

    public void login() {
        this.showBusyCursor();
        try {
            this.storeLoginToFile();
            this.updateLogin();
            ((DatabaseSession)this.getSession()).setLogin((Login)this.getLoginEditorPanel().getLogin());
            ((DatabaseSession)this.getSession()).login();
            this.resetButtons();
        }
        finally {
            this.showNormalCursor();
        }
    }

    public void logout() {
        this.showBusyCursor();
        try {
            ((DatabaseSession)this.getSession()).logout();
            this.resetButtons();
            this.storeSQLToFile();
        }
        finally {
            this.showNormalCursor();
        }
    }

    public void logProfileChanged() {
        if (this.getSession().isInProfile()) {
            ((PerformanceProfiler)this.getSession().getProfiler()).setShouldLogProfile(this.getLogProfileCheckbox().isSelected());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getSource() == this.getSQLText()) {
            this.connEtoC18(e);
        }
        if (e.getSource() == this.getCacheTable()) {
            this.connEtoC19(e);
        }
        if (e.getSource() == this.getClassList()) {
            this.connEtoC21(e);
        }
        if (e.getSource() == this.getResultsTable()) {
            this.connEtoC20(e);
        }
        if (e.getSource() == this.getQueryPage()) {
            this.connEtoC40(e);
        }
        if (e.getSource() == this.getLogText()) {
            this.connEtoC41(e);
        }
        if (e.getSource() == this.getLoginPage()) {
            this.connEtoC42(e);
        }
    }

    public void pasteSQL() {
        this.getSQLText().paste();
    }

    public void profileChanged() {
        if (this.getSession().isInProfile()) {
            this.getSession().clearProfile();
        }
        if (this.getProfileCheckbox().isSelected()) {
            this.getSession().setProfiler((SessionProfiler)new PerformanceProfiler(this.getLogProfileCheckbox().isSelected()));
            this.getBrowseProfileButton().setEnabled(true);
            this.getLogProfileCheckbox().setEnabled(true);
        } else {
            this.getBrowseProfileButton().setEnabled(false);
            this.getLogProfileCheckbox().setEnabled(false);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.getBrowseProfileMenuItem() && evt.getPropertyName().equals("enabled")) {
            this.connPtoP1SetTarget();
        }
    }

    public void resetButtons() {
        boolean isConnected = this.getSession() == null || this.getSession().isConnected();
        this.getLoginButton().setEnabled(!isConnected);
        this.getLogoutButton().setEnabled(isConnected);
        this.getQueryButton().setEnabled(isConnected);
        this.getSQLExecuteButton().setEnabled(isConnected);
        this.getSelectButton().setEnabled(isConnected);
    }

    public void resetCache() {
        Vector<CacheKey> cacheResults = new Vector<CacheKey>();
        this.setCacheResults(cacheResults);
        ClassInfo info = (ClassInfo)this.getClassList().getSelectedValue();
        DefaultTableModel model = new DefaultTableModel();
        if (info == null) {
            this.getCacheTable().setModel(model);
            this.getCacheTable().repaint();
            return;
        }
        IdentityMap map = ((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().getIdentityMap(info.descriptor.getJavaClass());
        Enumeration cacheEnum = map.keys();
        while (cacheEnum.hasMoreElements()) {
            CacheKey key = (CacheKey)cacheEnum.nextElement();
            if (!info.descriptor.getJavaClass().isInstance(key.getObject())) continue;
            cacheResults.addElement(key);
        }
        Object[] columns = new String[]{"Key", "Hash", "Version", "Object"};
        model.setColumnIdentifiers(columns);
        Enumeration cacheEnumeration = cacheResults.elements();
        while (cacheEnumeration.hasMoreElements()) {
            CacheKey key = (CacheKey)cacheEnumeration.nextElement();
            Object[] values = new String[]{key.getKey().toString(), new Integer(key.getObject().hashCode()).toString(), String.valueOf(key.getWriteLockValue()), key.getObject().toString()};
            model.addRow(values);
        }
        this.getCacheTable().setModel(model);
        this.getCacheTable().repaint();
    }

    public void resetDescriptors() {
        if (this.getSession() == null) {
            return;
        }
        boolean useFullNames = this.getFullNamesMenuItem().isSelected();
        ClassInfo[] classes = new ClassInfo[this.getSession().getDescriptors().size()];
        int index = 0;
        Iterator iterator = this.getSession().getDescriptors().values().iterator();
        while (iterator.hasNext()) {
            classes[index] = new ClassInfo((ClassDescriptor)iterator.next(), useFullNames);
            ++index;
        }
        Arrays.sort(classes, new ClassInfoCompare());
        DefaultListModel<ClassInfo> list = new DefaultListModel<ClassInfo>();
        for (index = 0; index < classes.length; ++index) {
            list.addElement(classes[index]);
        }
        this.getClassList().setModel(list);
        this.getClassList().repaint();
        this.resetCache();
    }

    public void selectSQL() {
        this.showBusyCursor();
        try {
            String sql = this.getSQLText().getSelectedText();
            if (sql == null || sql.length() == 0) {
                return;
            }
            Vector rows = this.getSession().executeSelectingCall((Call)new SQLCall(sql));
            this.setResultRows(rows);
            this.getLogBook().setSelectedComponent(this.getResultPage());
        }
        finally {
            this.showNormalCursor();
        }
    }

    public void setCacheResults(Vector cacheResults) {
        this.cacheResults = cacheResults;
    }

    public void setLog() {
        boolean autoscroll = false;
        if (this.getParent() instanceof JSplitPane) {
            autoscroll = true;
        }
        OutputStreamWriter log = new OutputStreamWriter(new TextAreaOutputStream(this.getLogText(), autoscroll));
        if (this.getSession() == null) {
            return;
        }
        this.getSession().setLog((Writer)log);
    }

    public void setResultObjects(Vector resultObjects, ClassDescriptor descriptor) {
        this.setResults(resultObjects);
        DefaultTableModel model = new DefaultTableModel();
        if (resultObjects.isEmpty()) {
            this.getResultsTable().setModel(model);
            this.getResultsTable().repaint();
            return;
        }
        Object[] columns = new String[descriptor.getMappings().size()];
        for (int index = 0; index < descriptor.getMappings().size(); ++index) {
            columns[index] = ((DatabaseMapping)descriptor.getMappings().elementAt(index)).getAttributeName();
        }
        model.setColumnIdentifiers(columns);
        Enumeration objectsEnumeration = resultObjects.elements();
        while (objectsEnumeration.hasMoreElements()) {
            Object object = objectsEnumeration.nextElement();
            Object[] values = new String[descriptor.getMappings().size()];
            for (int index = 0; index < descriptor.getMappings().size(); ++index) {
                DatabaseMapping mapping = (DatabaseMapping)descriptor.getMappings().elementAt(index);
                values[index] = String.valueOf(mapping.getAttributeValueFromObject(object));
            }
            model.addRow(values);
        }
        this.getResultsTable().setModel(model);
        this.getResultsTable().repaint();
    }

    public void setResultRows(Vector resultRows) {
        this.setResults(resultRows);
        DefaultTableModel model = new DefaultTableModel();
        if (resultRows.isEmpty()) {
            this.getResultsTable().setModel(model);
            this.getResultsTable().repaint();
            return;
        }
        DatabaseRecord firstRow = (DatabaseRecord)resultRows.firstElement();
        Object[] columns = new String[firstRow.getFields().size()];
        for (int index = 0; index < firstRow.getFields().size(); ++index) {
            columns[index] = ((DatabaseField)firstRow.getFields().elementAt(index)).getName();
        }
        model.setColumnIdentifiers(columns);
        Enumeration rowsEnumeration = resultRows.elements();
        while (rowsEnumeration.hasMoreElements()) {
            DatabaseRecord row = (DatabaseRecord)rowsEnumeration.nextElement();
            Object[] values = new String[row.getValues().size()];
            for (int index = 0; index < row.getValues().size(); ++index) {
                values[index] = String.valueOf(row.getValues().elementAt(index));
            }
            model.addRow(values);
        }
        this.getResultsTable().setModel(model);
        this.getResultsTable().repaint();
    }

    public void setResultReports(Vector results) {
        this.setResults(results);
        DefaultTableModel model = new DefaultTableModel();
        if (results.isEmpty()) {
            this.getResultsTable().setModel(model);
            this.getResultsTable().repaint();
            return;
        }
        Object first = results.get(0);
        if (first instanceof ReportQueryResult) {
            ReportQueryResult result2 = (ReportQueryResult)results.get(0);
            Object[] columns = new String[result2.getNames().size()];
            for (int index = 0; index < result2.getNames().size(); ++index) {
                columns[index] = (String)result2.getNames().get(index);
            }
            model.setColumnIdentifiers(columns);
            for (ReportQueryResult result2 : results) {
                Object[] values = new String[result2.getResults().size()];
                for (int index = 0; index < result2.getResults().size(); ++index) {
                    values[index] = String.valueOf(result2.getByIndex(index));
                }
                model.addRow(values);
            }
        } else if (first instanceof Object[]) {
            Object[] result3 = (Object[])results.get(0);
            Object[] columns = new String[result3.length];
            for (int index = 0; index < result3.length; ++index) {
                columns[index] = String.valueOf(index);
            }
            model.setColumnIdentifiers(columns);
            for (Object[] result3 : results) {
                Object[] values = new String[result3.length];
                for (int index = 0; index < result3.length; ++index) {
                    values[index] = String.valueOf(result3[index]);
                }
                model.addRow(values);
            }
        } else {
            Object[] columns = new String[]{"value"};
            model.setColumnIdentifiers(columns);
            for (Object result : results) {
                Object[] values = new String[]{String.valueOf(result)};
                model.addRow(values);
            }
        }
        this.getResultsTable().setModel(model);
        this.getResultsTable().repaint();
    }

    public void setResults(Vector results) {
        this.results = results;
    }

    public void setSession(Session session) {
        Session oldValue = this.fieldSession;
        this.fieldSession = session;
        this.firePropertyChange("session", oldValue, session);
        this.getSession().setLogLevel(this.getLogLevelChoice().getSelectedIndex());
        if (this.getSession().getDatasourceLogin() instanceof DatabaseLogin) {
            this.getLoginEditorPanel().setLogin((DatabaseLogin)this.getSession().getDatasourceLogin());
        }
        this.resetDescriptors();
        this.resetButtons();
        this.setLog();
    }

    public void setup() {
        this.resetButtons();
        this.logProfileChanged();
        this.profileChanged();
        this.getExpressionPanel().reset();
        this.getLoginEditorPanel().reset();
        this.loadLoginFromFile();
        this.loadSQLFromFile();
    }

    public void showBusyCursor() {
        for (Container parent = this; parent != null; parent = parent.getParent()) {
            parent.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public void showNormalCursor() {
        for (Container parent = this; parent != null; parent = parent.getParent()) {
            parent.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void storeLoginToFile() {
        DatabaseLogin login = this.getLoginEditorPanel().getLogin();
        try {
            FileOutputStream file = new FileOutputStream("console.login");
            ObjectOutputStream stream = new ObjectOutputStream(file);
            stream.writeObject(login);
            stream.flush();
            file.flush();
            stream.close();
            file.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void storeSQLToFile() {
        String sql = this.getSQLText().getText();
        try {
            FileOutputStream file = new FileOutputStream("console.sql");
            file.write(sql.getBytes());
            file.flush();
            file.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void templateSQLDelete() {
        this.getSQLText().setText(this.getSQLText().getText() + "\n\nDelete from <table> where <exp>");
    }

    public void templateSQLInsert() {
        this.getSQLText().setText(this.getSQLText().getText() + "\n\nInsert into <table> (<fields>) values (<values>)");
    }

    public void templateSQLSelect() {
        this.getSQLText().setText(this.getSQLText().getText() + "\n\nSelect <fields> from <tables> where <exp> order by <exp> group by <exp>");
    }

    public void templateSQLUpdate() {
        this.getSQLText().setText(this.getSQLText().getText() + "\n\nUpdate <table> set <<field> = <value>> where <exp>");
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.getClassList()) {
            this.connEtoC3(e);
        }
    }

    private void updateLogin() {
        if (this.shouldUseJndiConnector && this.getLoginEditorPanel().getLogin().getPlatform().isOracle()) {
            try {
                Class<?> connectionPoolHelperClass = Class.forName("org.eclipse.persistence.tools.sessionconsole.OracleConnectionPoolHelper");
                Class[] params = new Class[]{String.class};
                Method method = connectionPoolHelperClass.getDeclaredMethod("getOracleDataSource", params);
                Object[] args = new Object[]{this.getLoginEditorPanel().getLogin().getConnectionString()};
                DataSource datasource = (DataSource)method.invoke(null, args);
                if (datasource == null) {
                    return;
                }
                JNDIConnector jndiConnector = new JNDIConnector();
                jndiConnector.setDataSource(datasource);
                this.getLoginEditorPanel().getLogin().setConnector((Connector)jndiConnector);
                this.getLoginEditorPanel().getLogin().setUsesExternalConnectionPooling(true);
            }
            catch (Exception e) {
                System.out.println("Got exception while updating Session console login.  This usually results from running on a system not compiled with  Oracle dependencies.  If you are not running on Oracle, this is not a problem.");
                this.handleException(e);
            }
        }
    }
}

