/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.weaving.jpa;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.eclipse.persistence.exceptions.StaticWeaveException;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.tools.weaving.jpa.StaticWeaveProcessor;

public class StaticWeaveAntTask
extends Task {
    private String source;
    private String persistenceinfo;
    private String persistencexml;
    private String target;
    private Vector classPaths = new Vector();
    private int logLevel = 8;
    private Writer logWriter;

    public void setSource(String source) {
        this.source = source;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setLog(String logFile) throws IOException {
        try {
            this.logWriter = new FileWriter(logFile);
        }
        catch (Exception e) {
            throw StaticWeaveException.openLoggingFileException((String)logFile, (Exception)e);
        }
    }

    public void setLogLevel(String logLevel) {
        if (!(logLevel.equalsIgnoreCase("OFF") || logLevel.equalsIgnoreCase("SEVERE") || logLevel.equalsIgnoreCase("WARNING") || logLevel.equalsIgnoreCase("INFO") || logLevel.equalsIgnoreCase("CONFIG") || logLevel.equalsIgnoreCase("FINE") || logLevel.equalsIgnoreCase("FINER") || logLevel.equalsIgnoreCase("FINEST") || logLevel.equalsIgnoreCase("ALL"))) {
            throw StaticWeaveException.illegalLoggingLevel((String)logLevel);
        }
        this.logLevel = AbstractSessionLog.translateStringToLoggingLevel((String)logLevel.toUpperCase());
    }

    public void setPersistenceinfo(String persistenceinfo) {
        this.persistenceinfo = persistenceinfo;
    }

    public void setpersistencexml(String persistenceXMLLocation) {
        this.persistencexml = persistenceXMLLocation;
    }

    public void addClasspath(Path path) {
        this.classPaths.add(path);
    }

    private Vector getPathElement() {
        Vector<String> pathElements = new Vector<String>();
        for (int i = 0; i < this.classPaths.size(); ++i) {
            String[] thisSplitedPath;
            String thisPath = ((Path)this.classPaths.get(i)).toString();
            if (thisPath == null || (thisSplitedPath = thisPath.split(File.pathSeparator)) == null) continue;
            for (int j = 0; j < thisSplitedPath.length; ++j) {
                pathElements.add(thisSplitedPath[j]);
            }
        }
        return pathElements;
    }

    private URL[] getURLs() {
        Vector pathElements = this.getPathElement();
        URL[] urls = new URL[pathElements.size()];
        for (int i = 0; i < pathElements.size(); ++i) {
            try {
                urls[i] = new File((String)pathElements.get(i)).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw StaticWeaveException.exceptionPerformWeaving((Exception)e, pathElements.get(i));
            }
        }
        return urls;
    }

    public void execute() {
        this.verifyOptions();
        this.start();
    }

    private void verifyOptions() throws BuildException {
        if (this.source == null) {
            throw StaticWeaveException.missingSource();
        }
        if (this.target == null) {
            throw StaticWeaveException.missingTarget();
        }
    }

    private void start() {
        try {
            StaticWeaveProcessor weave = new StaticWeaveProcessor(this.source, this.target);
            URL[] urls = this.getURLs();
            if (urls != null) {
                URLClassLoader classLoader = new URLClassLoader(this.getURLs(), Thread.currentThread().getContextClassLoader());
                weave.setClassLoader(classLoader);
            }
            if (this.persistenceinfo != null) {
                weave.setPersistenceInfo(this.persistenceinfo);
            }
            if (this.persistencexml != null) {
                weave.setPersistenceXMLLocation(this.persistencexml);
            }
            if (this.logWriter != null) {
                weave.setLog(this.logWriter);
            }
            weave.setLogLevel(this.logLevel);
            weave.performWeaving();
        }
        catch (Exception e) {
            AbstractSessionLog.getLog().logThrowable(7, "weaver", (Throwable)e);
            throw StaticWeaveException.exceptionPerformWeaving((Exception)e, (Object)this.source);
        }
    }
}

