/* Generated By:JJTree&JavaCC: Do not edit this line. DDLParser.java */
/*
 * Copyright (c) 2011, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
//     Mike Norman - June 10 2011, created DDL parser package
package org.eclipse.persistence.tools.oracleddl.parser;

//javase imports
import java.io.InputStream;
import java.util.List;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

//metadata imports
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentType;
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentTypeDirection;
import org.eclipse.persistence.tools.oracleddl.metadata.BlobType;
import org.eclipse.persistence.tools.oracleddl.metadata.CharType;
import org.eclipse.persistence.tools.oracleddl.metadata.ClobType;
import org.eclipse.persistence.tools.oracleddl.metadata.CompositeDatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.DecimalType;
import org.eclipse.persistence.tools.oracleddl.metadata.DoubleType;
import org.eclipse.persistence.tools.oracleddl.metadata.FieldType;
import org.eclipse.persistence.tools.oracleddl.metadata.FloatType;
import org.eclipse.persistence.tools.oracleddl.metadata.FunctionType;
import org.eclipse.persistence.tools.oracleddl.metadata.IntervalDayToSecond;
import org.eclipse.persistence.tools.oracleddl.metadata.IntervalYearToMonth;
import org.eclipse.persistence.tools.oracleddl.metadata.LongType;
import org.eclipse.persistence.tools.oracleddl.metadata.LongRawType;
import org.eclipse.persistence.tools.oracleddl.metadata.NCharType;
import org.eclipse.persistence.tools.oracleddl.metadata.NClobType;
import org.eclipse.persistence.tools.oracleddl.metadata.NumericType;
import org.eclipse.persistence.tools.oracleddl.metadata.NVarChar2Type;
import org.eclipse.persistence.tools.oracleddl.metadata.ObjectType;
import org.eclipse.persistence.tools.oracleddl.metadata.ObjectTableType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLCollectionType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLCursorType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLPackageType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLRecordType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLSubType;
import org.eclipse.persistence.tools.oracleddl.metadata.ProcedureType;
import org.eclipse.persistence.tools.oracleddl.metadata.RawType;
import org.eclipse.persistence.tools.oracleddl.metadata.RealType;
import org.eclipse.persistence.tools.oracleddl.metadata.ROWTYPEType;
import org.eclipse.persistence.tools.oracleddl.metadata.TableType;
import org.eclipse.persistence.tools.oracleddl.metadata.TimeStampType;
import org.eclipse.persistence.tools.oracleddl.metadata.TYPEType;
import org.eclipse.persistence.tools.oracleddl.metadata.URowIdType;
import org.eclipse.persistence.tools.oracleddl.metadata.UnresolvedSizedType;
import org.eclipse.persistence.tools.oracleddl.metadata.UnresolvedType;
import org.eclipse.persistence.tools.oracleddl.metadata.VarCharType;
import org.eclipse.persistence.tools.oracleddl.metadata.VarChar2Type;
import org.eclipse.persistence.tools.oracleddl.metadata.VArrayType;
import org.eclipse.persistence.tools.oracleddl.util.DatabaseTypesRepository;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.BFILE_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.BINARY_INTEGER_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.BINARY_FLOAT_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.BINARY_DOUBLE_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.BOOLEAN_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.DATE_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.INTEGER_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.MLSLABEL_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.NATURAL_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.PLS_INTEGER_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.POSITIVE_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.ROWID_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.SIGN_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.SIMPLE_INTEGER_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.SIMPLE_DOUBLE_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.SIMPLE_FLOAT_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.SMALLINT_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.SYS_REFCURSOR_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.TIME_TYPE;
import static org.eclipse.persistence.tools.oracleddl.metadata.ScalarDatabaseTypeEnum.XMLTYPE_TYPE;

public class DDLParser/*@bgen(jjtree)*/implements DDLParserTreeConstants, DDLParserConstants {/*@bgen(jjtree)*/
  protected JJTDDLParserState jjtree = new JJTDDLParserState();
    protected Map<String, DatabaseType> localTypes = new HashMap<String, DatabaseType>();
    protected List<String> schemaPatterns = null;

    protected DatabaseTypesRepository typesRepository = new DatabaseTypesRepository();

    public DDLParser() {
        super();
    }

    public void setTypesRepository(DatabaseTypesRepository typesRepository) {
        this.typesRepository = typesRepository;
    }
    public DatabaseTypesRepository getTypesRepository() {
        return typesRepository;
    }

    public void setSchemaPatterns(List<String> schemaPatterns) {
        this.schemaPatterns = schemaPatterns;
    }

    protected String removeQuotes(String quotedString) {
        return quotedString.substring(1, quotedString.length() - 1);
    }

  final public String keywords() throws ParseException {
 Token t = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_ARRAY:
      t = jj_consume_token(K_ARRAY);
      break;
    case K_AUTHID:
      t = jj_consume_token(K_AUTHID);
      break;
    case K_BFILE:
      t = jj_consume_token(K_BFILE);
      break;
    case K_BINARY_DOUBLE:
      t = jj_consume_token(K_BINARY_DOUBLE);
      break;
    case K_BINARY_FLOAT:
      t = jj_consume_token(K_BINARY_FLOAT);
      break;
    case K_BINARY_INTEGER:
      t = jj_consume_token(K_BINARY_INTEGER);
      break;
    case K_BLOB:
      t = jj_consume_token(K_BLOB);
      break;
    case K_BOOLEAN:
      t = jj_consume_token(K_BOOLEAN);
      break;
    case K_BYTE:
      t = jj_consume_token(K_BYTE);
      break;
    case K_CHAR:
      t = jj_consume_token(K_CHAR);
      break;
    case K_CHARACTER:
      t = jj_consume_token(K_CHARACTER);
      break;
    case K_CLOB:
      t = jj_consume_token(K_CLOB);
      break;
    case K_COMMIT:
      t = jj_consume_token(K_COMMIT);
      break;
    case K_CONSTANT:
      t = jj_consume_token(K_CONSTANT);
      break;
    case K_CONSTRUCTOR:
      t = jj_consume_token(K_CONSTRUCTOR);
      break;
    case K_CURRENT_USER:
      t = jj_consume_token(K_CURRENT_USER);
      break;
    case K_DATE:
      t = jj_consume_token(K_DATE);
      break;
    case K_DAY:
      t = jj_consume_token(K_DAY);
      break;
    case K_DEC:
      t = jj_consume_token(K_DEC);
      break;
    case K_DECIMAL:
      t = jj_consume_token(K_DECIMAL);
      break;
    case K_DEFINER:
      t = jj_consume_token(K_DEFINER);
      break;
    case K_DELETE:
      t = jj_consume_token(K_DELETE);
      break;
    case K_DETERMINISTIC:
      t = jj_consume_token(K_DETERMINISTIC);
      break;
    case K_DOUBLE:
      t = jj_consume_token(K_DOUBLE);
      break;
    case K_EDITIONABLE:
      t = jj_consume_token(K_EDITIONABLE);
      break;
    case K_ENABLE:
      t = jj_consume_token(K_ENABLE);
      break;
    case K_FINAL:
      t = jj_consume_token(K_FINAL);
      break;
    case K_FLOAT:
      t = jj_consume_token(K_FLOAT);
      break;
    case K_FORCE:
      t = jj_consume_token(K_FORCE);
      break;
    case K_GLOBAL:
      t = jj_consume_token(K_GLOBAL);
      break;
    case K_INSTANTIABLE:
      t = jj_consume_token(K_INSTANTIABLE);
      break;
    case K_INT:
      t = jj_consume_token(K_INT);
      break;
    case K_INTEGER:
      t = jj_consume_token(K_INTEGER);
      break;
    case K_INTERVAL:
      t = jj_consume_token(K_INTERVAL);
      break;
    case K_KEY:
      t = jj_consume_token(K_KEY);
      break;
    case K_LOCAL:
      t = jj_consume_token(K_LOCAL);
      break;
    case K_LONG:
      t = jj_consume_token(K_LONG);
      break;
    case K_MLSLABEL:
      t = jj_consume_token(K_MLSLABEL);
      break;
    case K_MONTH:
      t = jj_consume_token(K_MONTH);
      break;
    case K_NATIONAL:
      t = jj_consume_token(K_NATIONAL);
      break;
    case K_NATURAL:
      t = jj_consume_token(K_NATURAL);
      break;
    case K_NCHAR:
      t = jj_consume_token(K_NCHAR);
      break;
    case K_NCLOB:
      t = jj_consume_token(K_NCLOB);
      break;
    case K_NOCOPY:
      t = jj_consume_token(K_NOCOPY);
      break;
    case K_NONEDITIONABLE:
      t = jj_consume_token(K_NONEDITIONABLE);
      break;
    case K_NUMBER:
      t = jj_consume_token(K_NUMBER);
      break;
    case K_NUMERIC:
      t = jj_consume_token(K_NUMERIC);
      break;
    case K_NVARCHAR2:
      t = jj_consume_token(K_NVARCHAR2);
      break;
    case K_NVARCHAR:
      t = jj_consume_token(K_NVARCHAR);
      break;
    case K_OBJECT:
      t = jj_consume_token(K_OBJECT);
      break;
    case K_OID:
      t = jj_consume_token(K_OID);
      break;
    case K_ORGANIZATION:
      t = jj_consume_token(K_ORGANIZATION);
      break;
    case K_OUT:
      t = jj_consume_token(K_OUT);
      break;
    case K_OVERFLOW:
      t = jj_consume_token(K_OVERFLOW);
      break;
    case K_PACKAGE:
      t = jj_consume_token(K_PACKAGE);
      break;
    case K_PARALLEL_ENABLE:
      t = jj_consume_token(K_PARALLEL_ENABLE);
      break;
    case K_PIPELINED:
      t = jj_consume_token(K_PIPELINED);
      break;
    case K_PLS_INTEGER:
      t = jj_consume_token(K_PLS_INTEGER);
      break;
    case K_POSITIVE:
      t = jj_consume_token(K_POSITIVE);
      break;
    case K_PRAGMA:
      t = jj_consume_token(K_PRAGMA);
      break;
    case K_PRECISION:
      t = jj_consume_token(K_PRECISION);
      break;
    case K_PRESERVE:
      t = jj_consume_token(K_PRESERVE);
      break;
    case K_RANGE:
      t = jj_consume_token(K_RANGE);
      break;
    case K_RAW:
      t = jj_consume_token(K_RAW);
      break;
    case K_REAL:
      t = jj_consume_token(K_REAL);
      break;
    case K_RECORD:
      t = jj_consume_token(K_RECORD);
      break;
    case K_REF:
      t = jj_consume_token(K_REF);
      break;
    case K_REPLACE:
      t = jj_consume_token(K_REPLACE);
      break;
    case K_RESULT:
      t = jj_consume_token(K_RESULT);
      break;
    case K_RESULT_CACHE:
      t = jj_consume_token(K_RESULT_CACHE);
      break;
    case K_RETURN:
      t = jj_consume_token(K_RETURN);
      break;
    case K_ROWID:
      t = jj_consume_token(K_ROWID);
      break;
    case K_ROWS:
      t = jj_consume_token(K_ROWS);
      break;
    case K_SECOND:
      t = jj_consume_token(K_SECOND);
      break;
    case K_SELF:
      t = jj_consume_token(K_SELF);
      break;
    case K_SET:
      t = jj_consume_token(K_SET);
      break;
    case K_SIGNTYPE:
      t = jj_consume_token(K_SIGNTYPE);
      break;
    case K_SIMPLE_DOUBLE:
      t = jj_consume_token(K_SIMPLE_DOUBLE);
      break;
    case K_SIMPLE_FLOAT:
      t = jj_consume_token(K_SIMPLE_FLOAT);
      break;
    case K_SIMPLE_INTEGER:
      t = jj_consume_token(K_SIMPLE_INTEGER);
      break;
    case K_SMALLINT:
      t = jj_consume_token(K_SMALLINT);
      break;
    case K_STRING:
      t = jj_consume_token(K_STRING);
      break;
    case K_SYS_REFCURSOR:
      t = jj_consume_token(K_SYS_REFCURSOR);
      break;
    case K_TEMPORARY:
      t = jj_consume_token(K_TEMPORARY);
      break;
    case K_TIME:
      t = jj_consume_token(K_TIME);
      break;
    case K_TIMESTAMP:
      t = jj_consume_token(K_TIMESTAMP);
      break;
    case K_UROWID:
      t = jj_consume_token(K_UROWID);
      break;
    case K_USING:
      t = jj_consume_token(K_USING);
      break;
    case K_VARCHAR2:
      t = jj_consume_token(K_VARCHAR2);
      break;
    case K_VARCHAR:
      t = jj_consume_token(K_VARCHAR);
      break;
    case K_VARRAY:
      t = jj_consume_token(K_VARRAY);
      break;
    case K_VARYING:
      t = jj_consume_token(K_VARYING);
      break;
    case K_XMLTYPE:
      t = jj_consume_token(K_XMLTYPE);
      break;
    case K_SYSXMLTYPE:
      t = jj_consume_token(K_SYSXMLTYPE);
      break;
    case K_YEAR:
      t = jj_consume_token(K_YEAR);
      break;
    case K_ZONE:
      t = jj_consume_token(K_ZONE);
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

// stripped-down version of PLSQL grammar: only parses package/top-level DDL specifications

// PLSQLPackage at 'top-level'
  final public PLSQLPackageType parsePLSQLPackage() throws ParseException {
 PLSQLPackageType packageType = new PLSQLPackageType();
 String dottedName = null;
 String schema = null;
 String packageName = null;
    jj_consume_token(R_CREATE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_OR:
      orReplace();
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_EDITIONABLE:
    case K_NONEDITIONABLE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_EDITIONABLE:
        jj_consume_token(K_EDITIONABLE);
        break;
      case K_NONEDITIONABLE:
        jj_consume_token(K_NONEDITIONABLE);
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      ;
    }
    jj_consume_token(K_PACKAGE);
    dottedName = OracleObjectNamePossiblyDotted();
          packageName = dottedName;
          if (dottedName.contains(".")) {
              int idx = dottedName.indexOf('.');
              schema = dottedName.substring(0, idx);
              packageName = dottedName.substring(idx+1, dottedName.length());
          }
          if (schema != null) {
            packageType.setSchema(schema);
          }
          packageType.setPackageName(packageName);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_AUTHID:
      invokerRights();
      break;
    default:
      ;
    }
    as();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case R_CURSOR:
      case R_FUNCTION:
      case R_PROCEDURE:
      case R_SUBTYPE:
      case R_TYPE:
      case K_ARRAY:
      case K_AUTHID:
      case K_BFILE:
      case K_BINARY_DOUBLE:
      case K_BINARY_FLOAT:
      case K_BINARY_INTEGER:
      case K_BLOB:
      case K_BOOLEAN:
      case K_BYTE:
      case K_CHAR:
      case K_CHARACTER:
      case K_CLOB:
      case K_COMMIT:
      case K_CONSTANT:
      case K_CONSTRUCTOR:
      case K_CURRENT_USER:
      case K_DATE:
      case K_DAY:
      case K_DEC:
      case K_DECIMAL:
      case K_DEFINER:
      case K_DELETE:
      case K_DETERMINISTIC:
      case K_DOUBLE:
      case K_EDITIONABLE:
      case K_ENABLE:
      case K_FINAL:
      case K_FLOAT:
      case K_FORCE:
      case K_GLOBAL:
      case K_INSTANTIABLE:
      case K_INT:
      case K_INTEGER:
      case K_INTERVAL:
      case K_KEY:
      case K_LOCAL:
      case K_LONG:
      case K_MLSLABEL:
      case K_MONTH:
      case K_NATIONAL:
      case K_NATURAL:
      case K_NCHAR:
      case K_NCLOB:
      case K_NOCOPY:
      case K_NONEDITIONABLE:
      case K_NUMBER:
      case K_NUMERIC:
      case K_NVARCHAR2:
      case K_NVARCHAR:
      case K_OBJECT:
      case K_OID:
      case K_ORGANIZATION:
      case K_OUT:
      case K_OVERFLOW:
      case K_PACKAGE:
      case K_PARALLEL_ENABLE:
      case K_PIPELINED:
      case K_PLS_INTEGER:
      case K_POSITIVE:
      case K_PRAGMA:
      case K_PRECISION:
      case K_PRESERVE:
      case K_RANGE:
      case K_RAW:
      case K_REAL:
      case K_RECORD:
      case K_REF:
      case K_REPLACE:
      case K_RESULT:
      case K_RESULT_CACHE:
      case K_RETURN:
      case K_ROWID:
      case K_ROWS:
      case K_SECOND:
      case K_SELF:
      case K_SET:
      case K_SIGNTYPE:
      case K_SIMPLE_DOUBLE:
      case K_SIMPLE_FLOAT:
      case K_SIMPLE_INTEGER:
      case K_SMALLINT:
      case K_STRING:
      case K_SYS_REFCURSOR:
      case K_TEMPORARY:
      case K_TIME:
      case K_TIMESTAMP:
      case K_UROWID:
      case K_USING:
      case K_VARCHAR2:
      case K_VARCHAR:
      case K_VARRAY:
      case K_VARYING:
      case K_XMLTYPE:
      case K_SYSXMLTYPE:
      case K_YEAR:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
        ;
        break;
      default:
        break label_1;
      }
      packageDeclaration(packageType);
    }
    jj_consume_token(R_END);
    skipToEnd();
      typesRepository.setDatabaseType(packageName, packageType);
      {if (true) return packageType;}
    throw new Error("Missing return statement in function");
  }

// procedure at 'top-level'
  final public ProcedureType parseTopLevelProcedure() throws ParseException {
 ProcedureType procedureType = null;
 String dottedName = null;
 String schema = null;
 String procedureName = null;
    jj_consume_token(R_CREATE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_OR:
      orReplace();
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_EDITIONABLE:
    case K_NONEDITIONABLE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_EDITIONABLE:
        jj_consume_token(K_EDITIONABLE);
        break;
      case K_NONEDITIONABLE:
        jj_consume_token(K_NONEDITIONABLE);
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      ;
    }
    jj_consume_token(R_PROCEDURE);
    dottedName = OracleObjectNamePossiblyDotted();
          procedureName = dottedName;
          if (dottedName.contains(".")) {
              int idx = dottedName.indexOf('.');
              schema = dottedName.substring(0, idx);
              procedureName = dottedName.substring(idx+1, dottedName.length());
          }
          procedureType = new ProcedureType(procedureName);
              if (schema != null) {
                  procedureType.setSchema(schema);
              }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_OPENPAREN:
      jj_consume_token(O_OPENPAREN);
      argumentList(procedureType);
      jj_consume_token(O_CLOSEPAREN);
      break;
    default:
      ;
    }
    as();
    skipToEnd();
      typesRepository.setDatabaseType(procedureName, procedureType);
      {if (true) return procedureType;}
    throw new Error("Missing return statement in function");
  }

// function at 'top-level'
  final public FunctionType parseTopLevelFunction() throws ParseException {
 FunctionType functionType = null;
 String dottedName = null;
 String schema = null;
 String functionName = null;
 ArgumentType returnType = null;
    jj_consume_token(R_CREATE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_OR:
      orReplace();
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_EDITIONABLE:
    case K_NONEDITIONABLE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_EDITIONABLE:
        jj_consume_token(K_EDITIONABLE);
        break;
      case K_NONEDITIONABLE:
        jj_consume_token(K_NONEDITIONABLE);
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      ;
    }
    jj_consume_token(R_FUNCTION);
    dottedName = OracleObjectNamePossiblyDotted();
          functionName = dottedName;
          if (dottedName.contains(".")) {
              int idx = dottedName.indexOf('.');
              schema = dottedName.substring(0, idx);
              functionName = dottedName.substring(idx+1, dottedName.length());
          }
              functionType = new FunctionType(functionName);
          if (schema != null) {
              functionType.setSchema(schema);
          }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_OPENPAREN:
      jj_consume_token(O_OPENPAREN);
      argumentList(functionType);
      jj_consume_token(O_CLOSEPAREN);
      break;
    default:
      ;
    }
    returnType = functionReturnSpec(functionType);
    as();
    skipToEnd();
      functionType.setReturnArgument(returnType);
      typesRepository.setDatabaseType(functionName, functionType);
      {if (true) return functionType;}
    throw new Error("Missing return statement in function");
  }

// table at 'top-level'
  final public TableType parseTable() throws ParseException {
 TableType tableType = null;
 String dottedName = null;
 String schema = null;
 String tableName = null;
 Token iot = null;
    jj_consume_token(R_CREATE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_GLOBAL:
      jj_consume_token(K_GLOBAL);
      jj_consume_token(K_TEMPORARY);
      break;
    default:
      ;
    }
    jj_consume_token(R_TABLE);
    dottedName = OracleObjectNamePossiblyDotted();
          tableName = dottedName;
          if (dottedName.contains(".")) {
              int idx = dottedName.indexOf('.');
              schema = dottedName.substring(0, idx);
              tableName = dottedName.substring(idx+1, dottedName.length());
          }
          tableType = new TableType(tableName);
                  if (schema != null) {
                       tableType.setSchema(schema);
                  }
    jj_consume_token(O_OPENPAREN);
    columnDeclarations(tableType);
    jj_consume_token(O_CLOSEPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_ORGANIZATION:
      jj_consume_token(K_ORGANIZATION);
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_INDEX:
      iot = jj_consume_token(R_INDEX);
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_NOCOMPRESS:
      jj_consume_token(R_NOCOMPRESS);
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_OVERFLOW:
      jj_consume_token(K_OVERFLOW);
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_ON:
      onCommit();
      break;
    default:
      ;
    }
    jj_consume_token(O_SEMICOLON);
    jj_consume_token(0);
         if (iot != null) {
             tableType.setIOT(true);
         }
         typesRepository.setDatabaseType(tableName, tableType);
         {if (true) return tableType;}
    throw new Error("Missing return statement in function");
  }

// type at 'top-level'
  final public CompositeDatabaseType parseType() throws ParseException {
 CompositeDatabaseType databaseType = null;
 DatabaseType enclosedType = null;
 String dottedName = null;
 String schema = null;
 String typeName = null;
 Token vsize = null;
 boolean varray = false;
 boolean nestedTable = false;
    jj_consume_token(R_CREATE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_OR:
      orReplace();
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_EDITIONABLE:
    case K_NONEDITIONABLE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_EDITIONABLE:
        jj_consume_token(K_EDITIONABLE);
        break;
      case K_NONEDITIONABLE:
        jj_consume_token(K_NONEDITIONABLE);
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      ;
    }
    jj_consume_token(R_TYPE);
    dottedName = OracleObjectNamePossiblyDotted();
          typeName = dottedName;
          if (dottedName.contains(".")) {
              int idx = dottedName.indexOf('.');
              schema = dottedName.substring(0, idx);
              typeName = dottedName.substring(idx+1, dottedName.length());
          }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_FORCE:
      jj_consume_token(K_FORCE);
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_OID:
      jj_consume_token(K_OID);
      jj_consume_token(S_CHAR_LITERAL);
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_AUTHID:
      invokerRights();
      break;
    default:
      ;
    }
    as();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_TABLE:
    case K_OBJECT:
    case K_VARRAY:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_OBJECT:
        jj_consume_token(K_OBJECT);
        jj_consume_token(O_OPENPAREN);
                databaseType = new ObjectType(typeName);
                if (schema != null) {
                    ((ObjectType)databaseType).setSchema(schema);
                }
        columnDeclarations(databaseType);
        constructorDeclaration();
        memberFunctionOrProcedureDeclaration();
        jj_consume_token(O_CLOSEPAREN);
        break;
      case K_VARRAY:
        jj_consume_token(K_VARRAY);
        jj_consume_token(O_OPENPAREN);
        vsize = jj_consume_token(S_NUMBER);
        jj_consume_token(O_CLOSEPAREN);
        jj_consume_token(R_OF);
                databaseType = new VArrayType(typeName);
                if (schema != null) {
                    ((VArrayType)databaseType).setSchema(schema);
                }
                if (vsize != null) {
                    Long size = Long.decode(vsize.image);
                    ((VArrayType)databaseType).setSize(size);
                }
        enclosedType = columnTypeSpec(databaseType);
        break;
      case R_TABLE:
        jj_consume_token(R_TABLE);
        jj_consume_token(R_OF);
                databaseType = new ObjectTableType(typeName);
                if (schema != null) {
                    ((ObjectTableType)databaseType).setSchema(schema);
                }
        enclosedType = columnTypeSpec(databaseType);
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_NOT:
    case K_FINAL:
    case K_INSTANTIABLE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case R_NOT:
        jj_consume_token(R_NOT);
        break;
      default:
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_FINAL:
        jj_consume_token(K_FINAL);
        break;
      case K_INSTANTIABLE:
        jj_consume_token(K_INSTANTIABLE);
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_SEMICOLON:
      jj_consume_token(O_SEMICOLON);
      break;
    default:
      ;
    }
    jj_consume_token(0);
        if (enclosedType != null) {
            ((CompositeDatabaseType)databaseType).setEnclosedType(enclosedType);
        }
        typesRepository.setDatabaseType(typeName, databaseType);
        {if (true) return databaseType;}
    throw new Error("Missing return statement in function");
  }

  final public void columnDeclarations(CompositeDatabaseType enclosingType) throws ParseException {
    if (jj_2_1(2)) {
      constructor();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_ARRAY:
      case K_AUTHID:
      case K_BFILE:
      case K_BINARY_DOUBLE:
      case K_BINARY_FLOAT:
      case K_BINARY_INTEGER:
      case K_BLOB:
      case K_BOOLEAN:
      case K_BYTE:
      case K_CHAR:
      case K_CHARACTER:
      case K_CLOB:
      case K_COMMIT:
      case K_CONSTANT:
      case K_CONSTRUCTOR:
      case K_CURRENT_USER:
      case K_DATE:
      case K_DAY:
      case K_DEC:
      case K_DECIMAL:
      case K_DEFINER:
      case K_DELETE:
      case K_DETERMINISTIC:
      case K_DOUBLE:
      case K_EDITIONABLE:
      case K_ENABLE:
      case K_FINAL:
      case K_FLOAT:
      case K_FORCE:
      case K_GLOBAL:
      case K_INSTANTIABLE:
      case K_INT:
      case K_INTEGER:
      case K_INTERVAL:
      case K_KEY:
      case K_LOCAL:
      case K_LONG:
      case K_MLSLABEL:
      case K_MONTH:
      case K_NATIONAL:
      case K_NATURAL:
      case K_NCHAR:
      case K_NCLOB:
      case K_NOCOPY:
      case K_NONEDITIONABLE:
      case K_NUMBER:
      case K_NUMERIC:
      case K_NVARCHAR2:
      case K_NVARCHAR:
      case K_OBJECT:
      case K_OID:
      case K_ORGANIZATION:
      case K_OUT:
      case K_OVERFLOW:
      case K_PACKAGE:
      case K_PARALLEL_ENABLE:
      case K_PIPELINED:
      case K_PLS_INTEGER:
      case K_POSITIVE:
      case K_PRAGMA:
      case K_PRECISION:
      case K_PRESERVE:
      case K_RANGE:
      case K_RAW:
      case K_REAL:
      case K_RECORD:
      case K_REF:
      case K_REPLACE:
      case K_RESULT:
      case K_RESULT_CACHE:
      case K_RETURN:
      case K_ROWID:
      case K_ROWS:
      case K_SECOND:
      case K_SELF:
      case K_SET:
      case K_SIGNTYPE:
      case K_SIMPLE_DOUBLE:
      case K_SIMPLE_FLOAT:
      case K_SIMPLE_INTEGER:
      case K_SMALLINT:
      case K_STRING:
      case K_SYS_REFCURSOR:
      case K_TEMPORARY:
      case K_TIME:
      case K_TIMESTAMP:
      case K_UROWID:
      case K_USING:
      case K_VARCHAR2:
      case K_VARCHAR:
      case K_VARRAY:
      case K_VARYING:
      case K_XMLTYPE:
      case K_SYSXMLTYPE:
      case K_YEAR:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
        columnDeclaration(enclosingType);
        break;
      case R_CHECK:
      case R_CONSTRAINT:
      case R_PRIMARY:
      case R_UNIQUE:
        constraintDeclaration(enclosingType);
        break;
      case R_MEMBER:
      case R_STATIC:
        memberFunctionOrProcedure();
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_COMMA:
      jj_consume_token(O_COMMA);
      columnDeclarations(enclosingType);
      break;
    default:
      ;
    }
  }

  final public void columnDeclaration(CompositeDatabaseType enclosingType) throws ParseException {
 String s = null;
 String pk = null;
 boolean notNull = false;
 DatabaseType columnType = null;
 FieldType column = null;
    s = OracleObjectName();
    columnType = columnTypeSpec(enclosingType);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_NOT:
      notNull = notNull();
      break;
    default:
      ;
    }
          column = new FieldType(s);
          if (enclosingType != null) {
              if (enclosingType.isPLSQLRecordType()) {
                  ((PLSQLRecordType)enclosingType).addField(column);
              }
              else if (enclosingType.isTableType()) {
                  ((TableType)enclosingType).addColumn(column);
              }
              else if (enclosingType.isObjectType()) {
                  ((ObjectType)enclosingType).addField(column);
              }
          }
          column.setEnclosedType(columnType);
          if (columnType instanceof UnresolvedType) {
              ((UnresolvedType)columnType).setOwningType(column);
          }
          if (notNull) {
              column.setNotNull();
          }
  }

  final public void constraintDeclaration(CompositeDatabaseType enclosingType) throws ParseException {
 String s = null;
 String pk = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_CONSTRAINT:
      jj_consume_token(R_CONSTRAINT);
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_ARRAY:
    case K_AUTHID:
    case K_BFILE:
    case K_BINARY_DOUBLE:
    case K_BINARY_FLOAT:
    case K_BINARY_INTEGER:
    case K_BLOB:
    case K_BOOLEAN:
    case K_BYTE:
    case K_CHAR:
    case K_CHARACTER:
    case K_CLOB:
    case K_COMMIT:
    case K_CONSTANT:
    case K_CONSTRUCTOR:
    case K_CURRENT_USER:
    case K_DATE:
    case K_DAY:
    case K_DEC:
    case K_DECIMAL:
    case K_DEFINER:
    case K_DELETE:
    case K_DETERMINISTIC:
    case K_DOUBLE:
    case K_EDITIONABLE:
    case K_ENABLE:
    case K_FINAL:
    case K_FLOAT:
    case K_FORCE:
    case K_GLOBAL:
    case K_INSTANTIABLE:
    case K_INT:
    case K_INTEGER:
    case K_INTERVAL:
    case K_KEY:
    case K_LOCAL:
    case K_LONG:
    case K_MLSLABEL:
    case K_MONTH:
    case K_NATIONAL:
    case K_NATURAL:
    case K_NCHAR:
    case K_NCLOB:
    case K_NOCOPY:
    case K_NONEDITIONABLE:
    case K_NUMBER:
    case K_NUMERIC:
    case K_NVARCHAR2:
    case K_NVARCHAR:
    case K_OBJECT:
    case K_OID:
    case K_ORGANIZATION:
    case K_OUT:
    case K_OVERFLOW:
    case K_PACKAGE:
    case K_PARALLEL_ENABLE:
    case K_PIPELINED:
    case K_PLS_INTEGER:
    case K_POSITIVE:
    case K_PRAGMA:
    case K_PRECISION:
    case K_PRESERVE:
    case K_RANGE:
    case K_RAW:
    case K_REAL:
    case K_RECORD:
    case K_REF:
    case K_REPLACE:
    case K_RESULT:
    case K_RESULT_CACHE:
    case K_RETURN:
    case K_ROWID:
    case K_ROWS:
    case K_SECOND:
    case K_SELF:
    case K_SET:
    case K_SIGNTYPE:
    case K_SIMPLE_DOUBLE:
    case K_SIMPLE_FLOAT:
    case K_SIMPLE_INTEGER:
    case K_SMALLINT:
    case K_STRING:
    case K_SYS_REFCURSOR:
    case K_TEMPORARY:
    case K_TIME:
    case K_TIMESTAMP:
    case K_UROWID:
    case K_USING:
    case K_VARCHAR2:
    case K_VARCHAR:
    case K_VARRAY:
    case K_VARYING:
    case K_XMLTYPE:
    case K_SYSXMLTYPE:
    case K_YEAR:
    case K_ZONE:
    case S_IDENTIFIER:
    case S_QUOTED_IDENTIFIER:
      OracleObjectName();
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_PRIMARY:
      jj_consume_token(R_PRIMARY);
      jj_consume_token(K_KEY);
      jj_consume_token(O_OPENPAREN);
      pkList((TableType)enclosingType);
      jj_consume_token(O_CLOSEPAREN);
      break;
    case R_CHECK:
      jj_consume_token(R_CHECK);
      jj_consume_token(O_OPENPAREN);
      skipToClosingParen();
      jj_consume_token(O_CLOSEPAREN);
      break;
    case R_UNIQUE:
      jj_consume_token(R_UNIQUE);
      jj_consume_token(O_OPENPAREN);
      uniqList();
      jj_consume_token(O_CLOSEPAREN);
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_USING:
      jj_consume_token(K_USING);
      jj_consume_token(R_INDEX);
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_ENABLE:
      jj_consume_token(K_ENABLE);
      break;
    default:
      ;
    }
  }

  final public DatabaseType columnTypeSpec(CompositeDatabaseType enclosingType) throws ParseException {
 String s = null;
 Token t = null;
 DatabaseType dt = null;
    if (jj_2_2(2)) {
      dt = datatype();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_ARRAY:
      case K_AUTHID:
      case K_BFILE:
      case K_BINARY_DOUBLE:
      case K_BINARY_FLOAT:
      case K_BINARY_INTEGER:
      case K_BLOB:
      case K_BOOLEAN:
      case K_BYTE:
      case K_CHAR:
      case K_CHARACTER:
      case K_CLOB:
      case K_COMMIT:
      case K_CONSTANT:
      case K_CONSTRUCTOR:
      case K_CURRENT_USER:
      case K_DATE:
      case K_DAY:
      case K_DEC:
      case K_DECIMAL:
      case K_DEFINER:
      case K_DELETE:
      case K_DETERMINISTIC:
      case K_DOUBLE:
      case K_EDITIONABLE:
      case K_ENABLE:
      case K_FINAL:
      case K_FLOAT:
      case K_FORCE:
      case K_GLOBAL:
      case K_INSTANTIABLE:
      case K_INT:
      case K_INTEGER:
      case K_INTERVAL:
      case K_KEY:
      case K_LOCAL:
      case K_LONG:
      case K_MLSLABEL:
      case K_MONTH:
      case K_NATIONAL:
      case K_NATURAL:
      case K_NCHAR:
      case K_NCLOB:
      case K_NOCOPY:
      case K_NONEDITIONABLE:
      case K_NUMBER:
      case K_NUMERIC:
      case K_NVARCHAR2:
      case K_NVARCHAR:
      case K_OBJECT:
      case K_OID:
      case K_ORGANIZATION:
      case K_OUT:
      case K_OVERFLOW:
      case K_PACKAGE:
      case K_PARALLEL_ENABLE:
      case K_PIPELINED:
      case K_PLS_INTEGER:
      case K_POSITIVE:
      case K_PRAGMA:
      case K_PRECISION:
      case K_PRESERVE:
      case K_RANGE:
      case K_RAW:
      case K_REAL:
      case K_RECORD:
      case K_REF:
      case K_REPLACE:
      case K_RESULT:
      case K_RESULT_CACHE:
      case K_RETURN:
      case K_ROWID:
      case K_ROWS:
      case K_SECOND:
      case K_SELF:
      case K_SET:
      case K_SIGNTYPE:
      case K_SIMPLE_DOUBLE:
      case K_SIMPLE_FLOAT:
      case K_SIMPLE_INTEGER:
      case K_SMALLINT:
      case K_STRING:
      case K_SYS_REFCURSOR:
      case K_TEMPORARY:
      case K_TIME:
      case K_TIMESTAMP:
      case K_UROWID:
      case K_USING:
      case K_VARCHAR2:
      case K_VARCHAR:
      case K_VARRAY:
      case K_VARYING:
      case K_XMLTYPE:
      case K_SYSXMLTYPE:
      case K_YEAR:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
        s = columnSpec();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case O_OPENPAREN:
          jj_consume_token(O_OPENPAREN);
          t = jj_consume_token(S_NUMBER);
          jj_consume_token(O_CLOSEPAREN);
          break;
        default:
          ;
        }
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_CONSTRAINT:
      jj_consume_token(R_CONSTRAINT);
      jj_consume_token(S_QUOTED_IDENTIFIER);
      break;
    default:
      ;
    }
      if (s != null) {
          if (s.contains(".")) {
              int dotIdx = s.indexOf('.');
              String namePart1 = s.substring(0, dotIdx);
              String namePart2 = s.substring(dotIdx+1, s.length());
              String schemaName = null;
              if (enclosingType.isTableType()) {
                 schemaName = ((TableType)enclosingType).getSchema();
              } else if (enclosingType.isObjectTableType()) {
                 schemaName = ((ObjectTableType)enclosingType).getSchema();
              } else if (enclosingType.isObjectType()) {
                 schemaName = ((ObjectType)enclosingType).getSchema();
              } else if (enclosingType.isPLSQLType()) {
                 schemaName = ((PLSQLType)enclosingType).getParentType().getSchema();
              } else if (enclosingType.isVArrayType()) {
                 schemaName = ((VArrayType)enclosingType).getSchema();
              }
              if (schemaName != null && schemaName.equals(namePart1)) {
                  s = namePart2;
              }
          }
          for (String typeName : localTypes.keySet()) {
              if (typeName.equals(s)) {
                  dt = localTypes.get(s);
                  break;
              }
          }
          if (dt == null) {
              if (t != null) {
                  Long size = Long.decode(t.image);
                  dt = new UnresolvedSizedType(s, size);
              }
              else {
                  dt = new UnresolvedType(s);
              }
              ((UnresolvedType)dt).setOwningType(enclosingType);
          }
      }
      {if (true) return dt;}
    throw new Error("Missing return statement in function");
  }

  final public void constructorDeclaration() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_CONSTRUCTOR:
      jj_consume_token(K_CONSTRUCTOR);
      skipToReturn();
      jj_consume_token(K_SELF);
      jj_consume_token(R_AS);
      jj_consume_token(K_RESULT);
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_COMMA:
      jj_consume_token(O_COMMA);
      constructorDeclaration();
      break;
    default:
      ;
    }
  }

  final public void uniqList() throws ParseException {
    OracleObjectName();
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_COMMA:
        ;
        break;
      default:
        break label_2;
      }
      jj_consume_token(O_COMMA);
      OracleObjectName();
    }
  }

  final public void pkList(TableType tableType) throws ParseException {
    pk(tableType);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_COMMA:
        ;
        break;
      default:
        break label_3;
      }
      jj_consume_token(O_COMMA);
      pk(tableType);
    }
  }

  final public void pk(TableType tableType) throws ParseException {
String s = null;
    s = OracleObjectName();
       List<FieldType> columns = tableType.getColumns();
       for (FieldType column : columns) {
            if (column.getFieldName().equals(s)) {
                column.setPk();
                break;
            }
       }
  }

  final public void packageDeclaration(PLSQLPackageType packageType) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_SUBTYPE:
    case R_TYPE:
      typeOrSubTypeDeclaration(packageType);
      break;
    case R_CURSOR:
      cursorDeclaration(packageType);
      break;
    case R_PROCEDURE:
      procedureSpec(packageType);
      break;
    case R_FUNCTION:
      functionSpec(packageType);
      break;
    case K_PRAGMA:
      pragmaDeclaration();
      jj_consume_token(O_SEMICOLON);
      break;
    default:
      if (jj_2_3(2)) {
        variableDeclaration(packageType);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void variableDeclaration(PLSQLPackageType packageType) throws ParseException {
 String varName = null;
 DatabaseType varType=null;
    varName = OracleObjectName();
    if (jj_2_5(2)) {
      jj_consume_token(R_EXCEPTION);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_ARRAY:
      case K_AUTHID:
      case K_BFILE:
      case K_BINARY_DOUBLE:
      case K_BINARY_FLOAT:
      case K_BINARY_INTEGER:
      case K_BLOB:
      case K_BOOLEAN:
      case K_BYTE:
      case K_CHAR:
      case K_CHARACTER:
      case K_CLOB:
      case K_COMMIT:
      case K_CONSTANT:
      case K_CONSTRUCTOR:
      case K_CURRENT_USER:
      case K_DATE:
      case K_DAY:
      case K_DEC:
      case K_DECIMAL:
      case K_DEFINER:
      case K_DELETE:
      case K_DETERMINISTIC:
      case K_DOUBLE:
      case K_EDITIONABLE:
      case K_ENABLE:
      case K_FINAL:
      case K_FLOAT:
      case K_FORCE:
      case K_GLOBAL:
      case K_INSTANTIABLE:
      case K_INT:
      case K_INTEGER:
      case K_INTERVAL:
      case K_KEY:
      case K_LOCAL:
      case K_LONG:
      case K_MLSLABEL:
      case K_MONTH:
      case K_NATIONAL:
      case K_NATURAL:
      case K_NCHAR:
      case K_NCLOB:
      case K_NOCOPY:
      case K_NONEDITIONABLE:
      case K_NUMBER:
      case K_NUMERIC:
      case K_NVARCHAR2:
      case K_NVARCHAR:
      case K_OBJECT:
      case K_OID:
      case K_ORGANIZATION:
      case K_OUT:
      case K_OVERFLOW:
      case K_PACKAGE:
      case K_PARALLEL_ENABLE:
      case K_PIPELINED:
      case K_PLS_INTEGER:
      case K_POSITIVE:
      case K_PRAGMA:
      case K_PRECISION:
      case K_PRESERVE:
      case K_RANGE:
      case K_RAW:
      case K_REAL:
      case K_RECORD:
      case K_REF:
      case K_REPLACE:
      case K_RESULT:
      case K_RESULT_CACHE:
      case K_RETURN:
      case K_ROWID:
      case K_ROWS:
      case K_SECOND:
      case K_SELF:
      case K_SET:
      case K_SIGNTYPE:
      case K_SIMPLE_DOUBLE:
      case K_SIMPLE_FLOAT:
      case K_SIMPLE_INTEGER:
      case K_SMALLINT:
      case K_STRING:
      case K_SYS_REFCURSOR:
      case K_TEMPORARY:
      case K_TIME:
      case K_TIMESTAMP:
      case K_UROWID:
      case K_USING:
      case K_VARCHAR2:
      case K_VARCHAR:
      case K_VARRAY:
      case K_VARYING:
      case K_XMLTYPE:
      case K_SYSXMLTYPE:
      case K_YEAR:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
        if (jj_2_4(2)) {
          jj_consume_token(K_CONSTANT);
        } else {
          ;
        }
        varType = typeSpec();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case R_NOT:
          jj_consume_token(R_NOT);
          jj_consume_token(R_NULL);
          break;
        default:
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case O_ASSIGN:
        case R_DEFAULT:
          variableDefaultAssignment();
          break;
        default:
          ;
        }
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(O_SEMICOLON);
        FieldType variable = new FieldType(varName);
        packageType.addLocalVariable(variable);
        if (varType != null) {
            variable.setEnclosedType(varType);
            if (varType.isROWTYPEType()) {
                ((ROWTYPEType)varType).setPackageType(packageType);
            }
        }
  }

  final public void variableDefaultAssignment() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_ASSIGN:
      jj_consume_token(O_ASSIGN);
      break;
    case R_DEFAULT:
      jj_consume_token(R_DEFAULT);
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
    skipToSemiColon();
  }

  final public DatabaseType datatype() throws ParseException {
 Token t = null;
 DatabaseType dt = null;
 Token precision = null;
 Long sl;
 Long pl;
 Token scale = null;
 Token withTimeZone = null;
 Token withLocalTimeZone = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_BINARY_INTEGER:
      jj_consume_token(K_BINARY_INTEGER);
                          {if (true) return BINARY_INTEGER_TYPE;}
      break;
    case K_BINARY_FLOAT:
      jj_consume_token(K_BINARY_FLOAT);
                          {if (true) return BINARY_FLOAT_TYPE;}
      break;
    case K_BINARY_DOUBLE:
      jj_consume_token(K_BINARY_DOUBLE);
                          {if (true) return BINARY_DOUBLE_TYPE;}
      break;
    case K_NATURAL:
      jj_consume_token(K_NATURAL);
                          {if (true) return NATURAL_TYPE;}
      break;
    case K_POSITIVE:
      jj_consume_token(K_POSITIVE);
                          {if (true) return POSITIVE_TYPE;}
      break;
    case K_SIGNTYPE:
      jj_consume_token(K_SIGNTYPE);
                          {if (true) return SIGN_TYPE;}
      break;
    case K_DEC:
    case K_DECIMAL:
    case K_NUMBER:
    case K_NUMERIC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_NUMBER:
        t = jj_consume_token(K_NUMBER);
        break;
      case K_NUMERIC:
        t = jj_consume_token(K_NUMERIC);
        break;
      case K_DECIMAL:
        t = jj_consume_token(K_DECIMAL);
        break;
      case K_DEC:
        t = jj_consume_token(K_DEC);
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_OPENPAREN:
        jj_consume_token(O_OPENPAREN);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case O_ASTERISK:
        case S_NUMBER:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case O_ASTERISK:
            precision = jj_consume_token(O_ASTERISK);
            break;
          case S_NUMBER:
            precision = jj_consume_token(S_NUMBER);
            break;
          default:
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          ;
        }
        label_4:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case O_COMMA:
            ;
            break;
          default:
            break label_4;
          }
          jj_consume_token(O_COMMA);
          scale = jj_consume_token(S_NUMBER);
        }
        jj_consume_token(O_CLOSEPAREN);
        break;
      default:
        ;
      }
            if (t.kind == K_NUMBER || t.kind == K_NUMERIC) {
                if (precision != null && precision.image.equals("*")) {
                    precision = null;
                }
                if (precision == null) {
                    if (scale != null && scale.image.equals("0")) {
                        dt = INTEGER_TYPE;
                    }
                    else {
                        dt = new NumericType();
                    }
                }
                    else {
                        pl = Long.decode(precision.image);
                        if (scale == null) {
                        dt = new NumericType(pl);
                    }
                    else {
                        sl = Long.decode(scale.image);
                        dt = new NumericType(pl, sl);
                        }
                    }
                //sometimes need to know difference between NUMERIC and NUMBER
                if (dt != INTEGER_TYPE && t.kind == K_NUMBER) {
                    ((NumericType)dt).setNumberSynonym(true);
                }
            }
            else  if (t.kind == K_DECIMAL || t.kind == K_DEC) {
                if (precision != null && precision.image.equals("*")) {
                    precision = null;
                }
                if (precision == null) {
                    dt = new DecimalType();
                }
                else {
                    pl = Long.decode(precision.image);
                    if (scale == null) {
                        dt = new DecimalType(pl);
                    }
                    else {
                        sl = Long.decode(scale.image);
                        dt = new DecimalType(pl, sl);
                    }
                }
            }
            {if (true) return dt;}
      break;
    case K_LONG:
      jj_consume_token(K_LONG);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_RAW:
        t = jj_consume_token(K_RAW);
        break;
      default:
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_OPENPAREN:
        jj_consume_token(O_OPENPAREN);
        precision = jj_consume_token(S_NUMBER);
        jj_consume_token(O_CLOSEPAREN);
        break;
      default:
        ;
      }
              if (t == null) {
              if (precision == null) {
                  dt = new LongType();
              }
              else {
                  pl = Long.decode(precision.image);
                  dt = new LongType(pl);
              }
              }
              else {
              if (precision == null) {
                  dt = new LongRawType();
              }
              else {
                  pl = Long.decode(precision.image);
                  dt = new LongRawType(pl);
              }
            }
            {if (true) return dt;}
      break;
    case K_RAW:
      jj_consume_token(K_RAW);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_OPENPAREN:
        jj_consume_token(O_OPENPAREN);
        precision = jj_consume_token(S_NUMBER);
        jj_consume_token(O_CLOSEPAREN);
        break;
      default:
        ;
      }
            if (precision == null) {
                dt = new RawType();
            }
            else {
                pl = Long.decode(precision.image);
                dt = new RawType(pl);
            }
            {if (true) return dt;}
      break;
    case K_BOOLEAN:
      jj_consume_token(K_BOOLEAN);
                    {if (true) return BOOLEAN_TYPE;}
      break;
    case K_XMLTYPE:
      jj_consume_token(K_XMLTYPE);
                    {if (true) return XMLTYPE_TYPE;}
      break;
    case K_SYSXMLTYPE:
      jj_consume_token(K_SYSXMLTYPE);
                       {if (true) return XMLTYPE_TYPE;}
      break;
    case K_DATE:
      jj_consume_token(K_DATE);
                 {if (true) return DATE_TYPE;}
      break;
    case K_INTERVAL:
      jj_consume_token(K_INTERVAL);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_DAY:
        jj_consume_token(K_DAY);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case O_OPENPAREN:
          jj_consume_token(O_OPENPAREN);
          precision = jj_consume_token(S_NUMBER);
          jj_consume_token(O_CLOSEPAREN);
          break;
        default:
          ;
        }
        jj_consume_token(R_TO);
        jj_consume_token(K_SECOND);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case O_OPENPAREN:
          jj_consume_token(O_OPENPAREN);
          scale = jj_consume_token(S_NUMBER);
          jj_consume_token(O_CLOSEPAREN);
          break;
        default:
          ;
        }
                if (precision == null) {
                        dt = new IntervalDayToSecond();
                    }
                    else {
                        pl = Long.decode(precision.image);
                        if (scale == null) {
                            dt = new IntervalDayToSecond(pl);
                        }
                        else {
                            sl = Long.decode(scale.image);
                            dt = new IntervalDayToSecond(pl, sl);
                        }
                    }
                {if (true) return dt;}
        break;
      case K_YEAR:
        jj_consume_token(K_YEAR);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case O_OPENPAREN:
          jj_consume_token(O_OPENPAREN);
          jj_consume_token(S_NUMBER);
          jj_consume_token(O_CLOSEPAREN);
          break;
        default:
          ;
        }
        jj_consume_token(R_TO);
        jj_consume_token(K_MONTH);
                if (precision == null) {
                    dt = new IntervalYearToMonth();
                }
                else {
                    pl = Long.decode(precision.image);
                    dt = new IntervalYearToMonth(pl);
                }
                {if (true) return dt;}
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case K_TIME:
      jj_consume_token(K_TIME);
                 {if (true) return TIME_TYPE;}
      break;
    case K_TIMESTAMP:
      jj_consume_token(K_TIMESTAMP);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_OPENPAREN:
        jj_consume_token(O_OPENPAREN);
        precision = jj_consume_token(S_NUMBER);
        jj_consume_token(O_CLOSEPAREN);
        break;
      default:
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case R_WITH:
        jj_consume_token(R_WITH);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case K_LOCAL:
          withLocalTimeZone = jj_consume_token(K_LOCAL);
          break;
        default:
          ;
        }
        withTimeZone = jj_consume_token(K_TIME);
        jj_consume_token(K_ZONE);
        break;
      default:
        ;
      }
          if (precision == null) {
              dt = new TimeStampType();
          }
          else {
              pl = Long.decode(precision.image);
              dt = new TimeStampType(pl);
          }
          if (withLocalTimeZone !=  null) {
              ((TimeStampType)dt).setWithLocalTimeZone();
          }
          else if (withTimeZone != null) {
              ((TimeStampType)dt).setWithTimeZone();
          }
          {if (true) return dt;}
      break;
    case K_INTEGER:
      jj_consume_token(K_INTEGER);
                     {if (true) return INTEGER_TYPE;}
      break;
    case K_INT:
      jj_consume_token(K_INT);
                     {if (true) return INTEGER_TYPE;}
      break;
    case K_SMALLINT:
      jj_consume_token(K_SMALLINT);
                     {if (true) return SMALLINT_TYPE;}
      break;
    case K_FLOAT:
      jj_consume_token(K_FLOAT);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_OPENPAREN:
        jj_consume_token(O_OPENPAREN);
        precision = jj_consume_token(S_NUMBER);
        jj_consume_token(O_CLOSEPAREN);
        break;
      default:
        ;
      }
          if (precision == null) {
              {if (true) return new FloatType();}
          }
          else {
              pl = Long.decode(precision.image);
              FloatType ft = new FloatType(pl);
              {if (true) return ft;}
          }
      break;
    case K_REAL:
      jj_consume_token(K_REAL);
                 {if (true) return new RealType();}
      break;
    case K_MLSLABEL:
      jj_consume_token(K_MLSLABEL);
                     {if (true) return MLSLABEL_TYPE;}
      break;
    case K_PLS_INTEGER:
      jj_consume_token(K_PLS_INTEGER);
                        {if (true) return PLS_INTEGER_TYPE;}
      break;
    case K_SIMPLE_INTEGER:
      jj_consume_token(K_SIMPLE_INTEGER);
                           {if (true) return SIMPLE_INTEGER_TYPE;}
      break;
    case K_SIMPLE_FLOAT:
      jj_consume_token(K_SIMPLE_FLOAT);
                         {if (true) return SIMPLE_FLOAT_TYPE;}
      break;
    case K_SIMPLE_DOUBLE:
      jj_consume_token(K_SIMPLE_DOUBLE);
                          {if (true) return SIMPLE_DOUBLE_TYPE;}
      break;
    case K_SYS_REFCURSOR:
      jj_consume_token(K_SYS_REFCURSOR);
                           {if (true) return SYS_REFCURSOR_TYPE;}
      break;
    case K_BLOB:
      jj_consume_token(K_BLOB);
                  {if (true) return new BlobType();}
      break;
    case K_NCLOB:
      jj_consume_token(K_NCLOB);
                  {if (true) return new NClobType();}
      break;
    case K_BFILE:
      jj_consume_token(K_BFILE);
                   {if (true) return BFILE_TYPE;}
      break;
    case K_ROWID:
      jj_consume_token(K_ROWID);
                  {if (true) return ROWID_TYPE;}
      break;
    case K_UROWID:
      jj_consume_token(K_UROWID);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_OPENPAREN:
        jj_consume_token(O_OPENPAREN);
        precision = jj_consume_token(S_NUMBER);
        jj_consume_token(O_CLOSEPAREN);
        break;
      default:
        ;
      }
          if (precision == null) {
              {if (true) return new URowIdType();}
          }
          else {
              pl = Long.decode(precision.image);
              {if (true) return new URowIdType(pl);}
          }
      break;
    case K_DOUBLE:
      jj_consume_token(K_DOUBLE);
      jj_consume_token(K_PRECISION);
                                 {if (true) return new DoubleType();}
      break;
    case K_CHAR:
      jj_consume_token(K_CHAR);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_VARYING:
        t = jj_consume_token(K_VARYING);
        break;
      default:
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_OPENPAREN:
        jj_consume_token(O_OPENPAREN);
        precision = jj_consume_token(S_NUMBER);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case K_BYTE:
        case K_CHAR:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case K_BYTE:
            jj_consume_token(K_BYTE);
            break;
          case K_CHAR:
            jj_consume_token(K_CHAR);
            break;
          default:
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          ;
        }
        jj_consume_token(O_CLOSEPAREN);
        break;
      default:
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_CHARACTER:
        jj_consume_token(K_CHARACTER);
        jj_consume_token(K_SET);
        jj_consume_token(S_IDENTIFIER);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case R_CHARSET:
          jj_consume_token(R_CHARSET);
          break;
        default:
          ;
        }
        break;
      default:
        ;
      }
          if (t == null) {
              if (precision == null) {
                  {if (true) return new CharType();}
              }
              else {
                  pl = Long.decode(precision.image);
                  {if (true) return new CharType(pl);}
              }
          }
          else {
              // ANSI syntax for VARCHAR2
              if (precision == null) {
                  {if (true) return new VarChar2Type();}
              }
              else {
                  pl = Long.decode(precision.image);
                  {if (true) return new VarChar2Type(pl);}
              }
          }
      break;
    case K_VARCHAR:
      jj_consume_token(K_VARCHAR);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_VARYING:
        jj_consume_token(K_VARYING);
        break;
      default:
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_OPENPAREN:
        jj_consume_token(O_OPENPAREN);
        precision = jj_consume_token(S_NUMBER);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case K_BYTE:
        case K_CHAR:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case K_BYTE:
            jj_consume_token(K_BYTE);
            break;
          case K_CHAR:
            jj_consume_token(K_CHAR);
            break;
          default:
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          ;
        }
        jj_consume_token(O_CLOSEPAREN);
        break;
      default:
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_CHARACTER:
        jj_consume_token(K_CHARACTER);
        jj_consume_token(K_SET);
        jj_consume_token(S_IDENTIFIER);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case R_CHARSET:
          jj_consume_token(R_CHARSET);
          break;
        default:
          ;
        }
        break;
      default:
        ;
      }
          if (precision == null) {
              {if (true) return new VarCharType();}
          }
          else {
              pl = Long.decode(precision.image);
              {if (true) return new VarCharType(pl);}
          }
      break;
    case K_VARCHAR2:
      jj_consume_token(K_VARCHAR2);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_VARYING:
        jj_consume_token(K_VARYING);
        break;
      default:
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_OPENPAREN:
        jj_consume_token(O_OPENPAREN);
        precision = jj_consume_token(S_NUMBER);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case K_BYTE:
        case K_CHAR:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case K_BYTE:
            jj_consume_token(K_BYTE);
            break;
          case K_CHAR:
            jj_consume_token(K_CHAR);
            break;
          default:
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          ;
        }
        jj_consume_token(O_CLOSEPAREN);
        break;
      default:
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_CHARACTER:
        jj_consume_token(K_CHARACTER);
        jj_consume_token(K_SET);
        jj_consume_token(S_IDENTIFIER);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case R_CHARSET:
          jj_consume_token(R_CHARSET);
          break;
        default:
          ;
        }
        break;
      default:
        ;
      }
            if (precision == null) {
                {if (true) return new VarChar2Type();}
            }
            else {
                pl = Long.decode(precision.image);
                {if (true) return new VarChar2Type(pl);}
            }
      break;
    case K_CHARACTER:
      jj_consume_token(K_CHARACTER);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_VARYING:
        t = jj_consume_token(K_VARYING);
        break;
      default:
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_OPENPAREN:
        jj_consume_token(O_OPENPAREN);
        precision = jj_consume_token(S_NUMBER);
        jj_consume_token(O_CLOSEPAREN);
        break;
      default:
        ;
      }
          if (t == null) {
              if (precision == null) {
                  {if (true) return new CharType();}
              }
              else {
                  pl = Long.decode(precision.image);
                  {if (true) return new CharType(pl);}
              }
          }
          else {
              // ANSI syntax for VARCHAR
              if (precision == null) {
                  {if (true) return new VarCharType();}
              }
              else {
                  pl = Long.decode(precision.image);
                  {if (true) return new VarCharType(pl);}
              }
          }
      break;
    case K_NCHAR:
      jj_consume_token(K_NCHAR);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_VARYING:
        t = jj_consume_token(K_VARYING);
        break;
      default:
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_OPENPAREN:
        jj_consume_token(O_OPENPAREN);
        precision = jj_consume_token(S_NUMBER);
        jj_consume_token(O_CLOSEPAREN);
        break;
      default:
        ;
      }
          if (t == null) {
              if (precision == null) {
                  {if (true) return new NCharType();}
              }
              else {
                  pl = Long.decode(precision.image);
                  {if (true) return new NCharType(pl);}
              }
          }
          else {
              // ANSI syntax for NVARCHAR2
              if (precision == null) {
                  {if (true) return new NVarChar2Type();}
              }
              else {
                  pl = Long.decode(precision.image);
                  {if (true) return new NVarChar2Type(pl);}
              }
          }
      break;
    case K_NVARCHAR:
      jj_consume_token(K_NVARCHAR);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_OPENPAREN:
        jj_consume_token(O_OPENPAREN);
        precision = jj_consume_token(S_NUMBER);
        jj_consume_token(O_CLOSEPAREN);
        break;
      default:
        ;
      }
            if (precision == null) {
                {if (true) return new NVarChar2Type();}
            }
            else {
                pl = Long.decode(precision.image);
                {if (true) return new NVarChar2Type(pl);}
            }
      break;
    case K_NVARCHAR2:
      jj_consume_token(K_NVARCHAR2);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_OPENPAREN:
        jj_consume_token(O_OPENPAREN);
        precision = jj_consume_token(S_NUMBER);
        jj_consume_token(O_CLOSEPAREN);
        break;
      default:
        ;
      }
            if (precision == null) {
                {if (true) return new NVarChar2Type();}
            }
            else {
                pl = Long.decode(precision.image);
                {if (true) return new NVarChar2Type(pl);}
            }
      break;
    case K_NATIONAL:
      jj_consume_token(K_NATIONAL);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_CHARACTER:
        jj_consume_token(K_CHARACTER);
        break;
      case K_CHAR:
        jj_consume_token(K_CHAR);
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_VARYING:
        t = jj_consume_token(K_VARYING);
        break;
      default:
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_OPENPAREN:
        jj_consume_token(O_OPENPAREN);
        precision = jj_consume_token(S_NUMBER);
        jj_consume_token(O_CLOSEPAREN);
        break;
      default:
        ;
      }
          if (t == null) {
              if (precision == null) {
                  {if (true) return new NCharType();}
              }
              else {
                  pl = Long.decode(precision.image);
                  {if (true) return new NCharType(pl);}
              }
          }
          else {
              // ANSI syntax for NVARCHAR2
              if (precision == null) {
                  {if (true) return new NVarChar2Type();}
              }
              else {
                  pl = Long.decode(precision.image);
                  {if (true) return new NVarChar2Type(pl);}
              }
          }
      break;
    case K_CLOB:
      jj_consume_token(K_CLOB);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_CHARACTER:
        jj_consume_token(K_CHARACTER);
        jj_consume_token(K_SET);
        jj_consume_token(S_IDENTIFIER);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case R_CHARSET:
          jj_consume_token(R_CHARSET);
          break;
        default:
          ;
        }
        break;
      default:
        ;
      }
                                                                          {if (true) return new ClobType();}
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public DatabaseType typeSpec() throws ParseException {
 boolean isTYPEType = false;
 boolean isROWTYPEType = false;
 DatabaseType dataType = null;
 String spec = null;
 String s = null;
    if (jj_2_6(3)) {
      dataType = datatype();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_ARRAY:
      case K_AUTHID:
      case K_BFILE:
      case K_BINARY_DOUBLE:
      case K_BINARY_FLOAT:
      case K_BINARY_INTEGER:
      case K_BLOB:
      case K_BOOLEAN:
      case K_BYTE:
      case K_CHAR:
      case K_CHARACTER:
      case K_CLOB:
      case K_COMMIT:
      case K_CONSTANT:
      case K_CONSTRUCTOR:
      case K_CURRENT_USER:
      case K_DATE:
      case K_DAY:
      case K_DEC:
      case K_DECIMAL:
      case K_DEFINER:
      case K_DELETE:
      case K_DETERMINISTIC:
      case K_DOUBLE:
      case K_EDITIONABLE:
      case K_ENABLE:
      case K_FINAL:
      case K_FLOAT:
      case K_FORCE:
      case K_GLOBAL:
      case K_INSTANTIABLE:
      case K_INT:
      case K_INTEGER:
      case K_INTERVAL:
      case K_KEY:
      case K_LOCAL:
      case K_LONG:
      case K_MLSLABEL:
      case K_MONTH:
      case K_NATIONAL:
      case K_NATURAL:
      case K_NCHAR:
      case K_NCLOB:
      case K_NOCOPY:
      case K_NONEDITIONABLE:
      case K_NUMBER:
      case K_NUMERIC:
      case K_NVARCHAR2:
      case K_NVARCHAR:
      case K_OBJECT:
      case K_OID:
      case K_ORGANIZATION:
      case K_OUT:
      case K_OVERFLOW:
      case K_PACKAGE:
      case K_PARALLEL_ENABLE:
      case K_PIPELINED:
      case K_PLS_INTEGER:
      case K_POSITIVE:
      case K_PRAGMA:
      case K_PRECISION:
      case K_PRESERVE:
      case K_RANGE:
      case K_RAW:
      case K_REAL:
      case K_RECORD:
      case K_REF:
      case K_REPLACE:
      case K_RESULT:
      case K_RESULT_CACHE:
      case K_RETURN:
      case K_ROWID:
      case K_ROWS:
      case K_SECOND:
      case K_SELF:
      case K_SET:
      case K_SIGNTYPE:
      case K_SIMPLE_DOUBLE:
      case K_SIMPLE_FLOAT:
      case K_SIMPLE_INTEGER:
      case K_SMALLINT:
      case K_STRING:
      case K_SYS_REFCURSOR:
      case K_TEMPORARY:
      case K_TIME:
      case K_TIMESTAMP:
      case K_UROWID:
      case K_USING:
      case K_VARCHAR2:
      case K_VARCHAR:
      case K_VARRAY:
      case K_VARYING:
      case K_XMLTYPE:
      case K_SYSXMLTYPE:
      case K_YEAR:
      case K_ZONE:
      case S_IDENTIFIER:
      case S_QUOTED_IDENTIFIER:
        spec = columnSpec();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case O_OPENPAREN:
        case R_ANCHORED_ROWTYPE:
        case R_ANCHORED_TYPE:
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case O_OPENPAREN:
            jj_consume_token(O_OPENPAREN);
            jj_consume_token(S_NUMBER);
            jj_consume_token(O_CLOSEPAREN);
            break;
          case R_ANCHORED_TYPE:
            jj_consume_token(R_ANCHORED_TYPE);
              isTYPEType=true;
              s = spec + removeQuotes(tokenImage[R_ANCHORED_TYPE]);
            break;
          case R_ANCHORED_ROWTYPE:
            jj_consume_token(R_ANCHORED_ROWTYPE);
              isROWTYPEType =true;
              s = spec + removeQuotes(tokenImage[R_ANCHORED_ROWTYPE]);
            break;
          default:
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          ;
        }
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
      if (dataType == null && localTypes != null) {
          // spec may need schema/catalog stripped off
          String tName = spec;
          StringTokenizer stok = new StringTokenizer(spec, ".");
          while (stok.hasMoreTokens()) {
              tName = stok.nextToken();
          }
          for (String typeName : localTypes.keySet()) {
              if (typeName.equals(spec)) {
                  dataType = localTypes.get(spec);
                  break;
              } else if (typeName.equals(tName)) {
                  dataType = localTypes.get(tName);
                  break;
              }
          }
      }
      if (dataType == null) {
          UnresolvedType uType = new UnresolvedType(spec);
          if (isTYPEType) {
              TYPEType tType = new TYPEType(s);
              tType.setEnclosedType(uType);
              uType.setOwningType(tType);
              dataType = tType;
              localTypes.put(spec, dataType);
          }
          else if (isROWTYPEType) {
              ROWTYPEType rType = new ROWTYPEType(s);
              rType.setEnclosedType(uType);
              uType.setOwningType(rType);
              dataType = rType;
              localTypes.put(spec, dataType);
          }
          else {
              dataType = uType;
          }
      }
      {if (true) return dataType;}
    throw new Error("Missing return statement in function");
  }

  final public String columnSpec() throws ParseException {
 String s1 = null;
 String s2 = null;
 String s3 = null;
    s1 = OracleObjectName();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_DOT:
      jj_consume_token(O_DOT);
      s2 = OracleObjectName();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_DOT:
        jj_consume_token(O_DOT);
        s3 = OracleObjectName();
        break;
      default:
        ;
      }
      break;
    default:
      ;
    }
      StringBuilder sb = new StringBuilder(s1);
      if (s2 != null) {
          sb.append('.');
          sb.append(s2);
          if (s3 != null) {
              sb.append('.');
              sb.append(s3);
          }
      }
      {if (true) return sb.toString();}
    throw new Error("Missing return statement in function");
  }

  final public String tableSpec() throws ParseException {
    OracleObjectName();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_DOT:
      jj_consume_token(O_DOT);
      OracleObjectName();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_ATSIGN:
        jj_consume_token(O_ATSIGN);
        jj_consume_token(S_IDENTIFIER);
        break;
      default:
        ;
      }
      break;
    default:
      ;
    }
     {if (true) return token.image;}
    throw new Error("Missing return statement in function");
  }

  final public String typeName() throws ParseException {
    OracleObjectName();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_DOT:
      jj_consume_token(O_DOT);
      OracleObjectName();
      break;
    default:
      ;
    }
     {if (true) return token.image;}
    throw new Error("Missing return statement in function");
  }

  final public void typeOrSubTypeDeclaration(PLSQLPackageType packageType) throws ParseException {
 String s = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_TYPE:
      typeDeclaration(packageType);
      break;
    case R_SUBTYPE:
      subtypeDeclaration(packageType);
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void typeDeclaration(PLSQLPackageType packageType) throws ParseException {
 String s = null;
    jj_consume_token(R_TYPE);
    s = typeName();
    jj_consume_token(R_IS);
    aTypeDeclaration(packageType, s);
    jj_consume_token(O_SEMICOLON);
  }

  final public void aTypeDeclaration(PLSQLPackageType packageType, String typeName) throws ParseException {
 String spec = null;
 String anchoredTypeName = null;
 boolean isTYPEType = false;
 boolean isROWTYPEType = false;
    if (jj_2_7(2)) {
      recordDeclaration(packageType, typeName);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case R_TABLE:
        plsqlTableDeclaration(packageType, typeName);
        break;
      default:
        if (jj_2_8(2)) {
          varrayDeclaration(packageType);
        } else if (jj_2_9(2)) {
          refCursorDeclaration(packageType, typeName);
        } else if (jj_2_10(2)) {
          spec = columnSpec();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case R_ANCHORED_TYPE:
            jj_consume_token(R_ANCHORED_TYPE);
            isTYPEType=true;
            anchoredTypeName = spec + removeQuotes(tokenImage[R_ANCHORED_TYPE]);
            break;
          case R_ANCHORED_ROWTYPE:
            jj_consume_token(R_ANCHORED_ROWTYPE);
            isROWTYPEType =true;
            anchoredTypeName = spec + removeQuotes(tokenImage[R_ANCHORED_ROWTYPE]);
            break;
          default:
            jj_consume_token(-1);
            throw new ParseException();
          }
         DatabaseType dataType = null;
         UnresolvedType uType = new UnresolvedType(anchoredTypeName);
         if (isTYPEType) {
             TYPEType tType = new TYPEType(anchoredTypeName);
             tType.setEnclosedType(uType);
             uType.setOwningType(tType);
             dataType = tType;
         }
         else if (isROWTYPEType) {
             ROWTYPEType rType = new ROWTYPEType(anchoredTypeName);
             rType.setEnclosedType(uType);
             rType.setPackageType(packageType);
             uType.setOwningType(rType);
             dataType = rType;
         }
         PLSQLType newType = new PLSQLType(typeName);
         newType.setEnclosedType(dataType);
         packageType.addType(newType);
         localTypes.put(typeName, newType);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

  final public void recordDeclaration(PLSQLPackageType packageType, String typeName) throws ParseException {
  PLSQLRecordType plsqlRecordType = new PLSQLRecordType(typeName);
  plsqlRecordType.setParentType(packageType);
    jj_consume_token(K_RECORD);
    jj_consume_token(O_OPENPAREN);
    fieldDeclarations(plsqlRecordType);
    jj_consume_token(O_CLOSEPAREN);
      packageType.addType(plsqlRecordType);
      localTypes.put(typeName, plsqlRecordType);
  }

  final public void fieldDeclarations(PLSQLRecordType plsqlRecordType) throws ParseException {
    fieldDeclaration(plsqlRecordType);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_COMMA:
      jj_consume_token(O_COMMA);
      fieldDeclarations(plsqlRecordType);
      break;
    default:
      ;
    }
  }

  final public void fieldDeclaration(PLSQLRecordType plsqlRecordType) throws ParseException {
  String s = null;
  DatabaseType dataType = null;
  FieldType fieldType = null;
    s = typeName();
    dataType = typeSpec();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_NOT:
      jj_consume_token(R_NOT);
      jj_consume_token(R_NULL);
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_ASSIGN:
    case R_DEFAULT:
      fieldDefaultAssignment();
      break;
    default:
      ;
    }
      fieldType = new FieldType(s);
      fieldType.setEnclosedType(dataType);
      plsqlRecordType.addField(fieldType);
      if (dataType instanceof UnresolvedType) {
          ((UnresolvedType)dataType).setOwningType(plsqlRecordType);
      }
  }

  final public void fieldDefaultAssignment() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_ASSIGN:
      jj_consume_token(O_ASSIGN);
      break;
    case R_DEFAULT:
      jj_consume_token(R_DEFAULT);
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
    skipToNextArg();
  }

  final public void subtypeDeclaration(PLSQLPackageType packageType) throws ParseException {
 String subtypeName;
DatabaseType subtype;
Token notNull = null;
Token rangeStart = null;
Token rangeEnd = null;
    jj_consume_token(R_SUBTYPE);
    subtypeName = OracleObjectName();
    jj_consume_token(R_IS);
    subtype = typeSpec();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_RANGE:
      jj_consume_token(K_RANGE);
      rangeStart = jj_consume_token(S_NUMBER);
      jj_consume_token(O_DOUBLEDOT);
      rangeEnd = jj_consume_token(S_NUMBER);
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_NOT:
      jj_consume_token(R_NOT);
      notNull = jj_consume_token(R_NULL);
      break;
    default:
      ;
    }
    jj_consume_token(O_SEMICOLON);
      PLSQLSubType newPLSQLSubType = new PLSQLSubType(subtypeName);
      newPLSQLSubType.setEnclosedType(subtype);
      if (subtype instanceof UnresolvedType) {
          ((UnresolvedType)subtype).setOwningType(newPLSQLSubType);
      }
      if (subtype.isROWTYPEType()) {
         ((ROWTYPEType)subtype).setPackageType(packageType);
      }
      packageType.addType(newPLSQLSubType);
      if (notNull != null) {
          newPLSQLSubType.setNotNull(true);
      }
      if (rangeStart != null) {
          long rStart = Long.decode(rangeStart.image).longValue();
          long rEnd = Long.decode(rangeEnd.image).longValue();
          newPLSQLSubType.setHasRange(true);
          newPLSQLSubType.setRangeStart(rStart);
          newPLSQLSubType.setRangeEnd(rEnd);
      }
      localTypes.put(subtypeName, newPLSQLSubType);
  }

  final public void plsqlTableDeclaration(PLSQLPackageType packageType, String typeName) throws ParseException {
  PLSQLCollectionType plsqlTable = new PLSQLCollectionType(typeName);
  plsqlTable.setParentType(packageType);
  DatabaseType nestedType;
    jj_consume_token(R_TABLE);
    jj_consume_token(R_OF);
    nestedType = typeSpec();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_NOT:
      jj_consume_token(R_NOT);
      jj_consume_token(R_NULL);
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_INDEX:
      jj_consume_token(R_INDEX);
      jj_consume_token(R_BY);
      plsqlTableIndexByDeclaration(plsqlTable);
      break;
    default:
      ;
    }
      if (nestedType instanceof UnresolvedType) {
        ((UnresolvedType)nestedType).setOwningType(plsqlTable);
      }
      plsqlTable.setEnclosedType(nestedType);
      packageType.addType(plsqlTable);
      localTypes.put(typeName, plsqlTable);
  }

  final public void plsqlTableIndexByDeclaration(PLSQLCollectionType plsqlTable) throws ParseException {
  DatabaseType indexType = null;
  Token precision = null;
  Token otherIndexByType = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_PLS_INTEGER:
      jj_consume_token(K_PLS_INTEGER);
                       indexType = PLS_INTEGER_TYPE;
      break;
    case K_BINARY_INTEGER:
      jj_consume_token(K_BINARY_INTEGER);
                           indexType = BINARY_INTEGER_TYPE;
      break;
    case K_VARCHAR2:
      jj_consume_token(K_VARCHAR2);
      jj_consume_token(O_OPENPAREN);
      precision = jj_consume_token(S_NUMBER);
      jj_consume_token(O_CLOSEPAREN);
        if (precision == null) {
            indexType = new VarChar2Type();
        }
        else {
            Long pl = Long.decode(precision.image);
            indexType = new VarChar2Type(pl);
        }
      break;
    case K_STRING:
      otherIndexByType = jj_consume_token(K_STRING);
      jj_consume_token(O_OPENPAREN);
      jj_consume_token(S_NUMBER);
      jj_consume_token(O_CLOSEPAREN);
        String indexTypename = otherIndexByType.image;
        for (String typeName : localTypes.keySet()) {
            if (typeName.equals(indexTypename)) {
                indexType = localTypes.get(indexTypename);
                break;
            }
        }
        //what else can INDEX BY be? Unresolved for now ...
        if (indexType == null) {
            indexType = new UnresolvedType(indexTypename);
            ((UnresolvedType)indexType).setOwningType(plsqlTable);
        }
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
      plsqlTable.setIndexed(true);
      plsqlTable.setIndexType(indexType);
  }

  final public void varrayDeclaration(PLSQLPackageType packageType) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_VARRAY:
      jj_consume_token(K_VARRAY);
      break;
    case K_VARYING:
      jj_consume_token(K_VARYING);
      jj_consume_token(K_ARRAY);
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(O_OPENPAREN);
    jj_consume_token(S_NUMBER);
    jj_consume_token(O_CLOSEPAREN);
    jj_consume_token(R_OF);
    datatype();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_NOT:
      jj_consume_token(R_NOT);
      jj_consume_token(R_NULL);
      break;
    default:
      ;
    }
  }

  final public void refCursorDeclaration(PLSQLPackageType packageType, String cursorTypeName) throws ParseException {
 PLSQLCursorType cursorType = null;
    jj_consume_token(K_REF);
    jj_consume_token(R_CURSOR);
        cursorType = new PLSQLCursorType(cursorTypeName);
        cursorType.setParentType(packageType);
        packageType.addCursor(cursorType);
        localTypes.put(cursorTypeName, cursorType);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_RETURN:
      refCursorTypeSpec(cursorType, packageType);
      break;
    default:
      ;
    }
  }

  final public void refCursorTypeSpec(PLSQLCursorType cursorType, PLSQLPackageType packageType) throws ParseException {
 String s = null;
 String spec = null;
 boolean isTYPEType = false;
 boolean isROWTYPEType = false;
 DatabaseType localType = null;
    jj_consume_token(K_RETURN);
    spec = OracleObjectName();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_ANCHORED_ROWTYPE:
    case R_ANCHORED_TYPE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case R_ANCHORED_TYPE:
        jj_consume_token(R_ANCHORED_TYPE);
                  isTYPEType = true;
                  s = spec + removeQuotes(tokenImage[R_ANCHORED_TYPE]);
        break;
      case R_ANCHORED_ROWTYPE:
        jj_consume_token(R_ANCHORED_ROWTYPE);
              isROWTYPEType = true;
              s = spec + removeQuotes(tokenImage[R_ANCHORED_ROWTYPE]);
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      ;
    }
      //check local variables first
      for (FieldType varField : packageType.getLocalVariables()) {
          if (spec.equals(varField.getFieldName())) {
                  if (isTYPEType) {
                      TYPEType tType = new TYPEType(s);
                      UnresolvedType uType = new UnresolvedType(s);
                      tType.setEnclosedType(uType);
                      uType.setOwningType(tType);
                      localType = tType;
                  }
                  else if (isROWTYPEType) {
                      ROWTYPEType rType = new ROWTYPEType(s);
                      rType.setPackageType(packageType);
                      UnresolvedType uType = new UnresolvedType(s);
                      rType.setEnclosedType(uType);
                      uType.setOwningType(rType);
                      localType = rType;
                  }
                  else {
                      localType = varField.getEnclosedType();
                  }
                  cursorType.setEnclosedType(localType);
              break;
          }
      }
      if (localType == null) {
          localType = localTypes.get(spec);
          if (localType == null) {
              UnresolvedType uType = new UnresolvedType(spec);
              if (isTYPEType) {
                  TYPEType tType = new TYPEType(s);
                  tType.setEnclosedType(uType);
                  uType.setOwningType(tType);
                  cursorType.setEnclosedType(tType);
              }
              else if (isROWTYPEType) {
                  ROWTYPEType rType = new ROWTYPEType(s);
                  rType.setEnclosedType(uType);
                  rType.setPackageType(packageType);
                  uType.setOwningType(rType);
                  cursorType.setEnclosedType(rType);
              }
              else {
                  uType.setOwningType(cursorType);
                  cursorType.setEnclosedType(uType);
              }
          }
          else {
              cursorType.setEnclosedType(localType);
         }
      }
  }

  final public void cursorDeclaration(PLSQLPackageType packageType) throws ParseException {
 Token t = null;
    jj_consume_token(R_CURSOR);
    skipToSemiColon();
  }

// Procedure Specification
  final public void procedureSpec(PLSQLPackageType packageType) throws ParseException {
 String procedureName= null;
 ProcedureType procedureType = null;
    jj_consume_token(R_PROCEDURE);
    procedureName = OracleObjectName();
            procedureType = new ProcedureType(procedureName);
            procedureType.setCatalogName(packageType.getPackageName());
            procedureType.setSchema(packageType.getSchema());
            procedureType.setParentType(packageType);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_OPENPAREN:
      jj_consume_token(O_OPENPAREN);
      argumentList(procedureType);
      jj_consume_token(O_CLOSEPAREN);
      break;
    default:
      ;
    }
    jj_consume_token(O_SEMICOLON);
      packageType.addProcedure(procedureType);
      for (ArgumentType argumentType : procedureType.getArguments()) {
          DatabaseType databaseType = argumentType.getEnclosedType();
          if (databaseType.isROWTYPEType()) {
              ((ROWTYPEType)databaseType).setPackageType(packageType);
          }
      }
  }

  final public void argumentList(ProcedureType procedureType) throws ParseException {
    argument(procedureType);
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case O_COMMA:
        ;
        break;
      default:
        break label_5;
      }
      jj_consume_token(O_COMMA);
      argument(procedureType);
    }
  }

// Member Function/Procedure Specification - ignore both
  final public void memberFunctionOrProcedureDeclaration() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_STATIC:
      jj_consume_token(R_STATIC);
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_MEMBER:
      jj_consume_token(R_MEMBER);
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_FUNCTION:
    case R_PROCEDURE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case R_PROCEDURE:
        jj_consume_token(R_PROCEDURE);
        skipToClosingParen();
        jj_consume_token(O_CLOSEPAREN);
        break;
      case R_FUNCTION:
        jj_consume_token(R_FUNCTION);
        skipToReturn();
        datatype();
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_COMMA:
      jj_consume_token(O_COMMA);
      memberFunctionOrProcedureDeclaration();
      break;
    default:
      ;
    }
  }

// Function Specification
  final public void functionSpec(PLSQLPackageType packageType) throws ParseException {
 String functionName= null;
 FunctionType functionType = null;
 ArgumentType returnDataType = null;
    jj_consume_token(R_FUNCTION);
    functionName = OracleObjectName();
            functionType = new FunctionType(functionName);
            functionType.setCatalogName(packageType.getPackageName());
            functionType.setSchema(packageType.getSchema());
            functionType.setParentType(packageType);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_OPENPAREN:
      jj_consume_token(O_OPENPAREN);
      argumentList(functionType);
      jj_consume_token(O_CLOSEPAREN);
      break;
    default:
      ;
    }
    returnDataType = functionReturnSpec(functionType);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_DETERMINISTIC:
    case K_PARALLEL_ENABLE:
    case K_PIPELINED:
    case K_RESULT_CACHE:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_DETERMINISTIC:
        jj_consume_token(K_DETERMINISTIC);
        break;
      case K_PIPELINED:
        jj_consume_token(K_PIPELINED);
        break;
      case K_PARALLEL_ENABLE:
        jj_consume_token(K_PARALLEL_ENABLE);
        break;
      case K_RESULT_CACHE:
        jj_consume_token(K_RESULT_CACHE);
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      ;
    }
    jj_consume_token(O_SEMICOLON);
      functionType.setReturnArgument(returnDataType);
      packageType.addProcedure(functionType);
      for (ArgumentType argumentType : functionType.getArguments()) {
          DatabaseType databaseType = argumentType.getEnclosedType();
          if (databaseType.isROWTYPEType()) {
              ((ROWTYPEType)databaseType).setPackageType(packageType);
          }
      }
      if (returnDataType.getEnclosedType().isROWTYPEType()) {
          ((ROWTYPEType)returnDataType.getEnclosedType()).setPackageType(packageType);
      }
  }

  final public ArgumentType functionReturnSpec(FunctionType functionType) throws ParseException {
 DatabaseType dataType = null;
    jj_consume_token(K_RETURN);
    dataType = typeSpec();
      ArgumentType returnType = new ArgumentType(null);
      returnType.setDirection(ArgumentTypeDirection.RETURN);
      // may need to strip off schema/catalog name
      if (dataType.getTypeName().contains(".")) {
          String dataTypeName = dataType.getTypeName();
          int dotIdx = dataTypeName.indexOf('.');
          String namePart1 = dataTypeName.substring(0, dotIdx);
          String namePart2 = dataTypeName.substring(dotIdx+1, dataTypeName.length());
          if (namePart1.equals(functionType.getCatalogName()) || namePart1.equals(functionType.getSchema())) {
              dataType.setTypeName(namePart2);
          } else if (schemaPatterns != null) {
              for (String possibleSchemaName : schemaPatterns) {
                  if (namePart1.equals(possibleSchemaName)) {
                      dataType.setTypeName(namePart2);
                      break;
                  }
              }
          }
      }
      returnType.setEnclosedType(dataType);
      if (dataType instanceof UnresolvedType) {
          ((UnresolvedType)dataType).setOwningType(returnType);
      }
      {if (true) return returnType;}
    throw new Error("Missing return statement in function");
  }

  final public void argument(ProcedureType procedureType) throws ParseException {
 String s = null;
 ArgumentType argumentType = null;
 DatabaseType argumentDataType = null;
 ArgumentTypeDirection argDirection = ArgumentTypeDirection.IN; // by default, arguments are IN
 String direction = null;
 boolean defaultAssignment = false;
    s = OracleObjectName();
    if (jj_2_11(2)) {
      direction = direction();
    } else {
      ;
    }
    if (jj_2_12(2)) {
      jj_consume_token(K_NOCOPY);
    } else {
      ;
    }
    argumentDataType = typeSpec();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_ASSIGN:
    case R_DEFAULT:
      defaultAssignment = argumentDefaultAssignment();
      break;
    default:
      ;
    }
      // may need to strip off schema/catalog name
      if (argumentDataType.getTypeName().contains(".")) {
          String argumentDataTypeName = argumentDataType.getTypeName();
          int dotIdx = argumentDataTypeName.indexOf('.');
          String namePart1 = argumentDataTypeName.substring(0, dotIdx);
          String namePart2 = argumentDataTypeName.substring(dotIdx+1, argumentDataTypeName.length());
          if (namePart1.equals(procedureType.getCatalogName()) || namePart1.equals(procedureType.getSchema())) {
              argumentDataType.setTypeName(namePart2);
          } else if (schemaPatterns != null) {
              for (String possibleSchemaName : schemaPatterns) {
                  if (namePart1.equals(possibleSchemaName)) {
                      argumentDataType.setTypeName(namePart2);
                      break;
                  }
              }
          }
      }
      argumentType = new ArgumentType(s);
      argumentType.setEnclosedType(argumentDataType);
      if (argumentDataType instanceof UnresolvedType) {
          ((UnresolvedType)argumentDataType).setOwningType(argumentType);
      }
      if (direction != null) {
          if ("OUT".equals(direction)) {
              argDirection = ArgumentTypeDirection.OUT;
          }
          else if ("IN OUT".equals(direction)) {
              argDirection = ArgumentTypeDirection.INOUT;
          }
      }
      argumentType.setDirection(argDirection);
      if (defaultAssignment) {
          argumentType.setOptional();
      }
      procedureType.addArgument(argumentType);
  }

  final public boolean argumentDefaultAssignment() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_ASSIGN:
      jj_consume_token(O_ASSIGN);
      break;
    case R_DEFAULT:
      jj_consume_token(R_DEFAULT);
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
    skipToNextArg();
      {if (true) return true;}
    throw new Error("Missing return statement in function");
  }

  final public void exceptionDeclaration() throws ParseException {
    jj_consume_token(S_IDENTIFIER);
    jj_consume_token(R_EXCEPTION);
    jj_consume_token(O_SEMICOLON);
  }

  final public void pragmaDeclaration() throws ParseException {
    jj_consume_token(K_PRAGMA);
    skipToSemiColon();
  }

  final public void orReplace() throws ParseException {
    jj_consume_token(R_OR);
    jj_consume_token(K_REPLACE);
  }

  final public void invokerRights() throws ParseException {
    jj_consume_token(K_AUTHID);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_CURRENT_USER:
      jj_consume_token(K_CURRENT_USER);
      break;
    case K_DEFINER:
      jj_consume_token(K_DEFINER);
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void as() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_AS:
      jj_consume_token(R_AS);
      break;
    case R_IS:
      jj_consume_token(R_IS);
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void onCommit() throws ParseException {
    jj_consume_token(R_ON);
    jj_consume_token(K_COMMIT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_DELETE:
      jj_consume_token(K_DELETE);
      break;
    case K_PRESERVE:
      jj_consume_token(K_PRESERVE);
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(K_ROWS);
  }

  final public boolean notNull() throws ParseException {
    jj_consume_token(R_NOT);
    jj_consume_token(R_NULL);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case K_ENABLE:
      jj_consume_token(K_ENABLE);
      break;
    default:
      ;
    }
      {if (true) return true;}
    throw new Error("Missing return statement in function");
  }

  final public String direction() throws ParseException {
 String dir = "";
    if (jj_2_14(2)) {
      jj_consume_token(R_IN);
                dir = "IN";
      if (jj_2_13(2)) {
        jj_consume_token(K_OUT);
                                                     dir += " OUT";
      } else {
        ;
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case K_OUT:
        jj_consume_token(K_OUT);
                 dir = "OUT";
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
      {if (true) return dir;}
    throw new Error("Missing return statement in function");
  }

  final public String OracleObjectName() throws ParseException {
 String keyword=null;
    if (jj_2_15(2)) {
      keyword = keywords();
                          {if (true) return keyword;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case S_IDENTIFIER:
        jj_consume_token(S_IDENTIFIER);
                      {if (true) return token.image;}
        break;
      case S_QUOTED_IDENTIFIER:
        jj_consume_token(S_QUOTED_IDENTIFIER);
                              {if (true) return removeQuotes(token.image);}
        break;
      default:
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public String OracleObjectNamePossiblyDotted() throws ParseException {
 String possiblyDottedName = "";
 String afterDot = null;
    possiblyDottedName = OracleObjectName();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case O_DOT:
      jj_consume_token(O_DOT);
      afterDot = OracleObjectName();
      break;
    default:
      ;
    }
      if (afterDot != null) {
          possiblyDottedName += "." + afterDot;
      }
      {if (true) return possiblyDottedName;}
    throw new Error("Missing return statement in function");
  }

  final public void skipToSemiColon() throws ParseException {
        Token t = getNextToken();
        while (t.kind != O_SEMICOLON) {
                t = getNextToken();
        }
        token_source.input_stream.backup(1);
  }

  final public void skipToClosingParen() throws ParseException {
        Token t = getNextToken();
        while (t.kind != O_CLOSEPAREN) {
            t = getNextToken();
        }
        token_source.input_stream.backup(1);
  }

  final public void skipToNextArg() throws ParseException {
        Token t = getNextToken();
        while (t.kind != O_COMMA && t.kind != O_CLOSEPAREN) {
            t = getNextToken();
        }
        token_source.input_stream.backup(1);
  }

  final public void skipToEnd() throws ParseException {
      /** skip through all the tokens. */
      Token t = getNextToken();
      while (t.kind != EOF) {
          t = getNextToken();
      }
  }

  final public void skipToReturn() throws ParseException {
        Token t = getNextToken();
        while (t.kind != K_RETURN) {
                t = getNextToken();
        }
  }

  final public void constructor() throws ParseException {
     Token t = token;
    jj_consume_token(K_CONSTRUCTOR);
    token = t;
  }

  final public void memberFunctionOrProcedure() throws ParseException {
     Token t = token;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_STATIC:
      jj_consume_token(R_STATIC);
      break;
    default:
      ;
    }
    jj_consume_token(R_MEMBER);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case R_FUNCTION:
      jj_consume_token(R_FUNCTION);
      break;
    case R_PROCEDURE:
      jj_consume_token(R_PROCEDURE);
      break;
    default:
      jj_consume_token(-1);
      throw new ParseException();
    }
        token = t;
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
  }

  private boolean jj_3R_10() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(220)) {
    jj_scanpos = xsp;
    if (jj_3R_61()) return true;
    }
    if (jj_scan_token(O_OPENPAREN)) return true;
    return false;
  }

  private boolean jj_3R_75() {
    if (jj_scan_token(O_OPENPAREN)) return true;
    if (jj_scan_token(S_NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_53() {
    if (jj_scan_token(K_CHARACTER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(221)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_79()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_89() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(9)) {
    jj_scanpos = xsp;
    if (jj_scan_token(35)) return true;
    }
    return false;
  }

  private boolean jj_3R_78() {
    if (jj_scan_token(K_CHARACTER)) return true;
    if (jj_scan_token(K_SET)) return true;
    return false;
  }

  private boolean jj_3R_62() {
    if (jj_scan_token(O_DOT)) return true;
    return false;
  }

  private boolean jj_3R_52() {
    if (jj_scan_token(K_VARCHAR2)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(221)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_77()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_78()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_73() {
    if (jj_scan_token(O_OPENPAREN)) return true;
    if (jj_scan_token(S_NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_76() {
    if (jj_scan_token(K_CHARACTER)) return true;
    if (jj_scan_token(K_SET)) return true;
    return false;
  }

  private boolean jj_3R_64() {
    if (jj_scan_token(O_OPENPAREN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_89()) jj_scanpos = xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_90()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(O_CLOSEPAREN)) return true;
    return false;
  }

  private boolean jj_3R_51() {
    if (jj_scan_token(K_VARCHAR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(221)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_75()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_76()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_13() {
    if (jj_scan_token(K_OUT)) return true;
    return false;
  }

  private boolean jj_3R_23() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(175)) {
    jj_scanpos = xsp;
    if (jj_scan_token(176)) {
    jj_scanpos = xsp;
    if (jj_scan_token(149)) {
    jj_scanpos = xsp;
    if (jj_scan_token(148)) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_64()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_22() {
    if (jj_scan_token(K_SIGNTYPE)) return true;
    return false;
  }

  private boolean jj_3R_12() {
    if (jj_3R_59()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_62()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_21() {
    if (jj_scan_token(K_POSITIVE)) return true;
    return false;
  }

  private boolean jj_3R_20() {
    if (jj_scan_token(K_NATURAL)) return true;
    return false;
  }

  private boolean jj_3R_85() {
    if (jj_scan_token(S_QUOTED_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_19() {
    if (jj_scan_token(K_BINARY_DOUBLE)) return true;
    return false;
  }

  private boolean jj_3R_84() {
    if (jj_scan_token(S_IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_6()) return true;
    return false;
  }

  private boolean jj_3R_18() {
    if (jj_scan_token(K_BINARY_FLOAT)) return true;
    return false;
  }

  private boolean jj_3_15() {
    if (jj_3R_16()) return true;
    return false;
  }

  private boolean jj_3R_59() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_15()) {
    jj_scanpos = xsp;
    if (jj_3R_84()) {
    jj_scanpos = xsp;
    if (jj_3R_85()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_17() {
    if (jj_scan_token(K_BINARY_INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_7() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_17()) {
    jj_scanpos = xsp;
    if (jj_3R_18()) {
    jj_scanpos = xsp;
    if (jj_3R_19()) {
    jj_scanpos = xsp;
    if (jj_3R_20()) {
    jj_scanpos = xsp;
    if (jj_3R_21()) {
    jj_scanpos = xsp;
    if (jj_3R_22()) {
    jj_scanpos = xsp;
    if (jj_3R_23()) {
    jj_scanpos = xsp;
    if (jj_3R_24()) {
    jj_scanpos = xsp;
    if (jj_3R_25()) {
    jj_scanpos = xsp;
    if (jj_3R_26()) {
    jj_scanpos = xsp;
    if (jj_3R_27()) {
    jj_scanpos = xsp;
    if (jj_3R_28()) {
    jj_scanpos = xsp;
    if (jj_3R_29()) {
    jj_scanpos = xsp;
    if (jj_3R_30()) {
    jj_scanpos = xsp;
    if (jj_3R_31()) {
    jj_scanpos = xsp;
    if (jj_3R_32()) {
    jj_scanpos = xsp;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) {
    jj_scanpos = xsp;
    if (jj_3R_35()) {
    jj_scanpos = xsp;
    if (jj_3R_36()) {
    jj_scanpos = xsp;
    if (jj_3R_37()) {
    jj_scanpos = xsp;
    if (jj_3R_38()) {
    jj_scanpos = xsp;
    if (jj_3R_39()) {
    jj_scanpos = xsp;
    if (jj_3R_40()) {
    jj_scanpos = xsp;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) {
    jj_scanpos = xsp;
    if (jj_3R_44()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) {
    jj_scanpos = xsp;
    if (jj_3R_46()) {
    jj_scanpos = xsp;
    if (jj_3R_47()) {
    jj_scanpos = xsp;
    if (jj_3R_48()) {
    jj_scanpos = xsp;
    if (jj_3R_49()) {
    jj_scanpos = xsp;
    if (jj_3R_50()) {
    jj_scanpos = xsp;
    if (jj_3R_51()) {
    jj_scanpos = xsp;
    if (jj_3R_52()) {
    jj_scanpos = xsp;
    if (jj_3R_53()) {
    jj_scanpos = xsp;
    if (jj_3R_54()) {
    jj_scanpos = xsp;
    if (jj_3R_55()) {
    jj_scanpos = xsp;
    if (jj_3R_56()) {
    jj_scanpos = xsp;
    if (jj_3R_57()) {
    jj_scanpos = xsp;
    if (jj_3R_58()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_74() {
    if (jj_scan_token(K_CHARACTER)) return true;
    if (jj_scan_token(K_SET)) return true;
    return false;
  }

  private boolean jj_3R_72() {
    if (jj_scan_token(O_OPENPAREN)) return true;
    if (jj_scan_token(S_NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_63() {
    if (jj_scan_token(K_OUT)) return true;
    return false;
  }

  private boolean jj_3R_50() {
    if (jj_scan_token(K_CHAR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(221)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_73()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_74()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_49() {
    if (jj_scan_token(K_DOUBLE)) return true;
    if (jj_scan_token(K_PRECISION)) return true;
    return false;
  }

  private boolean jj_3_14() {
    if (jj_scan_token(R_IN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_13()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_15() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_14()) {
    jj_scanpos = xsp;
    if (jj_3R_63()) return true;
    }
    return false;
  }

  private boolean jj_3R_48() {
    if (jj_scan_token(K_UROWID)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_72()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_47() {
    if (jj_scan_token(K_ROWID)) return true;
    return false;
  }

  private boolean jj_3R_46() {
    if (jj_scan_token(K_BFILE)) return true;
    return false;
  }

  private boolean jj_3R_45() {
    if (jj_scan_token(K_NCLOB)) return true;
    return false;
  }

  private boolean jj_3R_44() {
    if (jj_scan_token(K_BLOB)) return true;
    return false;
  }

  private boolean jj_3R_43() {
    if (jj_scan_token(K_SYS_REFCURSOR)) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_scan_token(K_CONSTANT)) return true;
    return false;
  }

  private boolean jj_3R_42() {
    if (jj_scan_token(K_SIMPLE_DOUBLE)) return true;
    return false;
  }

  private boolean jj_3R_41() {
    if (jj_scan_token(K_SIMPLE_FLOAT)) return true;
    return false;
  }

  private boolean jj_3R_60() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_4()) jj_scanpos = xsp;
    if (jj_3R_86()) return true;
    return false;
  }

  private boolean jj_3R_40() {
    if (jj_scan_token(K_SIMPLE_INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_87() {
    if (jj_scan_token(O_OPENPAREN)) return true;
    return false;
  }

  private boolean jj_3_5() {
    if (jj_scan_token(R_EXCEPTION)) return true;
    return false;
  }

  private boolean jj_3R_39() {
    if (jj_scan_token(K_PLS_INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_71() {
    if (jj_scan_token(O_OPENPAREN)) return true;
    if (jj_scan_token(S_NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_38() {
    if (jj_scan_token(K_MLSLABEL)) return true;
    return false;
  }

  private boolean jj_3R_37() {
    if (jj_scan_token(K_REAL)) return true;
    return false;
  }

  private boolean jj_3R_8() {
    if (jj_3R_59()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3R_60()) return true;
    }
    return false;
  }

  private boolean jj_3_3() {
    if (jj_3R_8()) return true;
    return false;
  }

  private boolean jj_3R_36() {
    if (jj_scan_token(K_FLOAT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_71()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_35() {
    if (jj_scan_token(K_SMALLINT)) return true;
    return false;
  }

  private boolean jj_3R_34() {
    if (jj_scan_token(K_INT)) return true;
    return false;
  }

  private boolean jj_3R_33() {
    if (jj_scan_token(K_INTEGER)) return true;
    return false;
  }

  private boolean jj_3R_69() {
    if (jj_scan_token(O_OPENPAREN)) return true;
    if (jj_scan_token(S_NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_88() {
    if (jj_3R_12()) return true;
    return false;
  }

  private boolean jj_3_6() {
    if (jj_3R_7()) return true;
    return false;
  }

  private boolean jj_3R_92() {
    if (jj_scan_token(O_OPENPAREN)) return true;
    return false;
  }

  private boolean jj_3R_83() {
    if (jj_scan_token(K_CHARACTER)) return true;
    if (jj_scan_token(K_SET)) return true;
    return false;
  }

  private boolean jj_3R_70() {
    if (jj_scan_token(R_WITH)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(165)) jj_scanpos = xsp;
    if (jj_scan_token(K_TIME)) return true;
    return false;
  }

  private boolean jj_3R_86() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_6()) {
    jj_scanpos = xsp;
    if (jj_3R_88()) return true;
    }
    return false;
  }

  private boolean jj_3R_32() {
    if (jj_scan_token(K_TIMESTAMP)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_69()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_70()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_31() {
    if (jj_scan_token(K_TIME)) return true;
    return false;
  }

  private boolean jj_3R_68() {
    if (jj_scan_token(K_YEAR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_92()) jj_scanpos = xsp;
    if (jj_scan_token(R_TO)) return true;
    return false;
  }

  private boolean jj_3R_58() {
    if (jj_scan_token(K_CLOB)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_83()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_91() {
    if (jj_scan_token(O_OPENPAREN)) return true;
    return false;
  }

  private boolean jj_3R_82() {
    if (jj_scan_token(O_OPENPAREN)) return true;
    if (jj_scan_token(S_NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_67() {
    if (jj_scan_token(K_DAY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_91()) jj_scanpos = xsp;
    if (jj_scan_token(R_TO)) return true;
    return false;
  }

  private boolean jj_3R_9() {
    if (jj_scan_token(K_RECORD)) return true;
    if (jj_scan_token(O_OPENPAREN)) return true;
    return false;
  }

  private boolean jj_3R_57() {
    if (jj_scan_token(K_NATIONAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(140)) {
    jj_scanpos = xsp;
    if (jj_scan_token(139)) return true;
    }
    xsp = jj_scanpos;
    if (jj_scan_token(221)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_87()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_30() {
    if (jj_scan_token(K_INTERVAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_67()) {
    jj_scanpos = xsp;
    if (jj_3R_68()) return true;
    }
    return false;
  }

  private boolean jj_3R_81() {
    if (jj_scan_token(O_OPENPAREN)) return true;
    if (jj_scan_token(S_NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_29() {
    if (jj_scan_token(K_DATE)) return true;
    return false;
  }

  private boolean jj_3R_28() {
    if (jj_scan_token(K_SYSXMLTYPE)) return true;
    return false;
  }

  private boolean jj_3_11() {
    if (jj_3R_15()) return true;
    return false;
  }

  private boolean jj_3R_27() {
    if (jj_scan_token(K_XMLTYPE)) return true;
    return false;
  }

  private boolean jj_3R_26() {
    if (jj_scan_token(K_BOOLEAN)) return true;
    return false;
  }

  private boolean jj_3R_66() {
    if (jj_scan_token(O_OPENPAREN)) return true;
    if (jj_scan_token(S_NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_56() {
    if (jj_scan_token(K_NVARCHAR2)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_82()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_80() {
    if (jj_scan_token(O_OPENPAREN)) return true;
    if (jj_scan_token(S_NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_65() {
    if (jj_scan_token(O_OPENPAREN)) return true;
    if (jj_scan_token(S_NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_90() {
    if (jj_scan_token(O_COMMA)) return true;
    return false;
  }

  private boolean jj_3R_25() {
    if (jj_scan_token(K_RAW)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_66()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_55() {
    if (jj_scan_token(K_NVARCHAR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_81()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_6() {
    if (jj_scan_token(K_CONSTRUCTOR)) return true;
    return false;
  }

  private boolean jj_3_12() {
    if (jj_scan_token(K_NOCOPY)) return true;
    return false;
  }

  private boolean jj_3R_16() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(130)) {
    jj_scanpos = xsp;
    if (jj_scan_token(131)) {
    jj_scanpos = xsp;
    if (jj_scan_token(132)) {
    jj_scanpos = xsp;
    if (jj_scan_token(133)) {
    jj_scanpos = xsp;
    if (jj_scan_token(134)) {
    jj_scanpos = xsp;
    if (jj_scan_token(135)) {
    jj_scanpos = xsp;
    if (jj_scan_token(136)) {
    jj_scanpos = xsp;
    if (jj_scan_token(137)) {
    jj_scanpos = xsp;
    if (jj_scan_token(138)) {
    jj_scanpos = xsp;
    if (jj_scan_token(139)) {
    jj_scanpos = xsp;
    if (jj_scan_token(140)) {
    jj_scanpos = xsp;
    if (jj_scan_token(141)) {
    jj_scanpos = xsp;
    if (jj_scan_token(142)) {
    jj_scanpos = xsp;
    if (jj_scan_token(143)) {
    jj_scanpos = xsp;
    if (jj_scan_token(144)) {
    jj_scanpos = xsp;
    if (jj_scan_token(145)) {
    jj_scanpos = xsp;
    if (jj_scan_token(146)) {
    jj_scanpos = xsp;
    if (jj_scan_token(147)) {
    jj_scanpos = xsp;
    if (jj_scan_token(148)) {
    jj_scanpos = xsp;
    if (jj_scan_token(149)) {
    jj_scanpos = xsp;
    if (jj_scan_token(150)) {
    jj_scanpos = xsp;
    if (jj_scan_token(151)) {
    jj_scanpos = xsp;
    if (jj_scan_token(152)) {
    jj_scanpos = xsp;
    if (jj_scan_token(153)) {
    jj_scanpos = xsp;
    if (jj_scan_token(154)) {
    jj_scanpos = xsp;
    if (jj_scan_token(155)) {
    jj_scanpos = xsp;
    if (jj_scan_token(156)) {
    jj_scanpos = xsp;
    if (jj_scan_token(157)) {
    jj_scanpos = xsp;
    if (jj_scan_token(158)) {
    jj_scanpos = xsp;
    if (jj_scan_token(159)) {
    jj_scanpos = xsp;
    if (jj_scan_token(160)) {
    jj_scanpos = xsp;
    if (jj_scan_token(161)) {
    jj_scanpos = xsp;
    if (jj_scan_token(162)) {
    jj_scanpos = xsp;
    if (jj_scan_token(163)) {
    jj_scanpos = xsp;
    if (jj_scan_token(164)) {
    jj_scanpos = xsp;
    if (jj_scan_token(165)) {
    jj_scanpos = xsp;
    if (jj_scan_token(166)) {
    jj_scanpos = xsp;
    if (jj_scan_token(167)) {
    jj_scanpos = xsp;
    if (jj_scan_token(168)) {
    jj_scanpos = xsp;
    if (jj_scan_token(169)) {
    jj_scanpos = xsp;
    if (jj_scan_token(170)) {
    jj_scanpos = xsp;
    if (jj_scan_token(171)) {
    jj_scanpos = xsp;
    if (jj_scan_token(172)) {
    jj_scanpos = xsp;
    if (jj_scan_token(173)) {
    jj_scanpos = xsp;
    if (jj_scan_token(174)) {
    jj_scanpos = xsp;
    if (jj_scan_token(175)) {
    jj_scanpos = xsp;
    if (jj_scan_token(176)) {
    jj_scanpos = xsp;
    if (jj_scan_token(177)) {
    jj_scanpos = xsp;
    if (jj_scan_token(178)) {
    jj_scanpos = xsp;
    if (jj_scan_token(179)) {
    jj_scanpos = xsp;
    if (jj_scan_token(180)) {
    jj_scanpos = xsp;
    if (jj_scan_token(181)) {
    jj_scanpos = xsp;
    if (jj_scan_token(182)) {
    jj_scanpos = xsp;
    if (jj_scan_token(183)) {
    jj_scanpos = xsp;
    if (jj_scan_token(184)) {
    jj_scanpos = xsp;
    if (jj_scan_token(185)) {
    jj_scanpos = xsp;
    if (jj_scan_token(186)) {
    jj_scanpos = xsp;
    if (jj_scan_token(187)) {
    jj_scanpos = xsp;
    if (jj_scan_token(188)) {
    jj_scanpos = xsp;
    if (jj_scan_token(189)) {
    jj_scanpos = xsp;
    if (jj_scan_token(190)) {
    jj_scanpos = xsp;
    if (jj_scan_token(191)) {
    jj_scanpos = xsp;
    if (jj_scan_token(192)) {
    jj_scanpos = xsp;
    if (jj_scan_token(193)) {
    jj_scanpos = xsp;
    if (jj_scan_token(194)) {
    jj_scanpos = xsp;
    if (jj_scan_token(195)) {
    jj_scanpos = xsp;
    if (jj_scan_token(196)) {
    jj_scanpos = xsp;
    if (jj_scan_token(197)) {
    jj_scanpos = xsp;
    if (jj_scan_token(198)) {
    jj_scanpos = xsp;
    if (jj_scan_token(199)) {
    jj_scanpos = xsp;
    if (jj_scan_token(200)) {
    jj_scanpos = xsp;
    if (jj_scan_token(201)) {
    jj_scanpos = xsp;
    if (jj_scan_token(202)) {
    jj_scanpos = xsp;
    if (jj_scan_token(203)) {
    jj_scanpos = xsp;
    if (jj_scan_token(204)) {
    jj_scanpos = xsp;
    if (jj_scan_token(205)) {
    jj_scanpos = xsp;
    if (jj_scan_token(206)) {
    jj_scanpos = xsp;
    if (jj_scan_token(207)) {
    jj_scanpos = xsp;
    if (jj_scan_token(208)) {
    jj_scanpos = xsp;
    if (jj_scan_token(209)) {
    jj_scanpos = xsp;
    if (jj_scan_token(210)) {
    jj_scanpos = xsp;
    if (jj_scan_token(211)) {
    jj_scanpos = xsp;
    if (jj_scan_token(212)) {
    jj_scanpos = xsp;
    if (jj_scan_token(213)) {
    jj_scanpos = xsp;
    if (jj_scan_token(214)) {
    jj_scanpos = xsp;
    if (jj_scan_token(215)) {
    jj_scanpos = xsp;
    if (jj_scan_token(216)) {
    jj_scanpos = xsp;
    if (jj_scan_token(217)) {
    jj_scanpos = xsp;
    if (jj_scan_token(218)) {
    jj_scanpos = xsp;
    if (jj_scan_token(219)) {
    jj_scanpos = xsp;
    if (jj_scan_token(220)) {
    jj_scanpos = xsp;
    if (jj_scan_token(221)) {
    jj_scanpos = xsp;
    if (jj_scan_token(222)) {
    jj_scanpos = xsp;
    if (jj_scan_token(223)) {
    jj_scanpos = xsp;
    if (jj_scan_token(224)) {
    jj_scanpos = xsp;
    if (jj_scan_token(225)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_14() {
    if (jj_scan_token(R_ANCHORED_ROWTYPE)) return true;
    return false;
  }

  private boolean jj_3R_79() {
    if (jj_scan_token(O_OPENPAREN)) return true;
    if (jj_scan_token(S_NUMBER)) return true;
    return false;
  }

  private boolean jj_3R_13() {
    if (jj_scan_token(R_ANCHORED_TYPE)) return true;
    return false;
  }

  private boolean jj_3R_61() {
    if (jj_scan_token(K_VARYING)) return true;
    if (jj_scan_token(K_ARRAY)) return true;
    return false;
  }

  private boolean jj_3_10() {
    if (jj_3R_12()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_13()) {
    jj_scanpos = xsp;
    if (jj_3R_14()) return true;
    }
    return false;
  }

  private boolean jj_3_9() {
    if (jj_3R_11()) return true;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_3R_7()) return true;
    return false;
  }

  private boolean jj_3R_24() {
    if (jj_scan_token(K_LONG)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(193)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_65()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_8() {
    if (jj_3R_10()) return true;
    return false;
  }

  private boolean jj_3R_54() {
    if (jj_scan_token(K_NCHAR)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(221)) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_80()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_77() {
    if (jj_scan_token(O_OPENPAREN)) return true;
    if (jj_scan_token(S_NUMBER)) return true;
    return false;
  }

  private boolean jj_3_7() {
    if (jj_3R_9()) return true;
    return false;
  }

  private boolean jj_3R_11() {
    if (jj_scan_token(K_REF)) return true;
    if (jj_scan_token(R_CURSOR)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public DDLParserTokenManager token_source;
  JavaCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;

  /** Constructor with InputStream. */
  public DDLParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public DDLParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new JavaCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new DDLParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
  }

  /** Constructor. */
  public DDLParser(java.io.Reader stream) {
    jj_input_stream = new JavaCharStream(stream, 1, 1);
    token_source = new DDLParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
  }

  /** Constructor with generated Token Manager. */
  public DDLParser(DDLParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
  }

  /** Reinitialise. */
  public void ReInit(DDLParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      return token;
    }
    token = oldToken;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    Token errortok = token.next;
    int line = errortok.beginLine, column = errortok.beginColumn;
    String mess = (errortok.kind == 0) ? tokenImage[0] : errortok.image;
    return new ParseException("Parse error at line " + line + ", column " + column + ".  Encountered: " + mess);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

}
