/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.descriptors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetMethodParameterTypes;
import org.eclipse.persistence.internal.security.PrivilegedGetMethodReturnType;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.mappings.AttributeAccessor;

public class MethodAttributeAccessor
extends AttributeAccessor {
    protected String setMethodName;
    protected String getMethodName;
    protected transient Method setMethod;
    protected transient Method getMethod;

    public Class getAttributeClass() {
        if (this.getGetMethod() == null) {
            return null;
        }
        return this.getGetMethodReturnType();
    }

    public Object getAttributeValueFromObject(Object anObject) throws DescriptorException {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedMethodInvoker(this.getGetMethod(), anObject, null));
                }
                catch (PrivilegedActionException exception) {
                    Exception throwableException = exception.getException();
                    if (throwableException instanceof IllegalAccessException) {
                        throw DescriptorException.illegalAccessWhileGettingValueThruMethodAccessor(this.getGetMethodName(), anObject.getClass().getName(), throwableException);
                    }
                    throw DescriptorException.targetInvocationWhileGettingValueThruMethodAccessor(this.getGetMethodName(), anObject.getClass().getName(), throwableException);
                }
            }
            return this.getMethod.invoke(anObject, (Object[])null);
        }
        catch (IllegalArgumentException exception) {
            throw DescriptorException.illegalArgumentWhileGettingValueThruMethodAccessor(this.getGetMethodName(), anObject.getClass().getName(), exception);
        }
        catch (IllegalAccessException exception) {
            throw DescriptorException.illegalAccessWhileGettingValueThruMethodAccessor(this.getGetMethodName(), anObject.getClass().getName(), exception);
        }
        catch (InvocationTargetException exception) {
            throw DescriptorException.targetInvocationWhileGettingValueThruMethodAccessor(this.getGetMethodName(), anObject.getClass().getName(), exception);
        }
        catch (NullPointerException exception) {
            throw DescriptorException.nullPointerWhileGettingValueThruMethodAccessor(this.getGetMethodName(), anObject.getClass().getName(), exception);
        }
    }

    protected Method getGetMethod() {
        return this.getMethod;
    }

    public String getGetMethodName() {
        return this.getMethodName;
    }

    public Class getGetMethodReturnType() {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return (Class)AccessController.doPrivileged(new PrivilegedGetMethodReturnType(this.getGetMethod()));
            }
            catch (PrivilegedActionException exception) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getMethodReturnType(this.getGetMethod());
    }

    protected Method getSetMethod() {
        return this.setMethod;
    }

    public String getSetMethodName() {
        return this.setMethodName;
    }

    public Class getSetMethodParameterType() {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return ((Class[])AccessController.doPrivileged(new PrivilegedGetMethodParameterTypes(this.getSetMethod())))[0];
            }
            catch (PrivilegedActionException exception) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getMethodParameterTypes(this.getSetMethod())[0];
    }

    public void initializeAttributes(Class theJavaClass) throws DescriptorException {
        if (this.getAttributeName() == null) {
            throw DescriptorException.attributeNameNotSpecified();
        }
        try {
            this.setGetMethod(Helper.getDeclaredMethod(theJavaClass, this.getGetMethodName(), null));
            Class[] parameterTypes = new Class[]{this.getGetMethodReturnType()};
            this.setSetMethod(Helper.getDeclaredMethod(theJavaClass, this.getSetMethodName(), parameterTypes));
        }
        catch (NoSuchMethodException ex) {
            DescriptorException descriptorException = DescriptorException.noSuchMethodWhileInitializingAttributesInMethodAccessor(this.getSetMethodName(), this.getGetMethodName(), theJavaClass.getName());
            descriptorException.setInternalException(ex);
            throw descriptorException;
        }
        catch (SecurityException exception) {
            DescriptorException descriptorException = DescriptorException.securityWhileInitializingAttributesInMethodAccessor(this.getSetMethodName(), this.getGetMethodName(), theJavaClass.getName());
            descriptorException.setInternalException(exception);
            throw descriptorException;
        }
    }

    public boolean isInitialized() {
        return this.getMethod != null && this.setMethod != null;
    }

    public boolean isMethodAttributeAccessor() {
        return true;
    }

    public void setAttributeValueInObject(Object domainObject, Object attributeValue) throws DescriptorException {
        block24: {
            Object[] parameters = new Object[]{attributeValue};
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        AccessController.doPrivileged(new PrivilegedMethodInvoker(this.getSetMethod(), domainObject, parameters));
                        break block24;
                    }
                    catch (PrivilegedActionException exception) {
                        Exception throwableException = exception.getException();
                        if (throwableException instanceof IllegalAccessException) {
                            throw DescriptorException.illegalAccessWhileSettingValueThruMethodAccessor(this.getSetMethodName(), attributeValue, throwableException);
                        }
                        throw DescriptorException.targetInvocationWhileSettingValueThruMethodAccessor(this.getSetMethodName(), attributeValue, throwableException);
                    }
                }
                this.setMethod.invoke(domainObject, parameters);
            }
            catch (IllegalAccessException exception) {
                throw DescriptorException.illegalAccessWhileSettingValueThruMethodAccessor(this.getSetMethodName(), attributeValue, exception);
            }
            catch (IllegalArgumentException exception) {
                try {
                    if (attributeValue instanceof String) {
                        Object newValue = ConversionManager.getDefaultManager().convertObject(attributeValue, this.getAttributeClass());
                        Object[] newParameters = new Object[]{newValue};
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                AccessController.doPrivileged(new PrivilegedMethodInvoker(this.getSetMethod(), domainObject, newParameters));
                            }
                            catch (PrivilegedActionException exc) {}
                        } else {
                            PrivilegedAccessHelper.invokeMethod(this.getSetMethod(), domainObject, newParameters);
                        }
                        return;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw DescriptorException.illegalArgumentWhileSettingValueThruMethodAccessor(this.getSetMethodName(), attributeValue, exception);
            }
            catch (InvocationTargetException exception) {
                throw DescriptorException.targetInvocationWhileSettingValueThruMethodAccessor(this.getSetMethodName(), attributeValue, exception);
            }
            catch (NullPointerException exception) {
                try {
                    Class fieldClass = this.getSetMethodParameterType();
                    if (fieldClass.isPrimitive() && attributeValue == null) {
                        parameters[0] = ConversionManager.getDefaultManager().convertObject(new Integer(0), fieldClass);
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                AccessController.doPrivileged(new PrivilegedMethodInvoker(this.getSetMethod(), domainObject, parameters));
                            }
                            catch (PrivilegedActionException exc) {
                                Exception throwableException = exc.getException();
                                if (throwableException instanceof IllegalAccessException) {
                                    throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), attributeValue, throwableException);
                                }
                                throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), attributeValue, throwableException);
                            }
                        }
                        PrivilegedAccessHelper.invokeMethod(this.getSetMethod(), domainObject, parameters);
                    }
                    throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), attributeValue, exception);
                }
                catch (IllegalAccessException accessException) {
                    throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), attributeValue, exception);
                }
                catch (InvocationTargetException invocationException) {
                    throw DescriptorException.nullPointerWhileSettingValueThruInstanceVariableAccessor(this.getAttributeName(), attributeValue, exception);
                }
            }
        }
    }

    protected void setGetMethod(Method getMethod) {
        this.getMethod = getMethod;
    }

    public void setGetMethodName(String getMethodName) {
        this.getMethodName = getMethodName;
    }

    protected void setSetMethod(Method setMethod) {
        this.setMethod = setMethod;
    }

    public void setSetMethodName(String setMethodName) {
        this.setMethodName = setMethodName;
    }
}

