/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.Stack;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.platform.xml.SAXDocumentBuilder;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SAXFragmentBuilder
extends SAXDocumentBuilder {
    private UnmarshalRecord owningRecord;

    public SAXFragmentBuilder(UnmarshalRecord unmarshalRecord) {
        this.owningRecord = unmarshalRecord;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String prefix;
        if (null != namespaceURI && "".equals(namespaceURI)) {
            namespaceURI = null;
        }
        int qNameColonIndex = qName.indexOf(":");
        if (namespaceURI != null && qNameColonIndex == -1 && (prefix = this.owningRecord.resolveNamespaceUri(namespaceURI)) != null && !prefix.equals("")) {
            qName = prefix + ":" + qName;
        }
        Element element = this.getInitializedDocument().createElementNS(namespaceURI, qName);
        Node parentNode = (Node)this.nodes.peek();
        if (this.stringBuffer.length() > 0 && this.nodes.size() != 1) {
            Text text = this.getInitializedDocument().createTextNode(this.stringBuffer.toString());
            parentNode.appendChild(text);
            this.stringBuffer.reset();
        }
        this.appendChildNode(parentNode, element);
        this.nodes.push(element);
        qNameColonIndex = qName.indexOf(":");
        if (qNameColonIndex > -1) {
            String prefix2 = qName.substring(0, qNameColonIndex);
            String parentUri = null;
            if (element.getParentNode() != null) {
                parentUri = XMLPlatformFactory.getInstance().getXMLPlatform().resolveNamespacePrefix(element.getParentNode(), prefix2);
            }
            if (parentUri == null || parentUri.equals("")) {
                this.startPrefixMapping(prefix2, namespaceURI);
            }
        }
        if (null != this.namespaceDeclarations) {
            for (String prefix3 : this.namespaceDeclarations.keySet()) {
                String uri = (String)this.namespaceDeclarations.get(prefix3);
                this.addNamespaceDeclaration(element, prefix3, uri);
            }
            this.namespaceDeclarations = null;
        }
        int numberOfAttributes = atts.getLength();
        for (int x = 0; x < numberOfAttributes; ++x) {
            String theUri;
            int colonIndex;
            String attributeNamespaceURI = atts.getURI(x);
            if (null != attributeNamespaceURI && "".equals(attributeNamespaceURI)) {
                attributeNamespaceURI = null;
            }
            if (attributeNamespaceURI == null && atts.getQName(x).startsWith("xmlns:")) {
                attributeNamespaceURI = "http://www.w3.org/2000/xmlns/";
            }
            if (attributeNamespaceURI == null) {
                element.setAttribute(atts.getQName(x), atts.getValue(x));
                continue;
            }
            String value = atts.getValue(x);
            element.setAttributeNS(attributeNamespaceURI, atts.getQName(x), value);
            if (!"http://www.w3.org/2001/XMLSchema-instance".equals(attributeNamespaceURI) || !"type".equals(atts.getLocalName(x)) || (colonIndex = value.indexOf(58)) <= -1) continue;
            String prefix4 = value.substring(0, colonIndex);
            String uri = XMLPlatformFactory.getInstance().getXMLPlatform().resolveNamespacePrefix(element, prefix4);
            if (uri != null && !uri.equals("") || (theUri = this.owningRecord.resolveNamespacePrefix(prefix4)) == null || theUri.equals("")) continue;
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix4, theUri);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.nodes.size() == 2) {
            Element endedElement = (Element)this.nodes.peek();
            if (this.stringBuffer.length() > 0) {
                Text text = this.getInitializedDocument().createTextNode(this.stringBuffer.toString());
                endedElement.appendChild(text);
                this.stringBuffer.reset();
            }
            this.owningRecord.getXMLReader().setContentHandler(this.owningRecord);
            this.owningRecord.endElement(namespaceURI, localName, qName);
        } else {
            super.endElement(namespaceURI, localName, qName);
        }
    }

    public Stack getNodes() {
        return this.nodes;
    }

    public void setOwningRecord(UnmarshalRecord record) {
        this.owningRecord = record;
    }

    public void appendChildNode(Node parent, Node child) {
        if (parent != this.getDocument()) {
            parent.appendChild(child);
        }
    }

    public Attr buildAttributeNode(String namespaceURI, String localName, String value) {
        try {
            Attr attribute = this.getInitializedDocument().createAttributeNS(namespaceURI, localName);
            attribute.setValue(value);
            return attribute;
        }
        catch (SAXException ex) {
            return null;
        }
    }

    public Text buildTextNode(String textValue) {
        try {
            Text text = this.getInitializedDocument().createTextNode(textValue);
            return text;
        }
        catch (SAXException sAXException) {
            return null;
        }
    }
}

