/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sequencing;

import java.util.Iterator;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.broker.SessionBroker;

class SessionBrokerSequencing
implements Sequencing {
    protected SessionBroker broker;
    protected int whenShouldAcquireValueForAll;

    public static boolean atLeastOneSessionHasSequencing(SessionBroker br) {
        boolean hasSequencing = false;
        Iterator sessionEnum = br.getSessionsByName().values().iterator();
        while (sessionEnum.hasNext() && !hasSequencing) {
            AbstractSession session = (AbstractSession)sessionEnum.next();
            hasSequencing = session.getSequencing() != null;
        }
        return hasSequencing;
    }

    public SessionBrokerSequencing(SessionBroker broker) {
        this.broker = broker;
        this.initialize();
    }

    protected void initialize() {
        this.whenShouldAcquireValueForAll = 0;
        boolean first = true;
        Iterator sessionEnum = this.broker.getSessionsByName().values().iterator();
        while ((first || this.whenShouldAcquireValueForAll != 0) && sessionEnum.hasNext()) {
            AbstractSession session = (AbstractSession)sessionEnum.next();
            Sequencing sequencing = session.getSequencing();
            if (sequencing == null) continue;
            if (first) {
                this.whenShouldAcquireValueForAll = sequencing.whenShouldAcquireValueForAll();
                first = false;
                continue;
            }
            if (this.whenShouldAcquireValueForAll == sequencing.whenShouldAcquireValueForAll()) continue;
            this.whenShouldAcquireValueForAll = 0;
        }
    }

    protected Sequencing get(Class cls) {
        return this.broker.getSessionForClass(cls).getSequencing();
    }

    public int whenShouldAcquireValueForAll() {
        return this.whenShouldAcquireValueForAll;
    }

    public Object getNextValue(Class cls) {
        return this.get(cls).getNextValue(cls);
    }
}

