/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.weaving;

import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.weaving.AttributeDetails;

public class ClassDetails {
    protected Class describedClass;
    protected String className;
    protected String superClassName;
    protected ClassDetails superClassDetails;
    protected boolean shouldWeaveValueHolders = false;
    protected boolean shouldWeaveChangeTracking = false;
    protected boolean shouldWeaveFetchGroups = false;
    protected boolean shouldWeaveInternal = false;
    protected Map<String, AttributeDetails> attributesMap;
    protected Map<String, AttributeDetails> getterMethodToAttributeDetails;
    protected Map<String, AttributeDetails> setterMethodToAttributeDetails;
    protected List lazyMappings;
    protected boolean isMappedSuperClass = false;
    protected boolean isEmbedable = false;
    protected Boolean usesAttributeAccess = null;
    protected boolean implementsCloneMethod = false;

    public Class getDescribedClass() {
        return this.describedClass;
    }

    public String getClassName() {
        return this.className;
    }

    public void setDescribedClass(Class describedClass) {
        this.describedClass = describedClass;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public void setSuperClassName(String superClassName) {
        this.superClassName = superClassName;
    }

    public ClassDetails getSuperClassDetails() {
        return this.superClassDetails;
    }

    public void setSuperClassDetails(ClassDetails superClassDetails) {
        this.superClassDetails = superClassDetails;
    }

    public boolean shouldWeaveValueHolders() {
        return this.shouldWeaveValueHolders;
    }

    public void setShouldWeaveValueHolders(boolean shouldWeaveValueHolders) {
        this.shouldWeaveValueHolders = shouldWeaveValueHolders;
    }

    public boolean shouldWeaveChangeTracking() {
        return this.shouldWeaveChangeTracking;
    }

    public void setShouldWeaveChangeTracking(boolean shouldWeaveChangeTracking) {
        this.shouldWeaveChangeTracking = shouldWeaveChangeTracking;
    }

    public boolean shouldWeaveFetchGroups() {
        return this.shouldWeaveFetchGroups;
    }

    public void setShouldWeaveFetchGroups(boolean shouldWeaveFetchGroups) {
        this.shouldWeaveFetchGroups = shouldWeaveFetchGroups;
    }

    public boolean shouldWeaveInternal() {
        return this.shouldWeaveInternal;
    }

    public void setShouldWeaveInternal(boolean shouldWeaveInternal) {
        this.shouldWeaveInternal = shouldWeaveInternal;
    }

    public Map getAttributesMap() {
        return this.attributesMap;
    }

    public Map getGetterMethodToAttributeDetails() {
        return this.getterMethodToAttributeDetails;
    }

    public List getLazyMappings() {
        return this.lazyMappings;
    }

    public Map getSetterMethodToAttributeDetails() {
        return this.setterMethodToAttributeDetails;
    }

    public void setAttributesMap(Map attributesMap) {
        this.attributesMap = attributesMap;
    }

    public void setGetterMethodToAttributeDetails(Map map) {
        this.getterMethodToAttributeDetails = map;
    }

    public void setLazyMappings(List lazyMappings) {
        this.lazyMappings = lazyMappings;
    }

    public boolean getImplementsCloneMethod() {
        return this.implementsCloneMethod;
    }

    public void setImplementsCloneMethod(boolean implementsCloneMethod) {
        this.implementsCloneMethod = implementsCloneMethod;
    }

    public String getNameOfSuperclassImplementingCloneMethod() {
        if (this.superClassDetails == null) {
            return null;
        }
        if (this.superClassDetails.getImplementsCloneMethod()) {
            return this.superClassDetails.getClassName();
        }
        return this.superClassDetails.getNameOfSuperclassImplementingCloneMethod();
    }

    public boolean isMappedSuperClass() {
        return this.isMappedSuperClass;
    }

    public void setIsMappedSuperClass(boolean isMappedSuperClass) {
        this.isMappedSuperClass = isMappedSuperClass;
    }

    public boolean isEmbedable() {
        return this.isEmbedable;
    }

    public void setIsEmbedable(boolean isEmbedable) {
        this.isEmbedable = isEmbedable;
    }

    public void setSetterMethodToAttributeDetails(Map map) {
        this.setterMethodToAttributeDetails = map;
    }

    public boolean usesAttributeAccess() {
        if (this.usesAttributeAccess != null) {
            return this.usesAttributeAccess;
        }
        for (AttributeDetails details : this.attributesMap.values()) {
            if (!details.isMappedWithAttributeAccess()) continue;
            this.usesAttributeAccess = Boolean.TRUE;
            return true;
        }
        if (this.getSuperClassDetails() != null) {
            return this.getSuperClassDetails().usesAttributeAccess();
        }
        this.usesAttributeAccess = Boolean.FALSE;
        return false;
    }

    public AttributeDetails getAttributeDetailsFromClassOrSuperClass(String attributeName) {
        AttributeDetails attribute = this.attributesMap.get(attributeName);
        if (attribute == null && this.superClassDetails != null) {
            return this.superClassDetails.getAttributeDetailsFromClassOrSuperClass(attributeName);
        }
        return attribute;
    }

    public boolean doesSuperclassWeaveChangeTracking() {
        if (this.getSuperClassDetails() == null) {
            return false;
        }
        if (this.getSuperClassDetails().shouldWeaveChangeTracking()) {
            return true;
        }
        return this.getSuperClassDetails().doesSuperclassWeaveChangeTracking();
    }

    public boolean canWeaveChangeTracking() {
        if (this.getSuperClassDetails() == null || !this.shouldWeaveChangeTracking()) {
            return this.shouldWeaveChangeTracking();
        }
        return this.getSuperClassDetails().canWeaveChangeTracking();
    }

    public boolean isInMetadataHierarchy(String className) {
        if (className.equals(Object.class.getName().replace('.', '/'))) {
            return true;
        }
        if (className.equals(this.className) || this.superClassName != null && className.equals(this.superClassName)) {
            return true;
        }
        if (this.superClassDetails != null) {
            return this.superClassDetails.isInMetadataHierarchy(className);
        }
        return false;
    }

    public boolean isInSuperclassHierarchy(String className) {
        if (className.equals(Object.class.getName().replace('.', '/'))) {
            return true;
        }
        if (this.superClassName != null && className.equals(this.superClassName)) {
            return true;
        }
        if (this.superClassDetails != null) {
            return this.superClassDetails.isInMetadataHierarchy(className);
        }
        return false;
    }
}

