/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.querykeys;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ExpressionIterator;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.expressions.TableExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.mappings.querykeys.ForeignReferenceQueryKey;

public class ManyToManyQueryKey
extends ForeignReferenceQueryKey {
    public boolean isCollectionQueryKey() {
        return true;
    }

    public boolean isManyToManyQueryKey() {
        return true;
    }

    public DatabaseTable getRelationTable(ClassDescriptor referenceDescriptor) {
        ExpressionIterator expIterator = new ExpressionIterator(){

            public void iterate(Expression each) {
                DatabaseField field;
                if (each.isTableExpression()) {
                    ((Collection)this.getResult()).add(((TableExpression)each).getTable());
                } else if (each.isDataExpression()) {
                    DatabaseField field2 = ((DataExpression)each).getField();
                    if (field2 != null && field2.hasTableName()) {
                        ((Collection)this.getResult()).add(field2.getTable());
                    }
                } else if (each.isParameterExpression() && (field = ((ParameterExpression)each).getField()) != null && field.hasTableName()) {
                    ((Collection)this.getResult()).add(field.getTable());
                }
            }
        };
        expIterator.setResult(new HashSet());
        expIterator.iterateOn(this.joinCriteria);
        HashSet tables = (HashSet)expIterator.getResult();
        DatabaseTable relationTable = null;
        for (DatabaseTable table : tables) {
            if (this.descriptor.getTables().contains(table) || referenceDescriptor.getTables().contains(table)) continue;
            relationTable = table;
            break;
        }
        if (relationTable != null) {
            return relationTable;
        }
        throw QueryException.noRelationTableInManyToManyQueryKey(this, this.joinCriteria);
    }
}

