/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.queries.WriteObjectQuery;

public class UpdateObjectQuery
extends WriteObjectQuery {
    public UpdateObjectQuery() {
    }

    public UpdateObjectQuery(Object objectToUpdate) {
        this();
        this.setObject(objectToUpdate);
    }

    public UpdateObjectQuery(Call call) {
        this();
        this.setCall(call);
    }

    public void executeCommit() throws DatabaseException, OptimisticLockException {
        QueryRedirector localRedirector = this.getRedirector();
        if (localRedirector != null) {
            this.redirectQuery(localRedirector, this, this.session, this.translationRow);
            return;
        }
        this.getQueryMechanism().updateObjectForWrite();
    }

    public void executeCommitWithChangeSet() throws DatabaseException, OptimisticLockException {
        QueryRedirector localRedirector = this.getRedirector();
        if (localRedirector != null) {
            this.redirectQuery(localRedirector, this, this.session, this.translationRow);
            return;
        }
        this.getQueryMechanism().updateObjectForWriteWithChangeSet();
    }

    protected void prepare() {
        super.prepare();
        this.getQueryMechanism().prepareUpdateObject();
    }

    protected DatabaseQuery checkForCustomQuery(AbstractSession session, AbstractRecord translationRow) {
        this.checkDescriptor(session);
        DescriptorQueryManager queryManager = this.getDescriptor().getQueryManager();
        if (!this.isCallQuery() && !this.isUserDefined() && queryManager.hasUpdateQuery()) {
            return queryManager.getUpdateQuery();
        }
        return null;
    }

    protected void prepareCustomQuery(DatabaseQuery customQuery) {
        UpdateObjectQuery customUpdateQuery = (UpdateObjectQuery)customQuery;
        customUpdateQuery.setObject(this.getObject());
        customUpdateQuery.setObjectChangeSet(this.getObjectChangeSet());
        customUpdateQuery.setCascadePolicy(this.getCascadePolicy());
        customUpdateQuery.setShouldMaintainCache(this.shouldMaintainCache());
        customUpdateQuery.setModifyRow(null);
    }

    protected QueryRedirector getDefaultRedirector() {
        return this.descriptor.getDefaultUpdateObjectQueryRedirector();
    }

    public boolean isUpdateObjectQuery() {
        return true;
    }
}

