/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.columns.MetadataHelper;

public abstract class OverrideMetadata
extends ORMetadata {
    private String m_javaClassName;
    private String m_name;

    protected OverrideMetadata(String xmlElement) {
        super(xmlElement);
    }

    protected OverrideMetadata(Annotation annotation, MetadataAccessibleObject accessibleObject) {
        super(annotation, accessibleObject);
        this.m_name = (String)MetadataHelper.invokeMethod("name", annotation);
        if (accessibleObject instanceof MetadataClass) {
            this.m_javaClassName = ((Class)accessibleObject.getElement()).getName();
        }
    }

    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof OverrideMetadata) {
            return this.valuesMatch(this.m_name, ((OverrideMetadata)objectToCompare).getName());
        }
        return false;
    }

    public String getIdentifier() {
        return this.m_name;
    }

    public abstract String getIgnoreMappedSuperclassContext();

    public String getJavaClassName() {
        return this.m_javaClassName;
    }

    public String getName() {
        return this.m_name;
    }

    public void setJavaClassName(String javaClassName) {
        this.m_javaClassName = javaClassName;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public boolean shouldOverride(OverrideMetadata existing, MetadataLogger logger, String descriptorClass) {
        if (existing == null) {
            return true;
        }
        if (existing.getJavaClassName().equals(this.getJavaClassName())) {
            return this.shouldOverride(existing);
        }
        logger.logWarningMessage(this.getIgnoreMappedSuperclassContext(), this.getName(), this.getJavaClassName(), descriptorClass);
        return false;
    }
}

