/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.dynamic;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.exceptions.DynamicException;
import org.eclipse.persistence.internal.dynamic.DynamicPropertiesManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;

public class DynamicTypeImpl
implements DynamicType {
    protected ClassDescriptor descriptor;
    protected DynamicType parentType;
    protected DynamicPropertiesManager dpm;
    protected Set<DatabaseMapping> mappingsRequiringInitialization = new HashSet<DatabaseMapping>();

    protected DynamicTypeImpl() {
    }

    public DynamicTypeImpl(ClassDescriptor descriptor, DynamicType parentType) {
        this();
        this.descriptor = descriptor;
        this.parentType = parentType;
    }

    public Object clone() {
        DynamicTypeImpl clonedDynamicTypeImpl = null;
        try {
            clonedDynamicTypeImpl = (DynamicTypeImpl)super.clone();
        }
        catch (Exception exception) {}
        return clonedDynamicTypeImpl;
    }

    @Override
    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public DynamicPropertiesManager getDynamicPropertiesManager() {
        return this.dpm;
    }

    public void setDynamicPropertiesManager(DynamicPropertiesManager dpm) {
        this.dpm = dpm;
    }

    @Override
    public DynamicType getParentType() {
        return this.parentType;
    }

    public List<DatabaseMapping> getMappings() {
        return this.getDescriptor().getMappings();
    }

    @Override
    public String getName() {
        return this.getDescriptor().getAlias();
    }

    @Override
    public String getClassName() {
        return this.getDescriptor().getJavaClassName();
    }

    @Override
    public int getNumberOfProperties() {
        return this.dpm.getPropertyNames().size();
    }

    public Set<DatabaseMapping> getMappingsRequiringInitialization() {
        return this.mappingsRequiringInitialization;
    }

    public boolean isInitialized() {
        return this.getDescriptor().isFullyInitialized();
    }

    @Override
    public boolean containsProperty(String propertyName) {
        return this.dpm.contains(propertyName);
    }

    @Override
    public Class<? extends DynamicEntity> getJavaClass() {
        return this.getDescriptor().getJavaClass();
    }

    public DatabaseMapping getMapping(String propertyName) {
        DatabaseMapping mapping = this.getDescriptor().getMappingForAttributeName(propertyName);
        if (mapping == null) {
            throw DynamicException.invalidPropertyName(this, propertyName);
        }
        return mapping;
    }

    @Override
    public List<String> getPropertiesNames() {
        return this.dpm.getPropertyNames();
    }

    @Override
    public Class<?> getPropertyType(String propertyName) {
        return this.getMapping(propertyName).getAttributeClassification();
    }

    @Override
    public DynamicEntity newDynamicEntity() {
        DynamicEntity newDynamicEntity = (DynamicEntity)this.getDescriptor().getInstantiationPolicy().buildNewInstance();
        return newDynamicEntity;
    }

    public void checkSet(String propertyName, Object value) throws DynamicException {
        DatabaseMapping mapping = this.getMapping(propertyName);
        if (value == null) {
            if (mapping.isCollectionMapping() || mapping.getAttributeClassification() != null && mapping.getAttributeClassification().isPrimitive()) {
                throw DynamicException.invalidSetPropertyType(mapping, value);
            }
            return;
        }
        Class expectedType = mapping.getAttributeClassification();
        if (mapping.isForeignReferenceMapping()) {
            expectedType = mapping.isCollectionMapping() ? (((CollectionMapping)mapping).getContainerPolicy().isMapPolicy() ? Map.class : Collection.class) : ((ForeignReferenceMapping)mapping).getReferenceClass();
        }
        if (expectedType != null && expectedType.isPrimitive() && !value.getClass().isPrimitive()) {
            expectedType = Helper.getObjectClass(expectedType);
        }
        if (expectedType != null && !expectedType.isAssignableFrom(value.getClass())) {
            throw DynamicException.invalidSetPropertyType(mapping, value);
        }
    }

    @Override
    public int getPropertyIndex(String propertyName) {
        return this.dpm.getPropertyNames().indexOf(propertyName);
    }

    @Override
    public Class<?> getPropertyType(int propertyIndex) {
        return this.getDescriptor().getMappings().get(propertyIndex).getAttributeClassification();
    }

    public String toString() {
        return "DynamicEntityType(" + this.getName() + ") - " + this.getDescriptor();
    }
}

