/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm.util;

import org.eclipse.persistence.internal.libraries.asm.ModuleVisitor;
import org.eclipse.persistence.internal.libraries.asm.util.CheckMethodAdapter;

public final class CheckModuleAdapter
extends ModuleVisitor {
    private boolean end;

    public CheckModuleAdapter(ModuleVisitor moduleVisitor) {
        super(393216, moduleVisitor);
    }

    @Override
    public void visitRequire(String string, int n) {
        this.checkEnd();
        if (string == null) {
            throw new IllegalArgumentException("require cannot be null");
        }
        super.visitRequire(string, n);
    }

    @Override
    public void visitExport(String string, String ... stringArray) {
        this.checkEnd();
        if (string == null) {
            throw new IllegalArgumentException("require cannot be null");
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] != null) continue;
                throw new IllegalArgumentException("to at index " + i + " cannot be null");
            }
        }
        super.visitExport(string, stringArray);
    }

    @Override
    public void visitUse(String string) {
        this.checkEnd();
        CheckMethodAdapter.checkInternalName(string, "service");
        super.visitUse(string);
    }

    @Override
    public void visitProvide(String string, String string2) {
        this.checkEnd();
        CheckMethodAdapter.checkInternalName(string, "service");
        CheckMethodAdapter.checkInternalName(string2, "impl");
        super.visitProvide(string, string2);
    }

    @Override
    public void visitEnd() {
        this.checkEnd();
        this.end = true;
        super.visitEnd();
    }

    private void checkEnd() {
        if (this.end) {
            throw new IllegalStateException("Cannot call a visit method after visitEnd has been called");
        }
    }
}

