/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.supplemental.fileupload;

import org.eclipse.rap.rwt.supplemental.fileupload.FileUploadReceiver;
import org.eclipse.rap.rwt.supplemental.fileupload.IFileUploadListener;
import org.eclipse.rap.rwt.supplemental.fileupload.internal.FileUploadHandlerStore;
import org.eclipse.rap.rwt.supplemental.fileupload.internal.FileUploadListenerList;
import org.eclipse.rap.rwt.supplemental.fileupload.internal.FileUploadServiceHandler;

public final class FileUploadHandler {
    private final String token;
    private final FileUploadReceiver receiver;
    private final FileUploadListenerList listeners;
    private long maxFileSize = -1L;

    public FileUploadHandler(FileUploadReceiver receiver) {
        if (receiver == null) {
            throw new NullPointerException("receiver is null");
        }
        this.token = FileUploadHandlerStore.createToken();
        this.listeners = new FileUploadListenerList();
        this.receiver = receiver;
        FileUploadHandlerStore.getInstance().registerHandler(this.token, this);
    }

    public String getUploadUrl() {
        return FileUploadServiceHandler.getUrl(this.token);
    }

    public FileUploadReceiver getReceiver() {
        return this.receiver;
    }

    public void addUploadListener(IFileUploadListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        this.listeners.addUploadListener(listener);
    }

    public void removeUploadListener(IFileUploadListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        this.listeners.removeUploadListener(listener);
    }

    public void dispose() {
        FileUploadHandlerStore.getInstance().deregisterHandler(this.token);
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    FileUploadListenerList getListeners() {
        return this.listeners;
    }

    String getToken() {
        return this.token;
    }
}

