/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class CanvasTab
extends ExampleTab {
    public CanvasTab(CTabFolder topFolder) {
        super(topFolder, "Canvas");
    }

    protected void createStyleControls(Composite parent) {
        this.createStyleButton("BORDER", 2048);
        this.cteateRoundedBorderGroup();
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createBgColorButton();
        this.createBgGradientButton();
        this.createBgImageButton();
    }

    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Canvas canvas = new Canvas(parent, this.getStyle());
        canvas.setLayout((Layout)new RowLayout(256));
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                event.gc.drawPoint(230, 100);
                CanvasTab.this.paintLines(event.display, event.gc);
                CanvasTab.this.paintRectangles(event.display, event.gc);
                CanvasTab.this.paintArcs(event.display, event.gc);
                CanvasTab.this.paintImages(event.display, event.gc);
                CanvasTab.this.paintTexts(event.display, event.gc);
                CanvasTab.this.paintPolylines(event.display, event.gc);
            }
        });
        canvas.redraw();
        this.registerControl((Control)canvas);
        Label label = new Label((Composite)canvas, 0);
        label.setText("Label");
        Button pushButton = new Button((Composite)canvas, 8);
        pushButton.setText("Push Button");
    }

    private void paintLines(Display display, GC gc) {
        gc.drawLine(30, 130, 400, 130);
        gc.setLineWidth(10);
        gc.setForeground(display.getSystemColor(5));
        gc.setAlpha(64);
        gc.drawLine(30, 140, 400, 140);
        gc.setForeground(display.getSystemColor(3));
        gc.setLineJoin(2);
        gc.setLineCap(2);
        int[] pointArray = new int[]{70, 120, 100, 150, 130, 120, 160, 150};
        gc.drawPolyline(pointArray);
        gc.setForeground(display.getSystemColor(12));
        gc.setLineJoin(3);
        gc.setLineCap(3);
        pointArray = new int[]{170, 120, 200, 150, 230, 120, 260, 150};
        gc.drawPolyline(pointArray);
        gc.setForeground(display.getSystemColor(4));
        gc.setLineJoin(1);
        gc.setLineCap(1);
        pointArray = new int[]{270, 120, 300, 150, 330, 120, 360, 150};
        gc.drawPolyline(pointArray);
        gc.setLineWidth(1);
        gc.setAlpha(255);
    }

    private void paintRectangles(Display display, GC gc) {
        gc.setForeground(display.getSystemColor(2));
        gc.drawRectangle(30, 160, 50, 50);
        gc.setForeground(display.getSystemColor(9));
        gc.drawRoundRectangle(90, 160, 50, 50, 10, 10);
        gc.setBackground(display.getSystemColor(5));
        gc.fillRectangle(150, 160, 50, 50);
        gc.fillRoundRectangle(210, 160, 50, 50, 10, 10);
        gc.fillGradientRectangle(270, 160, 50, 50, true);
        gc.fillGradientRectangle(330, 160, 50, 50, false);
    }

    private void paintArcs(Display display, GC gc) {
        gc.setForeground(display.getSystemColor(9));
        gc.drawOval(30, 220, 50, 25);
        gc.setBackground(display.getSystemColor(1));
        gc.setForeground(display.getSystemColor(5));
        gc.drawArc(90, 220, 50, 25, 45, 180);
        gc.setBackground(display.getSystemColor(7));
        gc.fillArc(150, 220, 50, 25, 45, 180);
        gc.setBackground(display.getSystemColor(9));
        gc.fillOval(210, 220, 50, 50);
    }

    private void paintImages(Display display, GC gc) {
        Image image = display.getSystemImage(2);
        int width = image.getImageData().width;
        int height = image.getImageData().height;
        gc.drawImage(image, 30, 280);
        gc.setAlpha(64);
        gc.drawImage(image, 90, 280);
        gc.setAlpha(255);
        gc.drawImage(image, 9, 3, width - 20, height - 6, 150, 280, width - 10, height + 4);
    }

    private void paintTexts(Display display, GC gc) {
        gc.setForeground(display.getSystemColor(1));
        gc.drawString("Hello RAP World!", 200, 280, false);
        Font font = Graphics.getFont((String)"Arial, Verdana, Tahoma", (int)16, (int)3);
        gc.setFont(font);
        gc.setForeground(display.getSystemColor(3));
        gc.drawText("\tHello RAP World!\nAgain!", 300, 280, true);
    }

    private void paintPolylines(Display display, GC gc) {
        int[] pointArray = new int[]{55, 340, 80, 365, 55, 390, 30, 365};
        gc.drawPolygon(pointArray);
        pointArray = new int[]{105, 340, 130, 365, 105, 390, 80, 365};
        gc.fillPolygon(pointArray);
        pointArray = new int[]{155, 340, 180, 365, 155, 390, 130, 365};
        gc.drawPolyline(pointArray);
    }
}

