/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.registry;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.cheatsheets.CheatSheetListener;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.osgi.framework.Bundle;

public class CheatSheetElement
extends WorkbenchAdapter
implements IAdaptable,
IPluginContribution {
    private String contentFile;
    private String id;
    private String name;
    private String description;
    private IConfigurationElement configurationElement;
    private String listenerClass;
    private boolean composite;
    private boolean registered = false;
    private String contentXml;
    private String href;
    static /* synthetic */ Class class$0;

    public CheatSheetElement(String name) {
        this.name = name;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IConfigurationElement getConfigurationElement() {
        return this.configurationElement;
    }

    public String getContentFile() {
        return this.contentFile;
    }

    public String getDescription() {
        return this.description;
    }

    public String getID() {
        return this.id;
    }

    public String getLabel(Object element) {
        return this.name;
    }

    public String getListenerClass() {
        return this.listenerClass;
    }

    public void setConfigurationElement(IConfigurationElement newConfigurationElement) {
        this.configurationElement = newConfigurationElement;
    }

    public void setContentFile(String value) {
        this.contentFile = value;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public void setID(String value) {
        this.id = value;
    }

    public void setListenerClass(String value) {
        this.listenerClass = value;
    }

    public CheatSheetListener createListenerInstance() {
        Status status;
        String message;
        if (this.listenerClass == null || this.configurationElement == null) {
            return null;
        }
        Class extClass = null;
        CheatSheetListener listener = null;
        String pluginId = this.configurationElement.getContributor().getName();
        try {
            Bundle bundle = Platform.getBundle((String)pluginId);
            extClass = bundle.loadClass(this.listenerClass);
        }
        catch (Exception e) {
            message = NLS.bind((String)Messages.get().ERROR_LOADING_CLASS, (Object[])new Object[]{this.listenerClass});
            status = new Status(4, "org.eclipse.rap.ui.cheatsheets", 0, message, (Throwable)e);
            CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
        }
        try {
            if (extClass != null) {
                listener = (CheatSheetListener)extClass.newInstance();
            }
        }
        catch (Exception e) {
            message = NLS.bind((String)Messages.get().ERROR_CREATING_CLASS, (Object[])new Object[]{this.listenerClass});
            status = new Status(4, "org.eclipse.rap.ui.cheatsheets", 0, message, (Throwable)e);
            CheatSheetPlugin.getPlugin().getLog().log((IStatus)status);
        }
        if (listener != null) {
            return listener;
        }
        return null;
    }

    public String getLocalId() {
        return this.id;
    }

    public String getPluginId() {
        return this.configurationElement.getContributor().getName();
    }

    public void setComposite(boolean composite) {
        this.composite = composite;
    }

    public boolean isComposite() {
        return this.composite;
    }

    public String getRestorePath() {
        if (!this.registered) {
            return this.contentFile;
        }
        return null;
    }

    public void setRegistered(boolean registered) {
        this.registered = registered;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public void setContentXml(String xml) {
        this.contentXml = xml;
    }

    public String getContentXml() {
        return this.contentXml;
    }

    public void setHref(String contentPath) {
        this.href = contentPath;
    }

    public String getHref() {
        return this.href;
    }
}

