/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.palette;

import org.eclipse.gef.SharedImages;
import org.eclipse.gef.internal.GEFMessages;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.tools.MarqueeSelectionTool;
import org.eclipse.jface.resource.ImageDescriptor;

public class MarqueeToolEntry
extends ToolEntry {
    public MarqueeToolEntry() {
        this(null, null);
    }

    public MarqueeToolEntry(String label) {
        this(label, null);
    }

    public MarqueeToolEntry(String label, String description) {
        super(label, description, null, null, MarqueeSelectionTool.class);
        if (label == null || label.length() == 0) {
            this.setLabel(GEFMessages.MarqueeTool_Label);
        }
        this.setUserModificationPermission(1);
    }

    public String getDescription() {
        String description = super.getDescription();
        if (description != null) {
            return description;
        }
        int marqueeBehavior = this.getMarqueeBehavior();
        if (marqueeBehavior == MarqueeSelectionTool.BEHAVIOR_CONNECTIONS_TOUCHED) {
            return GEFMessages.MarqueeTool_Connections_Touched_Desc;
        }
        if (marqueeBehavior == MarqueeSelectionTool.BEHAVIOR_CONNECTIONS_CONTAINED) {
            return GEFMessages.MarqueeTool_Connections_Contained_Desc;
        }
        if (marqueeBehavior == MarqueeSelectionTool.BEHAVIOR_NODES_TOUCHED) {
            return GEFMessages.MarqueeTool_Nodes_Touched_Desc;
        }
        if (marqueeBehavior == MarqueeSelectionTool.BEHAVIOR_NODES_CONTAINED) {
            return GEFMessages.MarqueeTool_Nodes_Contained_Desc;
        }
        if (marqueeBehavior == MarqueeSelectionTool.BEHAVIOR_NODES_TOUCHED_AND_RELATED_CONNECTIONS) {
            return GEFMessages.MarqueeTool_Nodes_Touched_And_Related_Connections_Desc;
        }
        if (marqueeBehavior == MarqueeSelectionTool.BEHAVIOR_NODES_CONTAINED_AND_RELATED_CONNECTIONS) {
            return GEFMessages.MarqueeTool_Nodes_Contained_And_Related_Connections_Desc;
        }
        throw new IllegalArgumentException("Unknown marquee behavior");
    }

    public ImageDescriptor getLargeIcon() {
        ImageDescriptor imageDescriptor = super.getLargeIcon();
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        int marqueeBehavior = this.getMarqueeBehavior();
        if (marqueeBehavior == MarqueeSelectionTool.BEHAVIOR_CONNECTIONS_CONTAINED || marqueeBehavior == MarqueeSelectionTool.BEHAVIOR_CONNECTIONS_TOUCHED) {
            return SharedImages.DESC_MARQUEE_TOOL_CONNECTIONS_24;
        }
        if (marqueeBehavior == MarqueeSelectionTool.BEHAVIOR_NODES_CONTAINED || marqueeBehavior == MarqueeSelectionTool.BEHAVIOR_NODES_TOUCHED) {
            return SharedImages.DESC_MARQUEE_TOOL_NODES_24;
        }
        return SharedImages.DESC_MARQUEE_TOOL_24;
    }

    private int getMarqueeBehavior() {
        Object value = this.getToolProperty(MarqueeSelectionTool.PROPERTY_MARQUEE_BEHAVIOR);
        if (value != null && value instanceof Integer) {
            return (Integer)value;
        }
        return MarqueeSelectionTool.DEFAULT_MARQUEE_BEHAVIOR;
    }

    public ImageDescriptor getSmallIcon() {
        ImageDescriptor imageDescriptor = super.getSmallIcon();
        if (imageDescriptor != null) {
            return imageDescriptor;
        }
        int marqueeBehavior = this.getMarqueeBehavior();
        if (marqueeBehavior == MarqueeSelectionTool.BEHAVIOR_CONNECTIONS_CONTAINED || marqueeBehavior == MarqueeSelectionTool.BEHAVIOR_CONNECTIONS_TOUCHED) {
            return SharedImages.DESC_MARQUEE_TOOL_CONNECTIONS_16;
        }
        if (marqueeBehavior == MarqueeSelectionTool.BEHAVIOR_NODES_CONTAINED || marqueeBehavior == MarqueeSelectionTool.BEHAVIOR_NODES_TOUCHED) {
            return SharedImages.DESC_MARQUEE_TOOL_NODES_16;
        }
        return SharedImages.DESC_MARQUEE_TOOL_16;
    }
}

