/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.rwt.internal.theme.IThemeAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.events.SetDataEvent;
import org.eclipse.swt.internal.widgets.ICellToolTipAdapter;
import org.eclipse.swt.internal.widgets.ICellToolTipProvider;
import org.eclipse.swt.internal.widgets.IItemHolderAdapter;
import org.eclipse.swt.internal.widgets.ITreeAdapter;
import org.eclipse.swt.internal.widgets.ItemHolder;
import org.eclipse.swt.internal.widgets.WidgetTreeVisitor;
import org.eclipse.swt.internal.widgets.treekit.TreeThemeAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tree
extends Composite {
    private static final TreeItem[] EMPTY_SELECTION = new TreeItem[0];
    private static final int MIN_ITEM_HEIGHT = 16;
    private static final int GRID_WIDTH = 1;
    private static final Rectangle TEXT_MARGIN = new Rectangle(3, 0, 8, 0);
    private int itemCount;
    private int customItemHeight;
    private TreeItem[] items;
    final ItemHolder<TreeColumn> columnHolder = new ItemHolder<TreeColumn>(TreeColumn.class);
    private TreeItem[] selection;
    private boolean linesVisible;
    private int[] columnOrder;
    private int itemImageCount;
    private TreeColumn sortColumn;
    private int sortDirection;
    private boolean headerVisible;
    private final ITreeAdapter treeAdapter = new InternalTreeAdapter();
    private int scrollLeft;
    private int topItemIndex;
    private boolean hasVScrollBar;
    private boolean hasHScrollBar;
    private Point itemImageSize;
    LayoutCache layoutCache;
    boolean isFlatIndexValid;
    private int visibleItemsCount;
    boolean markupEnabled;
    boolean markupValidationDisabled;

    public Tree(Composite parent, int style) {
        super(parent, Tree.checkStyle(style));
        this.setTreeEmpty();
        this.sortDirection = 0;
        this.selection = EMPTY_SELECTION;
        this.customItemHeight = -1;
        this.layoutCache = new LayoutCache();
    }

    TreeItem[] getCreatedItems() {
        TreeItem[] result;
        if (this.isVirtual()) {
            int count = 0;
            int i = 0;
            while (i < this.itemCount) {
                if (this.items[i] != null && this.items[i].isCached()) {
                    ++count;
                }
                ++i;
            }
            result = new TreeItem[count];
            count = 0;
            i = 0;
            while (i < this.itemCount) {
                if (this.items[i] != null && this.items[i].isCached()) {
                    result[count] = this.items[i];
                    ++count;
                }
                ++i;
            }
        } else {
            result = new TreeItem[this.itemCount];
            System.arraycopy(this.items, 0, result, 0, this.itemCount);
        }
        return result;
    }

    private void setTreeEmpty() {
        this.items = new TreeItem[4];
    }

    @Override
    void initState() {
        this.state &= 0xFFFFFEFF;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        Object result = adapter == IItemHolderAdapter.class ? new CompositeItemHolder() : (adapter == ITreeAdapter.class ? this.treeAdapter : (adapter == ICellToolTipAdapter.class ? this.treeAdapter : super.getAdapter(adapter)));
        return (T)result;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        int i = 0;
        while (i < this.itemCount) {
            if (this.items[i] != null) {
                this.items[i].clearPreferredWidthBuffers(true);
            }
            ++i;
        }
        this.layoutCache.invalidateItemHeight();
        this.updateScrollBars();
    }

    public void setItemCount(int count) {
        this.checkWidget();
        int oldItemCount = this.itemCount;
        int newItemCount = Math.max(0, count);
        if (newItemCount != oldItemCount) {
            int deleteIndex = oldItemCount - 1;
            while (deleteIndex >= newItemCount) {
                TreeItem item = this.items[deleteIndex];
                if (item != null && !item.isDisposed()) {
                    item.dispose();
                } else {
                    this.destroyItem(null, deleteIndex);
                }
                --deleteIndex;
            }
            int length = Math.max(4, (newItemCount + 3) / 4 * 4);
            TreeItem[] newItems = new TreeItem[length];
            System.arraycopy(this.items, 0, newItems, 0, Math.min(newItemCount, this.itemCount));
            this.items = newItems;
            if (!this.isVirtual()) {
                int i = this.itemCount;
                while (i < newItemCount) {
                    this.items[i] = new TreeItem(this, 0, i);
                    ++i;
                }
            }
            this.itemCount = newItemCount;
            this.isFlatIndexValid = false;
            this.updateScrollBars();
            this.redraw();
        }
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        TreeItem[] result = new TreeItem[this.itemCount];
        if (this.isVirtual()) {
            int i = 0;
            while (i < this.itemCount) {
                result[i] = this._getItem(i);
                ++i;
            }
        } else {
            System.arraycopy(this.items, 0, result, 0, this.itemCount);
        }
        return result;
    }

    private TreeItem _getItem(int index) {
        if (this.isVirtual() && this.items[index] == null) {
            this.items[index] = new TreeItem(this, null, 0, index, false);
        }
        return this.items[index];
    }

    public TreeItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            SWT.error(6);
        }
        return this._getItem(index);
    }

    public int indexOf(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        if (item.isDisposed()) {
            SWT.error(5);
        }
        return item.parent == this ? item.index : -1;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    public void removeAll() {
        this.checkWidget();
        int i = this.itemCount - 1;
        while (i >= 0) {
            if (this.items[i] != null) {
                this.items[i].dispose();
            } else {
                --this.itemCount;
            }
            --i;
        }
        this.setTreeEmpty();
        this.selection = EMPTY_SELECTION;
    }

    public void showItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.getParent() == this) {
            TreeItem parent = item.getParentItem();
            while (parent != null) {
                parent.setExpanded(true);
                parent = parent.getParentItem();
            }
            int flatIndex = item.getFlatIndex();
            if (flatIndex <= this.topItemIndex) {
                this.setTopItemIndex(flatIndex);
            } else {
                int itemsAreaHeight = this.getClientArea().height - this.getHeaderHeight();
                int rows = (int)Math.floor(itemsAreaHeight / this.getItemHeight());
                if (flatIndex >= this.topItemIndex + rows) {
                    this.setTopItemIndex(flatIndex - rows + 1);
                }
            }
        }
    }

    public void setTopItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.getParent() == this) {
            TreeItem parent = item.getParentItem();
            while (parent != null) {
                parent.setExpanded(true);
                parent = parent.getParentItem();
            }
            int itemsAreaHeight = this.getClientArea().height - this.getHeaderHeight();
            int rows = (int)Math.floor(itemsAreaHeight / this.getItemHeight());
            int flatIndex = item.getFlatIndex();
            if (flatIndex <= this.topItemIndex || flatIndex + rows <= this.visibleItemsCount) {
                this.setTopItemIndex(flatIndex);
            } else {
                int index = Math.max(0, this.visibleItemsCount - rows);
                this.setTopItemIndex(index);
            }
        }
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        TreeItem result = null;
        if (this.itemCount > 0) {
            List<TreeItem> visibleItems = this.collectVisibleItems(null);
            result = visibleItems.get(this.topItemIndex);
        }
        return result;
    }

    private void setTopItemIndex(int index) {
        if (index != this.topItemIndex) {
            this.topItemIndex = index;
            this.adjustTopItemIndex();
            this.updateAllItems();
        }
    }

    int getTopItemIndex() {
        return this.topItemIndex;
    }

    public void showColumn(TreeColumn column) {
        int index;
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (column.getParent() == this && (index = this.indexOf(column)) >= 0 && index < this.getColumnCount()) {
            int leftColumnsWidth = 0;
            int rightColumnsWidth = 0;
            int columnWidth = column.getWidth();
            int clientWidth = this.getClientArea().width;
            int[] columnOrder = this.getColumnOrder();
            boolean found = false;
            int i = 0;
            while (i < columnOrder.length) {
                if (index != columnOrder[i]) {
                    int currentColumnWidth = this.getColumn(columnOrder[i]).getWidth();
                    if (found) {
                        rightColumnsWidth += currentColumnWidth;
                    } else if (this.isFixedColumn(columnOrder[i])) {
                        clientWidth -= currentColumnWidth;
                    } else {
                        leftColumnsWidth += currentColumnWidth;
                    }
                } else {
                    found = true;
                }
                ++i;
            }
            if (this.getColumnLeftOffset(index) > leftColumnsWidth) {
                this.scrollLeft = leftColumnsWidth;
            } else if (this.scrollLeft < leftColumnsWidth + columnWidth - clientWidth) {
                this.scrollLeft = columnWidth + rightColumnsWidth < clientWidth ? leftColumnsWidth + columnWidth + rightColumnsWidth - clientWidth : leftColumnsWidth;
            }
        }
    }

    public void showSelection() {
        this.checkWidget();
        if (this.selection.length == 0) {
            return;
        }
        this.showItem(this.selection[0]);
    }

    public TreeItem[] getSelection() {
        this.checkWidget();
        TreeItem[] result = new TreeItem[this.selection.length];
        System.arraycopy(this.selection, 0, result, 0, this.selection.length);
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.selection.length;
    }

    public void setSelection(TreeItem selection) {
        this.checkWidget();
        if (selection == null) {
            SWT.error(4);
        }
        this.setSelection(new TreeItem[]{selection});
    }

    public void setSelection(TreeItem[] selection) {
        this.checkWidget();
        if (selection == null) {
            SWT.error(4);
        }
        int length = selection.length;
        if ((this.style & 4) != 0) {
            if (length == 0 || length > 1) {
                this.deselectAll();
            } else {
                TreeItem item = selection[0];
                if (item != null) {
                    if (item.isDisposed()) {
                        SWT.error(5);
                    }
                    this.selection = new TreeItem[]{item};
                }
            }
        } else if (length == 0) {
            this.deselectAll();
        } else {
            TreeItem[] validSelection = new TreeItem[length];
            int validLength = 0;
            int i = 0;
            while (i < length) {
                if (selection[i] != null) {
                    if (selection[i].isDisposed()) {
                        SWT.error(5);
                    }
                    validSelection[validLength] = selection[i];
                    ++validLength;
                }
                ++i;
            }
            if (validLength > 0) {
                this.selection = new TreeItem[validLength];
                System.arraycopy(validSelection, 0, this.selection, 0, validLength);
            }
        }
    }

    public void select(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 4) != 0) {
            this.setSelection(item);
        } else {
            ArrayList<TreeItem> selItems = new ArrayList<TreeItem>(Arrays.asList(this.selection));
            if (!selItems.contains(item)) {
                selItems.add(item);
                this.selection = new TreeItem[selItems.size()];
                selItems.toArray(this.selection);
            }
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            final ArrayList allItems = new ArrayList();
            WidgetTreeVisitor.accept(this, new WidgetTreeVisitor.AllWidgetTreeVisitor(){

                public boolean doVisit(Widget widget) {
                    if (widget instanceof TreeItem) {
                        allItems.add((TreeItem)widget);
                    }
                    return true;
                }
            });
            this.selection = new TreeItem[allItems.size()];
            allItems.toArray(this.selection);
        }
    }

    public void deselect(TreeItem item) {
        ArrayList<TreeItem> selItems;
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if ((selItems = new ArrayList<TreeItem>(Arrays.asList(this.selection))).contains(item)) {
            selItems.remove(item);
            this.selection = new TreeItem[selItems.size()];
            selItems.toArray(this.selection);
        }
    }

    public void deselectAll() {
        this.checkWidget();
        this.selection = EMPTY_SELECTION;
    }

    public void setLinesVisible(boolean value) {
        this.checkWidget();
        if (this.linesVisible == value) {
            return;
        }
        this.linesVisible = value;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 1;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return this.linesVisible;
    }

    public void clear(int index, boolean recursive) {
        TreeItem item;
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        if ((item = this.items[index]) != null) {
            item.clear();
            if (recursive) {
                item.clearAll(true, false);
            }
        }
    }

    public TreeItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        TreeItem result = null;
        int index = (point.y - this.getHeaderHeight()) / this.getItemHeight() + this.topItemIndex;
        List<TreeItem> visibleItems = this.collectVisibleItems(null);
        if (index >= 0 && index < visibleItems.size()) {
            result = visibleItems.get(index);
        }
        return result;
    }

    private List<TreeItem> collectVisibleItems(TreeItem parentItem) {
        ArrayList<TreeItem> result = new ArrayList<TreeItem>();
        TreeItem[] items = parentItem == null ? this.items : parentItem.items;
        int itemCount = parentItem == null ? this.itemCount : parentItem.itemCount;
        int i = 0;
        while (i < itemCount) {
            TreeItem item = items[i];
            result.add(item);
            if (item != null && item.getExpanded()) {
                result.addAll(this.collectVisibleItems(item));
            }
            ++i;
        }
        return result;
    }

    public int getItemHeight() {
        this.checkWidget();
        int result = this.customItemHeight;
        if (result == -1) {
            if (!this.layoutCache.hasItemHeight()) {
                this.layoutCache.itemHeight = this.computeItemHeight();
            }
            result = this.layoutCache.itemHeight;
        }
        return result;
    }

    public void clearAll(boolean recursive) {
        this.checkWidget();
        int i = 0;
        while (i < this.itemCount) {
            TreeItem item = this.items[i];
            if (item != null) {
                item.clear();
                if (recursive) {
                    item.clearAll(true, false);
                }
            }
            ++i;
        }
        if (this.isVirtual() && this.itemCount != 0) {
            this.updateAllItems();
        }
    }

    @Override
    public void changed(Control[] changed) {
        this.clearItemsPreferredWidthBuffer();
        super.changed(changed);
    }

    private void clearItemsPreferredWidthBuffer() {
        int i = 0;
        while (i < this.itemCount) {
            TreeItem item = this.items[i];
            if (item != null) {
                item.clearPreferredWidthBuffers(true);
            }
            ++i;
        }
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnHolder.size();
    }

    void createColumn(TreeColumn column, int index) {
        this.columnHolder.insert(column, index);
        if (this.columnOrder == null) {
            this.columnOrder = new int[]{index};
        } else {
            int length = this.columnOrder.length;
            int i = index;
            while (i < length) {
                int n = i++;
                this.columnOrder[n] = this.columnOrder[n] + 1;
            }
            int[] newColumnOrder = new int[length + 1];
            System.arraycopy(this.columnOrder, 0, newColumnOrder, 0, index);
            System.arraycopy(this.columnOrder, index, newColumnOrder, index + 1, length - index);
            this.columnOrder = newColumnOrder;
            this.columnOrder[index] = index;
        }
        int i = 0;
        while (i < this.itemCount) {
            if (this.items[i] != null) {
                this.items[i].shiftData(index);
            }
            ++i;
        }
        this.updateScrollBars();
    }

    final void destroyColumn(TreeColumn column) {
        if (!this.isInDispose()) {
            int index = this.indexOf(column);
            int i = 0;
            while (i < this.itemCount) {
                if (this.items[i] != null) {
                    this.items[i].removeData(index);
                }
                ++i;
            }
            if (column == this.sortColumn) {
                this.sortColumn = null;
            }
            this.columnHolder.remove(column);
            int length = this.columnOrder.length;
            int[] newColumnOrder = new int[length - 1];
            int count = 0;
            int i2 = 0;
            while (i2 < length) {
                if (this.columnOrder[i2] != index) {
                    int newOrder = this.columnOrder[i2];
                    if (index < newOrder) {
                        // empty if block
                    }
                    newColumnOrder[count] = --newOrder;
                    ++count;
                }
                ++i2;
            }
            this.columnOrder = newColumnOrder;
            this.updateScrollBars();
        }
    }

    public int getHeaderHeight() {
        this.checkWidget();
        if (!this.layoutCache.hasHeaderHeight()) {
            this.layoutCache.headerHeight = this.computeHeaderHeight();
        }
        return this.layoutCache.headerHeight;
    }

    public void setHeaderVisible(boolean value) {
        this.checkWidget();
        if (this.headerVisible != value) {
            this.headerVisible = value;
            this.layoutCache.invalidateHeaderHeight();
            this.updateScrollBars();
        }
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return this.headerVisible;
    }

    public int indexOf(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            SWT.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        return this.columnHolder.indexOf(column);
    }

    public TreeColumn getColumn(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.columnHolder.size()) {
            this.error(6);
        }
        return this.columnHolder.getItem(index);
    }

    public TreeColumn[] getColumns() {
        this.checkWidget();
        return (TreeColumn[])this.columnHolder.getItems();
    }

    public void setColumnOrder(int[] order) {
        int columnCount;
        this.checkWidget();
        if (order == null) {
            this.error(4);
        }
        if (order.length != (columnCount = this.getColumnCount())) {
            this.error(5);
        }
        if (columnCount > 0) {
            int[] oldOrder = new int[columnCount];
            System.arraycopy(this.columnOrder, 0, oldOrder, 0, this.columnOrder.length);
            boolean reorder = false;
            boolean[] seen = new boolean[columnCount];
            int i = 0;
            while (i < order.length) {
                int index = order[i];
                if (index < 0 || index >= columnCount) {
                    this.error(6);
                }
                if (seen[index]) {
                    this.error(5);
                }
                seen[index] = true;
                if (index != oldOrder[i]) {
                    reorder = true;
                }
                ++i;
            }
            if (reorder) {
                System.arraycopy(order, 0, this.columnOrder, 0, this.columnOrder.length);
                i = 0;
                while (i < seen.length) {
                    if (oldOrder[i] != this.columnOrder[i]) {
                        TreeColumn column = this.getColumn(this.columnOrder[i]);
                        int controlMoved = 10;
                        ControlEvent controlEvent = new ControlEvent(column, controlMoved);
                        controlEvent.processEvent();
                    }
                    ++i;
                }
            }
        }
    }

    public void setSortColumn(TreeColumn column) {
        this.checkWidget();
        if (column != null && column.isDisposed()) {
            this.error(5);
        }
        if (column == this.sortColumn) {
            return;
        }
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            this.sortColumn.setSortDirection(0);
        }
        this.sortColumn = column;
        if (this.sortColumn != null) {
            this.sortColumn.setSortDirection(this.sortDirection);
        }
    }

    public void setSortDirection(int direction) {
        this.checkWidget();
        if (direction != 128 && direction != 1024 && direction != 0) {
            return;
        }
        this.sortDirection = direction;
        if (this.sortColumn == null || this.sortColumn.isDisposed()) {
            return;
        }
        this.sortColumn.setSortDirection(this.sortDirection);
    }

    public TreeColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public int[] getColumnOrder() {
        int[] result;
        this.checkWidget();
        if (this.columnHolder.size() == 0) {
            result = new int[]{};
        } else {
            result = new int[this.columnOrder.length];
            System.arraycopy(this.columnOrder, 0, result, 0, this.columnOrder.length);
        }
        return result;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.addListener(this, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.removeListener(this, listener);
    }

    public void addTreeListener(TreeListener listener) {
        this.checkWidget();
        TreeEvent.addListener((Adaptable)this, listener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.checkWidget();
        TreeEvent.removeListener((Adaptable)this, listener);
    }

    @Override
    public void setData(String key, Object value) {
        if ("org.eclipse.rwt.themeVariant".equals(key)) {
            this.layoutCache.invalidateAll();
        } else if ("org.eclipse.rap.rwt.customItemHeight".equals(key)) {
            this.setCustomItemHeight(value);
        } else if ("org.eclipse.rap.rwt.markupEnabled".equals(key) && !this.markupEnabled) {
            this.markupEnabled = Boolean.TRUE.equals(value);
        } else if ("org.eclipse.rap.rwt.markupValidationDisabled".equals(key)) {
            this.markupValidationDisabled = Boolean.TRUE.equals(value);
        }
        super.setData(key, value);
    }

    @Override
    void releaseChildren() {
        int i = this.items.length - 1;
        while (i >= 0) {
            if (this.items[i] != null) {
                this.items[i].dispose();
            }
            --i;
        }
        TreeColumn[] cols = (TreeColumn[])this.columnHolder.getItems();
        int c = 0;
        while (c < cols.length) {
            cols[c].dispose();
            this.columnHolder.remove(cols[c]);
            ++c;
        }
        super.releaseChildren();
    }

    void removeFromSelection(TreeItem item) {
        int index = -1;
        int i = 0;
        while (index == -1 && i < this.selection.length) {
            if (this.selection[i] == item) {
                index = i;
            }
            ++i;
        }
        if (index != -1) {
            TreeItem[] newSelection = new TreeItem[this.selection.length - 1];
            System.arraycopy(this.selection, 0, newSelection, 0, index);
            if (index < this.selection.length - 1) {
                int length = this.selection.length - index - 1;
                System.arraycopy(this.selection, index + 1, newSelection, index, length);
            }
            this.selection = newSelection;
        }
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        TreeItem item;
        int i;
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (this.getColumnCount() > 0) {
            i = 0;
            while (i < this.getColumnCount()) {
                width += this.getColumn(i).getWidth();
                ++i;
            }
        } else {
            i = 0;
            while (i < this.itemCount) {
                item = this.items[i];
                if (item != null && item.isCached()) {
                    int itemWidth = item.getPreferredWidth(0, false);
                    width = Math.max(width, itemWidth);
                    if (item.getExpanded()) {
                        int innerWidth = this.getMaxInnerWidth(item.items, 0, 1, false);
                        width = Math.max(width, innerWidth);
                    }
                }
                ++i;
            }
        }
        height += this.getHeaderHeight();
        height += this.itemCount * this.getItemHeight();
        i = 0;
        while (i < this.itemCount) {
            item = this.items[i];
            if (item != null && !item.isInDispose() && item.getExpanded()) {
                height += item.getInnerHeight();
            }
            ++i;
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        width += border * 2;
        height += border * 2;
        if ((this.style & 0x200) != 0) {
            width += this.getVerticalBar().getSize().x;
        }
        if ((this.style & 0x100) != 0) {
            height += this.getHorizontalBar().getSize().y;
        }
        return new Point(width, height);
    }

    private void setCustomItemHeight(Object value) {
        if (value == null) {
            this.customItemHeight = -1;
        } else {
            int itemHeight;
            if (!(value instanceof Integer)) {
                this.error(5);
            }
            if ((itemHeight = ((Integer)value).intValue()) < 0) {
                this.error(6);
            }
            this.customItemHeight = itemHeight;
        }
    }

    int getMaxContentWidth(TreeColumn column) {
        return this.getMaxInnerWidth(this.items, this.indexOf(column), 1, true);
    }

    private int getMaxInnerWidth(TreeItem[] items, int columnIndex, int level, boolean clearBuffer) {
        int maxInnerWidth = 0;
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            if (item != null && item.isCached()) {
                int indention;
                int n = indention = columnIndex == 0 ? level * this.getIndentionWidth() : 0;
                if (clearBuffer) {
                    item.clearPreferredWidthBuffers(false);
                }
                int itemWidth = item.getPreferredWidth(columnIndex, false) + indention;
                maxInnerWidth = Math.max(maxInnerWidth, itemWidth);
                if (item.getExpanded()) {
                    int innerWidth = this.getMaxInnerWidth(item.items, columnIndex, level + 1, clearBuffer);
                    maxInnerWidth = Math.max(maxInnerWidth, innerWidth);
                }
            }
            ++i;
        }
        return maxInnerWidth;
    }

    int getCellLeft(int index) {
        return this.getColumnCount() == 0 ? 0 : this.getColumn(index).getLeft();
    }

    private int getCellWidth(int index) {
        return this.getColumnCount() == 0 && index == 0 ? this.getMaxInnerWidth(this.items, 0, 1, false) : this.getColumn(index).getWidth();
    }

    int getImageOffset(int index) {
        int result;
        int n = result = this.isTreeColumn(index) ? 0 : this.getCellPadding().x;
        if (this.hasCheckBoxes(index)) {
            result += this.getCheckImageOuterSize().x;
        }
        return result;
    }

    private int getTextOffset(int index) {
        int result = this.getImageOffset(index);
        result += this.getItemImageOuterWidth(index);
        if (this.isTreeColumn(index)) {
            result += Tree.TEXT_MARGIN.x;
        }
        return result;
    }

    int getTextWidth(int index) {
        int result = this.getCellWidth(index) - this.getTextOffset(index) - this.getCellPadding().width;
        if (this.isTreeColumn(index)) {
            result -= Tree.TEXT_MARGIN.width - Tree.TEXT_MARGIN.x;
        }
        return Math.max(0, result);
    }

    int getIndentionOffset(TreeItem item) {
        return this.getIndentionWidth() * (item.depth + 1);
    }

    int getVisualCellLeft(int index, TreeItem item) {
        int result = this.getCellLeft(index) - this.getColumnLeftOffset(index);
        if (this.isTreeColumn(index)) {
            result += this.getIndentionOffset(item);
        }
        if (this.hasCheckBoxes(index)) {
            result += this.getCheckImageOuterSize().x;
        }
        return result;
    }

    int getVisualCellWidth(int index, TreeItem item) {
        int result;
        if (this.getColumnCount() == 0 && index == 0) {
            String text = item.getText(0);
            int textWidth = Graphics.stringExtent((Font)item.getFont(), (String)text).x;
            result = this.getCellPadding().width + this.getItemImageOuterWidth(index) + textWidth + Tree.TEXT_MARGIN.width;
        } else {
            result = this.getColumn(index).getWidth();
            if (this.isTreeColumn(index)) {
                result -= this.getIndentionOffset(item);
            }
            if (this.hasCheckBoxes(index)) {
                result -= this.getCheckImageOuterSize().x;
            }
            result = Math.max(0, result);
        }
        return result;
    }

    int getVisualTextLeft(int index, TreeItem item) {
        return this.getVisualCellLeft(index, item) + this.getCellPadding().x + this.getItemImageOuterWidth(index);
    }

    int getVisualTextWidth(int index, TreeItem item) {
        int result = 0;
        if (index == 0 && this.getColumnCount() == 0) {
            result = Graphics.stringExtent((Font)item.getFont(), (String)item.getText((int)0)).x;
            result += Tree.TEXT_MARGIN.width;
        } else if (index >= 0 && index < this.getColumnCount()) {
            result = this.getTextWidth(index) - this.getIndentionOffset(item);
            result = Math.max(0, result);
        }
        return result;
    }

    int getPreferredCellWidth(TreeItem item, int columnIndex, boolean checkData) {
        int result = item.getPreferredWidthBuffer(columnIndex);
        if (!item.hasPreferredWidthBuffer(columnIndex)) {
            result = this.getTextOffset(columnIndex);
            Rectangle padding = this.getCellPadding();
            result += Graphics.stringExtent((Font)this.getFont(), (String)item.getTextWithoutMaterialize((int)columnIndex)).x;
            result += padding.width - padding.x;
            if (this.isTreeColumn(columnIndex)) {
                result += Tree.TEXT_MARGIN.width - Tree.TEXT_MARGIN.x;
            }
            item.setPreferredWidthBuffer(columnIndex, result);
        }
        return result;
    }

    boolean isTreeColumn(int index) {
        return index == 0 && this.getColumnCount() == 0 || this.getColumnCount() > 0 && this.getColumnOrder()[0] == index;
    }

    final int getColumnLeftOffset(int columnIndex) {
        int result = this.scrollLeft;
        if (columnIndex >= 0) {
            result = this.isFixedColumn(columnIndex) ? 0 : this.scrollLeft;
        }
        return result;
    }

    private boolean isFixedColumn(int index) {
        int[] columnOrder = this.getColumnOrder();
        int visualIndex = -1;
        int i = 0;
        while (i < columnOrder.length && visualIndex == -1) {
            if (index == columnOrder[i]) {
                visualIndex = i;
            }
            ++i;
        }
        return visualIndex < this.getFixedColumns();
    }

    private int getFixedColumns() {
        int result = -1;
        try {
            Integer data = (Integer)this.getData("org.eclipse.rap.rwt.fixedColumns");
            if (data != null) {
                result = data;
            }
        }
        catch (ClassCastException classCastException) {}
        return result;
    }

    private boolean hasCheckBoxes(int index) {
        return (this.style & 0x20) != 0 && this.isTreeColumn(index);
    }

    private boolean hasColumnImages(int columnIndex) {
        int count;
        int n = count = columnIndex == 0 ? this.itemImageCount : this.getColumn((int)columnIndex).itemImageCount;
        return count > 0;
    }

    void updateColumnImageCount(int columnIndex, Image oldImage, Image newImage) {
        int delta = 0;
        if (oldImage == null && newImage != null) {
            delta = 1;
        } else if (oldImage != null && newImage == null) {
            delta = -1;
        }
        if (delta != 0) {
            if (columnIndex == 0) {
                this.itemImageCount += delta;
            } else {
                TreeColumn column = this.getColumn(columnIndex);
                column.itemImageCount += delta;
            }
        }
    }

    void updateItemImageSize(Image image) {
        if (image != null && this.itemImageSize == null) {
            Rectangle imageBounds = image.getBounds();
            this.itemImageSize = new Point(imageBounds.width, imageBounds.height);
            this.layoutCache.invalidateItemHeight();
        }
    }

    Point getItemImageSize(int index) {
        Point result;
        if (this.hasColumnImages(index)) {
            result = this.getItemImageSize();
            if (this.getColumnCount() > 0) {
                int availWidth = this.getColumn(index).getWidth();
                availWidth -= this.getCellPadding().x;
                availWidth = Math.max(0, availWidth);
                result.x = Math.min(result.x, availWidth);
            }
        } else {
            result = new Point(0, 0);
        }
        return result;
    }

    private int getItemImageOuterWidth(int index) {
        int result = 0;
        if (this.hasColumnImages(index)) {
            result += this.getItemImageSize((int)index).x;
            result += this.getCellSpacing();
        }
        return result;
    }

    private Point getItemImageSize() {
        Point result = new Point(0, 0);
        if (this.itemImageSize != null) {
            result.x = this.itemImageSize.x;
            result.y = this.itemImageSize.y;
        }
        return result;
    }

    private Point getCheckImageSize() {
        return this.getThemeAdapter().getCheckBoxImageSize(this);
    }

    private TreeThemeAdapter getThemeAdapter() {
        return (TreeThemeAdapter)this.getAdapter(IThemeAdapter.class);
    }

    private Point getCheckImageOuterSize() {
        Point result = this.getCheckImageSize();
        Rectangle margin = this.getCheckBoxMargin();
        result.x += margin.width;
        result.y += margin.height;
        return result;
    }

    private Rectangle getCheckBoxMargin() {
        if (!this.layoutCache.hasCheckBoxMargin()) {
            this.layoutCache.checkBoxMargin = this.getThemeAdapter().getCheckBoxMargin(this);
        }
        return this.layoutCache.checkBoxMargin;
    }

    private int getIndentionWidth() {
        return this.getThemeAdapter().getIndentionWidth(this);
    }

    private int computeHeaderHeight() {
        int result = 0;
        if (this.headerVisible) {
            TreeThemeAdapter themeAdapter = this.getThemeAdapter();
            Font headerFont = themeAdapter.getHeaderFont(this);
            int textHeight = Graphics.getCharHeight(headerFont);
            int imageHeight = 0;
            int i = 0;
            while (i < this.getColumnCount()) {
                Image image;
                int height;
                TreeColumn column = this.columnHolder.getItem(i);
                if (column.getText().contains("\n")) {
                    int columnTextHeight = Graphics.textExtent((Font)headerFont, (String)column.getText(), (int)0).y;
                    textHeight = Math.max(textHeight, columnTextHeight);
                }
                int n = height = (image = this.getColumn(i).getImage()) == null ? 0 : image.getBounds().height;
                if (height > imageHeight) {
                    imageHeight = height;
                }
                ++i;
            }
            result = Math.max(textHeight, imageHeight);
            result += themeAdapter.getHeaderBorderBottomWidth(this);
            result += themeAdapter.getHeaderPadding((Control)this).height;
        }
        return result;
    }

    private int computeItemHeight() {
        Rectangle padding = this.getCellPadding();
        int textHeight = Graphics.getCharHeight(this.getFont());
        int itemImageHeight = this.getItemImageSize().y + padding.height;
        int result = Math.max(itemImageHeight, textHeight += Tree.TEXT_MARGIN.height + padding.height);
        if (this.hasCheckBoxes(0)) {
            result = Math.max(this.getCheckImageOuterSize().y, result);
        }
        ++result;
        result = Math.max(result, 16);
        return result;
    }

    @Override
    void notifyResize(Point oldSize) {
        if (!oldSize.equals(this.getSize()) && !TextSizeUtil.isTemporaryResize()) {
            this.updateAllItems();
            this.updateScrollBars();
            this.adjustTopItemIndex();
        }
        super.notifyResize(oldSize);
    }

    private void adjustTopItemIndex() {
        int correction;
        int visibleRowCount = this.getVisibleRowCount(false);
        int n = correction = visibleRowCount == 0 ? 1 : 0;
        if (this.topItemIndex > this.visibleItemsCount - visibleRowCount - correction) {
            this.topItemIndex = Math.max(0, this.visibleItemsCount - visibleRowCount - correction);
        }
    }

    private int getVisibleRowCount(boolean includePartlyVisible) {
        int clientHeight = this.getBounds().height - this.getHeaderHeight() - this.getHScrollBarHeight();
        int result = 0;
        if (clientHeight >= 0) {
            int itemHeight = this.getItemHeight();
            result = clientHeight / itemHeight;
            if (includePartlyVisible && clientHeight % itemHeight != 0) {
                ++result;
            }
        }
        return result;
    }

    void updateAllItems() {
        int flatIndex = 0;
        int index = 0;
        while (index < this.itemCount) {
            flatIndex = this.updateAllItemsRecursively(null, index, flatIndex);
            ++index;
        }
        this.isFlatIndexValid = true;
        this.visibleItemsCount = flatIndex;
    }

    private int updateAllItemsRecursively(TreeItem parent, int index, int flatIndex) {
        TreeItem item;
        int newFlatIndex = flatIndex;
        TreeItem treeItem = item = parent == null ? this.items[index] : parent.items[index];
        if (this.isVirtual() && this.isItemVisible(flatIndex)) {
            if (item == null) {
                item = parent == null ? this._getItem(index) : parent._getItem(index);
            }
            this.checkData(item, index);
        }
        if (item != null) {
            item.setFlatIndex(newFlatIndex);
        }
        ++newFlatIndex;
        if (item != null && item.isCached() && item.getExpanded()) {
            int i = 0;
            while (i < item.itemCount) {
                newFlatIndex = this.updateAllItemsRecursively(item, i, newFlatIndex);
                ++i;
            }
        }
        return newFlatIndex;
    }

    private boolean isItemVisible(int flatIndex) {
        boolean result = false;
        int headerHeight = this.getHeaderHeight();
        int itemHeight = this.getItemHeight();
        int itemPosition = headerHeight + (flatIndex - this.getTopItemIndex()) * itemHeight;
        if (itemPosition >= 0 && itemPosition <= this.getSize().y) {
            result = true;
        }
        return result;
    }

    final boolean checkData(TreeItem item, int index) {
        boolean result = true;
        if (this.isVirtual() && !item.isCached()) {
            item.markCached();
            SetDataEvent event = new SetDataEvent(this, item, index);
            event.processEvent();
            if (this.isDisposed() || item.isDisposed()) {
                result = false;
            }
        }
        return result;
    }

    private static int checkStyle(int style) {
        int result = style;
        if ((style & 0x10) == 0) {
            result |= 0x300;
        }
        return Tree.checkBits(result, 4, 2, 0, 0, 0, 0);
    }

    Rectangle getCellPadding() {
        if (!this.layoutCache.hasCellPadding()) {
            this.layoutCache.cellPadding = this.getThemeAdapter().getCellPadding(this);
        }
        return this.layoutCache.cellPadding;
    }

    int getCellSpacing() {
        if (!this.layoutCache.hasCellSpacing()) {
            this.layoutCache.cellSpacing = this.getThemeAdapter().getCellSpacing(this);
        }
        return this.layoutCache.cellSpacing;
    }

    boolean hasVScrollBar() {
        return this.hasVScrollBar;
    }

    boolean hasHScrollBar() {
        return this.hasHScrollBar;
    }

    @Override
    int getVScrollBarWidth() {
        int result = 0;
        if (this.hasVScrollBar()) {
            result = this.getVerticalBar().getSize().x;
        }
        return result;
    }

    @Override
    int getHScrollBarHeight() {
        int result = 0;
        if (this.hasHScrollBar()) {
            result = this.getHorizontalBar().getSize().y;
        }
        return result;
    }

    boolean needsVScrollBar() {
        int availableHeight = this.getClientArea().height;
        int height = this.getHeaderHeight();
        height += this.itemCount * this.getItemHeight();
        int i = 0;
        while (i < this.itemCount) {
            TreeItem item = this.items[i];
            if (item != null && item.getExpanded()) {
                height += item.getInnerHeight();
            }
            ++i;
        }
        return height > availableHeight;
    }

    boolean needsHScrollBar() {
        boolean result = false;
        int availableWidth = this.getClientArea().width;
        int columnCount = this.getColumnCount();
        if (columnCount > 0) {
            int totalWidth = 0;
            int i = 0;
            while (i < columnCount) {
                TreeColumn column = this.getColumn(i);
                totalWidth += column.getWidth();
                ++i;
            }
            result = totalWidth > availableWidth;
        } else {
            int maxWidth = 0;
            int i = 0;
            while (i < this.itemCount) {
                TreeItem item = this.items[i];
                if (item != null && !item.isInDispose() && item.isCached()) {
                    int itemWidth = item.getPreferredWidth(0, false);
                    maxWidth = Math.max(maxWidth, itemWidth);
                    if (item.getExpanded()) {
                        int innerWidth = this.getMaxInnerWidth(item.items, 0, 1, false);
                        maxWidth = Math.max(maxWidth, innerWidth);
                    }
                }
                ++i;
            }
            result = maxWidth > availableWidth;
        }
        return result;
    }

    void updateScrollBars() {
        if ((this.style & 0x10) == 0) {
            this.hasVScrollBar = false;
            this.hasHScrollBar = this.needsHScrollBar();
            if (this.needsVScrollBar()) {
                this.hasVScrollBar = true;
                this.hasHScrollBar = this.needsHScrollBar();
            }
            this.getHorizontalBar().setVisible(this.hasHScrollBar);
            this.getVerticalBar().setVisible(this.hasVScrollBar);
        }
    }

    boolean isVirtual() {
        return (this.style & 0x10000000) != 0;
    }

    void createItem(TreeItem item, int index) {
        if (this.itemCount == this.items.length) {
            boolean small = this.isVisible();
            int length = small ? this.items.length + 4 : Math.max(4, this.items.length * 3 / 2);
            TreeItem[] newItems = new TreeItem[length];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount - index);
        this.items[index] = item;
        ++this.itemCount;
        this.adjustItemIndices(index);
    }

    void destroyItem(TreeItem treeItem, int index) {
        --this.itemCount;
        if (this.itemCount == 0) {
            this.setTreeEmpty();
        } else {
            System.arraycopy(this.items, index + 1, this.items, index, this.itemCount - index);
            this.items[this.itemCount] = null;
        }
        this.adjustItemIndices(index);
    }

    private void adjustItemIndices(int start) {
        int i = start;
        while (i < this.itemCount) {
            if (this.items[i] != null) {
                this.items[i].index = i;
            }
            ++i;
        }
    }

    @Override
    void reskinChildren(int flags) {
        int i = 0;
        while (i < this.itemCount) {
            if (this.items[i] != null) {
                this.items[i].reskinChildren(flags);
            }
            ++i;
        }
        TreeColumn[] columns = this.getColumns();
        if (columns != null) {
            int i2 = 0;
            while (i2 < columns.length) {
                TreeColumn column = columns[i2];
                if (!column.isDisposed()) {
                    column.reskinChildren(flags);
                }
                ++i2;
            }
        }
        super.reskinChildren(flags);
    }

    private final class CompositeItemHolder
    implements IItemHolderAdapter {
        private CompositeItemHolder() {
        }

        public void add(Item item) {
            if (!(item instanceof TreeColumn)) {
                String msg = "Only TreeColumns may be added to CompositeItemHolder";
                throw new IllegalArgumentException(msg);
            }
            Tree.this.columnHolder.add((TreeColumn)item);
        }

        public void insert(Item item, int index) {
            if (!(item instanceof TreeColumn)) {
                String msg = "Only TreeColumns may be inserted to CompositeItemHolder";
                throw new IllegalArgumentException(msg);
            }
            Tree.this.columnHolder.insert((TreeColumn)item, index);
        }

        public void remove(Item item) {
            if (!(item instanceof TreeColumn)) {
                String msg = "Only TreeColumns may be removed from CompositeItemHolder";
                throw new IllegalArgumentException(msg);
            }
            Tree.this.columnHolder.remove((TreeColumn)item);
        }

        public Item[] getItems() {
            TreeItem[] items = Tree.this.getCreatedItems();
            Item[] columns = Tree.this.columnHolder.getItems();
            Item[] result = new Item[columns.length + items.length];
            System.arraycopy(columns, 0, result, 0, columns.length);
            System.arraycopy(items, 0, result, columns.length, items.length);
            return result;
        }
    }

    private final class InternalTreeAdapter
    implements ITreeAdapter,
    ICellToolTipAdapter,
    SerializableCompatibility {
        private String toolTipText;
        private ICellToolTipProvider provider;

        private InternalTreeAdapter() {
        }

        public void checkData() {
            Tree.this.updateAllItems();
        }

        public void setScrollLeft(int left) {
            Tree.this.scrollLeft = left;
        }

        public int getScrollLeft() {
            return Tree.this.scrollLeft;
        }

        public boolean isCached(TreeItem item) {
            return item.isCached();
        }

        public boolean hasHScrollBar() {
            return Tree.this.hasHScrollBar();
        }

        public boolean hasVScrollBar() {
            return Tree.this.hasVScrollBar();
        }

        public Point getItemImageSize(int index) {
            return Tree.this.getItemImageSize(index);
        }

        public int getCellLeft(int index) {
            return Tree.this.getCellLeft(index);
        }

        public int getCellWidth(int index) {
            return Tree.this.getCellWidth(index);
        }

        public int getTextOffset(int index) {
            return Tree.this.getTextOffset(index);
        }

        public int getTextMaxWidth(int index) {
            return Tree.this.getTextWidth(index);
        }

        public int getCheckWidth() {
            return ((Tree)Tree.this).getCheckImageSize().x;
        }

        public int getImageOffset(int index) {
            return Tree.this.getImageOffset(index);
        }

        public int getIndentionWidth() {
            return Tree.this.getIndentionWidth();
        }

        public int getCheckLeft() {
            return ((Tree)Tree.this).getCheckBoxMargin().x;
        }

        public Rectangle getTextMargin() {
            return TEXT_MARGIN;
        }

        public int getTopItemIndex() {
            return Tree.this.getTopItemIndex();
        }

        public void setTopItemIndex(int index) {
            Tree.this.setTopItemIndex(index);
        }

        public int getColumnLeft(TreeColumn column) {
            int index = Tree.this.indexOf(column);
            return Tree.this.getColumn(index).getLeft();
        }

        public ICellToolTipProvider getCellToolTipProvider() {
            return this.provider;
        }

        public void setCellToolTipProvider(ICellToolTipProvider provider) {
            this.provider = provider;
        }

        public String getCellToolTipText() {
            return this.toolTipText;
        }

        public void setCellToolTipText(String toolTipText) {
            this.toolTipText = toolTipText;
        }

        public int getFixedColumns() {
            return Tree.this.getFixedColumns();
        }

        public boolean isFixedColumn(TreeColumn column) {
            return Tree.this.isFixedColumn(Tree.this.indexOf(column));
        }
    }

    static final class LayoutCache
    implements SerializableCompatibility {
        private static final int UNKNOWN = -1;
        int headerHeight = -1;
        int itemHeight = -1;
        int cellSpacing = -1;
        Rectangle cellPadding;
        Rectangle checkBoxMargin;

        LayoutCache() {
        }

        public boolean hasHeaderHeight() {
            return this.headerHeight != -1;
        }

        public void invalidateHeaderHeight() {
            this.headerHeight = -1;
        }

        public boolean hasItemHeight() {
            return this.itemHeight != -1;
        }

        public void invalidateItemHeight() {
            this.itemHeight = -1;
        }

        public boolean hasCellSpacing() {
            return this.cellSpacing != -1;
        }

        public void invalidateCellSpacing() {
            this.cellSpacing = -1;
        }

        public boolean hasCellPadding() {
            return this.cellPadding != null;
        }

        public void invalidateCellPadding() {
            this.cellPadding = null;
        }

        public boolean hasCheckBoxMargin() {
            return this.checkBoxMargin != null;
        }

        public void invalidateCheckBoxMargin() {
            this.checkBoxMargin = null;
        }

        public void invalidateAll() {
            this.invalidateHeaderHeight();
            this.invalidateItemHeight();
            this.invalidateCellSpacing();
            this.invalidateCellPadding();
            this.invalidateCheckBoxMargin();
        }
    }
}

