/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class TabFolderTab
extends ExampleTab {
    protected static final int MAX_ITEMS = 3;
    private boolean onDemandContent;
    private TabFolder folder;
    private TabItem[] tabItems;
    private Button[] tabRadios;

    public TabFolderTab() {
        super("TabFolder");
    }

    protected void createStyleControls(Composite parent) {
        this.createStyleButton("BORDER", 2048);
        this.createStyleButton("TOP", 128);
        this.createStyleButton("BOTTOM", 1024);
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createOnDemandButton(parent);
        this.createFgColorButton();
        this.createBgColorButton();
        this.createFontChooser();
        this.tabRadios = new Button[3];
        int i = 0;
        while (i < 3) {
            this.tabRadios[i] = this.createPropertyButton("Select Tab " + i, 16);
            final int itemIndex = i;
            this.tabRadios[i].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Button radio = (Button)event.getSource();
                    if (radio.getSelection()) {
                        TabFolderTab.this.folder.setSelection(itemIndex);
                    }
                }
            });
            ++i;
        }
        this.tabRadios[0].setSelection(true);
        this.createChangeContentButton(parent);
        this.createInsertItemButton(parent);
        this.createDisposeItemButton(parent);
    }

    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.folder = new TabFolder(parent, this.getStyle());
        this.folder.setToolTipText("Tab Folder Tooltip");
        this.tabItems = new TabItem[3];
        this.folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TabItem item = (TabItem)event.item;
                if (TabFolderTab.this.tabRadios != null) {
                    int index = item.getParent().indexOf(item);
                    int i = 0;
                    while (i < 3) {
                        if (TabFolderTab.this.checkControl((Control)TabFolderTab.this.tabRadios[i])) {
                            TabFolderTab.this.tabRadios[i].setSelection(index == i);
                        }
                        ++i;
                    }
                }
                TabFolderTab.this.createItemContent(item);
            }
        });
        int i = 0;
        while (i < 3) {
            this.tabItems[i] = new TabItem(this.folder, 0);
            this.tabItems[i].setText("TabItem " + i);
            this.tabItems[i].setToolTipText("Tooltip for TabItem " + i);
            if (!this.onDemandContent) {
                this.createItemContent(this.tabItems[i]);
            }
            ++i;
        }
        this.registerControl((Control)this.folder);
    }

    private void createOnDemandButton(Composite parent) {
        Button button = new Button(parent, 32);
        button.setText("Create Item Content on Demand");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                TabFolderTab.this.onDemandContent = button.getSelection();
                TabFolderTab.this.createNew();
            }
        });
    }

    private void createChangeContentButton(Composite parent) {
        Button btnChangeContent = new Button(parent, 8);
        btnChangeContent.setText("Change Content for Selected Item");
        btnChangeContent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TabItem item = TabFolderTab.this.folder.getSelection()[0];
                Label content = new Label((Composite)TabFolderTab.this.folder, 0);
                int index = TabFolderTab.this.folder.indexOf(item);
                content.setText("Alternate content for tab item " + index);
                item.setControl((Control)content);
            }
        });
    }

    private void createInsertItemButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Insert item before first item");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TabItem tabItem = new TabItem(TabFolderTab.this.folder, 0, 0);
                tabItem.setText("TabItem " + TabFolderTab.this.folder.indexOf(tabItem));
                tabItem.setToolTipText("Tooltip for TabItem " + TabFolderTab.this.folder.indexOf(tabItem));
                if (!TabFolderTab.this.onDemandContent) {
                    TabFolderTab.this.createItemContent(tabItem);
                }
            }
        });
    }

    private void createDisposeItemButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Dispose of selected item");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TabItem[] selection = TabFolderTab.this.folder.getSelection();
                if (selection.length > 0) {
                    selection[0].dispose();
                }
            }
        });
    }

    private void createItemContent(TabItem item) {
        if (item.getControl() == null) {
            TabFolder folder = item.getParent();
            Text content = new Text((Composite)folder, 74);
            int index = folder.indexOf(item);
            String text = "This is the content for item " + index;
            if (this.onDemandContent) {
                text = String.valueOf(text) + "\nIt was created on demand, when the item was selected for the first time through user interaction.";
            }
            content.setText(text);
            item.setControl((Control)content);
        }
    }
}

