/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolTip;

public class ToolTipTab
extends ExampleTab {
    private ToolTip toolTip;
    private boolean toolTipAutoHide;
    private String toolTipText = "";
    private String toolTipMessage = "";
    private Point toolTipLocation;
    private boolean toolTipSelectionListener;
    private final SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent event) {
            ToolTipTab.this.log("" + event);
        }
    };

    public ToolTipTab() {
        super("ToolTip");
    }

    protected void createStyleControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.createStyleButton("BALLOON", 4096);
        this.createStyleButton("ICON_ERROR", 1);
        this.createStyleButton("ICON_INFORMATION", 2);
        this.createStyleButton("ICON_WARNING", 8);
        this.createAutoHideButton();
        this.createTextInput();
        this.createMessageInput();
        this.createLocationInput();
        this.createSelectionListenerButton();
    }

    protected void createExampleControls(final Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Button button = new Button(parent, 8);
        button.setText("Show ToolTip");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (ToolTipTab.this.toolTip != null) {
                    ToolTipTab.this.toolTip.dispose();
                }
                ToolTipTab.this.toolTip = new ToolTip(parent.getShell(), ToolTipTab.this.getStyle());
                ToolTipTab.this.toolTip.setVisible(true);
                ToolTipTab.this.toolTip.setAutoHide(ToolTipTab.this.toolTipAutoHide);
                ToolTipTab.this.toolTip.setText(ToolTipTab.this.toolTipText);
                ToolTipTab.this.toolTip.setMessage(ToolTipTab.this.toolTipMessage);
                if (ToolTipTab.this.toolTipLocation != null) {
                    ToolTipTab.this.toolTip.setLocation(ToolTipTab.this.toolTipLocation);
                }
                ToolTipTab.this.updateSelectionListener();
            }
        });
    }

    private void createTextInput() {
        Composite group = new Composite(this.styleComp, 0);
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        group.setLayout((Layout)new GridLayout(2, false));
        new Label(group, 0).setText("Text");
        Text text = new Text(group, 2048);
        text.setLayoutData((Object)new GridData(4, 128, true, false));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Text text = (Text)event.widget;
                ToolTipTab.this.toolTipText = text.getText();
            }
        });
    }

    private void createMessageInput() {
        Composite group = new Composite(this.styleComp, 0);
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        group.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(group, 0);
        label.setLayoutData((Object)new GridData(4, 128, false, false));
        label.setText("Message");
        Text text = new Text(group, 2050);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 150;
        text.setLayoutData((Object)gridData);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Text text = (Text)event.widget;
                ToolTipTab.this.toolTipMessage = text.getText();
            }
        });
    }

    private void createLocationInput() {
        Composite group = new Composite(this.styleComp, 0);
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        group.setLayout((Layout)new GridLayout(4, false));
        new Label(group, 0).setText("Location X");
        final Text textX = new Text(group, 2048);
        new Label(group, 0).setText("Y");
        final Text textY = new Text(group, 2048);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                int x = ToolTipTab.parseInt(textX.getText());
                int y = ToolTipTab.parseInt(textY.getText());
                if (x > 0 && y > 0) {
                    ToolTipTab.this.toolTipLocation = new Point(x, y);
                } else {
                    ToolTipTab.this.toolTipLocation = null;
                }
            }
        };
        textX.addModifyListener(modifyListener);
        textY.addModifyListener(modifyListener);
    }

    private void createAutoHideButton() {
        Button button = new Button(this.styleComp, 32);
        button.setText("AutoHide");
        button.setSelection(this.toolTipAutoHide);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                ToolTipTab.this.toolTipAutoHide = button.getSelection();
            }
        });
    }

    private void createSelectionListenerButton() {
        Button button = new Button(this.styleComp, 32);
        button.setText("SelectionListener");
        button.setSelection(this.toolTipSelectionListener);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                ToolTipTab.this.toolTipSelectionListener = button.getSelection();
                ToolTipTab.this.updateSelectionListener();
            }
        });
    }

    private void updateSelectionListener() {
        if (this.toolTip != null) {
            if (this.toolTipSelectionListener) {
                this.toolTip.addSelectionListener(this.selectionListener);
            } else {
                this.toolTip.removeSelectionListener(this.selectionListener);
            }
        }
    }

    private static int parseInt(String text) {
        int result;
        try {
            result = Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            result = -1;
        }
        return result;
    }
}

