/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo;

import org.eclipse.rap.rwt.graphics.Graphics;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class DemoChartViewPart
extends ViewPart {
    private Bar[] bars;

    public void createPartControl(Composite parent) {
        this.initBars();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        Canvas canvas = new Canvas(composite, 0);
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                DemoChartViewPart.this.drawGrid(event);
                DemoChartViewPart.this.drawBars(event);
            }
        });
    }

    public void setFocus() {
    }

    private void initBars() {
        this.bars = new Bar[6];
        String[] titles = new String[]{"A", "B", "C", "D", "E", "F"};
        int[] heights = new int[]{34, 111, 21, 45, 87, 50};
        Color[] colors = new Color[]{Graphics.getColor((int)99, (int)150, (int)239), Graphics.getColor((int)239, (int)130, (int)123), Graphics.getColor((int)49, (int)203, (int)49), Graphics.getColor((int)255, (int)215, (int)0), Graphics.getColor((int)132, (int)113, (int)255), Graphics.getColor((int)140, (int)239, (int)140)};
        int i = 0;
        while (i < this.bars.length) {
            this.bars[i] = new Bar(titles[i], heights[i], colors[i]);
            ++i;
        }
    }

    private void drawGrid(PaintEvent event) {
        Display display = event.display;
        GC gc = event.gc;
        gc.setFont(new Font((Device)display, "Arial", 10, 0));
        int i = 2;
        while (i < 9) {
            gc.setForeground(Graphics.getColor((int)0, (int)0, (int)0));
            gc.drawString(String.valueOf(8 - i), 10, i * 20 - 7);
            gc.setForeground(Graphics.getColor((int)230, (int)230, (int)230));
            gc.drawLine(20, i * 20, 160, i * 20);
            ++i;
        }
        gc.setForeground(Graphics.getColor((int)0, (int)0, (int)0));
        gc.drawLine(20, 20, 20, 160);
        gc.drawPolygon(new int[]{20, 10, 23, 20, 17, 20});
        gc.drawLine(20, 160, 160, 160);
        gc.drawPolygon(new int[]{170, 160, 160, 157, 160, 163});
    }

    private void drawBars(PaintEvent event) {
        int i = 0;
        while (i < 6) {
            this.bars[i].redraw(event, 30 + i * 20);
            ++i;
        }
    }

    private class Bar {
        private final String title;
        private final int height;
        private final Color color;

        public Bar(String title, int height, Color color) {
            this.title = title;
            this.height = height;
            this.color = color;
        }

        public void redraw(PaintEvent event, int x) {
            Display display = event.display;
            GC gc = event.gc;
            gc.setBackground(this.color);
            gc.fillRectangle(x, 160 - this.height, 15, this.height);
            gc.setForeground(Graphics.getColor((int)0, (int)0, (int)0));
            gc.setBackground(Graphics.getColor((int)0, (int)0, (int)0));
            gc.drawRectangle(x, 160 - this.height, 15, this.height);
            gc.fillRectangle(x + 13, 160 - this.height, 2, this.height);
            gc.setFont(new Font((Device)display, "Arial", 10, 0));
            gc.setForeground(Graphics.getColor((int)0, (int)0, (int)0));
            gc.setBackground(Graphics.getColor((int)255, (int)255, (int)255));
            gc.drawString(this.title, x + 5, 161);
        }
    }
}

