/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.examples.pages;

import java.util.ArrayList;
import org.eclipse.rap.examples.ExampleUtil;
import org.eclipse.rap.examples.IExamplePage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public final class CanvasExamplePage
implements IExamplePage {
    private static final int MODE_POLYFORM = 0;
    private static final int MODE_OVAL = 1;
    private static final int MODE_STAMP = 2;
    private static final int SNAP_DISTANCE = 10;
    private static final int LINE_WIDTH = 2;
    private static final RGB[] COLORS = new RGB[]{new RGB(21, 184, 185), new RGB(102, 169, 58), new RGB(71, 110, 188), new RGB(251, 113, 189), new RGB(144, 202, 215), new RGB(254, 207, 21), new RGB(255, 83, 22), new RGB(182, 199, 66), new RGB(254, 159, 169), new RGB(159, 122, 171), new RGB(66, 187, 134)};
    private static final int[] IMAGES = new int[]{4, 2, 8, 1};
    private Canvas drawingArea;
    private int mode;
    private ArrayList<Object[]> path = new ArrayList();
    private int[] currentParam;
    private Point currentStart;
    private int currentColor;
    private int currentImage;
    private int currentAlpha = 255;

    public void createControl(Composite parent) {
        parent.setLayout((Layout)ExampleUtil.createMainLayout((int)1));
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)ExampleUtil.createFillData());
        composite.setLayout((Layout)ExampleUtil.createGridLayout((int)1, (boolean)false, (boolean)true, (boolean)true));
        ExampleUtil.createHeading((Composite)composite, (String)"click to draw shapes", (int)1);
        this.createDrawingArea(composite);
        this.createControlButtons(composite);
        parent.layout();
        this.clear();
    }

    private void createDrawingArea(Composite parent) {
        this.drawingArea = new Canvas(parent, 2048);
        this.drawingArea.setLayoutData((Object)ExampleUtil.createFillData());
        this.drawingArea.setBackground(parent.getDisplay().getSystemColor(1));
        this.drawingArea.addPaintListener((PaintListener)new DrawingAreaPaintListener());
        this.drawingArea.addMouseListener((MouseListener)new DrawingAreaMouseListener());
    }

    private void createControlButtons(Composite parent) {
        Composite buttonArea = new Composite(parent, 0);
        buttonArea.setLayout((Layout)ExampleUtil.createRowLayout((int)256, (boolean)false));
        Button polyformButton = new Button(buttonArea, 16);
        polyformButton.setText("Polyform");
        polyformButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CanvasExamplePage.this.newOperation();
                CanvasExamplePage.this.mode = 0;
            }
        });
        Button ovalButton = new Button(buttonArea, 16);
        ovalButton.setText("Oval");
        ovalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CanvasExamplePage.this.newOperation();
                CanvasExamplePage.this.mode = 1;
            }
        });
        Button stampButton = new Button(buttonArea, 16);
        stampButton.setText("Stamp");
        stampButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CanvasExamplePage.this.newOperation();
                CanvasExamplePage.this.mode = 2;
            }
        });
        final Button transparencyButton = new Button(buttonArea, 32);
        transparencyButton.setText("Transparency");
        transparencyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = transparencyButton.getSelection();
                CanvasExamplePage.this.currentAlpha = selected ? 128 : 255;
            }
        });
        Button clearButton = new Button(buttonArea, 8);
        clearButton.setText("Clear");
        clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CanvasExamplePage.this.clear();
            }
        });
        polyformButton.setSelection(true);
    }

    private void addToCurrentParam(int x, int y) {
        if (this.currentParam == null) {
            this.currentParam = new int[]{x, y};
            this.currentStart = new Point(x, y);
        } else {
            int length = this.currentParam.length;
            int[] newParam = new int[length + 2];
            System.arraycopy(this.currentParam, 0, newParam, 0, length);
            newParam[length] = x;
            newParam[length + 1] = y;
            this.currentParam = newParam;
        }
    }

    private void addOperationToPath() {
        Object fill = this.getCurrentFill();
        switch (this.mode) {
            case 1: {
                int centerX = this.currentParam[0];
                int centerY = this.currentParam[1];
                int radiusX = Math.abs(centerX - this.currentParam[2]);
                int radiusY = Math.abs(centerY - this.currentParam[3]);
                this.currentParam = new int[]{centerX - radiusX, centerY - radiusY, radiusX * 2, radiusY * 2};
                break;
            }
            case 2: {
                Image stamp = (Image)fill;
                this.currentParam[0] = this.currentParam[0] - stamp.getBounds().width / 2;
                this.currentParam[1] = this.currentParam[1] - stamp.getBounds().height / 2;
            }
        }
        Object[] arg = new Object[]{new Integer(this.mode), this.currentParam, fill, new Integer(this.currentAlpha)};
        this.path.add(arg);
    }

    private Object getCurrentFill() {
        Image result;
        switch (this.mode) {
            case 2: {
                result = this.drawingArea.getDisplay().getSystemImage(IMAGES[this.currentImage]);
                ++this.currentImage;
                if (this.currentImage < IMAGES.length) break;
                this.currentImage = 0;
                break;
            }
            default: {
                result = new Color((Device)this.drawingArea.getDisplay(), COLORS[this.currentColor]);
                ++this.currentColor;
                if (this.currentColor < COLORS.length) break;
                this.currentColor = 0;
            }
        }
        return result;
    }

    private void clear() {
        this.path = new ArrayList();
        this.newOperation();
    }

    private void newOperation() {
        this.currentParam = null;
        this.currentStart = null;
        this.drawingArea.redraw();
    }

    private boolean isNearStart(int x, int y) {
        boolean result = false;
        if (this.currentStart != null) {
            int diffX = Math.abs(this.currentStart.x - x);
            int diffY = Math.abs(this.currentStart.y - y);
            result = diffX < 10 && diffY < 10;
        }
        return result;
    }

    private void drawStartPoint(GC gc) {
        int x = this.currentStart.x - 10;
        int y = this.currentStart.y - 10;
        int diameter = 20;
        gc.setBackground(this.drawingArea.getDisplay().getSystemColor(1));
        gc.fillOval(x, y, diameter, diameter);
        gc.drawOval(x, y, diameter, diameter);
    }

    private final class DrawingAreaMouseListener
    extends MouseAdapter {
        private DrawingAreaMouseListener() {
        }

        public void mouseDown(MouseEvent e) {
            switch (CanvasExamplePage.this.mode) {
                case 0: {
                    if (CanvasExamplePage.this.isNearStart(e.x, e.y)) {
                        CanvasExamplePage.this.addOperationToPath();
                        CanvasExamplePage.this.newOperation();
                        break;
                    }
                    CanvasExamplePage.this.addToCurrentParam(e.x, e.y);
                    break;
                }
                case 1: {
                    CanvasExamplePage.this.addToCurrentParam(e.x, e.y);
                    if (CanvasExamplePage.this.currentParam.length != 4) break;
                    CanvasExamplePage.this.addOperationToPath();
                    CanvasExamplePage.this.newOperation();
                    break;
                }
                case 2: {
                    CanvasExamplePage.this.addToCurrentParam(e.x, e.y);
                    CanvasExamplePage.this.addOperationToPath();
                    CanvasExamplePage.this.newOperation();
                }
            }
            CanvasExamplePage.this.drawingArea.redraw();
        }
    }

    private final class DrawingAreaPaintListener
    implements PaintListener {
        private DrawingAreaPaintListener() {
        }

        public void paintControl(PaintEvent event) {
            GC gc = event.gc;
            gc.setLineWidth(2);
            int i = 0;
            while (i < CanvasExamplePage.this.path.size()) {
                Object[] operation = (Object[])CanvasExamplePage.this.path.get(i);
                int operationMode = (Integer)operation[0];
                int[] param = (int[])operation[1];
                gc.setAlpha(((Integer)operation[3]).intValue());
                switch (operationMode) {
                    case 0: {
                        gc.setBackground((Color)operation[2]);
                        gc.fillPolygon(param);
                        gc.setAlpha(255);
                        gc.drawPolygon(param);
                        break;
                    }
                    case 1: {
                        gc.setBackground((Color)operation[2]);
                        gc.fillOval(param[0], param[1], param[2], param[3]);
                        gc.setAlpha(255);
                        gc.drawOval(param[0], param[1], param[2], param[3]);
                        break;
                    }
                    case 2: {
                        gc.drawImage((Image)operation[2], param[0], param[1]);
                    }
                }
                ++i;
            }
            if (CanvasExamplePage.this.currentParam != null) {
                gc.setAlpha(255);
                CanvasExamplePage.this.drawStartPoint(gc);
                switch (CanvasExamplePage.this.mode) {
                    case 0: {
                        gc.drawPolyline(CanvasExamplePage.this.currentParam);
                    }
                }
            }
        }
    }
}

