/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.application;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.rap.rwt.application.Application;
import org.eclipse.rap.rwt.application.ApplicationConfiguration;
import org.eclipse.rap.rwt.application.EntryPoint;
import org.eclipse.rap.rwt.application.EntryPointFactory;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.application.SessionFailoverConfigurator;
import org.eclipse.rap.rwt.internal.client.ClientProvider;
import org.eclipse.rap.rwt.internal.lifecycle.RWTLifeCycle;
import org.eclipse.rap.rwt.internal.service.ServiceManagerImpl;
import org.eclipse.rap.rwt.internal.theme.Theme;
import org.eclipse.rap.rwt.internal.theme.ThemeManager;
import org.eclipse.rap.rwt.internal.theme.css.CssFileReader;
import org.eclipse.rap.rwt.internal.theme.css.StyleSheet;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.eclipse.rap.rwt.lifecycle.PhaseListener;
import org.eclipse.rap.rwt.service.ResourceLoader;
import org.eclipse.rap.rwt.service.ServiceHandler;
import org.eclipse.rap.rwt.service.SettingStoreFactory;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationImpl
implements Application {
    private final ApplicationContextImpl applicationContext;
    private final ApplicationConfiguration configuration;

    public ApplicationImpl(ApplicationContextImpl applicationContext, ApplicationConfiguration configuration) {
        this.applicationContext = applicationContext;
        this.configuration = configuration;
    }

    @Override
    public void setOperationMode(Application.OperationMode operationMode) {
        ParamCheck.notNull((Object)operationMode, "operationMode");
        switch (operationMode) {
            case JEE_COMPATIBILITY: {
                break;
            }
            case SWT_COMPATIBILITY: {
                this.applicationContext.getLifeCycleFactory().configure(RWTLifeCycle.class);
                break;
            }
            case SESSION_FAILOVER: {
                new SessionFailoverConfigurator(this.applicationContext).configure();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation mode: " + (Object)((Object)operationMode));
            }
        }
    }

    @Override
    public void addPhaseListener(PhaseListener phaseListener) {
        ParamCheck.notNull(phaseListener, "phaseListener");
        this.applicationContext.getPhaseListenerRegistry().add(phaseListener);
    }

    @Override
    public void setSettingStoreFactory(SettingStoreFactory settingStoreFactory) {
        ParamCheck.notNull(settingStoreFactory, "settingStoreFactory");
        this.applicationContext.getSettingStoreManager().register(settingStoreFactory);
    }

    @Override
    public void addEntryPoint(String path, Class<? extends EntryPoint> entryPointType, Map<String, String> properties) {
        ParamCheck.notNull(path, "path");
        ParamCheck.notNull(entryPointType, "entryPointType");
        this.applicationContext.getEntryPointManager().register(path, entryPointType, properties);
    }

    @Override
    public void addEntryPoint(String path, EntryPointFactory entryPointFactory, Map<String, String> properties) {
        ParamCheck.notNull(path, "path");
        ParamCheck.notNull(entryPointFactory, "entryPointFactory");
        this.applicationContext.getEntryPointManager().register(path, entryPointFactory, properties);
    }

    @Override
    public void addResource(String resourceName, ResourceLoader resourceLoader) {
        ParamCheck.notNull(resourceName, "resourceName");
        ParamCheck.notNull(resourceLoader, "resourceLoader");
        this.applicationContext.getResourceRegistry().add(resourceName, resourceLoader);
    }

    @Override
    public void addServiceHandler(String serviceHandlerId, ServiceHandler serviceHandler) {
        ParamCheck.notNull(serviceHandlerId, "serviceHandlerId");
        ParamCheck.notNull(serviceHandler, "serviceHandler");
        ServiceManagerImpl serviceManager = this.applicationContext.getServiceManager();
        serviceManager.registerServiceHandler(serviceHandlerId, serviceHandler);
    }

    @Override
    public void addStyleSheet(String themeId, String styleSheetLocation) {
        this.addStyleSheet(themeId, styleSheetLocation, new ResourceLoaderImpl(this.getClassLoader()));
    }

    @Override
    public void addStyleSheet(String themeId, String styleSheetLocation, ResourceLoader resourceLoader) {
        ParamCheck.notNull(themeId, "themeId");
        ParamCheck.notNull(styleSheetLocation, "styleSheetLocation");
        ParamCheck.notNull(resourceLoader, "resourceLoader");
        StyleSheet styleSheet = this.readStyleSheet(styleSheetLocation, resourceLoader);
        ThemeManager themeManager = this.applicationContext.getThemeManager();
        Theme theme = themeManager.getTheme(themeId);
        if (theme != null) {
            theme.addStyleSheet(styleSheet);
        } else {
            themeManager.registerTheme(new Theme(themeId, "unknown", styleSheet));
        }
    }

    @Override
    public void addThemableWidget(Class<? extends Widget> widget) {
        this.addThemableWidget(widget, new ResourceLoaderImpl(widget.getClassLoader()));
    }

    public void addThemableWidget(Class<? extends Widget> widget, ResourceLoader resourceLoader) {
        ParamCheck.notNull(widget, "widget");
        ParamCheck.notNull(resourceLoader, "resourceLoader");
        this.applicationContext.getThemeManager().addThemeableWidget(widget, resourceLoader);
    }

    public void addClientProvider(ClientProvider clientProvider) {
        this.applicationContext.getClientSelector().addClientProvider(clientProvider);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.applicationContext.setAttribute(name, value);
    }

    private ClassLoader getClassLoader() {
        return this.configuration.getClass().getClassLoader();
    }

    private StyleSheet readStyleSheet(String styleSheetLocation, ResourceLoader loader) {
        StyleSheet result;
        try {
            result = CssFileReader.readStyleSheet(styleSheetLocation, loader);
        }
        catch (IOException iOException) {
            String text = "Failed to read stylesheet from resource ''{0}''";
            Object[] args = new Object[]{styleSheetLocation};
            String msg = MessageFormat.format(text, args);
            throw new IllegalArgumentException(msg);
        }
        return result;
    }

    public ApplicationContextImpl getApplicationContext() {
        return this.applicationContext;
    }

    static class ResourceLoaderImpl
    implements ResourceLoader {
        private final ClassLoader loader;

        private ResourceLoaderImpl(ClassLoader loader) {
            this.loader = loader;
        }

        public InputStream getResourceAsStream(String resourceName) throws IOException {
            return this.loader.getResourceAsStream(resourceName);
        }
    }
}

